/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-29 15:29:49 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `aor_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_crm_meta` (
  `meta_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`meta_ID`),
  KEY `object_ID` (`object_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_crmapp_meta` (
  `meta_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`meta_ID`),
  KEY `object_ID` (`object_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_crocoblock_workflows` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `remote_id` mediumint(8) DEFAULT NULL,
  `namespace` text DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `steps` longtext DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_estate_file_meta` (
  `meta_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_ID` bigint(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `multi_unit` text DEFAULT NULL,
  `number_of_sleeps` text DEFAULT NULL,
  `elevator` text DEFAULT NULL,
  `parking` text DEFAULT NULL,
  `warehouse` text DEFAULT NULL,
  `access_type` text DEFAULT NULL,
  `frontage_type` text DEFAULT NULL,
  `cabinet` text DEFAULT NULL,
  `cabinet_type` text DEFAULT NULL,
  `year_of_manufacture` text DEFAULT NULL,
  `master` text DEFAULT NULL,
  `building_facade` text DEFAULT NULL,
  `side` text DEFAULT NULL,
  `meterage` text DEFAULT NULL,
  `square_footage_on_the_street` text DEFAULT NULL,
  `type_of_land` text DEFAULT NULL,
  `access_to_people` text DEFAULT NULL,
  `_visibility` text DEFAULT NULL,
  `gallery` text DEFAULT NULL,
  `_description` text DEFAULT NULL,
  PRIMARY KEY (`meta_ID`),
  KEY `object_ID` (`object_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_addon_feed` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `feed_order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `addon_slug` varchar(50) DEFAULT NULL,
  `event_type` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addon_form` (`addon_slug`,`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `source_id` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM AUTO_INCREMENT=434 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_gf_sms_sent` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `entry_id` varchar(20) NOT NULL,
  `date` datetime DEFAULT NULL,
  `sender` varchar(20) NOT NULL,
  `reciever` varchar(255) NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `aor_gf_sms_verification` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `entry_id` mediumint(8) unsigned NOT NULL,
  `try_num` mediumint(8) unsigned NOT NULL,
  `sent_num` mediumint(8) unsigned NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `code` varchar(250) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gf_sms_verification_form_id_index` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `aor_ip_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `aor_jet_fb_migrations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `version` varchar(255) DEFAULT NULL,
  `executed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `execution_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_jet_fb_records` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `from_content_id` bigint(20) NOT NULL,
  `from_content_type` varchar(20) NOT NULL,
  `status` varchar(255) DEFAULT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `referrer` text DEFAULT NULL,
  `submit_type` varchar(20) DEFAULT NULL,
  `is_viewed` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_jet_fb_records_actions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `record_id` bigint(20) NOT NULL,
  `action_slug` varchar(255) NOT NULL,
  `action_id` int(11) NOT NULL,
  `on_event` varchar(155) DEFAULT 'DEFAULT.PROCESS',
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `record_id` (`record_id`),
  CONSTRAINT `records__record_id__records_actions` FOREIGN KEY (`record_id`) REFERENCES `aor_jet_fb_records` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_jet_fb_records_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `record_id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL,
  `field_value` longtext DEFAULT NULL,
  `field_type` varchar(40) NOT NULL,
  `field_attrs` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `record_id` (`record_id`),
  CONSTRAINT `records__record_id__records_fields` FOREIGN KEY (`record_id`) REFERENCES `aor_jet_fb_records` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=4856 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_p_statistic` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) NOT NULL,
  `counter` bigint(20) NOT NULL,
  `date` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `aor_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4866 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=632 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_static` (
  `sid` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  `count` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `aor_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `aor_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: aor_actionscheduler_actions */
INSERT INTO `aor_actionscheduler_actions` VALUES("10", "action_scheduler/migration_hook", "complete", "2025-12-17 09:06:37", "2025-12-17 09:06:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765962397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765962397;}", "1", "1", "2025-12-17 09:06:50", "2025-12-17 12:36:50", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("11", "action_scheduler/migration_hook", "complete", "2025-12-17 16:03:28", "2025-12-17 16:03:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765987408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765987408;}", "1", "1", "2025-12-17 16:03:52", "2025-12-17 19:33:52", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("12", "action_scheduler/migration_hook", "complete", "2025-12-17 16:09:48", "2025-12-17 16:09:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765987788;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765987788;}", "1", "1", "2025-12-17 16:09:51", "2025-12-17 19:39:51", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("13", "action_scheduler/migration_hook", "complete", "2025-12-27 11:10:46", "2025-12-27 11:10:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766833846;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766833846;}", "1", "1", "2025-12-27 11:10:51", "2025-12-27 14:40:51", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("14", "action_scheduler/migration_hook", "complete", "2025-12-27 11:12:33", "2025-12-27 11:12:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766833953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766833953;}", "1", "1", "2025-12-27 11:12:41", "2025-12-27 14:42:41", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("15", "action_scheduler/migration_hook", "complete", "2025-12-27 11:13:41", "2025-12-27 11:13:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766834021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766834021;}", "1", "1", "2025-12-27 11:13:52", "2025-12-27 14:43:52", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("16", "action_scheduler/migration_hook", "complete", "2025-12-27 11:33:57", "2025-12-27 11:33:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766835237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766835237;}", "1", "1", "2025-12-27 11:33:59", "2025-12-27 15:03:59", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("17", "action_scheduler/migration_hook", "complete", "2025-12-27 11:36:04", "2025-12-27 11:36:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766835364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766835364;}", "1", "1", "2025-12-27 11:36:04", "2025-12-27 15:06:04", "0", NULL);
INSERT INTO `aor_actionscheduler_actions` VALUES("18", "action_scheduler/migration_hook", "failed", "2025-12-27 11:37:06", "2025-12-27 11:37:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766835426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766835426;}", "1", "1", "2025-12-27 11:37:16", "2025-12-27 15:07:16", "0", NULL);

/* INSERT TABLE DATA: aor_actionscheduler_groups */
INSERT INTO `aor_actionscheduler_groups` VALUES("1", "action-scheduler-migration");

/* INSERT TABLE DATA: aor_actionscheduler_logs */
INSERT INTO `aor_actionscheduler_logs` VALUES("1", "10", "action created", "2025-12-17 09:05:37", "2025-12-17 09:05:37");
INSERT INTO `aor_actionscheduler_logs` VALUES("2", "10", "action started via Async Request", "2025-12-17 09:06:50", "2025-12-17 09:06:50");
INSERT INTO `aor_actionscheduler_logs` VALUES("3", "10", "action complete via Async Request", "2025-12-17 09:06:50", "2025-12-17 09:06:50");
INSERT INTO `aor_actionscheduler_logs` VALUES("4", "11", "action created", "2025-12-17 16:02:28", "2025-12-17 16:02:28");
INSERT INTO `aor_actionscheduler_logs` VALUES("5", "11", "action started via WP Cron", "2025-12-17 16:03:52", "2025-12-17 16:03:52");
INSERT INTO `aor_actionscheduler_logs` VALUES("6", "11", "action complete via WP Cron", "2025-12-17 16:03:52", "2025-12-17 16:03:52");
INSERT INTO `aor_actionscheduler_logs` VALUES("7", "12", "action created", "2025-12-17 16:08:48", "2025-12-17 16:08:48");
INSERT INTO `aor_actionscheduler_logs` VALUES("8", "12", "action started via WP Cron", "2025-12-17 16:09:51", "2025-12-17 16:09:51");
INSERT INTO `aor_actionscheduler_logs` VALUES("9", "12", "action complete via WP Cron", "2025-12-17 16:09:51", "2025-12-17 16:09:51");
INSERT INTO `aor_actionscheduler_logs` VALUES("10", "13", "action created", "2025-12-27 11:09:46", "2025-12-27 11:09:46");
INSERT INTO `aor_actionscheduler_logs` VALUES("11", "13", "action started via Async Request", "2025-12-27 11:10:51", "2025-12-27 11:10:51");
INSERT INTO `aor_actionscheduler_logs` VALUES("12", "13", "action complete via Async Request", "2025-12-27 11:10:51", "2025-12-27 11:10:51");
INSERT INTO `aor_actionscheduler_logs` VALUES("13", "14", "action created", "2025-12-27 11:11:33", "2025-12-27 11:11:33");
INSERT INTO `aor_actionscheduler_logs` VALUES("14", "14", "action started via WP Cron", "2025-12-27 11:12:41", "2025-12-27 11:12:41");
INSERT INTO `aor_actionscheduler_logs` VALUES("15", "14", "action complete via WP Cron", "2025-12-27 11:12:41", "2025-12-27 11:12:41");
INSERT INTO `aor_actionscheduler_logs` VALUES("16", "15", "action created", "2025-12-27 11:12:41", "2025-12-27 11:12:41");
INSERT INTO `aor_actionscheduler_logs` VALUES("17", "15", "action started via WP Cron", "2025-12-27 11:13:52", "2025-12-27 11:13:52");
INSERT INTO `aor_actionscheduler_logs` VALUES("18", "15", "action complete via WP Cron", "2025-12-27 11:13:52", "2025-12-27 11:13:52");
INSERT INTO `aor_actionscheduler_logs` VALUES("19", "16", "action created", "2025-12-27 11:32:57", "2025-12-27 11:32:57");
INSERT INTO `aor_actionscheduler_logs` VALUES("20", "16", "action started via Async Request", "2025-12-27 11:33:59", "2025-12-27 11:33:59");
INSERT INTO `aor_actionscheduler_logs` VALUES("21", "16", "action complete via Async Request", "2025-12-27 11:33:59", "2025-12-27 11:33:59");
INSERT INTO `aor_actionscheduler_logs` VALUES("22", "17", "action created", "2025-12-27 11:35:04", "2025-12-27 11:35:04");
INSERT INTO `aor_actionscheduler_logs` VALUES("23", "17", "action started via WP Cron", "2025-12-27 11:36:04", "2025-12-27 11:36:04");
INSERT INTO `aor_actionscheduler_logs` VALUES("24", "17", "action complete via WP Cron", "2025-12-27 11:36:04", "2025-12-27 11:36:04");
INSERT INTO `aor_actionscheduler_logs` VALUES("25", "18", "action created", "2025-12-27 11:36:06", "2025-12-27 11:36:06");
INSERT INTO `aor_actionscheduler_logs` VALUES("26", "18", "action started via Async Request", "2025-12-27 11:37:16", "2025-12-27 11:37:16");
INSERT INTO `aor_actionscheduler_logs` VALUES("27", "18", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-12-27 11:37:16", "2025-12-27 11:37:16");

/* INSERT TABLE DATA: aor_comments */
INSERT INTO `aor_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2025-12-16 13:52:00", "2025-12-16 10:22:00", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: aor_crocoblock_workflows */
INSERT INTO `aor_crocoblock_workflows` VALUES("1", "1", "jet-engine", "a:3:{s:8:\"workflow\";s:35:\"Create listing for CPT from scratch\";s:11:\"description\";s:176:\"A guide to creating the most basic listing – a listing for CPT based on a query from Query Builder. This could be a good starting point to understand JetEngine possibilities.\";s:16:\"relatedWorkflows\";a:0:{}}", "a:4:{i:0;a:6:{s:4:\"name\";s:18:\"Create a Post Type\";s:4:\"help\";s:327:\"<p>Post Type is the most basic way of storing various pieces of content. Is a tool for creating unique content types, offering more features and fields than standard WordPress posts and pages.</p>Before starting, you need to add a new one.</p><p>If you already have the Post Type you need, you can proceed to the next step.</p>\";s:8:\"tutorial\";s:107:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-a-custom-post-type-based-on-jetengine-plugin/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"admin.php?page=jet-engine-cpt&cpt_action=add\";s:5:\"label\";s:14:\"Create new CPT\";}s:7:\"minTime\";i:3;s:7:\"maxTime\";i:10;}i:1;a:6:{s:4:\"name\";s:36:\"Create a new query for the Post Type\";s:4:\"help\";s:466:\"<p>Query is a base tool for getting any data from database. In this case you need a query to get the posts. But you can use it to get almost any data. On the next step you will use this query as data source for your listing.</p><p>When creating a Query, please make sure you selected the previously created CPT in the <b>Post Type</b> option in the Posts Query’s <b>General</b> settings.</p><p>If you already have a query for this CPT, you can go to next step.</p>\";s:8:\"tutorial\";s:79:\"https://crocoblock.com/knowledge-base/jetengine/query-builder-posts-query-type/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:48:\"admin.php?page=jet-engine-query&query_action=add\";s:5:\"label\";s:16:\"Create new Query\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:4;}i:2;a:6:{s:4:\"name\";s:48:\"Create a listing item based on the created Query\";s:4:\"help\";s:332:\"<p>Listing item represents a single element of your future listing. Here you can set up content, layout, and design of a listing item.</p><p>To use the previously created Query as a source for your listing item, you need to set <b>Listing source</b> to <b>Query Builder</b> and then select your Query in the <b>Query</b> option.</p>\";s:8:\"tutorial\";s:143:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-query-builder-listing-template/#create-listing-template-with-query-builder-source\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"edit.php?post_type=jet-engine#add_new__query\";s:5:\"label\";s:32:\"Create new listing item template\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:10;}i:3;a:6:{s:4:\"name\";s:32:\"Add listing to the selected page\";s:4:\"help\";s:226:\"The last step is to add a new listing, based on the previously created listing item and Query, to the selected page. To do this, you need to use the <b>Listing Grid</b> widget (block/element, depending on the builder you use).\";s:8:\"tutorial\";s:76:\"https://crocoblock.com/knowledge-base/features/listing-grid-widget-overview/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:23:\"edit.php?post_type=page\";s:5:\"label\";s:15:\"Go to all pages\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}}");
INSERT INTO `aor_crocoblock_workflows` VALUES("2", "2", "jet-engine", "a:3:{s:8:\"workflow\";s:21:\"Show posts on the map\";s:11:\"description\";s:83:\"A guide to showcasing your posts listing on the map using the Maps Listings module.\";s:16:\"relatedWorkflows\";a:0:{}}", "a:5:{i:0;a:7:{s:4:\"name\";s:31:\"Set up the Maps Listings module\";s:4:\"help\";s:316:\"<p>Before starting, you need to prepare Maps to work:</p><ul><li>Select <b>Map Provider</b> and <b>Geocoding Provider</b> to be used</li><li>Set up <b>API keys or tokens</b> for this provider (if needed)</li></ul><p>All these things can be done in the <b>Maps Settings</b> section on <b>JetEngine</b> admin page.</p>\";s:8:\"tutorial\";s:108:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-choosing-different-map-providers-for-map-listings/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:39:\"admin.php?page=jet-engine#maps_settings\";s:5:\"label\";s:23:\"Configure Maps settings\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:8;s:10:\"dependency\";a:3:{s:5:\"label\";s:29:\"Activate Maps Listings module\";s:4:\"type\";s:17:\"jet_engine_module\";s:6:\"module\";s:13:\"maps-listings\";}}i:1;a:6:{s:4:\"name\";s:35:\"Add a Map Field to the selected CPT\";s:4:\"help\";s:314:\"<p>The best way to set coordinates for a post on the map is by using the <b>Map</b> meta field. Just add this field type to the CPT which you want to showcase on the map.</p><p>Then go to CPT edit page and select a proper location for all the posts you need. Now your posts are ready to use with Maps Listings.</p>\";s:8:\"tutorial\";s:77:\"https://crocoblock.com/knowledge-base/features/meta-field-types-overview/#map\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:30:\"admin.php?page=jet-engine-meta\";s:5:\"label\";s:24:\"Go to Meta Boxes manager\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}i:2;a:6:{s:4:\"name\";s:36:\"Create a new Query for the Post Type\";s:4:\"help\";s:289:\"<p>Query is a base tool for getting any data from DB. When creating a Query, please make sure you selected the previously created CPT in the <b>Post Type</b> option in the Posts Query’s <b>General</b> settings.</p><p>If you already have a query for this CPT, you can go to next step.</p>\";s:8:\"tutorial\";s:79:\"https://crocoblock.com/knowledge-base/jetengine/query-builder-posts-query-type/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:48:\"admin.php?page=jet-engine-query&query_action=add\";s:5:\"label\";s:16:\"Create new Query\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:4;}i:3;a:6:{s:4:\"name\";s:48:\"Create a listing item based on the created Query\";s:4:\"help\";s:629:\"<p>Listing item represents a single element of your future listing. In case of the map, listing item - is a content of popup you see, when click on map marker.</p><p>You can add any data you want, setup layout and design of a listing item. As mentioned before, on the map, listing items will be shown in the informational pop-up after you clicking a corresponding marker and represents the data of the post, related to this marker.</p><p>To use the previously created Query as a source for your listing item, you need to set <b>Listing source</b> to <b>Query Builder</b> and then select your Query in the <b>Query</b> option.</p>\";s:8:\"tutorial\";s:143:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-query-builder-listing-template/#create-listing-template-with-query-builder-source\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"edit.php?post_type=jet-engine#add_new__query\";s:5:\"label\";s:32:\"Create new listing item template\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:10;}i:4;a:6:{s:4:\"name\";s:40:\"Add the Map Listing to the selected page\";s:4:\"help\";s:618:\"<p>Now you can add map listing, based on the previously created listing item and Query, to the selected page. To do this, you need to use the <b>Map Listing</b> widget (block/element, depending on the builder you use).</p><p>After adding a <b>Map Listing</b> widget/block to the page content, you need to set these options to make sure it will work:</p><ul><li><b>Listing</b> – the listing item you created before</li><li><b>Address Meta Field</b> – here you need to set the name/ID of a Map meta field you created on Step 2</li><li>Set a marker icon for your post on the map in the <b>Marker</b> section</li></ul>\";s:8:\"tutorial\";s:101:\"https://crocoblock.com/knowledge-base/features/map-listing-overview/#map-listing-widgetblock-overview\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:23:\"edit.php?post_type=page\";s:5:\"label\";s:15:\"Go to all pages\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}}");
INSERT INTO `aor_crocoblock_workflows` VALUES("3", "3", "jet-engine", "a:4:{s:8:\"workflow\";s:59:\"Add Favorites/Wishlist functionality via Data Stores module\";s:11:\"description\";s:135:\"A guide to creating the \'Add to favorites/wishlist\' button and Favorites/Wishlist listing on your website using the Data Stores module.\";s:16:\"relatedWorkflows\";a:0:{}s:12:\"fullTutorial\";s:86:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-data-stores-module-overview/\";}", "a:5:{i:0;a:7:{s:4:\"name\";s:23:\"Create a new Data Store\";s:4:\"help\";s:545:\"<p>Data Stores allow you to create user-specific storages for some collections of item IDs (for example, post IDs, user IDs, term IDs, etc.). This functionality lets you add Wishlists, Favorites, Bookmarks, etc., to your website.</p><p>The Data Stores module gives tools for users to add/remove items from such storages and showcase storage data via the Listing Grid widget.</p><p>To start, you need to create your first Data Store. Each type of Data Store has its own specifics; for a quick start, we recommend using the Cookies store type.</p>\";s:8:\"tutorial\";s:108:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-data-stores-module-overview/#creating-a-data-store\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:37:\"admin.php?page=jet-engine#data_stores\";s:5:\"label\";s:17:\"Create Data Store\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;s:10:\"dependency\";a:3:{s:5:\"label\";s:27:\"Activate Data Stores module\";s:4:\"type\";s:17:\"jet_engine_module\";s:6:\"module\";s:11:\"data-stores\";}}i:1;a:6:{s:4:\"name\";s:50:\"Allow users to add items to the created Data Store\";s:4:\"help\";s:579:\"<p>Once you have created a Data Store, you need to enable your website visitors to add items to this store.</p><p>You can use the <b>Data Store Button</b> widget/block for this. Add this widget/block where you need the \'Add to Favorites/Wishlist\' button. This could be:</p><ul><li>Listing of posts (or any other items you want to store)</li><li>Single post template of posts you want to store</li><li>Single user page, if you want to store user IDs</li></ul><p>In widget/block settings, make sure to select the previously created Data Store in the <b>Select store</b> option.</p>\";s:8:\"tutorial\";s:82:\"https://crocoblock.com/knowledge-base/jetengine/data-store-button-widget-overview/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:29:\"edit.php?post_type=jet-engine\";s:5:\"label\";s:19:\"Go to Listing Items\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:3;}i:2;a:6:{s:4:\"name\";s:43:\"Create a query to get items from Data Store\";s:4:\"help\";s:713:\"<p>Before you showcase stored items from a website visitor, you need to query these items from the database. JetEngine has a unified tool to query any data from the database – Query Builder. In this tutorial, we\'ll cover a case when you store posts. For other types of content, the routine will be very similar.</p><p>So, you need to:</p><ul><li>Create a new query and select a <b>Post Type</b> to be stored in the Post Type option.</li><li>Go to the <b>Post & Page</b> tab</li><li>In the <b>Post In</b> option, press the database icon to the right from the input.</li><li>In the dynamic arguments list, select <b>Get store</b>.</li><li>In the <b>Store</b> option, select the previously created store.</li></ul>\";s:8:\"tutorial\";s:137:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-data-stores-module-overview/#creating-a-posts-query-via-jetengine-query-builder\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:48:\"admin.php?page=jet-engine-query&query_action=add\";s:5:\"label\";s:13:\"Add new Query\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:3;}i:3;a:6:{s:4:\"name\";s:48:\"Create a listing item based on the created query\";s:4:\"help\";s:533:\"<p>Listing item represents a single element of your future listing.</p><p>To use the previously created Query as a source for your listing item, you need to set <b>Listing source</b> to <b>Query Builder</b> and then select your Query in the <b>Query</b> option.</p><p><b>Please note!</p> Make sure you\'ve added at least one post to the Data Store by yourself for the listing preview to work correctly.</p><p>Also, you can use any listing item created for the same Post Type and select a previously created Query on the next step.</p>\";s:8:\"tutorial\";s:143:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-query-builder-listing-template/#create-listing-template-with-query-builder-source\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"edit.php?post_type=jet-engine#add_new__query\";s:5:\"label\";s:32:\"Create new Listing item template\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:10;}i:4;a:6:{s:4:\"name\";s:32:\"Add listing to the selected page\";s:4:\"help\";s:549:\"<p>The last step is to add a new listing, based on the previously created listing item and Query, to the selected page. To do this, you need to use the <b>Listing Grid</b> widget (block/element, depending on the builder you use).</p><p>If you didn\'t create a new listing item in the previous step and want to use a different listing item for the Favorites query, go to the Custom Query section in the Listing Grid widget/block settings and enable the Use Custom Query option. Then, select the previously created query in the Custom Query option.</p>\";s:8:\"tutorial\";s:76:\"https://crocoblock.com/knowledge-base/features/listing-grid-widget-overview/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:23:\"edit.php?post_type=page\";s:5:\"label\";s:15:\"Go to all pages\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}}");

/* INSERT TABLE DATA: aor_duplicator_packages */
INSERT INTO `aor_duplicator_packages` VALUES("1", "amlak_or", "819753fb05ca44f96889_20251229152938", "22", "2025-12-29 15:29:49", "amirmohammad8197", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-29 15:29:38\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:8:\"amlak_or\";s:4:\"Hash\";s:35:\"819753fb05ca44f96889_20251229152938\";s:8:\"NameHash\";s:44:\"amlak_or_819753fb05ca44f96889_20251229152938\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:54:\"amlak_or_819753fb05ca44f96889_20251229152938_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.1\";s:6:\"WPUser\";s:16:\"amirmohammad8197\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:56:\"amlak_or_819753fb05ca44f96889_20251229152938_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:30:\"/home/azindm/amlakor.azindm.ir\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3525;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16589;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-29 15:29:38\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:8:\"amlak_or\";s:4:\"Hash\";s:35:\"819753fb05ca44f96889_20251229152938\";s:8:\"NameHash\";s:44:\"amlak_or_819753fb05ca44f96889_20251229152938\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:62:\"amlak_or_819753fb05ca44f96889_20251229152938_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:44:\"/home/azindm/amlakor.azindm.ir/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:57:\"amlak_or_819753fb05ca44f96889_20251229152938_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:120:\"/home/azindm/amlakor.azindm.ir/wp-content/backups-dup-lite/tmp/amlak_or_819753fb05ca44f96889_20251229152938_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:39:\"/home/azindm/amlakor.azindm.ir/wp-admin\";i:1;s:42:\"/home/azindm/amlakor.azindm.ir/wp-includes\";i:2;s:51:\"/home/azindm/amlakor.azindm.ir/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:30:\"/home/azindm/amlakor.azindm.ir\";i:1;s:30:\"/home/azindm/amlakor.azindm.ir\";i:2;s:41:\"/home/azindm/amlakor.azindm.ir/wp-content\";i:3;s:49:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads\";i:4;s:49:\"/home/azindm/amlakor.azindm.ir/wp-content/plugins\";i:5;s:52:\"/home/azindm/amlakor.azindm.ir/wp-content/mu-plugins\";i:6;s:48:\"/home/azindm/amlakor.azindm.ir/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:62:\"/home/azindm/amlakor.azindm.ir/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: aor_e_events */
INSERT INTO `aor_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-12-16T13:54:10.561-04:30\"}", "2025-12-16 13:54:10");
INSERT INTO `aor_e_events` VALUES("2", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-12-16T13:54:10.681-04:30\"}", "2025-12-16 13:54:10");
INSERT INTO `aor_e_events` VALUES("3", "{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2025-12-16T13:54:15.537-04:30\"}", "2025-12-16 13:54:15");

/* INSERT TABLE DATA: aor_estate_file_meta */
INSERT INTO `aor_estate_file_meta` VALUES("27", "80", "شسیشسیشسیشی", NULL, NULL, "true", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `aor_estate_file_meta` VALUES("28", "81", "شسیشسیشسی", NULL, NULL, "true", NULL, "true", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `aor_estate_file_meta` VALUES("29", "94", "شیراز، فسا", NULL, "22", NULL, "دارد", "دارد", "درب هال", "دو نبش (دوبر)", "دارد", "دارد", "1390", "ندارد", "دارد", "جنوب, شرق", "222", NULL, NULL, "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/logo.png , https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/1.png", "این یک ملک تستی است");
INSERT INTO `aor_estate_file_meta` VALUES("30", "98", "شسیشسیشسیشسیشسی", "15", "2", "true", "true", "true", NULL, NULL, "true", "metal", "1387", "true", "Ceramics", "the north", "213", NULL, NULL, "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/slider.end_.azar_.404.webp , https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/11.png", "شسیشسیشسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("31", "101", "شسیشسیسشی", NULL, "12", NULL, "true", "true", "درب حیاط", "single", "true", "Other cabinets", "1389", "true", "brick", "the north, south", "21", NULL, "commercial", "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/22-shatelbirthday-1920.600-0409-m-01.webp , https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/12.png", "شسیشسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("32", "105", "شسیشسیشسیشسیش", "23", "23", "true", "true", "true", NULL, NULL, "true", "metal", "1391", "true", "Ceramics", "south, east", "213", NULL, NULL, "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/22-shatelbirthday-1920.600-0409-m-011.webp , https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/13.png", "شسیشسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("33", "109", "سشیشسیشسی", NULL, "2", NULL, "true", "true", "درب حیاط", "double", "true", "mdf", "1392", "true", "brick", "south, east", "23", NULL, "commercial", "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/icon-8.webp", "سیشسیشسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("34", "112", "شسیشسی", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "شمال", NULL, NULL, NULL, NULL, "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/22-shatelbirthday-1920.600-0409-m-012.webp", "شسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("35", "115", "شسیشسی", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "جنوبی, شرقی", NULL, NULL, "residential", "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/icon-81.webp", "شسیشسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("36", "118", "شسیشس", NULL, NULL, NULL, NULL, NULL, "hall", NULL, NULL, NULL, NULL, NULL, NULL, "شرقی", NULL, NULL, "commercial", NULL, "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/icon-82.webp", "سشیشسیش");
INSERT INTO `aor_estate_file_meta` VALUES("37", "124", "سیبسیب", "1", "", "", "", "", "", "", "", "", "", "", "", "شمالی, جنوبی, شرقی, غربی", "", "", "", "1", "خصوصی", "[\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/571-5715396_tractor-png-high-quality-image-massey-ferguson-tractor.png\"]", "سیبسیب");
INSERT INTO `aor_estate_file_meta` VALUES("38", "519", "شسبسبی", "1", "", "false", "false", "false", "", "", "false", "", "", "false", "", "", "", "", "", "", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/1-banersnappey.webp", "سیبسب");
INSERT INTO `aor_estate_file_meta` VALUES("39", "521", "شسیشسی", "1", "", "false", "false", "false", "", "", "false", "", "", "false", "", "", "", "", "", "1", "خصوصی", "462,520", "شسیشی");
INSERT INTO `aor_estate_file_meta` VALUES("40", "563", "شسیشسیشسی", NULL, "2", NULL, "true", "true", "hall", "double", "true", "metal", "1395", "false", "Ceramics", "جنوبی, غربی", "2", NULL, NULL, "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/2-banersnappey.png", "شسیشسیشسی");
INSERT INTO `aor_estate_file_meta` VALUES("41", "566", "شسیشسیشسی", NULL, "2", NULL, "دارد", "ندارد", "درب هال", "تک لاین", "دارد", NULL, "1389", "دارد", "سرامیک", "جنوبی, غربی", "2", NULL, NULL, "1", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/2-banersnappey1.png", "یبسیبسیب");
INSERT INTO `aor_estate_file_meta` VALUES("42", "630", "سشیشسی", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2", "خصوصی", "https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/right-img-services.webp", "شسیشسی");

/* INSERT TABLE DATA: aor_gf_addon_feed */
INSERT INTO `aor_gf_addon_feed` VALUES("1", "1", "1", "0", "{\"feedName\":\"\\u062b\\u0628\\u062a \\u0645\\u0644\\u06a9 \\u062c\\u062f\\u06cc\\u062f\",\"action\":\"post-create\",\"postVisibility\":\"public\",\"postType\":\"estate_file\",\"postStatus\":\"private\",\"postDate\":\"entry\",\"postDateFieldDate\":\"\",\"postDateFieldTime\":\"\",\"postDateCustom\":\"\",\"postAuthor\":\"logged-in-user\",\"postComments\":\"0\",\"postPingbacks\":\"0\",\"postTitle\":\"{\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0645\\u0644\\u06a9::1}\",\"postContent\":\"{\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0645\\u0644\\u06a9::1}\",\"postMedia\":[\"16\"],\"postMetaFields\":[{\"key\":\"gf_custom\",\"custom_key\":\"gallery\",\"value\":\"16\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"_description\",\"value\":\"3\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"address\",\"value\":\"18\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"multi_unit\",\"value\":\"31\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"number_of_sleeps\",\"value\":\"6\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"parking\",\"value\":\"25\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"elevator\",\"value\":\"24\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"warehouse\",\"value\":\"26\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"access_type\",\"value\":\"32\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"frontage_type\",\"value\":\"41\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"cabinet\",\"value\":\"33\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"cabinet_type\",\"value\":\"34\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"year_of_manufacture\",\"value\":\"22\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"master\",\"value\":\"35\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"building_facade\",\"value\":\"36\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"side\",\"value\":\"43\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"meterage\",\"value\":\"20\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"square_footage_on_the_street\",\"value\":\"39\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"type_of_land\",\"value\":\"40\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"_visibility\",\"value\":\"42\",\"custom_value\":\"\"},{\"key\":\"gf_custom\",\"custom_key\":\"access_to_people\",\"value\":\"13\",\"custom_value\":\"\"}],\"postTaxonomy_property-type\":[{\"key\":\"field\",\"value\":\"17\",\"custom_value\":\"\"}],\"feed_condition_conditional_logic_object\":[],\"feed_condition_conditional_logic\":\"0\",\"postDiscussion\":\"\",\"feedCondition\":\"\"}", "gravityformsadvancedpostcreation", NULL);

/* INSERT TABLE DATA: aor_gf_draft_submissions */
INSERT INTO `aor_gf_draft_submissions` VALUES("eb3db6b794a84fdb9c329d3e24e12c06", NULL, "1", "2025-12-17 11:10:50", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u0644\\u06a9 \\u0628\\u0627 \\u06af\\u0631\\u0648\\u06cc\\u062a\\u06cc \\u0641\\u0631\\u0645\",\"3\":\"\\u0633\\u0631 \\u067e\\u06cc\\u0686\\u0648\",\"4\":{\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\"}},\"partial_entry\":{\"id\":\"1\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:10:50\",\"date_updated\":\"2025-12-17 11:10:50\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u0644\\u06a9 \\u0628\\u0627 \\u06af\\u0631\\u0648\\u06cc\\u062a\\u06cc \\u0641\\u0631\\u0645\",\"3\":\"\\u0633\\u0631 \\u067e\\u06cc\\u0686\\u0648\",\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\",\"submission_speeds\":\"{\\\"1\\\":[16384]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"69428fbaf12a3\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("6ca9a421cfcf457ea4ebef727d2430af", NULL, "1", "2025-12-17 11:13:45", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u062c\\u062f\\u062f\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"4\":{\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\"}},\"partial_entry\":{\"id\":\"2\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:13:45\",\"date_updated\":\"2025-12-17 11:13:45\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u062c\\u062f\\u062f\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\",\"submission_speeds\":\"{\\\"1\\\":[6917]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"6942906958782\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("909532afa12744d7b945bbef83f0cfde", NULL, "1", "2025-12-17 11:15:06", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u062a\\u0633\\u062a 2\",\"3\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"4\":{\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\"}},\"partial_entry\":{\"id\":\"3\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:15:05\",\"date_updated\":\"2025-12-17 11:15:05\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u062a\\u0633\\u062a 2\",\"3\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\",\"submission_speeds\":\"{\\\"1\\\":[6570]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694290ba08910\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("2ad0c36824864df9a307fc74b42e7ec9", NULL, "1", "2025-12-17 11:17:59", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u062a\\u0633\\u062a \\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"4\":{\"4.1\":\"\",\"4.2\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631\",\"4.3\":\"\\u0627\\u0646\\u0628\\u0627\\u0631\\u06cc\"}},\"partial_entry\":{\"id\":\"4\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:17:59\",\"date_updated\":\"2025-12-17 11:17:59\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u062a\\u0633\\u062a \\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"4.1\":\"\",\"4.2\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631\",\"4.3\":\"\\u0627\\u0646\\u0628\\u0627\\u0631\\u06cc\",\"submission_speeds\":\"{\\\"1\\\":[9960]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694291677ff43\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("2ecfc6d015ef4b72b4279d6660d85782", NULL, "1", "2025-12-17 11:21:54", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"12\",\"6\":\"3\",\"4\":{\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\"}},\"partial_entry\":{\"id\":\"5\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:21:53\",\"date_updated\":\"2025-12-17 11:21:53\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"12\",\"6\":\"3\",\"4.1\":\"\",\"4.2\":\"elevator\",\"4.3\":\"warehouse\",\"submission_speeds\":\"{\\\"1\\\":[18662]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"6942925202302\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("de3d33c7ed0441a3b7f99c7b4c6ab497", NULL, "1", "2025-12-17 11:23:53", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u0633\\u0634\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"\",\"6\":\"\",\"4\":{\"4.1\":\"\",\"4.2\":\"\",\"4.3\":\"warehouse\"}},\"partial_entry\":{\"id\":\"6\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:23:53\",\"date_updated\":\"2025-12-17 11:23:53\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u0633\\u0634\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"\",\"6\":\"\",\"4.1\":\"\",\"4.2\":\"\",\"4.3\":\"warehouse\",\"submission_speeds\":\"{\\\"1\\\":[3364]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694292c4b635c\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("832d4406553f44829094913e802b81c0", NULL, "1", "2025-12-17 11:44:28", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"lkl;ka;skd;laskd;asd\",\"3\":\"asdasdasd\",\"5\":\"\",\"6\":\"\",\"4\":{\"4.1\":\"\",\"4.2\":\"true\",\"4.3\":\"\"}},\"partial_entry\":{\"id\":\"7\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:44:27\",\"date_updated\":\"2025-12-17 11:44:27\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"lkl;ka;skd;laskd;asd\",\"3\":\"asdasdasd\",\"5\":\"\",\"6\":\"\",\"4.1\":\"\",\"4.2\":\"true\",\"4.3\":\"\",\"submission_speeds\":\"{\\\"1\\\":[7664]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"6942979c087bf\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("b3d6a4cd468b407ea172b565a8336e46", NULL, "1", "2025-12-17 11:45:47", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\",\"3\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"\",\"6\":\"\",\"4\":{\"4.1\":\"\",\"4.2\":\"\",\"4.3\":\"\"}},\"partial_entry\":{\"id\":\"8\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:45:47\",\"date_updated\":\"2025-12-17 11:45:47\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\",\"3\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"\",\"6\":\"\",\"4.1\":\"\",\"4.2\":\"\",\"4.3\":\"\",\"submission_speeds\":\"{\\\"1\\\":[12336]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694297ebbaaf2\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("ced8bb421dc7443c9bda02acdb03d0bf", NULL, "1", "2025-12-17 11:46:03", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\",\"3\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\",\"5\":\"\",\"6\":\"\",\"4\":{\"4.1\":\"\",\"4.2\":\"\",\"4.3\":\"\"}},\"partial_entry\":{\"id\":\"9\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:46:03\",\"date_updated\":\"2025-12-17 11:46:03\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\",\"3\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631 \\u0646\\u062f\\u0627\\u0631\\u06cc\\u0645\",\"5\":\"\",\"6\":\"\",\"4.1\":\"\",\"4.2\":\"\",\"4.3\":\"\",\"submission_speeds\":\"{\\\"1\\\":[6980]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694297fb67fb6\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("01ef2aada8a24f0eaf24bc36477f2e9c", NULL, "1", "2025-12-17 11:49:50", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u062a\\u0633\\u062a \\u0627\\u0646\\u0628\\u0627\\u0631 \\u0648 \\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u06cc\",\"5\":\"\",\"6\":\"\",\"4\":{\"4.1\":\"\",\"4.2\":\"true\",\"4.3\":\"true\"}},\"partial_entry\":{\"id\":\"10\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:49:50\",\"date_updated\":\"2025-12-17 11:49:50\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u062a\\u0633\\u062a \\u0627\\u0646\\u0628\\u0627\\u0631 \\u0648 \\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u06cc\",\"5\":\"\",\"6\":\"\",\"4.1\":\"\",\"4.2\":\"true\",\"4.3\":\"true\",\"submission_speeds\":\"{\\\"1\\\":[16074]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694298dedd73d\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("c8a48c7b133f41838ad5e75258545b2f", NULL, "1", "2025-12-17 11:50:46", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"1\":\"\\u062a\\u0633\\u062a \\u0627\\u0646\\u0628\\u0627\\u0631 \\u0648 \\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"\",\"6\":\"\",\"4\":{\"4.1\":\"\",\"4.2\":\"true\",\"4.3\":\"true\"}},\"partial_entry\":{\"id\":\"11\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.197\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-17 11:50:46\",\"date_updated\":\"2025-12-17 11:50:46\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1\":\"\\u062a\\u0633\\u062a \\u0627\\u0646\\u0628\\u0627\\u0631 \\u0648 \\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"5\":\"\",\"6\":\"\",\"4.1\":\"\",\"4.2\":\"true\",\"4.3\":\"true\",\"submission_speeds\":\"{\\\"1\\\":[9798]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"69429916df482\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("89b12bde66fe4c6fa536b407d2bd0218", NULL, "1", "2025-12-27 09:05:35", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u0645\\u0644\\u06a9 \\u062a\\u0633\\u062a\\u06cc\",\"3\":\"\\u0627\\u06cc\\u0646 \\u06cc\\u06a9 \\u0645\\u0644\\u06a9 \\u062a\\u0633\\u062a\\u06cc \\u0627\\u0633\\u062a\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u06cc\\u0631\\u0627\\u0632\\u060c \\u0641\\u0633\\u0627\",\"28\":\"\",\"20\":\"222\",\"6\":\"22\",\"22\":\"1390\",\"24\":\"\",\"25\":\"\\u062f\\u0627\\u0631\\u062f\",\"26\":\"\\u062f\\u0627\\u0631\\u062f\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\\u062f\\u0648 \\u0646\\u0628\\u0634 (\\u062f\\u0648\\u0628\\u0631)\",\"32\":\"\\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644\",\"33\":\"\\u062f\\u0627\\u0631\\u062f\",\"34\":\"\\u062f\\u0627\\u0631\\u062f\",\"35\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"36\":\"\\u062f\\u0627\\u0631\\u062f\",\"38\":{\"38.1\":\"\",\"38.2\":\"\\u062c\\u0646\\u0648\\u0628\",\"38.3\":\"\\u0634\\u0631\\u0642\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"12\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 09:05:35\",\"date_updated\":\"2025-12-27 09:05:35\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/logo.png\\\",\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/1.png\\\"]\",\"1\":\"\\u0645\\u0644\\u06a9 \\u062a\\u0633\\u062a\\u06cc\",\"3\":\"\\u0627\\u06cc\\u0646 \\u06cc\\u06a9 \\u0645\\u0644\\u06a9 \\u062a\\u0633\\u062a\\u06cc \\u0627\\u0633\\u062a\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u06cc\\u0631\\u0627\\u0632\\u060c \\u0641\\u0633\\u0627\",\"20\":\"222\",\"6\":\"22\",\"22\":\"1390\",\"25\":\"\\u062f\\u0627\\u0631\\u062f\",\"26\":\"\\u062f\\u0627\\u0631\\u062f\",\"41\":\"\\u062f\\u0648 \\u0646\\u0628\\u0634 (\\u062f\\u0648\\u0628\\u0631)\",\"32\":\"\\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644\",\"33\":\"\\u062f\\u0627\\u0631\\u062f\",\"34\":\"\\u062f\\u0627\\u0631\\u062f\",\"35\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"36\":\"\\u062f\\u0627\\u0631\\u062f\",\"38.1\":\"\",\"38.2\":\"\\u062c\\u0646\\u0648\\u0628\",\"38.3\":\"\\u0634\\u0631\\u0642\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[6921]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"98d02b57_input_16_D0YI1Yb3jGNqdsdX_o_1jdfgp83q1qsg6g67vcukd106mc.png\",\"uploaded_filename\":\"logo.png\",\"id\":\"o_1jdfgp83q1qsg6g67vcukd106mc\"},{\"temp_filename\":\"98d02b57_input_16_bS0y8rRkCuszWisN_o_1jdfgp83q1h8ojo41pok1leu12b4b.png\",\"uploaded_filename\":\"1.png\",\"id\":\"o_1jdfgp83q1h8ojo41pok1leu12b4b\"}]},\"gform_unique_id\":\"98d02b57\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("06a3a03171da4293a6b109f8effb9773", NULL, "1", "2025-12-27 09:25:56", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u0644\\u06a9 \\u0628\\u0627 \\u0647\\u0645\\u0647 \\u06af\\u0632\\u06cc\\u0646\\u0647 \\u0647\\u0627\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"213\",\"6\":\"2\",\"22\":\"1387\",\"24\":\"true\",\"25\":\"true\",\"26\":\"true\",\"27\":\"\",\"19\":\"\",\"31\":\"15\",\"41\":\"\",\"32\":\"\",\"33\":\"true\",\"34\":\"metal\",\"35\":\"true\",\"36\":\"Ceramics\",\"38\":{\"38.1\":\"the north\",\"38.2\":\"\",\"38.3\":\"\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"13\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 09:25:56\",\"date_updated\":\"2025-12-27 09:25:56\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/slider.end_.azar_.404.webp\\\",\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/11.png\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u0644\\u06a9 \\u0628\\u0627 \\u0647\\u0645\\u0647 \\u06af\\u0632\\u06cc\\u0646\\u0647 \\u0647\\u0627\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"213\",\"6\":\"2\",\"22\":\"1387\",\"24\":\"true\",\"25\":\"true\",\"26\":\"true\",\"31\":\"15\",\"33\":\"true\",\"34\":\"metal\",\"35\":\"true\",\"36\":\"Ceramics\",\"38.1\":\"the north\",\"38.2\":\"\",\"38.3\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"41\":\"\",\"32\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[4510]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"82e3089c_input_16_6njNaehCaJIxOb0i_o_1jdfhvslf1a3gh64mo2r8843mc.webp\",\"uploaded_filename\":\"slider.end_.azar_.404.webp\",\"id\":\"o_1jdfhvslf1a3gh64mo2r8843mc\"},{\"temp_filename\":\"82e3089c_input_16_txDvctbRf3QMFvlL_o_1jdfhvslf2vlidj14g21ct917hlb.png\",\"uploaded_filename\":\"1.png\",\"id\":\"o_1jdfhvslf2vlidj14g21ct917hlb\"}]},\"gform_unique_id\":\"82e3089c\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("39f6dc19bb3a48219638dd35aa148685", NULL, "1", "2025-12-27 09:35:03", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639 \\u0648 \\u0632\\u0645\\u06cc\\u0646\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0633\\u0634\\u06cc\",\"28\":\"\",\"20\":\"21\",\"6\":\"12\",\"22\":\"1389\",\"24\":\"\",\"25\":\"true\",\"26\":\"true\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"single\",\"32\":\"\\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"33\":\"true\",\"34\":\"Other cabinets\",\"35\":\"true\",\"36\":\"brick\",\"38\":{\"38.1\":\"the north\",\"38.2\":\"south\",\"38.3\":\"\"},\"39\":\"\",\"40\":\"commercial\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"14\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 09:35:03\",\"date_updated\":\"2025-12-27 09:35:03\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/22-shatelbirthday-1920.600-0409-m-01.webp\\\",\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/12.png\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639 \\u0648 \\u0632\\u0645\\u06cc\\u0646\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0633\\u0634\\u06cc\",\"20\":\"21\",\"6\":\"12\",\"22\":\"1389\",\"25\":\"true\",\"26\":\"true\",\"41\":\"single\",\"32\":\"\\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"33\":\"true\",\"34\":\"Other cabinets\",\"35\":\"true\",\"36\":\"brick\",\"38.1\":\"the north\",\"38.2\":\"south\",\"38.3\":\"\",\"40\":\"commercial\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"39\":\"\",\"submission_speeds\":\"{\\\"4\\\":[3633]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"976fc548_input_16_wPCJ5pVEDWAQBJoy_o_1jdfigt6m1ef719qb1hvclnf98cc.webp\",\"uploaded_filename\":\"22-shatelbirthday-1920.600-0409-m-01.webp\",\"id\":\"o_1jdfigt6m1ef719qb1hvclnf98cc\"},{\"temp_filename\":\"976fc548_input_16_btdPwYsdqrIAcGkV_o_1jdfigt6m1ecq1dqp17ivucsetb.png\",\"uploaded_filename\":\"1.png\",\"id\":\"o_1jdfigt6m1ecq1dqp17ivucsetb\"}]},\"gform_unique_id\":\"976fc548\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("000cf2ecc8da4d4ea4745a988843a1cb", NULL, "1", "2025-12-27 09:47:35", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\",\"28\":\"\",\"20\":\"213\",\"6\":\"23\",\"22\":\"1391\",\"24\":\"true\",\"25\":\"true\",\"26\":\"true\",\"27\":\"\",\"19\":\"\",\"31\":\"23\",\"41\":\"\",\"32\":\"\",\"33\":\"true\",\"34\":\"metal\",\"35\":\"true\",\"36\":\"Ceramics\",\"38\":{\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"15\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 09:47:35\",\"date_updated\":\"2025-12-27 09:47:35\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/22-shatelbirthday-1920.600-0409-m-011.webp\\\",\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/13.png\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\",\"20\":\"213\",\"6\":\"23\",\"22\":\"1391\",\"24\":\"true\",\"25\":\"true\",\"26\":\"true\",\"31\":\"23\",\"33\":\"true\",\"34\":\"metal\",\"35\":\"true\",\"36\":\"Ceramics\",\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"41\":\"\",\"32\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[6730]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"97845b2a_input_16_B5J3QpU3zZKFDMod_o_1jdfj4jip13deb2v1gl214551hukc.webp\",\"uploaded_filename\":\"22-shatelbirthday-1920.600-0409-m-01.webp\",\"id\":\"o_1jdfj4jip13deb2v1gl214551hukc\"},{\"temp_filename\":\"97845b2a_input_16_7GzKCMXbOiTryYW8_o_1jdfj4jipafm1mpdd2v1fl61i2ub.png\",\"uploaded_filename\":\"1.png\",\"id\":\"o_1jdfj4jipafm1mpdd2v1fl61i2ub\"}]},\"gform_unique_id\":\"97845b2a\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("9fb8fba39ea145449b140b37760264bc", NULL, "1", "2025-12-27 09:51:16", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639 2\",\"3\":\"\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"23\",\"6\":\"2\",\"22\":\"1392\",\"24\":\"\",\"25\":\"true\",\"26\":\"true\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"double\",\"32\":\"\\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"33\":\"true\",\"34\":\"mdf\",\"35\":\"true\",\"36\":\"brick\",\"38\":{\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\"},\"39\":\"\",\"40\":\"commercial\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"16\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 09:51:16\",\"date_updated\":\"2025-12-27 09:51:16\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/icon-8.webp\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639 2\",\"3\":\"\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"23\",\"6\":\"2\",\"22\":\"1392\",\"25\":\"true\",\"26\":\"true\",\"41\":\"double\",\"32\":\"\\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"33\":\"true\",\"34\":\"mdf\",\"35\":\"true\",\"36\":\"brick\",\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\",\"40\":\"commercial\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"39\":\"\",\"submission_speeds\":\"{\\\"4\\\":[4126]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"08eb5640_input_16_WNRPW4J4J2V8Ngd1_o_1jdfjer6j1shkt4d17os1obv1qaaa.webp\",\"uploaded_filename\":\"icon-8.webp\",\"id\":\"o_1jdfjer6j1shkt4d17os1obv1qaaa\"}]},\"gform_unique_id\":\"08eb5640\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("d69e2a3099c94670921275a884bb880b", NULL, "1", "2025-12-27 10:06:37", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639 3\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"38\":{\"38.1\":\"north\",\"38.2\":\"\",\"38.3\":\"\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"\"},\"partial_entry\":{\"id\":\"17\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 10:06:37\",\"date_updated\":\"2025-12-27 10:06:37\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/22-shatelbirthday-1920.600-0409-m-012.webp\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u0636\\u0644\\u0639 3\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"38.1\":\"north\",\"38.2\":\"\",\"38.3\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[2059]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"ca8c8d67_input_16_ep8Ub2i2TyqkUQRG_o_1jdfkbn0418vp154d8ub1uun1ipra.webp\",\"uploaded_filename\":\"22-shatelbirthday-1920.600-0409-m-01.webp\",\"id\":\"o_1jdfkbn0418vp154d8ub1uun1ipra\"}]},\"gform_unique_id\":\"ca8c8d67\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("168c529c8b744a8fad67ad942731a748", NULL, "1", "2025-12-27 10:09:32", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc213\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"38\":{\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\"},\"39\":\"\",\"40\":\"residential\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"18\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 10:09:32\",\"date_updated\":\"2025-12-27 10:09:32\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/icon-81.webp\\\"]\",\"1\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc213\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\",\"40\":\"residential\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"submission_speeds\":\"{\\\"4\\\":[3503]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"f5371a7d_input_16_3yrla0LuyUagYBHC_o_1jdfkgcvk1srchp11jls1nce1t1fa.webp\",\"uploaded_filename\":\"icon-8.webp\",\"id\":\"o_1jdfkgcvk1srchp11jls1nce1t1fa\"}]},\"gform_unique_id\":\"f5371a7d\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("38143c4c9a8141b0856625d3ec9a6b79", NULL, "1", "2025-12-27 10:12:29", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644 \\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"3\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\",\"14\":\"\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"hall\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"38\":{\"38.1\":\"\",\"38.2\":\"\",\"38.3\":\"east\"},\"39\":\"\",\"40\":\"commercial\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"\"},\"partial_entry\":{\"id\":\"19\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 10:12:29\",\"date_updated\":\"2025-12-27 10:12:29\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/icon-82.webp\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644 \\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"3\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\\u0634\",\"17\":\"\\u0632\\u0645\\u06cc\\u0646\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"hall\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"38.1\":\"\",\"38.2\":\"\",\"38.3\":\"east\",\"40\":\"commercial\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"submission_speeds\":\"{\\\"4\\\":[2270]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"2e4c5828_input_16_bFKYPzE31YHm0AUW_o_1jdfkl5d61op5n281j8p1thq5tua.webp\",\"uploaded_filename\":\"icon-8.webp\",\"id\":\"o_1jdfkl5d61op5n281j8p1thq5tua\"}]},\"gform_unique_id\":\"2e4c5828\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("8de325f99cc14338a329768d3abcee4b", NULL, "1", "2025-12-27 10:29:03", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0646\\u0645\\u0633\\u06cc\\u062a\\u0628\\u0645\\u0633\\u06cc\\u0628\",\"3\":\"\\u0633\\u06cc\\u0628\\u0633\\u06cc\\u0628\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0633\\u06cc\\u0628\\u0633\\u06cc\\u0628\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"38\":{\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"\\u0627\\u0645\\u06cc\\u0631\\u0645\\u062d\\u0645\\u062f \\u0639\\u0628\\u062f\\u06cc\"]},\"partial_entry\":{\"id\":\"20\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 10:29:03\",\"date_updated\":\"2025-12-27 10:29:03\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/571-5715396_tractor-png-high-quality-image-massey-ferguson-tractor.png\\\"]\",\"1\":\"\\u062a\\u0646\\u0645\\u0633\\u06cc\\u062a\\u0628\\u0645\\u0633\\u06cc\\u0628\",\"3\":\"\\u0633\\u06cc\\u0628\\u0633\\u06cc\\u0628\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0633\\u06cc\\u0628\\u0633\\u06cc\\u0628\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"38.1\":\"\",\"38.2\":\"south\",\"38.3\":\"east\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"\\\\u0627\\\\u0645\\\\u06cc\\\\u0631\\\\u0645\\\\u062d\\\\u0645\\\\u062f \\\\u0639\\\\u0628\\\\u062f\\\\u06cc\\\"]\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[3282]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"a0759330_input_16_TN3grlLhCGX28A8g_o_1jdflkevf1qrb1cdu1vek7h91g9ja.png\",\"uploaded_filename\":\"571-5715396_tractor-png-high-quality-image-massey-ferguson-tractor.png\",\"id\":\"o_1jdflkevf1qrb1cdu1vek7h91g9ja\"}]},\"gform_unique_id\":\"a0759330\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("b4c4478dabc742e1b693d111a2736ec8", NULL, "2", "2025-12-27 11:01:49", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "{\"submitted_values\":{\"1\":{\"1.1\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"1.2\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"1.3\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\"}},\"partial_entry\":{\"id\":\"21\",\"status\":\"active\",\"form_id\":\"2\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=2\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 11:01:48\",\"date_updated\":\"2025-12-27 11:01:48\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1.1\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"1.2\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"1.3\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\",\"submission_speeds\":\"{\\\"1\\\":[4446]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694fbc9d26eee\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("336f42d7aef44505b37dd8f23411747a", NULL, "2", "2025-12-27 11:10:38", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "{\"submitted_values\":{\"1\":{\"1.1\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"1.2\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"1.3\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\"}},\"partial_entry\":{\"id\":\"22\",\"status\":\"active\",\"form_id\":\"2\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=2\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 11:10:38\",\"date_updated\":\"2025-12-27 11:10:38\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1.1\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"1.2\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"1.3\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\",\"submission_speeds\":\"{\\\"1\\\":[11323]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694fbea224f49\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("dc5f2cfa97d5426599dd120285b33456", NULL, "2", "2025-12-27 11:12:03", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "{\"submitted_values\":{\"1\":{\"1.1\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"1.2\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"1.3\":\"\"}},\"partial_entry\":{\"id\":\"23\",\"status\":\"active\",\"form_id\":\"2\",\"ip\":\"151.233.195.31\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=2\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 11:12:03\",\"date_updated\":\"2025-12-27 11:12:03\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"1.1\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"1.2\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"1.3\":\"\",\"submission_speeds\":\"{\\\"1\\\":[3076]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"694fbf0395e69\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("3deec92f29434a7abcd4794450d5a336", NULL, "2", "2025-12-27 16:41:53", "151.233.155.71", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "{\"submitted_values\":{\"2\":{\"2.1\":\"\",\"2.2\":\"\",\"2.3\":\"\",\"2.4\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0686\\u0647\\u0627\\u0631\\u0645\"}},\"partial_entry\":{\"id\":\"26\",\"status\":\"active\",\"form_id\":\"2\",\"ip\":\"151.233.155.71\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=2\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-27 16:41:53\",\"date_updated\":\"2025-12-27 16:41:53\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"2.1\":\"\",\"2.2\":\"\",\"2.3\":\"\",\"2.4\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0686\\u0647\\u0627\\u0631\\u0645\",\"submission_speeds\":\"{\\\"1\\\":[4273]}\"},\"field_values\":\"\",\"page_number\":\"1\",\"files\":[],\"gform_unique_id\":\"69500c5163aef\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("003483476c0b4a85bc6594300122465f", NULL, "1", "2025-12-28 12:51:12", "151.233.187.240", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u06cc\\u0648\\u0632\\u0631 \\u0622\\u06cc\\u062f\\u06cc\",\"3\":\"\\u0633\\u06cc\\u0628\\u0633\\u0628\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u0628\\u0633\\u0628\\u06cc\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"43\":{\"43.1\":\"\",\"43.2\":\"\",\"43.3\":\"\",\"43.4\":\"\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"\"},\"partial_entry\":{\"id\":\"27\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.187.240\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/?gf_page=preview&id=1\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-28 12:51:10\",\"date_updated\":\"2025-12-28 12:51:10\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":null,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/1-banersnappey.webp\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u06cc\\u0648\\u0632\\u0631 \\u0622\\u06cc\\u062f\\u06cc\",\"3\":\"\\u0633\\u06cc\\u0628\\u0633\\u0628\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u0628\\u0633\\u0628\\u06cc\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"43.1\":\"\",\"43.2\":\"\",\"43.3\":\"\",\"43.4\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[2181]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"0f3cf2ca_input_16_ykAFV3Y6kJJtDDoN_o_1jdig5sc0shtsvd13pf1qah1lh5a.webp\",\"uploaded_filename\":\"1-banersnappey.webp\",\"id\":\"o_1jdig5sc0shtsvd13pf1qah1lh5a\"}]},\"gform_unique_id\":\"0f3cf2ca\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("7183d953cb2844d892f11fbb0b57c6a1", NULL, "1", "2025-12-28 12:53:31", "151.233.187.240", "https://amlakor.azindm.ir/crm/my-property/add-new-property/", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u06cc\\u0648\\u0632\\u0631 \\u0622\\u06cc\\u062f\\u06cc 2\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u06cc\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"43\":{\"43.1\":\"\",\"43.2\":\"\",\"43.3\":\"\",\"43.4\":\"\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"28\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.187.240\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/crm\\/my-property\\/add-new-property\\/\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-28 12:53:29\",\"date_updated\":\"2025-12-28 12:53:29\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":197,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/1-banersnappey1.webp\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u06cc\\u0648\\u0632\\u0631 \\u0622\\u06cc\\u062f\\u06cc 2\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u06cc\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"43.1\":\"\",\"43.2\":\"\",\"43.3\":\"\",\"43.4\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[4156]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"7c56b124_input_16_eItz2jYzUFNZAvQD_o_1jdig9k961iiulkq4v91rl31ov1a.webp\",\"uploaded_filename\":\"1-banersnappey.webp\",\"id\":\"o_1jdig9k961iiulkq4v91rl31ov1a\"}]},\"gform_unique_id\":\"7c56b124\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("a021407668394ccb8a97f3dea87a0244", NULL, "1", "2025-12-28 16:24:46", "151.233.242.248", "https://amlakor.azindm.ir/crm/my-property/add-new-property/?_=1766939009589", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u062a\\u0646 \\u0647\\u0627\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"2\",\"6\":\"2\",\"22\":\"1395\",\"24\":\"\",\"25\":\"true\",\"26\":\"true\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"double\",\"32\":\"hall\",\"33\":\"true\",\"34\":\"metal\",\"35\":\"false\",\"36\":\"Ceramics\",\"43\":{\"43.1\":\"\",\"43.2\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"43.3\":\"\",\"43.4\":\"\\u063a\\u0631\\u0628\\u06cc\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"29\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.242.248\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/crm\\/my-property\\/add-new-property\\/?_=1766939009589\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-28 16:24:45\",\"date_updated\":\"2025-12-28 16:24:45\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":197,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/2-banersnappey.png\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u0645\\u062a\\u0646 \\u0647\\u0627\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"2\",\"6\":\"2\",\"22\":\"1395\",\"25\":\"true\",\"26\":\"true\",\"41\":\"double\",\"32\":\"hall\",\"33\":\"true\",\"34\":\"metal\",\"35\":\"false\",\"36\":\"Ceramics\",\"43.1\":\"\",\"43.2\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"43.3\":\"\",\"43.4\":\"\\u063a\\u0631\\u0628\\u06cc\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[4347]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"ec31a4ca_input_16_CrsrQocz3y5QWEmW_o_1jdisbotf14ha106814nv17nmt9a.png\",\"uploaded_filename\":\"2-banersnappey.png\",\"id\":\"o_1jdisbotf14ha106814nv17nmt9a\"}]},\"gform_unique_id\":\"ec31a4ca\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("bb136177aee34d1a997dc0d32568f351", NULL, "1", "2025-12-28 16:29:21", "151.233.242.248", "https://amlakor.azindm.ir/crm/my-property/add-new-property/?_=1766939284780", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a \\u062c\\u062f\\u06cc\\u062f\",\"3\":\"\\u06cc\\u0628\\u0633\\u06cc\\u0628\\u0633\\u06cc\\u0628\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"2\",\"6\":\"2\",\"22\":\"1389\",\"24\":\"\",\"25\":\"\\u062f\\u0627\\u0631\\u062f\",\"26\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\\u062a\\u06a9 \\u0644\\u0627\\u06cc\\u0646\",\"32\":\"\\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644\",\"33\":\"\\u062f\\u0627\\u0631\\u062f\",\"34\":\"\",\"35\":\"\\u062f\\u0627\\u0631\\u062f\",\"36\":\"\\u0633\\u0631\\u0627\\u0645\\u06cc\\u06a9\",\"43\":{\"43.1\":\"\",\"43.2\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"43.3\":\"\",\"43.4\":\"\\u063a\\u0631\\u0628\\u06cc\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"1\"]},\"partial_entry\":{\"id\":\"30\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.242.248\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/crm\\/my-property\\/add-new-property\\/?_=1766939284780\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-28 16:29:20\",\"date_updated\":\"2025-12-28 16:29:20\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":197,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/2-banersnappey1.png\\\"]\",\"1\":\"\\u062a\\u0633\\u062a \\u062c\\u062f\\u06cc\\u062f\",\"3\":\"\\u06cc\\u0628\\u0633\\u06cc\\u0628\\u0633\\u06cc\\u0628\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"2\",\"6\":\"2\",\"22\":\"1389\",\"25\":\"\\u062f\\u0627\\u0631\\u062f\",\"26\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"41\":\"\\u062a\\u06a9 \\u0644\\u0627\\u06cc\\u0646\",\"32\":\"\\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644\",\"33\":\"\\u062f\\u0627\\u0631\\u062f\",\"35\":\"\\u062f\\u0627\\u0631\\u062f\",\"36\":\"\\u0633\\u0631\\u0627\\u0645\\u06cc\\u06a9\",\"43.1\":\"\",\"43.2\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"43.3\":\"\",\"43.4\":\"\\u063a\\u0631\\u0628\\u06cc\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"1\\\"]\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[2980]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"aab21533_input_16_J0ccKIiwG5NLzNzF_o_1jdisk37g1dq42t811mh1phg1931a.png\",\"uploaded_filename\":\"2-banersnappey.png\",\"id\":\"o_1jdisk37g1dq42t811mh1phg1931a\"}]},\"gform_unique_id\":\"aab21533\"}");
INSERT INTO `aor_gf_draft_submissions` VALUES("aac3609c2422458a96bfb419202e42eb", NULL, "1", "2025-12-29 15:27:32", "151.233.238.123", "https://amlakor.azindm.ir/crm/my-property/add-new-property/?_=1767021990344", "{\"submitted_values\":{\"16\":\"\",\"1\":\"\\u062a\\u0633\\u062a\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"14\":\"\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\",\"28\":\"\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"24\":\"\",\"25\":\"\",\"26\":\"\",\"27\":\"\",\"19\":\"\",\"31\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"34\":\"\",\"35\":\"\",\"36\":\"\",\"43\":{\"43.1\":\"\",\"43.2\":\"\",\"43.3\":\"\",\"43.4\":\"\"},\"39\":\"\",\"40\":\"\",\"29\":\"\",\"30\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":[\"2\"]},\"partial_entry\":{\"id\":\"31\",\"status\":\"active\",\"form_id\":\"1\",\"ip\":\"151.233.238.123\",\"source_url\":\"https:\\/\\/amlakor.azindm.ir\\/crm\\/my-property\\/add-new-property\\/?_=1767021990344\",\"currency\":\"USD\",\"post_id\":null,\"date_created\":\"2025-12-29 15:27:31\",\"date_updated\":\"2025-12-29 15:27:31\",\"is_starred\":0,\"is_read\":0,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/143.0.0.0 Safari\\/537.36\",\"payment_status\":null,\"payment_date\":null,\"payment_amount\":null,\"payment_method\":\"\",\"transaction_id\":null,\"is_fulfilled\":null,\"created_by\":\"1\",\"transaction_type\":null,\"source_id\":197,\"16\":\"[\\\"https:\\\\\\/\\\\\\/amlakor.azindm.ir\\\\\\/wp-content\\\\\\/uploads\\\\\\/gravity_forms\\\\\\/1-d36590944d4e0849fcdfb5fb546a0791\\\\\\/2025\\\\\\/12\\\\\\/right-img-services.webp\\\"]\",\"1\":\"\\u062a\\u0633\\u062a\",\"3\":\"\\u0634\\u0633\\u06cc\\u0634\\u0633\\u06cc\",\"17\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"18\":\"\\u0633\\u0634\\u06cc\\u0634\\u0633\\u06cc\",\"20\":\"\",\"6\":\"\",\"22\":\"\",\"25\":\"\",\"26\":\"\",\"41\":\"\",\"32\":\"\",\"33\":\"\",\"35\":\"\",\"36\":\"\",\"43.1\":\"\",\"43.2\":\"\",\"43.3\":\"\",\"43.4\":\"\",\"42\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"13\":\"[\\\"2\\\"]\",\"24\":\"\",\"31\":\"\",\"34\":\"\",\"39\":\"\",\"40\":\"\",\"submission_speeds\":\"{\\\"4\\\":[10818]}\"},\"field_values\":\"\",\"page_number\":\"4\",\"files\":{\"input_16\":[{\"temp_filename\":\"9c575da8_input_16_hcORQeGT3J9Clbys_o_1jdlbg5in1qcv1mam1a0tlr1ifpa.webp\",\"uploaded_filename\":\"right-img-services.webp\",\"id\":\"o_1jdlbg5in1qcv1mam1a0tlr1ifpa\"}]},\"gform_unique_id\":\"9c575da8\"}");

/* INSERT TABLE DATA: aor_gf_entry */
INSERT INTO `aor_gf_entry` VALUES("1", "1", NULL, "2025-12-17 11:10:50", "2025-12-17 11:10:50", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "5735640601", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("2", "1", NULL, "2025-12-17 11:13:45", "2025-12-17 11:13:45", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6266188159", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("3", "1", NULL, "2025-12-17 11:15:05", "2025-12-17 11:15:05", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "7858532273", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("4", "1", NULL, "2025-12-17 11:17:59", "2025-12-17 11:17:59", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "1364038229", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("5", "1", NULL, "2025-12-17 11:21:53", "2025-12-17 11:21:53", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6091533368", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("6", "1", NULL, "2025-12-17 11:23:53", "2025-12-17 11:23:53", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6929903135", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("7", "1", NULL, "2025-12-17 11:44:27", "2025-12-17 11:44:27", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "2260091692", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("8", "1", NULL, "2025-12-17 11:45:47", "2025-12-17 11:45:47", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "4953139185", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("9", "1", NULL, "2025-12-17 11:46:03", "2025-12-17 11:46:03", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "3330013649", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("10", "1", NULL, "2025-12-17 11:49:50", "2025-12-17 11:49:50", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "0115290798", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("11", "1", NULL, "2025-12-17 11:50:46", "2025-12-17 11:50:46", "0", "0", "151.233.195.197", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6614091353", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("12", "1", NULL, "2025-12-27 09:05:35", "2025-12-27 09:05:35", "0", "0", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6350606041", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("13", "1", NULL, "2025-12-27 09:25:56", "2025-12-27 09:25:56", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, "", "4139560711", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("14", "1", NULL, "2025-12-27 09:35:03", "2025-12-27 09:35:03", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, "", "8288987975", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("15", "1", NULL, "2025-12-27 09:47:35", "2025-12-27 09:47:35", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, "", "6750265829", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("16", "1", NULL, "2025-12-27 09:51:16", "2025-12-27 09:51:16", "0", "0", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "2499147226", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("17", "1", NULL, "2025-12-27 10:06:37", "2025-12-27 10:06:37", "0", "0", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6859643948", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("18", "1", NULL, "2025-12-27 10:09:32", "2025-12-27 10:09:32", "0", "0", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6341956633", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("19", "1", NULL, "2025-12-27 10:12:29", "2025-12-27 10:12:29", "0", "0", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "1627815011", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("20", "1", NULL, "2025-12-27 10:29:03", "2025-12-28 00:11:00", "0", "0", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "2770471911", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("21", "2", NULL, "2025-12-27 11:01:48", "2025-12-27 11:01:48", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "9771542986", NULL, "1", NULL, "trash", NULL);
INSERT INTO `aor_gf_entry` VALUES("22", "2", NULL, "2025-12-27 11:10:38", "2025-12-27 11:10:38", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "9230326434", NULL, "1", NULL, "trash", NULL);
INSERT INTO `aor_gf_entry` VALUES("23", "2", NULL, "2025-12-27 11:12:03", "2025-12-27 11:12:03", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "0153163696", NULL, "1", NULL, "trash", NULL);
INSERT INTO `aor_gf_entry` VALUES("24", "2", NULL, "2025-12-27 11:29:44", "2025-12-27 11:29:44", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("25", "2", NULL, "2025-12-27 11:31:08", "2025-12-27 11:31:08", "0", "1", "151.233.195.31", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("26", "2", NULL, "2025-12-27 16:41:53", "2025-12-27 16:41:53", "0", "0", "151.233.155.71", "https://amlakor.azindm.ir/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "4846200285", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("27", "1", NULL, "2025-12-28 12:51:10", "2025-12-28 12:51:10", "0", "0", "151.233.187.240", "https://amlakor.azindm.ir/?gf_page=preview&id=1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "1123430327", NULL, "1", NULL, "active", NULL);
INSERT INTO `aor_gf_entry` VALUES("28", "1", NULL, "2025-12-28 12:53:29", "2025-12-28 12:53:29", "0", "0", "151.233.187.240", "https://amlakor.azindm.ir/crm/my-property/add-new-property/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "9840371815", NULL, "1", NULL, "active", "197");
INSERT INTO `aor_gf_entry` VALUES("29", "1", NULL, "2025-12-28 16:24:45", "2025-12-28 16:24:45", "0", "0", "151.233.242.248", "https://amlakor.azindm.ir/crm/my-property/add-new-property/?_=1766939009589", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "0662805858", NULL, "1", NULL, "active", "197");
INSERT INTO `aor_gf_entry` VALUES("30", "1", NULL, "2025-12-28 16:29:20", "2025-12-28 16:29:20", "0", "0", "151.233.242.248", "https://amlakor.azindm.ir/crm/my-property/add-new-property/?_=1766939284780", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "6844915397", NULL, "1", NULL, "active", "197");
INSERT INTO `aor_gf_entry` VALUES("31", "1", NULL, "2025-12-29 15:27:31", "2025-12-29 15:27:31", "0", "0", "151.233.238.123", "https://amlakor.azindm.ir/crm/my-property/add-new-property/?_=1767021990344", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "USD", NULL, NULL, NULL, NULL, "4835240740", NULL, "1", NULL, "active", "197");

/* INSERT TABLE DATA: aor_gf_entry_meta */
INSERT INTO `aor_gf_entry_meta` VALUES("1", "1", "1", "1", "تست ملک با گرویتی فرم", "");
INSERT INTO `aor_gf_entry_meta` VALUES("2", "1", "1", "3", "سر پیچو", "");
INSERT INTO `aor_gf_entry_meta` VALUES("5", "1", "1", "submission_speeds", "{\"1\":[16384]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("6", "1", "1", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:56;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("7", "1", "1", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765969852;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("8", "1", "1", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("9", "1", "1", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("10", "1", "2", "1", "تست مجدد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("11", "1", "2", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("100", "1", "12", "18", "شیراز، فسا", "");
INSERT INTO `aor_gf_entry_meta` VALUES("14", "1", "2", "submission_speeds", "{\"1\":[6917]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("15", "1", "2", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:57;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("16", "1", "2", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765970026;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("17", "1", "2", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("18", "1", "2", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("19", "1", "3", "1", "تست 2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("20", "1", "3", "3", "سشیشسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("99", "1", "12", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("23", "1", "3", "submission_speeds", "{\"1\":[6570]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("24", "1", "3", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:58;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("25", "1", "3", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765970111;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("26", "1", "3", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("27", "1", "3", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("28", "1", "4", "1", "تست شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("29", "1", "4", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("32", "1", "4", "submission_speeds", "{\"1\":[9960]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("33", "1", "4", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:59;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("34", "1", "4", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765970280;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("35", "1", "4", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("36", "1", "4", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("37", "1", "5", "1", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("38", "1", "5", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("101", "1", "12", "20", "222", "");
INSERT INTO `aor_gf_entry_meta` VALUES("40", "1", "5", "6", "3", "");
INSERT INTO `aor_gf_entry_meta` VALUES("98", "1", "12", "3", "این یک ملک تستی است", "");
INSERT INTO `aor_gf_entry_meta` VALUES("43", "1", "5", "submission_speeds", "{\"1\":[18662]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("44", "1", "5", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:60;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("45", "1", "5", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765970515;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("46", "1", "5", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("47", "1", "5", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("48", "1", "6", "1", "سششسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("49", "1", "6", "3", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("51", "1", "6", "submission_speeds", "{\"1\":[3364]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("52", "1", "6", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:61;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("53", "1", "6", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765970634;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("54", "1", "6", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("55", "1", "6", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("56", "1", "7", "1", "lkl;ka;skd;laskd;asd", "");
INSERT INTO `aor_gf_entry_meta` VALUES("57", "1", "7", "3", "asdasdasd", "");
INSERT INTO `aor_gf_entry_meta` VALUES("59", "1", "7", "submission_speeds", "{\"1\":[7664]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("60", "1", "7", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:77;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("61", "1", "7", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765971869;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("62", "1", "7", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("63", "1", "7", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("64", "1", "8", "1", "آسانسور نداریم", "");
INSERT INTO `aor_gf_entry_meta` VALUES("65", "1", "8", "3", "سشیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("66", "1", "8", "submission_speeds", "{\"1\":[12336]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("67", "1", "8", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:78;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("68", "1", "8", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765971949;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("69", "1", "8", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("70", "1", "8", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("71", "1", "9", "1", "آسانسور نداریم", "");
INSERT INTO `aor_gf_entry_meta` VALUES("72", "1", "9", "3", "آسانسور نداریمآسانسور نداریمآسانسور نداریمآسانسور نداریمآسانسور نداریمآسانسور نداریم", "");
INSERT INTO `aor_gf_entry_meta` VALUES("73", "1", "9", "submission_speeds", "{\"1\":[6980]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("74", "1", "9", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:79;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("75", "1", "9", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765971964;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("76", "1", "9", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("77", "1", "9", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("78", "1", "10", "1", "تست انبار و آسانسور", "");
INSERT INTO `aor_gf_entry_meta` VALUES("79", "1", "10", "3", "شسیشسیشسیشی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("97", "1", "12", "1", "ملک تستی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("82", "1", "10", "submission_speeds", "{\"1\":[16074]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("83", "1", "10", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:80;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("84", "1", "10", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765972192;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("85", "1", "10", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("86", "1", "10", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("87", "1", "11", "1", "تست انبار و آسانسور", "");
INSERT INTO `aor_gf_entry_meta` VALUES("88", "1", "11", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("96", "1", "12", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/logo.png\",\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/1.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("91", "1", "11", "submission_speeds", "{\"1\":[9798]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("92", "1", "11", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:81;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:0:{}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("93", "1", "11", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1765972248;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("94", "1", "11", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("95", "1", "11", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("102", "1", "12", "6", "22", "");
INSERT INTO `aor_gf_entry_meta` VALUES("103", "1", "12", "22", "1390", "");
INSERT INTO `aor_gf_entry_meta` VALUES("104", "1", "12", "25", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("105", "1", "12", "26", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("106", "1", "12", "41", "دو نبش (دوبر)", "");
INSERT INTO `aor_gf_entry_meta` VALUES("107", "1", "12", "32", "درب هال", "");
INSERT INTO `aor_gf_entry_meta` VALUES("108", "1", "12", "33", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("109", "1", "12", "34", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("110", "1", "12", "35", "ندارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("111", "1", "12", "36", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("314", "2", "21", "gppa_choices", "a:0:{}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("332", "2", "26", "submission_speeds", "{\"1\":[4273]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("114", "1", "12", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("115", "1", "12", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("116", "1", "12", "31f0a5dff7e9e5a86a39a88897c370a771d2f3040dc7f7d5ef040e19593cc8828039b89e905b09ac220e65769bcfc8163f3e6e97677605163a29bd55606b2079", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:8:\"logo.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("117", "1", "12", "5bff951e8c662de1034aa6d4da3ec8b6ce30ea2b2e540011df67971a1b298985ea2e57504a497a9485c968f3783c404c50d774f1b11a4461d5a47d756facef68", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:5:\"1.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("118", "1", "12", "submission_speeds", "{\"4\":[6921]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("119", "1", "12", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("120", "1", "12", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:94;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:2:{s:110:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/logo.png\";i:95;s:107:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/1.png\";i:96;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("121", "1", "12", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766826338;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("122", "1", "12", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("123", "1", "12", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("124", "1", "13", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/slider.end_.azar_.404.webp\",\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/11.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("125", "1", "13", "1", "تست ملک با همه گزینه ها", "");
INSERT INTO `aor_gf_entry_meta` VALUES("126", "1", "13", "3", "شسیشسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("127", "1", "13", "17", "آپارتمان", "");
INSERT INTO `aor_gf_entry_meta` VALUES("128", "1", "13", "18", "شسیشسیشسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("129", "1", "13", "20", "213", "");
INSERT INTO `aor_gf_entry_meta` VALUES("130", "1", "13", "6", "2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("131", "1", "13", "22", "1387", "");
INSERT INTO `aor_gf_entry_meta` VALUES("132", "1", "13", "24", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("133", "1", "13", "25", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("134", "1", "13", "26", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("135", "1", "13", "31", "15", "");
INSERT INTO `aor_gf_entry_meta` VALUES("136", "1", "13", "33", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("137", "1", "13", "34", "metal", "");
INSERT INTO `aor_gf_entry_meta` VALUES("138", "1", "13", "35", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("139", "1", "13", "36", "Ceramics", "");
INSERT INTO `aor_gf_entry_meta` VALUES("335", "1", "27", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/1-banersnappey.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("141", "1", "13", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("142", "1", "13", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("143", "1", "13", "cff1daaddd3eee344827a0d46ddc6aa0868e99f9699825848d1bb08c7e55edb4d90b25d5397c56821cfa6ff1d18391be50b765b51756022cb823d88003b8b6bd", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:26:\"slider.end_.azar_.404.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("144", "1", "13", "35db601a63d5d839564f88d6319b71e40912f2470e9d70d2f98dd52345091c9079fc2d74ab8cf10193146122be3293c1372ef9f8e0dade73165c9e7b61752fb4", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:6:\"11.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("145", "1", "13", "submission_speeds", "{\"4\":[4510]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("146", "1", "13", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("147", "1", "13", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:98;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:2:{s:128:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/slider.end_.azar_.404.webp\";i:99;s:108:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/11.png\";i:100;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("148", "1", "13", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766827557;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("149", "1", "13", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("150", "1", "13", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("151", "1", "14", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/22-shatelbirthday-1920.600-0409-m-01.webp\",\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/12.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("152", "1", "14", "1", "تست ضلع و زمین", "");
INSERT INTO `aor_gf_entry_meta` VALUES("153", "1", "14", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("154", "1", "14", "17", "زمین", "");
INSERT INTO `aor_gf_entry_meta` VALUES("155", "1", "14", "18", "شسیشسیسشی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("156", "1", "14", "20", "21", "");
INSERT INTO `aor_gf_entry_meta` VALUES("157", "1", "14", "6", "12", "");
INSERT INTO `aor_gf_entry_meta` VALUES("158", "1", "14", "22", "1389", "");
INSERT INTO `aor_gf_entry_meta` VALUES("159", "1", "14", "25", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("160", "1", "14", "26", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("161", "1", "14", "41", "single", "");
INSERT INTO `aor_gf_entry_meta` VALUES("162", "1", "14", "32", "درب حیاط", "");
INSERT INTO `aor_gf_entry_meta` VALUES("163", "1", "14", "33", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("164", "1", "14", "34", "Other cabinets", "");
INSERT INTO `aor_gf_entry_meta` VALUES("165", "1", "14", "35", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("166", "1", "14", "36", "brick", "");
INSERT INTO `aor_gf_entry_meta` VALUES("169", "1", "14", "40", "commercial", "");
INSERT INTO `aor_gf_entry_meta` VALUES("170", "1", "14", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("171", "1", "14", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("172", "1", "14", "09631eeba986737ad04b496926f28b7929dfc608d30452ab19fefc44fa61021f24388fc3f999f3cb91d7458ec7e7547a3dfe80061d74922a531f25977d1a04f0", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:41:\"22-shatelbirthday-1920.600-0409-m-01.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("173", "1", "14", "7cab51f037e117e447ece710f6b6c053f642fe11be7702f5a8674c34f28dea68e2c3bc3cfb29953d25abe5b55566c3e6f2fb001eb659e9108926dcee80a21f61", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:6:\"12.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("174", "1", "14", "submission_speeds", "{\"4\":[3633]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("175", "1", "14", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("176", "1", "14", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:101;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:2:{s:143:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/22-shatelbirthday-1920.600-0409-m-01.webp\";i:102;s:108:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/12.png\";i:103;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("177", "1", "14", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766828105;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("178", "1", "14", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("179", "1", "14", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("180", "1", "15", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/22-shatelbirthday-1920.600-0409-m-011.webp\",\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/13.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("181", "1", "15", "1", "تست ضلع", "");
INSERT INTO `aor_gf_entry_meta` VALUES("182", "1", "15", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("183", "1", "15", "17", "آپارتمان", "");
INSERT INTO `aor_gf_entry_meta` VALUES("184", "1", "15", "18", "شسیشسیشسیشسیش", "");
INSERT INTO `aor_gf_entry_meta` VALUES("185", "1", "15", "20", "213", "");
INSERT INTO `aor_gf_entry_meta` VALUES("186", "1", "15", "6", "23", "");
INSERT INTO `aor_gf_entry_meta` VALUES("187", "1", "15", "22", "1391", "");
INSERT INTO `aor_gf_entry_meta` VALUES("188", "1", "15", "24", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("189", "1", "15", "25", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("190", "1", "15", "26", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("191", "1", "15", "31", "23", "");
INSERT INTO `aor_gf_entry_meta` VALUES("192", "1", "15", "33", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("193", "1", "15", "34", "metal", "");
INSERT INTO `aor_gf_entry_meta` VALUES("194", "1", "15", "35", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("195", "1", "15", "36", "Ceramics", "");
INSERT INTO `aor_gf_entry_meta` VALUES("313", "2", "21", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("198", "1", "15", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("199", "1", "15", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("200", "1", "15", "86b2002f2958ef0f02e8e8093feb99ce5e1a10df498e30786b105fed65b58c75b171abb65ed8377b21a783c80733629a21efe3dbd3672eb515e30db5e375329f", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:42:\"22-shatelbirthday-1920.600-0409-m-011.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("201", "1", "15", "72710fb61e91149f046be8aa6cad569fbd2b38114785ff595d4cbe0689d5ae8f8360e8cf51dc444cf0b2107430dd8714bb45689f7860f8c16276b8693604ddd4", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:6:\"13.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("202", "1", "15", "submission_speeds", "{\"4\":[6730]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("203", "1", "15", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("204", "1", "15", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:105;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:2:{s:144:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/22-shatelbirthday-1920.600-0409-m-011.webp\";i:106;s:108:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/13.png\";i:107;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("205", "1", "15", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766828857;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("206", "1", "15", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("207", "1", "15", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("208", "1", "16", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/icon-8.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("209", "1", "16", "1", "تست ضلع 2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("210", "1", "16", "3", "سیشسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("211", "1", "16", "17", "زمین", "");
INSERT INTO `aor_gf_entry_meta` VALUES("212", "1", "16", "18", "سشیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("213", "1", "16", "20", "23", "");
INSERT INTO `aor_gf_entry_meta` VALUES("214", "1", "16", "6", "2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("215", "1", "16", "22", "1392", "");
INSERT INTO `aor_gf_entry_meta` VALUES("216", "1", "16", "25", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("217", "1", "16", "26", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("218", "1", "16", "41", "double", "");
INSERT INTO `aor_gf_entry_meta` VALUES("219", "1", "16", "32", "درب حیاط", "");
INSERT INTO `aor_gf_entry_meta` VALUES("220", "1", "16", "33", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("221", "1", "16", "34", "mdf", "");
INSERT INTO `aor_gf_entry_meta` VALUES("222", "1", "16", "35", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("223", "1", "16", "36", "brick", "");
INSERT INTO `aor_gf_entry_meta` VALUES("226", "1", "16", "40", "commercial", "");
INSERT INTO `aor_gf_entry_meta` VALUES("227", "1", "16", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("228", "1", "16", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("229", "1", "16", "49122404f8a912c157aa7ec886481063bb0df7b2b197ac42223cc7329bce76c3c93836e4081453ddcb6c8ba97c0e88e4332f804700ae4891a70c4fd13c9dabdb", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:11:\"icon-8.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("230", "1", "16", "submission_speeds", "{\"4\":[4126]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("231", "1", "16", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("232", "1", "16", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:109;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:113:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/icon-8.webp\";i:110;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("233", "1", "16", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766829077;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("234", "1", "16", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("235", "1", "16", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("236", "1", "17", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/22-shatelbirthday-1920.600-0409-m-012.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("237", "1", "17", "1", "تست ضلع 3", "");
INSERT INTO `aor_gf_entry_meta` VALUES("238", "1", "17", "3", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("239", "1", "17", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("240", "1", "17", "18", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("242", "1", "17", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("243", "1", "17", "298e20beae40b792c4187472f33b0dd8f93f08cb6e6de6f8cebdf13f4c20eff88feae96321414d157782fd534a77fff65fe1f6ff2739c45b64c30994cb748757", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:42:\"22-shatelbirthday-1920.600-0409-m-012.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("244", "1", "17", "submission_speeds", "{\"4\":[2059]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("245", "1", "17", "gppa_choices", "a:1:{i:13;a:0:{}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("246", "1", "17", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:112;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:144:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/22-shatelbirthday-1920.600-0409-m-012.webp\";i:113;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("247", "1", "17", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766829999;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("248", "1", "17", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("249", "1", "17", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("250", "1", "18", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/icon-81.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("251", "1", "18", "1", "شسیشسی213", "");
INSERT INTO `aor_gf_entry_meta` VALUES("252", "1", "18", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("253", "1", "18", "17", "زمین", "");
INSERT INTO `aor_gf_entry_meta` VALUES("254", "1", "18", "18", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("312", "2", "21", "submission_speeds", "{\"1\":[4446]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("308", "1", "20", "43.3", "شرقی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("257", "1", "18", "40", "residential", "");
INSERT INTO `aor_gf_entry_meta` VALUES("258", "1", "18", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("259", "1", "18", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("260", "1", "18", "287d6569888a342c951ef246d32430b9ac5c24bd6b391af75cf97599d4fa608fef95ba3bb52a0350319504d7c1ec0976bde9c1bd875e5b139430e618ba4496e4", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:12:\"icon-81.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("261", "1", "18", "submission_speeds", "{\"4\":[3503]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("262", "1", "18", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("263", "1", "18", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:115;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:114:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/icon-81.webp\";i:116;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("264", "1", "18", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766830173;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("265", "1", "18", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("266", "1", "18", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("267", "1", "19", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/icon-82.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("268", "1", "19", "1", "تست درب هال درب حیاط", "");
INSERT INTO `aor_gf_entry_meta` VALUES("269", "1", "19", "3", "سشیشسیش", "");
INSERT INTO `aor_gf_entry_meta` VALUES("270", "1", "19", "17", "زمین", "");
INSERT INTO `aor_gf_entry_meta` VALUES("271", "1", "19", "18", "شسیشس", "");
INSERT INTO `aor_gf_entry_meta` VALUES("272", "1", "19", "32", "hall", "");
INSERT INTO `aor_gf_entry_meta` VALUES("274", "1", "19", "40", "commercial", "");
INSERT INTO `aor_gf_entry_meta` VALUES("275", "1", "19", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("276", "1", "19", "4506cb0c5c6396914eba39d8101fad41c196bcdd8b8dcdfe73467f8a456f9356185fa9f03f3203fd942d7b5ee661a24c48b586762d73dc2ca88cda621d208852", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:12:\"icon-82.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("277", "1", "19", "submission_speeds", "{\"4\":[2270]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("278", "1", "19", "gppa_choices", "a:1:{i:13;a:0:{}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("279", "1", "19", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:118;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:114:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/icon-82.webp\";i:119;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("280", "1", "19", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766830351;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("281", "1", "19", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("282", "1", "19", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("283", "1", "20", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/571-5715396_tractor-png-high-quality-image-massey-ferguson-tractor.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("284", "1", "20", "1", "تنمسیتبمسیب", "");
INSERT INTO `aor_gf_entry_meta` VALUES("285", "1", "20", "3", "سیبسیب", "");
INSERT INTO `aor_gf_entry_meta` VALUES("286", "1", "20", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("287", "1", "20", "18", "سیبسیب", "");
INSERT INTO `aor_gf_entry_meta` VALUES("306", "1", "20", "43.1", "شمالی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("290", "1", "20", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("291", "1", "20", "13", "[\"\\u0627\\u0645\\u06cc\\u0631\\u0645\\u062d\\u0645\\u062f \\u0639\\u0628\\u062f\\u06cc\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("292", "1", "20", "36f89c3b8e563005ad1e08651f949284f0c1308f80c12bc3a242a1e6e2ccb68293206520e910025e3c0a09d083dfc88c7556620627bf24157c5b5b5cb843db64", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:70:\"571-5715396_tractor-png-high-quality-image-massey-ferguson-tractor.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("293", "1", "20", "submission_speeds", "{\"4\":[3282]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("294", "1", "20", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("295", "1", "20", "gppa_choices", "a:0:{}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("334", "2", "26", "gppa_choices", "a:0:{}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("296", "1", "20", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:124;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:172:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/571-5715396_tractor-png-high-quality-image-massey-ferguson-tractor.png\";i:309;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("297", "1", "20", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766831345;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("298", "1", "20", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("299", "1", "20", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("330", "1", "20", "43.4", "غربی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("307", "1", "20", "43.2", "جنوبی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("329", "2", "25", "submission_speeds", "{\"1\":[1628]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("318", "2", "22", "submission_speeds", "{\"1\":[11323]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("319", "2", "22", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("320", "2", "22", "previous_status", "active", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("321", "2", "21", "previous_status", "active", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("333", "2", "26", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("331", "2", "26", "2.4", "انتخاب چهارم", "");
INSERT INTO `aor_gf_entry_meta` VALUES("324", "2", "23", "submission_speeds", "{\"1\":[3076]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("325", "2", "23", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("328", "2", "25", "2.4", "انتخاب چهارم", "");
INSERT INTO `aor_gf_entry_meta` VALUES("327", "2", "24", "submission_speeds", "{\"1\":[6321]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("336", "1", "27", "1", "تست یوزر آیدی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("337", "1", "27", "3", "سیبسب", "");
INSERT INTO `aor_gf_entry_meta` VALUES("338", "1", "27", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("339", "1", "27", "18", "شسبسبی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("340", "1", "27", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("341", "1", "27", "917c991fdc4a5b34cec66b76c9d804b9cb1617654d8d9c5524ced3fa4cc4580dd173d49acf1f608eaf2043b1800824f2f1f3f994f1103c2554ad8094ed18e14a", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:19:\"1-banersnappey.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("342", "1", "27", "submission_speeds", "{\"4\":[2181]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("343", "1", "27", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:519;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:121:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/1-banersnappey.webp\";i:520;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("344", "1", "27", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766926271;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("345", "1", "27", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("346", "1", "27", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("347", "1", "27", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("348", "1", "27", "gppa_choices", "a:1:{i:13;a:0:{}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("349", "1", "28", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/1-banersnappey1.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("350", "1", "28", "1", "تست یوزر آیدی 2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("351", "1", "28", "3", "شسیشی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("352", "1", "28", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("353", "1", "28", "18", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("354", "1", "28", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("355", "1", "28", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("356", "1", "28", "22fa5a4e50ea41540f567775ac7f7445a172fd40c7dc9c80b354627e18d96f9f2e256e90589b86fd0e4aaeac14e8221c1d68f94fe87259edf26b8ebe7fe4828c", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:20:\"1-banersnappey1.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("357", "1", "28", "submission_speeds", "{\"4\":[4156]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("358", "1", "28", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:521;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:122:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/1-banersnappey1.webp\";i:522;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("359", "1", "28", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766926411;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("360", "1", "28", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("361", "1", "28", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("362", "1", "28", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("363", "1", "28", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("364", "1", "29", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/2-banersnappey.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("365", "1", "29", "1", "تست متن ها", "");
INSERT INTO `aor_gf_entry_meta` VALUES("366", "1", "29", "3", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("367", "1", "29", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("368", "1", "29", "18", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("369", "1", "29", "20", "2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("370", "1", "29", "6", "2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("371", "1", "29", "22", "1395", "");
INSERT INTO `aor_gf_entry_meta` VALUES("372", "1", "29", "25", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("373", "1", "29", "26", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("374", "1", "29", "41", "double", "");
INSERT INTO `aor_gf_entry_meta` VALUES("375", "1", "29", "32", "hall", "");
INSERT INTO `aor_gf_entry_meta` VALUES("376", "1", "29", "33", "true", "");
INSERT INTO `aor_gf_entry_meta` VALUES("377", "1", "29", "34", "metal", "");
INSERT INTO `aor_gf_entry_meta` VALUES("378", "1", "29", "35", "false", "");
INSERT INTO `aor_gf_entry_meta` VALUES("379", "1", "29", "36", "Ceramics", "");
INSERT INTO `aor_gf_entry_meta` VALUES("380", "1", "29", "43.2", "جنوبی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("381", "1", "29", "43.4", "غربی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("382", "1", "29", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("383", "1", "29", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("384", "1", "29", "63f32043d3e60cf0d069757c27b81e48808f73782e86695821efa52f4bf5cc9dbbab7df6c577a0f5941be93928801d3337f5c01a9d98c9936f30cd8d7e533b46", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:18:\"2-banersnappey.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("385", "1", "29", "submission_speeds", "{\"4\":[4347]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("386", "1", "29", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:563;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:120:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/2-banersnappey.png\";i:564;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("387", "1", "29", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766939086;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("388", "1", "29", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("389", "1", "29", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("390", "1", "29", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("391", "1", "29", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("392", "1", "30", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/2-banersnappey1.png\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("393", "1", "30", "1", "تست جدید", "");
INSERT INTO `aor_gf_entry_meta` VALUES("394", "1", "30", "3", "یبسیبسیب", "");
INSERT INTO `aor_gf_entry_meta` VALUES("395", "1", "30", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("396", "1", "30", "18", "شسیشسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("397", "1", "30", "20", "2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("398", "1", "30", "6", "2", "");
INSERT INTO `aor_gf_entry_meta` VALUES("399", "1", "30", "22", "1389", "");
INSERT INTO `aor_gf_entry_meta` VALUES("400", "1", "30", "25", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("401", "1", "30", "26", "ندارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("402", "1", "30", "41", "تک لاین", "");
INSERT INTO `aor_gf_entry_meta` VALUES("403", "1", "30", "32", "درب هال", "");
INSERT INTO `aor_gf_entry_meta` VALUES("404", "1", "30", "33", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("405", "1", "30", "35", "دارد", "");
INSERT INTO `aor_gf_entry_meta` VALUES("406", "1", "30", "36", "سرامیک", "");
INSERT INTO `aor_gf_entry_meta` VALUES("407", "1", "30", "43.2", "جنوبی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("408", "1", "30", "43.4", "غربی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("409", "1", "30", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("410", "1", "30", "13", "[\"1\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("411", "1", "30", "d4d9278e8ac265edb20466c617139bf03a6831df340ed78601ff4e21f78c8e05485aea2f7237dc1f159d68977ce239b92b83675e1455a7ccc49ca3cc83fedb17", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:19:\"2-banersnappey1.png\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("412", "1", "30", "submission_speeds", "{\"4\":[2980]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("413", "1", "30", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:566;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:121:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/2-banersnappey1.png\";i:567;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("414", "1", "30", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1766939361;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("415", "1", "30", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("416", "1", "30", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("417", "1", "30", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("418", "1", "30", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"1\"]\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("419", "1", "31", "16", "[\"https:\\/\\/amlakor.azindm.ir\\/wp-content\\/uploads\\/gravity_forms\\/1-d36590944d4e0849fcdfb5fb546a0791\\/2025\\/12\\/right-img-services.webp\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("420", "1", "31", "1", "تست", "");
INSERT INTO `aor_gf_entry_meta` VALUES("421", "1", "31", "3", "شسیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("422", "1", "31", "17", "ویلایی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("423", "1", "31", "18", "سشیشسی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("424", "1", "31", "42", "خصوصی", "");
INSERT INTO `aor_gf_entry_meta` VALUES("425", "1", "31", "13", "[\"2\"]", "");
INSERT INTO `aor_gf_entry_meta` VALUES("426", "1", "31", "8b9e9dbcc6848455e92e4e2f95965b7c120ca104ed2c850bef86fdf520499b71580ff3c18d950142ccf168d3331192da3f41ac18a1e4a34ef83909624c768c64", "a:3:{s:4:\"path\";s:107:\"/home/azindm/amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:3:\"url\";s:102:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/\";s:9:\"file_name\";s:23:\"right-img-services.webp\";}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("427", "1", "31", "submission_speeds", "{\"4\":[10818]}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("428", "1", "31", "gravityformsadvancedpostcreation_post_id", "a:1:{i:0;a:3:{s:7:\"post_id\";i:630;s:7:\"feed_id\";s:1:\"1\";s:5:\"media\";a:1:{s:125:\"https://amlakor.azindm.ir/wp-content/uploads/gravity_forms/1-d36590944d4e0849fcdfb5fb546a0791/2025/12/right-img-services.webp\";i:631;}}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("429", "1", "31", "feed_1_status", "a:1:{i:0;a:5:{s:9:\"timestamp\";i:1767022052;s:6:\"status\";s:7:\"success\";s:4:\"code\";s:0:\"\";s:7:\"message\";s:0:\"\";s:4:\"data\";s:0:\"\";}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("430", "1", "31", "gravityformsadvancedpostcreation_is_fulfilled", "1", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("431", "1", "31", "processed_feeds", "a:1:{s:32:\"gravityformsadvancedpostcreation\";a:1:{i:0;i:1;}}", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("432", "1", "31", "is_approved", "3", NULL);
INSERT INTO `aor_gf_entry_meta` VALUES("433", "1", "31", "gppa_choices", "a:1:{i:13;a:1:{s:5:\"[\"2\"]\";s:0:\"\";}}", NULL);

/* INSERT TABLE DATA: aor_gf_entry_notes */
INSERT INTO `aor_gf_entry_notes` VALUES("1", "1", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:10:50", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("2", "2", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:13:45", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("3", "3", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:15:06", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("4", "4", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:17:59", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("5", "5", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:21:54", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("6", "6", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:23:53", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("7", "7", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:44:28", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("8", "8", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:45:47", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("9", "9", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:46:03", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("10", "10", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:49:50", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("11", "11", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-17 11:50:46", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("12", "12", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 09:05:35", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("13", "13", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 09:25:56", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("14", "14", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 09:35:03", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("15", "15", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 09:47:35", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("16", "16", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 09:51:16", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("17", "17", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 10:06:37", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("18", "18", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 10:09:32", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("19", "19", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 10:12:29", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("20", "20", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-27 10:29:03", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("21", "21", "اعلان مدیر (شناسه: 694fbc6bd729c)", "0", "2025-12-27 11:01:49", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("22", "22", "اعلان مدیر (شناسه: 694fbc6bd729c)", "0", "2025-12-27 11:10:38", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("23", "23", "اعلان مدیر (شناسه: 694fbc6bd729c)", "0", "2025-12-27 11:12:03", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("24", "24", "اعلان مدیر (ID: 694fbc6bd729c)", "0", "2025-12-27 11:29:44", "WordPress successfully passed the notification email to the sending server.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("25", "25", "اعلان مدیر (ID: 694fbc6bd729c)", "0", "2025-12-27 11:31:08", "WordPress successfully passed the notification email to the sending server.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("26", "26", "اعلان مدیر (شناسه: 694fbc6bd729c)", "0", "2025-12-27 16:41:53", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("27", "27", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-28 12:51:12", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("28", "28", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-28 12:53:31", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("29", "29", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-28 16:24:46", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("30", "30", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-28 16:29:21", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");
INSERT INTO `aor_gf_entry_notes` VALUES("31", "31", "اعلان مدیریت (شناسه: 69428e4fd470f)", "0", "2025-12-29 15:27:32", "وردپرس با موفقیت ایمیل اعلان را به سرور فرستنده منتقل کرد.", "notification", "success");

/* INSERT TABLE DATA: aor_gf_form */
INSERT INTO `aor_gf_form` VALUES("1", "ثبت فایل ملک جدید", "2025-12-17 11:04:47", NULL, "1", "0");
INSERT INTO `aor_gf_form` VALUES("2", "تتتت", "2025-12-27 11:00:59", NULL, "1", "0");

/* INSERT TABLE DATA: aor_gf_form_meta */
INSERT INTO `aor_gf_form_meta` VALUES("1", "{\"fields\":[{\"type\":\"fileupload\",\"is_payment\":false,\"id\":16,\"formId\":1,\"label\":\"\\u0639\\u06a9\\u0633 \\u0645\\u0644\\u06a9:\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"fileupload\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"maxFileSize\":10,\"maxFiles\":\"\",\"multipleFiles\":true,\"allowedExtensions\":\"jpg, jpeg, png, webp\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"7f448a21\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"checkboxLabel\":\"\",\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"is_payment\":false,\"id\":1,\"formId\":1,\"label\":\"\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0645\\u0644\\u06a9:\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"5b515c25\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"textarea\",\"is_payment\":false,\"id\":3,\"formId\":1,\"label\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a:\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"small\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"ea3863fa\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\",\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[]},{\"type\":\"page\",\"is_payment\":false,\"id\":14,\"formId\":1,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"nextButton\":{\"type\":\"text\",\"text\":\"\\u0628\\u0639\\u062f\",\"imageUrl\":\"\",\"id\":14},\"previousButton\":{\"type\":\"text\",\"text\":\"\\u0642\\u0628\\u0644\",\"imageUrl\":\"\"},\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"page\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"350884f8\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"pageNumber\":2,\"fields\":\"\"},{\"type\":\"select\",\"is_payment\":false,\"id\":17,\"formId\":1,\"label\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0645\\u0644\\u06a9:\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\",\"value\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"value\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u062a\\u062c\\u0627\\u0631\\u06cc\",\"value\":\"\\u062a\\u062c\\u0627\\u0631\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0632\\u0645\\u06cc\\u0646\",\"value\":\"\\u0632\\u0645\\u06cc\\u0646\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0633\\u0627\\u06cc\\u0631\",\"value\":\"\\u0633\\u0627\\u06cc\\u0631\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0644\\u0637\\u0641\\u0627 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0645\\u0644\\u06a9 \\u0631\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f:\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"372bb10a\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"textarea\",\"is_payment\":false,\"id\":18,\"formId\":1,\"label\":\"\\u0645\\u06a9\\u0627\\u0646 \\u0645\\u0644\\u06a9:\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"small\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"5ca3cd21\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\",\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[]},{\"type\":\"section\",\"is_payment\":false,\"id\":28,\"formId\":1,\"label\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"section\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"59c131c1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\"},{\"type\":\"number\",\"is_payment\":false,\"id\":20,\"formId\":1,\"label\":\"\\u0645\\u062a\\u0631\\u0627\\u0698:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"numberFormat\":\"decimal_dot\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"number\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"enableCalculation\":false,\"rangeMin\":\"\",\"rangeMax\":\"\",\"calculationFormula\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"62d1d0a2\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationRounding\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"number\",\"is_payment\":false,\"id\":6,\"formId\":1,\"label\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0627\\u062a\\u0627\\u0642:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"numberFormat\":\"decimal_dot\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"number\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"enableCalculation\":false,\"rangeMin\":\"\",\"rangeMax\":\"\",\"calculationFormula\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"ce70c2f6\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationRounding\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\",\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[]},{\"type\":\"select\",\"is_payment\":false,\"id\":22,\"formId\":1,\"label\":\"\\u0633\\u0627\\u0644 \\u0633\\u0627\\u062e\\u062a:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"1404\",\"value\":\"1404\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1403\",\"value\":\"1403\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1402\",\"value\":\"1402\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1401\",\"value\":\"1401\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1400\",\"value\":\"1400\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1399\",\"value\":\"1399\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1398\",\"value\":\"1398\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1397\",\"value\":\"1397\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1396\",\"value\":\"1396\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1395\",\"value\":\"1395\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1394\",\"value\":\"1394\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1393\",\"value\":\"1393\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1392\",\"value\":\"1392\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1391\",\"value\":\"1391\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1390\",\"value\":\"1390\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1389\",\"value\":\"1389\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1388\",\"value\":\"1388\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1387\",\"value\":\"1387\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1386\",\"value\":\"1386\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1385\",\"value\":\"1385\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1384\",\"value\":\"1384\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1383\",\"value\":\"1383\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1382\",\"value\":\"1382\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1381\",\"value\":\"1381\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1380\",\"value\":\"1380\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1379\",\"value\":\"1379\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1378\",\"value\":\"1378\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1377\",\"value\":\"1377\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1376\",\"value\":\"1376\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1375\",\"value\":\"1375\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1374\",\"value\":\"1374\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1373\",\"value\":\"1373\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1372\",\"value\":\"1372\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1371\",\"value\":\"1371\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"1370\",\"value\":\"1370\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0642\\u0628\\u0644 \\u0627\\u0632 1370\",\"value\":\"\\u0642\\u0628\\u0644 \\u0627\\u0632 1370\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0633\\u0627\\u0644 \\u0633\\u0627\\u062e\\u062a:\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"aaef7368\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"select\",\"is_payment\":false,\"id\":24,\"formId\":1,\"label\":\"\\u0622\\u0633\\u0627\\u0646\\u0633\\u0648\\u0631:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\"}]},\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"de19a09c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":25,\"formId\":1,\"label\":\"\\u067e\\u0627\\u0631\\u06a9\\u06cc\\u0646\\u06af:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"de19a09c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":26,\"formId\":1,\"label\":\"\\u0627\\u0646\\u0628\\u0627\\u0631\\u06cc:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"de19a09c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":2,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"page\",\"is_payment\":false,\"id\":27,\"formId\":1,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"nextButton\":{\"type\":\"text\",\"text\":\"\\u0628\\u0639\\u062f\",\"imageUrl\":\"\",\"id\":27},\"previousButton\":{\"type\":\"text\",\"text\":\"\\u0642\\u0628\\u0644\",\"imageUrl\":\"\"},\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"page\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"f80d2902\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"pageNumber\":3,\"fields\":\"\"},{\"type\":\"section\",\"is_payment\":false,\"id\":19,\"formId\":1,\"label\":\"\\u0633\\u0627\\u06cc\\u0631 \\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627 \\u0648 \\u0627\\u0645\\u06a9\\u0627\\u0646\\u0627\\u062a\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"section\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"e8395d6c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\"},{\"type\":\"number\",\"is_payment\":false,\"id\":31,\"formId\":1,\"label\":\"\\u0686\\u0646\\u062f \\u0648\\u0627\\u062d\\u062f\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"numberFormat\":\"decimal_dot\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"number\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0622\\u067e\\u0627\\u0631\\u062a\\u0645\\u0627\\u0646\"}]},\"enableCalculation\":false,\"rangeMin\":\"\",\"rangeMax\":\"\",\"calculationFormula\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"7dfea3fb\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationRounding\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"select\",\"is_payment\":false,\"id\":41,\"formId\":1,\"label\":\"\\u0648\\u0636\\u0639\\u06cc\\u062a \\u0628\\u0631:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062a\\u06a9 \\u0644\\u0627\\u06cc\\u0646\",\"value\":\"\\u062a\\u06a9 \\u0644\\u0627\\u06cc\\u0646\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u062f\\u0648 \\u0646\\u0628\\u0634 (\\u062f\\u0648\\u0628\\u0631)\",\"value\":\"\\u062f\\u0648 \\u0646\\u0628\\u0634 (\\u062f\\u0648\\u0628\\u0631)\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0633\\u0647 \\u0646\\u0628\\u0634\",\"value\":\"\\u0633\\u0647 \\u0646\\u0628\\u0634\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"any\",\"rules\":[{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\"},{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0632\\u0645\\u06cc\\u0646\"}]},\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"7dfea3fb\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":32,\"formId\":1,\"label\":\"\\u0646\\u0648\\u0639 \\u062f\\u0633\\u062a\\u0631\\u0633\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644\",\"value\":\"\\u062f\\u0631\\u0628 \\u0647\\u0627\\u0644\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"value\":\"\\u062f\\u0631\\u0628 \\u062d\\u06cc\\u0627\\u0637\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"any\",\"rules\":[{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0648\\u06cc\\u0644\\u0627\\u06cc\\u06cc\"},{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0632\\u0645\\u06cc\\u0646\"}]},\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"7dfea3fb\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":33,\"formId\":1,\"label\":\"\\u06a9\\u0627\\u0628\\u06cc\\u0646\\u062a:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"3886220a\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":34,\"formId\":1,\"label\":\"\\u0646\\u0648\\u0639 \\u06a9\\u0627\\u0628\\u06cc\\u0646\\u062a:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"MDF\",\"value\":\"MDF\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0641\\u0644\\u0632\",\"value\":\"\\u0641\\u0644\\u0632\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0633\\u0627\\u06cc\\u0631\",\"value\":\"\\u0633\\u0627\\u06cc\\u0631\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"33\",\"operator\":\"is\",\"value\":\"\\u062f\\u0627\\u0631\\u062f\"}]},\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"de1c15e7\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":35,\"formId\":1,\"label\":\"\\u0645\\u0633\\u062a\\u0631:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"value\":\"\\u0646\\u062f\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"57e8b587\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"select\",\"is_payment\":false,\"id\":36,\"formId\":1,\"label\":\"\\u0646\\u0645\\u0627:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u0633\\u0646\\u06af\",\"value\":\"\\u0633\\u0646\\u06af\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0633\\u0631\\u0627\\u0645\\u06cc\\u06a9\",\"value\":\"\\u0633\\u0631\\u0627\\u0645\\u06cc\\u06a9\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0622\\u062c\\u0631\",\"value\":\"\\u0622\\u062c\\u0631\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0633\\u0627\\u06cc\\u0631\",\"value\":\"\\u0633\\u0627\\u06cc\\u0631\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"1d7e296c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"checkbox\",\"is_payment\":false,\"id\":43,\"formId\":1,\"label\":\"\\u0636\\u0644\\u0639:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"choices\":[{\"text\":\"\\u0634\\u0645\\u0627\\u0644\\u06cc\",\"value\":\"\\u0634\\u0645\\u0627\\u0644\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"value\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0634\\u0631\\u0642\\u06cc\",\"value\":\"\\u0634\\u0631\\u0642\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u063a\\u0631\\u0628\\u06cc\",\"value\":\"\\u063a\\u0631\\u0628\\u06cc\",\"isSelected\":false,\"price\":\"\"}],\"validateState\":true,\"inputs\":[{\"id\":\"43.1\",\"label\":\"\\u0634\\u0645\\u0627\\u0644\\u06cc\",\"name\":\"\"},{\"id\":\"43.2\",\"label\":\"\\u062c\\u0646\\u0648\\u0628\\u06cc\",\"name\":\"\"},{\"id\":\"43.3\",\"label\":\"\\u0634\\u0631\\u0642\\u06cc\",\"name\":\"\"},{\"id\":\"43.4\",\"label\":\"\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"checkbox\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableSelectAll\":\"\",\"choiceLimit\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"3d783fd6\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"selectAllText\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0647\\u0645\\u0647\",\"displayOnly\":\"\"},{\"type\":\"number\",\"is_payment\":false,\"id\":39,\"formId\":1,\"label\":\"\\u0645\\u062a\\u0631\\u0627\\u0698 \\u0628\\u0631 \\u062e\\u06cc\\u0627\\u0628\\u0627\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"numberFormat\":\"decimal_dot\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"number\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u062a\\u062c\\u0627\\u0631\\u06cc\"}]},\"enableCalculation\":false,\"rangeMin\":\"\",\"rangeMax\":\"\",\"calculationFormula\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"d107b28d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationRounding\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"select\",\"is_payment\":false,\"id\":40,\"formId\":1,\"label\":\"\\u0646\\u0648\\u0639 \\u0632\\u0645\\u06cc\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u0645\\u0633\\u06a9\\u0648\\u0646\\u06cc\",\"value\":\"\\u0645\\u0633\\u06a9\\u0648\\u0646\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u062a\\u062c\\u0627\\u0631\\u06cc\",\"value\":\"\\u062a\\u062c\\u0627\\u0631\\u06cc\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"17\",\"operator\":\"is\",\"value\":\"\\u0632\\u0645\\u06cc\\u0646\"}]},\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"1fb06b9f\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":3,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":false},{\"type\":\"page\",\"is_payment\":false,\"id\":29,\"formId\":1,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"nextButton\":{\"type\":\"text\",\"text\":\"\\u0628\\u0639\\u062f\",\"imageUrl\":\"\",\"id\":29},\"previousButton\":{\"type\":\"text\",\"text\":\"\\u0642\\u0628\\u0644\",\"imageUrl\":\"\"},\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"page\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"7d47141f\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"pageNumber\":4,\"fields\":\"\"},{\"type\":\"section\",\"is_payment\":false,\"id\":30,\"formId\":1,\"label\":\"\\u062f\\u0633\\u062a\\u0631\\u0633\\u06cc \\u0647\\u0627\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"section\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"953cd325\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":4,\"fields\":\"\"},{\"type\":\"select\",\"is_payment\":false,\"id\":42,\"formId\":1,\"label\":\"\\u0648\\u0636\\u0639\\u06cc\\u062a \\u0646\\u0645\\u0627\\u06cc\\u0634\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"value\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\",\"isSelected\":true,\"price\":\"\"},{\"text\":\"\\u0639\\u0645\\u0648\\u0645\\u06cc\",\"value\":\"\\u0639\\u0645\\u0648\\u0645\\u06cc\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"289ba624\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":[],\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"pageNumber\":4,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":true},{\"type\":\"multiselect\",\"is_payment\":false,\"id\":13,\"formId\":1,\"label\":\"\\u062f\\u0633\\u062a\\u0631\\u0633\\u06cc \\u0647\\u0627:\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"storageType\":\"json\",\"inputs\":null,\"choices\":[{\"text\":\"First Choice\",\"value\":\"First Choice\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Second Choice\",\"value\":\"Second Choice\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Third Choice\",\"value\":\"Third Choice\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Fourth Choice\",\"value\":\"Fourth Choice\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Fifth Choice\",\"value\":\"Fifth Choice\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"multiselect\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":{\"enabled\":true,\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"42\",\"operator\":\"is\",\"value\":\"\\u062e\\u0635\\u0648\\u0635\\u06cc\"}]},\"enableEnhancedUI\":true,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"multiSelectSize\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"3def61a1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"gppa-choices-filter-groups\":[],\"gppa-choices-templates\":{\"value\":\"ID\",\"label\":\"display_name\"},\"gppa-values-filter-groups\":[],\"gppa-values-templates\":[],\"errors\":[],\"gppa-choices-enabled\":true,\"gppa-choices-object-type\":\"user\",\"gppa-choices-ordering-property\":\"ID\",\"pageNumber\":4,\"fields\":\"\",\"displayOnly\":\"\",\"enableChoiceValue\":true,\"gppaDisable\":false}],\"button\":{\"type\":\"text\",\"text\":\"\\u062b\\u0628\\u062a \\u0645\\u0644\\u06a9\",\"imageUrl\":\"\",\"width\":\"full\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"title\":\"\\u062b\\u0628\\u062a \\u0641\\u0627\\u06cc\\u0644 \\u0645\\u0644\\u06a9 \\u062c\\u062f\\u06cc\\u062f\",\"description\":\"\",\"version\":\"2.9.21\",\"id\":1,\"markupVersion\":2,\"nextFieldId\":44,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":{\"type\":\"text\",\"text\":\"\\u0642\\u0628\\u0644\",\"imageUrl\":\"\"},\"pagination\":{\"type\":\"percentage\",\"pages\":[\"\",\"\",\"\",\"\"],\"style\":\"blue\",\"backgroundColor\":null,\"color\":null,\"display_progressbar_on_confirmation\":false,\"progressbar_completion_text\":null},\"firstPageCssClass\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"validationPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"validationSummary\":\"1\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(\\u0636\\u0631\\u0648\\u0631\\u06cc)\",\"cssClass\":\"\",\"saveButtonText\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"honeypotAction\":\"spam\",\"submitSpeedCheckThreshold\":2000,\"submitSpeedCheckMode\":\"normal\",\"enableAnimation\":true,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableHoneypot\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"enableSubmitSpeedCheck\":false}", NULL, "{\"69428e4fd4d93\":{\"id\":\"69428e4fd4d93\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"redirect\",\"message\":\"\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0633 \\u0634\\u0645\\u0627 \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645! \\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0645\\u06cc \\u06af\\u06cc\\u0631\\u06cc\\u0645.\",\"url\":\"https:\\/\\/amlakor.azindm.ir\\/crm\\/my-property\\/\",\"pageId\":\"\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"\",\"conditionalLogic\":[]}}", "{\"69428e4fd470f\":{\"id\":\"69428e4fd470f\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0641\\u0631\\u0645 \\u0627\\u0631\\u0633\\u0627\\u0644\\u06cc \\u062c\\u062f\\u06cc\\u062f {form_title}\",\"message\":\"{all_fields}\"}}");
INSERT INTO `aor_gf_form_meta` VALUES("2", "{\"fields\":[{\"type\":\"checkbox\",\"id\":2,\"formId\":2,\"label\":\"\\u0628\\u062f\\u0648\\u0646 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"choices\":[{\"text\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"value\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"value\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\",\"value\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0686\\u0647\\u0627\\u0631\\u0645\",\"value\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0686\\u0647\\u0627\\u0631\\u0645\",\"isSelected\":false,\"price\":\"\"}],\"validateState\":true,\"inputs\":[{\"id\":\"2.1\",\"label\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0627\\u0648\\u0644\",\"name\":\"\"},{\"id\":\"2.2\",\"label\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u062f\\u0648\\u0645\",\"name\":\"\"},{\"id\":\"2.3\",\"label\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u0633\\u0648\\u0645\",\"name\":\"\"},{\"id\":\"2.4\",\"label\":\"\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"checkbox\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableDisplayInColumns\":\"\",\"enableSelectAll\":\"\",\"choiceLimit\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"67fa7637\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"selectAllText\":\"\\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0631\\u062f\\u0646 \\u0647\\u0645\\u0647\"}],\"button\":{\"type\":\"text\",\"text\":\"\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"title\":\"\\u062a\\u062a\\u062a\\u062a\",\"description\":\"\",\"version\":\"2.9.21\",\"id\":2,\"markupVersion\":2,\"nextFieldId\":4,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null}", NULL, "{\"694fbc6bd7509\":{\"id\":\"694fbc6bd7509\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f \\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"\\u0628\\u0627 \\u062a\\u0634\\u06a9\\u0631 \\u0627\\u0632 \\u062a\\u0645\\u0627\\u0633 \\u0634\\u0645\\u0627! \\u062f\\u0631 \\u0627\\u0633\\u0631\\u0639 \\u0648\\u0642\\u062a \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062f\\u0631 \\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0628\\u0648\\u062f.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"694fbc6bd729c\":{\"id\":\"694fbc6bd729c\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062c\\u062f\\u06cc\\u062f \\u0627\\u0632 {form_title}\",\"message\":\"{all_fields}\"}}");

/* INSERT TABLE DATA: aor_gf_form_view */
INSERT INTO `aor_gf_form_view` VALUES("1", "1", "2025-12-17 16:49:24", "", "55");
INSERT INTO `aor_gf_form_view` VALUES("2", "1", "2025-12-18 17:18:24", "", "8");
INSERT INTO `aor_gf_form_view` VALUES("3", "1", "2025-12-20 00:18:19", "", "12");
INSERT INTO `aor_gf_form_view` VALUES("4", "1", "2025-12-21 00:35:53", "", "3");
INSERT INTO `aor_gf_form_view` VALUES("5", "1", "2025-12-22 11:07:58", "", "11");
INSERT INTO `aor_gf_form_view` VALUES("6", "1", "2025-12-23 11:35:54", "", "27");
INSERT INTO `aor_gf_form_view` VALUES("7", "1", "2025-12-24 18:14:16", "", "11");
INSERT INTO `aor_gf_form_view` VALUES("8", "1", "2025-12-25 18:16:56", "", "10");
INSERT INTO `aor_gf_form_view` VALUES("9", "1", "2025-12-26 20:28:26", "", "6");
INSERT INTO `aor_gf_form_view` VALUES("10", "1", "2025-12-27 20:30:34", "", "28");
INSERT INTO `aor_gf_form_view` VALUES("11", "1", "2025-12-29 06:11:18", "", "5");

/* INSERT TABLE DATA: aor_jet_fb_migrations */
INSERT INTO `aor_jet_fb_migrations` VALUES("1", "Jet_Form_Builder\\Migrations\\Versions\\Version_2_1_7", "2025-12-17 13:50:51", "0");
INSERT INTO `aor_jet_fb_migrations` VALUES("2", "Jet_Form_Builder\\Migrations\\Versions\\Version_3_1_7", "2025-12-17 13:50:51", "0");
INSERT INTO `aor_jet_fb_migrations` VALUES("3", "Jet_Form_Builder\\Migrations\\Versions\\Version_2_1_0", "2025-12-17 13:50:52", "0");
INSERT INTO `aor_jet_fb_migrations` VALUES("4", "Jet_Form_Builder\\Migrations\\Versions\\Version_2_1_8", "2025-12-17 13:50:52", "0");

/* INSERT TABLE DATA: aor_jet_fb_records */
INSERT INTO `aor_jet_fb_records` VALUES("1", "19", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 13:50:51", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("2", "19", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=20", "reload", NULL, "2025-12-17 13:52:08", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("3", "23", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=22", "reload", NULL, "2025-12-17 13:54:21", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("4", "18", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 13:56:23", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("5", "26", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=25", "reload", NULL, "2025-12-17 13:58:02", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("6", "26", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=27", "reload", NULL, "2025-12-17 13:58:41", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("7", "31", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=28", "reload", NULL, "2025-12-17 14:02:17", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("8", "33", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 14:06:08", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("9", "33", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 14:07:13", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("10", "36", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 14:08:57", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("11", "39", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=37", "reload", NULL, "2025-12-17 14:12:13", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("12", "41", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 14:16:42", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("13", "41", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=42", "reload", NULL, "2025-12-17 14:17:09", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("14", "44", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=43", "reload", NULL, "2025-12-17 14:18:43", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("15", "47", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=45", "reload", NULL, "2025-12-17 14:22:06", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("16", "69", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949", "reload", NULL, "2025-12-17 15:06:15", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("17", "72", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=70", "reload", NULL, "2025-12-17 15:08:29", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("18", "72", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=73", "reload", NULL, "2025-12-17 15:09:50", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records` VALUES("19", "74", "1", "16", "jet-form-builder", "success", NULL, NULL, "https://amlakor.azindm.ir/?post_type=jet-form-builder&p=16&jfb_preview_nonce=cca5c4a949&inserted_post_id=75", "reload", NULL, "2025-12-17 15:10:41", "0000-00-00 00:00:00");

/* INSERT TABLE DATA: aor_jet_fb_records_actions */
INSERT INTO `aor_jet_fb_records_actions` VALUES("1", "1", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 13:50:52", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("2", "2", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 13:52:08", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("3", "3", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 13:54:21", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("4", "4", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 13:56:23", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("5", "5", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 13:58:02", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("6", "6", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 13:58:41", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("7", "7", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:02:17", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("8", "8", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:06:08", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("9", "9", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:07:13", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("10", "10", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:08:57", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("11", "11", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:12:13", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("12", "12", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:16:42", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("13", "13", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:17:09", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("14", "14", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:18:43", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("15", "15", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 14:22:06", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("16", "16", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 15:06:15", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("17", "17", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 15:08:29", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("18", "18", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 15:09:50", "0000-00-00 00:00:00");
INSERT INTO `aor_jet_fb_records_actions` VALUES("19", "19", "insert_post", "9598", "DEFAULT.PROCESS", "success", "2025-12-17 15:10:41", "0000-00-00 00:00:00");

/* INSERT TABLE DATA: aor_jet_fb_records_fields */
INSERT INTO `aor_jet_fb_records_fields` VALUES("1", "1", "title", "تست", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("2", "1", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("3", "1", "inserted_post_id", "20", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("4", "1", "inserted_post", "20", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("5", "2", "title", "فایل تستی", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("6", "2", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("7", "2", "inserted_post_id", "22", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("8", "2", "inserted_estate_file", "22", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("9", "3", "title", "ملک شماره 2", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("10", "3", "parking_copy", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("11", "3", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("12", "3", "inserted_post_id", "24", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("13", "3", "inserted_estate_file", "24", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("14", "4", "title", "تست آسانسور", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("15", "4", "parking_copy", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("16", "4", "elevator", "{\"jet_preset\":true,\"from\":\"post\",\"post_from\":\"current_post\",\"current_field_prop\":\"post_meta\",\"current_field_key\":\"elevator\"}{\"jet_preset\":true,\"from\":\"post\",\"post_from\":\"current_post\",\"current_field_prop\":\"post_meta\",\"current_field_key\":\"parking\"}", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("17", "4", "inserted_post_id", "25", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("18", "4", "inserted_estate_file", "25", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("19", "5", "title", "تست پارکینگ و آسانسور", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("20", "5", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("21", "5", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("22", "5", "inserted_post_id", "27", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("23", "5", "inserted_estate_file", "27", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("24", "6", "title", "تست آسانسور", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("25", "6", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("26", "6", "inserted_post_id", "28", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("27", "6", "inserted_estate_file", "28", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("28", "7", "title", "تست آسانسور و پارکنیگ", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("29", "7", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("30", "7", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("31", "7", "inserted_post_id", "32", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("32", "7", "inserted_estate_file", "32", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("33", "8", "title", "تست", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("34", "8", "address", "پشت تل نرسیده", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("35", "8", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("36", "8", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("37", "8", "inserted_post_id", "34", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("38", "8", "inserted_estate_file", "34", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("39", "9", "title", "تست", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("40", "9", "address", "پشت تل نرسیده", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("41", "9", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("42", "9", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("43", "9", "inserted_post_id", "35", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("44", "9", "inserted_estate_file", "35", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("45", "10", "title", "تست خالی بودن", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("46", "10", "inserted_post_id", "37", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("47", "10", "inserted_estate_file", "37", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("48", "11", "title", "تست ورودی محتوا", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("49", "11", "address", "پشت تل نرسیده", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("50", "11", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("51", "11", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("52", "11", "inserted_post_id", "40", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("53", "11", "inserted_estate_file", "40", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("54", "12", "title", "تست ورود محتوا", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("55", "12", "address", "سر پیچو", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("56", "12", "parking", "on", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("57", "12", "elevator", "on", "switcher", "{\"label\":\"آسانسور:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("58", "12", "inserted_post_id", "42", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("59", "12", "inserted_estate_file", "42", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("60", "13", "title", "تست خاموش بودن", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("61", "13", "address", "سشیشی", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("62", "13", "inserted_post_id", "43", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("63", "13", "inserted_estate_file", "43", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("64", "14", "title", "تست خاموش بودن2", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("65", "14", "address", "شسیشسی", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("66", "14", "inserted_post_id", "45", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("67", "14", "inserted_estate_file", "45", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("68", "15", "title", "تست ثبت ملک", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("69", "15", "address", "شسیشسی", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("70", "15", "parking", "true", "switcher", "{\"label\":\"پارکینگ:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("71", "15", "inserted_post_id", "48", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("72", "15", "inserted_estate_file", "48", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("73", "16", "title", "تست با جت فرم", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("74", "16", "address", "شسیشسیشسی", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("75", "16", "inserted_post_id", "70", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("76", "16", "inserted_estate_file", "70", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("77", "17", "title", "تست جدید جت فرم", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("78", "17", "address", "شسیشسیشسی", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("79", "17", "elevator", "on", "switcher", "{\"label\":\"آسانسور\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("80", "17", "inserted_post_id", "73", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("81", "17", "inserted_estate_file", "73", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("82", "18", "title", "ksajdl`", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("83", "18", "address", "askjdashdkas", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("84", "18", "elevator", "on", "switcher", "{\"label\":\"آسانسور\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("85", "18", "inserted_post_id", "75", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("86", "18", "inserted_estate_file", "75", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("87", "19", "title", "kmnx,mzxc", "text-field", "{\"label\":\"Post Title\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("88", "19", "address", "am,sn,dmnas,d", "textarea-field", "{\"label\":\"آدرس:\"}");
INSERT INTO `aor_jet_fb_records_fields` VALUES("89", "19", "inserted_post_id", "76", "computed", "[]");
INSERT INTO `aor_jet_fb_records_fields` VALUES("90", "19", "inserted_estate_file", "76", "computed", "[]");

/* INSERT TABLE DATA: aor_jet_post_types */
INSERT INTO `aor_jet_post_types` VALUES("1", "estate_file", "publish", "a:3:{s:4:\"name\";s:15:\"فایل ملک\";s:13:\"singular_name\";s:15:\"فایل ملک\";s:9:\"all_items\";s:28:\"فایل‌های املاک\";}", "a:24:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:1;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:14:\"custom_storage\";b:1;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:12:\"rewrite_slug\";s:11:\"estate_file\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:-1;s:9:\"menu_icon\";s:20:\"dashicons-admin-home\";s:8:\"supports\";a:5:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:15:\"page-attributes\";i:4;s:9:\"thumbnail\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:21:{i:0;a:11:{s:5:\"title\";s:24:\"گالری تصاویر:\";s:4:\"name\";s:7:\"gallery\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:7:\"gallery\";s:2:\"id\";i:3077;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:11:\"is_required\";b:1;}i:1;a:11:{s:5:\"title\";s:15:\"توضیحات:\";s:4:\"name\";s:12:\"_description\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:8:\"textarea\";s:2:\"id\";i:2746;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:11:\"is_required\";b:1;}i:2;a:11:{s:5:\"title\";s:9:\"آدرس:\";s:4:\"name\";s:7:\"address\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:8:\"textarea\";s:2:\"id\";i:7740;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:11:\"is_required\";b:1;}i:3;a:13:{s:5:\"title\";s:18:\"چند واحدی:\";s:4:\"name\";s:10:\"multi_unit\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:5980;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:2:\"99\";s:11:\"is_required\";b:1;}i:4;a:13:{s:5:\"title\";s:20:\"تعداد خواب:\";s:4:\"name\";s:16:\"number_of_sleeps\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:2678;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:17:\"conditional_logic\";s:0:\"\";s:10:\"conditions\";a:0:{}s:20:\"conditional_relation\";s:3:\"AND\";}i:5;a:10:{s:5:\"title\";s:15:\"پارکینگ:\";s:4:\"name\";s:7:\"parking\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:4:\"true\";s:5:\"value\";s:8:\"دارد\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:5:\"false\";s:5:\"value\";s:10:\"ندارد\";s:2:\"id\";i:8372;s:10:\"is_checked\";b:1;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:1095;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:6;a:10:{s:5:\"title\";s:15:\"آسانسور:\";s:4:\"name\";s:8:\"elevator\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:4:\"true\";s:5:\"value\";s:8:\"دارد\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:5:\"false\";s:5:\"value\";s:10:\"ندارد\";s:2:\"id\";i:8372;s:10:\"is_checked\";b:1;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:9186;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:7;a:10:{s:5:\"title\";s:11:\"انبار:\";s:4:\"name\";s:9:\"warehouse\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:4:\"true\";s:5:\"value\";s:8:\"دارد\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:5:\"false\";s:5:\"value\";s:10:\"ندارد\";s:2:\"id\";i:8372;s:10:\"is_checked\";b:1;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:8056;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:8;a:10:{s:5:\"title\";s:20:\"نوع دسترسی:\";s:4:\"name\";s:11:\"access_type\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:4:\"hall\";s:5:\"value\";s:13:\"درب هال\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:4:\"yard\";s:5:\"value\";s:15:\"درب حیاط\";s:2:\"id\";i:8372;s:10:\"is_checked\";s:0:\"\";}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:2534;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:9;a:10:{s:5:\"title\";s:16:\"وضعیت بر:\";s:4:\"name\";s:13:\"frontage_type\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:3:{i:0;a:3:{s:3:\"key\";s:6:\"single\";s:5:\"value\";s:13:\"تک لاین\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:6:\"double\";s:5:\"value\";s:22:\"دو نبش (دوبر)\";s:2:\"id\";i:8372;s:10:\"is_checked\";s:0:\"\";}i:2;a:3:{s:3:\"key\";s:6:\"triple\";s:5:\"value\";s:11:\"سه نبش\";s:2:\"id\";i:6363;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:6698;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:10;a:10:{s:5:\"title\";s:13:\"کابینت:\";s:4:\"name\";s:7:\"cabinet\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:4:\"true\";s:5:\"value\";s:8:\"دارد\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:5:\"false\";s:5:\"value\";s:10:\"ندارد\";s:2:\"id\";i:8372;s:10:\"is_checked\";b:1;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:9406;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:11;a:10:{s:5:\"title\";s:20:\"نوع کابینت:\";s:4:\"name\";s:12:\"cabinet_type\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:3:{i:0;a:3:{s:3:\"key\";s:3:\"mdf\";s:5:\"value\";s:3:\"MDF\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:5:\"metal\";s:5:\"value\";s:6:\"فلز\";s:2:\"id\";i:8372;s:10:\"is_checked\";s:0:\"\";}i:2;a:3:{s:3:\"key\";s:14:\"Other cabinets\";s:5:\"value\";s:8:\"سایر\";s:2:\"id\";i:1613;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:4154;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:12;a:10:{s:5:\"title\";s:16:\"سال ساخت:\";s:4:\"name\";s:19:\"year_of_manufacture\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:9380;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:13;a:10:{s:5:\"title\";s:9:\"مستر:\";s:4:\"name\";s:6:\"master\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:4:\"true\";s:5:\"value\";s:8:\"دارد\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:5:\"false\";s:5:\"value\";s:10:\"ندارد\";s:2:\"id\";i:8372;s:10:\"is_checked\";b:1;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:1641;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:14;a:10:{s:5:\"title\";s:7:\"نما:\";s:4:\"name\";s:15:\"building_facade\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:4:{i:0;a:3:{s:3:\"key\";s:5:\"stone\";s:5:\"value\";s:6:\"سنگ\";s:2:\"id\";i:2555;}i:1;a:4:{s:3:\"key\";s:8:\"Ceramics\";s:5:\"value\";s:12:\"سرامیک\";s:2:\"id\";i:8372;s:10:\"is_checked\";s:0:\"\";}i:2;a:3:{s:3:\"key\";s:5:\"brick\";s:5:\"value\";s:6:\"آجر\";s:2:\"id\";i:5678;}i:3;a:3:{s:3:\"key\";s:11:\"Other views\";s:5:\"value\";s:8:\"سایر\";s:2:\"id\";i:1613;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:7405;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:15;a:13:{s:5:\"title\";s:7:\"ضلع:\";s:4:\"name\";s:4:\"side\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:4:{i:0;a:3:{s:3:\"key\";s:5:\"north\";s:5:\"value\";s:8:\"شمال\";s:2:\"id\";i:6006;}i:1;a:3:{s:3:\"key\";s:5:\"south\";s:5:\"value\";s:8:\"جنوب\";s:2:\"id\";i:7393;}i:2;a:3:{s:3:\"key\";s:4:\"east\";s:5:\"value\";s:6:\"شرق\";s:2:\"id\";i:8739;}i:3;a:3:{s:3:\"key\";s:4:\"west\";s:5:\"value\";s:6:\"غرب\";s:2:\"id\";i:1519;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:5639;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:8:\"is_array\";s:0:\"\";s:16:\"revision_support\";s:0:\"\";s:14:\"quick_editable\";s:0:\"\";}i:16;a:13:{s:5:\"title\";s:11:\"متراژ:\";s:4:\"name\";s:8:\"meterage\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:9204;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:5:\"10000\";s:11:\"is_required\";s:0:\"\";}i:17;a:13:{s:5:\"title\";s:29:\"متراژ بر خیابان:\";s:4:\"name\";s:28:\"square_footage_on_the_street\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:2250;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:5:\"10000\";s:11:\"is_required\";s:0:\"\";}i:18;a:10:{s:5:\"title\";s:16:\"نوع زمین:\";s:4:\"name\";s:12:\"type_of_land\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:2:{i:0;a:3:{s:3:\"key\";s:10:\"commercial\";s:5:\"value\";s:10:\"تجاری\";s:2:\"id\";i:6006;}i:1;a:3:{s:3:\"key\";s:11:\"residential\";s:5:\"value\";s:12:\"مسکونی\";s:2:\"id\";i:7393;}}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:8891;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:19;a:10:{s:5:\"title\";s:22:\"وضعیت نمایش:\";s:4:\"name\";s:11:\"_visibility\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:9651;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:20;a:10:{s:5:\"title\";s:24:\"دسترسی افراد:\";s:4:\"name\";s:16:\"access_to_people\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:7105;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}}");
INSERT INTO `aor_jet_post_types` VALUES("2", "crmapp", "publish", "a:1:{s:4:\"name\";s:3:\"crm\";}", "a:24:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:0;s:12:\"hierarchical\";b:1;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:14:\"custom_storage\";b:1;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:12:\"rewrite_slug\";s:3:\"crm\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:-1;s:9:\"menu_icon\";s:15:\"dashicons-forms\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:15:\"page-attributes\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:0:{}");
INSERT INTO `aor_jet_post_types` VALUES("3", NULL, "query", "a:1:{s:4:\"name\";s:11:\"Posts Query\";}", "a:19:{s:10:\"query_type\";s:5:\"posts\";s:5:\"posts\";a:5:{s:7:\"orderby\";a:0:{}s:10:\"meta_query\";a:1:{i:0;a:5:{s:3:\"_id\";i:990118;s:9:\"collapsed\";b:0;s:3:\"key\";s:16:\"access_to_people\";s:7:\"compare\";s:4:\"LIKE\";s:5:\"value\";s:0:\"\";}}s:9:\"tax_query\";a:0:{}s:10:\"date_query\";a:0:{}s:9:\"post_type\";a:1:{i:0;s:11:\"estate_file\";}}s:15:\"__dynamic_posts\";a:3:{s:10:\"meta_query\";a:1:{i:990118;a:1:{s:5:\"value\";s:45:\"%current_user_id%{\"context\":\"default_object\"}\";}}s:9:\"tax_query\";a:0:{}s:10:\"date_query\";a:0:{}}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:16:\"avoid_duplicates\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}s:13:\"cache_expires\";i:0;}", "a:0:{}");

/* INSERT TABLE DATA: aor_jet_taxonomies */
INSERT INTO `aor_jet_taxonomies` VALUES("1", "property-type", "a:1:{i:0;s:11:\"estate_file\";}", "publish", "a:1:{s:4:\"name\";s:13:\"نوع ملک\";}", "a:17:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:7:\"rewrite\";b:1;s:12:\"hierarchical\";b:1;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:20:\"rewrite_hierarchical\";b:0;s:9:\"query_var\";s:0:\"\";s:12:\"rewrite_slug\";s:13:\"property-type\";s:15:\"capability_type\";s:0:\"\";s:11:\"description\";s:0:\"\";}", "a:0:{}");

/* INSERT TABLE DATA: aor_options */
INSERT INTO `aor_options` VALUES("1", "cron", "a:18:{i:1767022196;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1767025320;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1767046950;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1767050519;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1767051177;a:1:{s:41:\"check_plugin_updates-user-role-editor-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1767052319;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1767054119;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1767089825;a:1:{s:30:\"gravityview-expired-transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767090120;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767090150;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767090152;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767090188;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1767092585;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767094383;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767176520;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1767609000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1767730993;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `aor_options` VALUES("2", "siteurl", "https://amlakor.azindm.ir", "on");
INSERT INTO `aor_options` VALUES("3", "home", "https://amlakor.azindm.ir", "on");
INSERT INTO `aor_options` VALUES("4", "blogname", "املاک اردیبهشت", "on");
INSERT INTO `aor_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `aor_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `aor_options` VALUES("7", "admin_email", "dev-email@vordinpro.com", "on");
INSERT INTO `aor_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `aor_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `aor_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `aor_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `aor_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `aor_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `aor_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `aor_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `aor_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `aor_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `aor_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `aor_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `aor_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `aor_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `aor_options` VALUES("22", "default_pingback_flag", "0", "on");
INSERT INTO `aor_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `aor_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `aor_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `aor_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `aor_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `aor_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `aor_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `aor_options` VALUES("30", "rewrite_rules", "a:197:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"gf_live_preview/?$\";s:35:\"index.php?post_type=gf_live_preview\";s:48:\"gf_live_preview/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=gf_live_preview&feed=$matches[1]\";s:43:\"gf_live_preview/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=gf_live_preview&feed=$matches[1]\";s:35:\"gf_live_preview/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=gf_live_preview&paged=$matches[1]\";s:19:\"^wp\\.serviceworker$\";s:29:\"index.php?wp_service_worker=1\";s:18:\"view/([^/]+)/csv/?\";s:39:\"index.php?gravityview=$matches[1]&csv=1\";s:18:\"view/([^/]+)/tsv/?\";s:39:\"index.php?gravityview=$matches[1]&tsv=1\";s:23:\"^gk-download/([^/]+)/?$\";s:39:\"index.php?gk_download_token=$matches[1]\";s:14:\"estate_file/?$\";s:31:\"index.php?post_type=estate_file\";s:44:\"estate_file/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=estate_file&feed=$matches[1]\";s:39:\"estate_file/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=estate_file&feed=$matches[1]\";s:31:\"estate_file/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=estate_file&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)/entry(/(.*))?/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&entry=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"property-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=property-type&term=$matches[1]&feed=$matches[2]\";s:49:\"property-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=property-type&term=$matches[1]&feed=$matches[2]\";s:30:\"property-type/([^/]+)/embed/?$\";s:60:\"index.php?taxonomy=property-type&term=$matches[1]&embed=true\";s:42:\"property-type/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?taxonomy=property-type&term=$matches[1]&paged=$matches[2]\";s:24:\"property-type/([^/]+)/?$\";s:49:\"index.php?taxonomy=property-type&term=$matches[1]\";s:43:\"gf_live_preview/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"gf_live_preview/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"gf_live_preview/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"gf_live_preview/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"gf_live_preview/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"gf_live_preview/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"gf_live_preview/([^/]+)/embed/?$\";s:48:\"index.php?gf_live_preview=$matches[1]&embed=true\";s:36:\"gf_live_preview/([^/]+)/trackback/?$\";s:42:\"index.php?gf_live_preview=$matches[1]&tb=1\";s:56:\"gf_live_preview/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?gf_live_preview=$matches[1]&feed=$matches[2]\";s:51:\"gf_live_preview/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?gf_live_preview=$matches[1]&feed=$matches[2]\";s:44:\"gf_live_preview/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?gf_live_preview=$matches[1]&paged=$matches[2]\";s:51:\"gf_live_preview/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?gf_live_preview=$matches[1]&cpage=$matches[2]\";s:40:\"gf_live_preview/([^/]+)/entry(/(.*))?/?$\";s:55:\"index.php?gf_live_preview=$matches[1]&entry=$matches[3]\";s:40:\"gf_live_preview/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?gf_live_preview=$matches[1]&page=$matches[2]\";s:32:\"gf_live_preview/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"gf_live_preview/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"gf_live_preview/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"gf_live_preview/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"gf_live_preview/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"gf_live_preview/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"view/([^/]+)/embed/?$\";s:44:\"index.php?gravityview=$matches[1]&embed=true\";s:25:\"view/([^/]+)/trackback/?$\";s:38:\"index.php?gravityview=$matches[1]&tb=1\";s:33:\"view/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?gravityview=$matches[1]&paged=$matches[2]\";s:40:\"view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?gravityview=$matches[1]&cpage=$matches[2]\";s:29:\"view/([^/]+)/entry(/(.*))?/?$\";s:51:\"index.php?gravityview=$matches[1]&entry=$matches[3]\";s:29:\"view/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?gravityview=$matches[1]&page=$matches[2]\";s:21:\"view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"crm/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"crm/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"crm/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"crm/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"crm/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"crm/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:18:\"crm/(.+?)/embed/?$\";s:39:\"index.php?crmapp=$matches[1]&embed=true\";s:22:\"crm/(.+?)/trackback/?$\";s:33:\"index.php?crmapp=$matches[1]&tb=1\";s:30:\"crm/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?crmapp=$matches[1]&paged=$matches[2]\";s:37:\"crm/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?crmapp=$matches[1]&cpage=$matches[2]\";s:26:\"crm/(.+?)/entry(/(.*))?/?$\";s:46:\"index.php?crmapp=$matches[1]&entry=$matches[3]\";s:26:\"crm/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?crmapp=$matches[1]&page=$matches[2]\";s:37:\"estate_file/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"estate_file/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"estate_file/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"estate_file/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"estate_file/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"estate_file/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"estate_file/(.+?)/embed/?$\";s:44:\"index.php?estate_file=$matches[1]&embed=true\";s:30:\"estate_file/(.+?)/trackback/?$\";s:38:\"index.php?estate_file=$matches[1]&tb=1\";s:50:\"estate_file/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?estate_file=$matches[1]&feed=$matches[2]\";s:45:\"estate_file/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?estate_file=$matches[1]&feed=$matches[2]\";s:38:\"estate_file/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?estate_file=$matches[1]&paged=$matches[2]\";s:45:\"estate_file/(.+?)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?estate_file=$matches[1]&cpage=$matches[2]\";s:34:\"estate_file/(.+?)/entry(/(.*))?/?$\";s:51:\"index.php?estate_file=$matches[1]&entry=$matches[3]\";s:34:\"estate_file/(.+?)(?:/([0-9]+))?/?$\";s:50:\"index.php?estate_file=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=87&cpage=$matches[1]\";s:16:\"entry(/(.*))?/?$\";s:28:\"index.php?&entry=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)/entry(/(.*))?/?$\";s:48:\"index.php?pagename=$matches[1]&entry=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)/entry(/(.*))?/?$\";s:44:\"index.php?name=$matches[1]&entry=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `aor_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `aor_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `aor_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `aor_options` VALUES("34", "active_plugins", "a:18:{i:0;s:29:\"gravityperks/gravityperks.php\";i:1;s:29:\"gravityforms/gravityforms.php\";i:2;s:40:\"ajax-loader-cache/ajax-loader-bymdez.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:31:\"elementor-pro/elementor-pro.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:45:\"gp-populate-anything/gp-populate-anything.php\";i:7;s:57:\"gravityformsadvancedpostcreation/advancedpostcreation.php\";i:8;s:47:\"gravityview-advanced-filter/advanced-filter.php\";i:9;s:27:\"gravityview/gravityview.php\";i:10;s:25:\"jet-engine/jet-engine.php\";i:11;s:35:\"jetformbuilder/jet-form-builder.php\";i:12;s:39:\"persian-elementor/persian-elementor.php\";i:13;s:31:\"persian-gravity-forms/index.php\";i:14;s:41:\"powerpack-elements/powerpack-elements.php\";i:15;s:11:\"pwa/pwa.php\";i:16;s:45:\"user-role-editor-pro/user-role-editor-pro.php\";i:17;s:29:\"wp-parsidate/wp-parsidate.php\";}", "on");
INSERT INTO `aor_options` VALUES("35", "category_base", "", "on");
INSERT INTO `aor_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `aor_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `aor_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `aor_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `aor_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `aor_options` VALUES("41", "template", "hello-elementor", "on");
INSERT INTO `aor_options` VALUES("42", "stylesheet", "hello-child", "on");
INSERT INTO `aor_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `aor_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `aor_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `aor_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `aor_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `aor_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `aor_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `aor_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `aor_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `aor_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `aor_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `aor_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `aor_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `aor_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `aor_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `aor_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `aor_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `aor_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `aor_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `aor_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `aor_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `aor_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `aor_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `aor_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `aor_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `aor_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `aor_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `aor_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `aor_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `aor_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `aor_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `aor_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `aor_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `aor_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `aor_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `aor_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `aor_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `aor_options` VALUES("80", "uninstall_plugins", "a:4:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:43:\"wp-parsi-statistics/wp-parsi-statistics.php\";s:28:\"wp_parsi_statistics_unistall\";s:45:\"user-role-editor-pro/user-role-editor-pro.php\";a:2:{i:0;s:20:\"User_Role_Editor_Pro\";i:1;s:9:\"uninstall\";}s:19:\"bbpress/bbpress.php\";s:15:\"bbp_remove_caps\";}", "off");
INSERT INTO `aor_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `aor_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `aor_options` VALUES("83", "page_on_front", "87", "on");
INSERT INTO `aor_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `aor_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `aor_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `aor_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `aor_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `aor_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `aor_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `aor_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `aor_options` VALUES("92", "admin_email_lifespan", "1781432519", "on");
INSERT INTO `aor_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `aor_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `aor_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `aor_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `aor_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `aor_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `aor_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `aor_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `aor_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `aor_options` VALUES("102", "aor_user_roles", "a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:148:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:16:\"ure_export_roles\";b:1;s:16:\"ure_import_roles\";b:1;s:21:\"ure_admin_menu_access\";b:1;s:18:\"ure_widgets_access\";b:1;s:23:\"ure_widgets_show_access\";b:1;s:21:\"ure_meta_boxes_access\";b:1;s:22:\"ure_other_roles_access\";b:1;s:21:\"ure_edit_posts_access\";b:1;s:28:\"ure_edit_gravityforms_access\";b:1;s:29:\"ure_plugins_activation_access\";b:1;s:21:\"ure_view_posts_access\";b:1;s:25:\"ure_front_end_menu_access\";b:1;s:20:\"ure_nav_menus_access\";b:1;s:23:\"gravityview_full_access\";b:1;s:25:\"gravityview_view_settings\";b:1;s:25:\"gravityview_edit_settings\";b:1;s:21:\"gravityview_uninstall\";b:1;s:27:\"gravityview_contact_support\";b:1;s:24:\"edit_others_gravityviews\";b:1;s:25:\"edit_private_gravityviews\";b:1;s:27:\"edit_published_gravityviews\";b:1;s:25:\"read_private_gravityviews\";b:1;s:27:\"delete_private_gravityviews\";b:1;s:26:\"delete_others_gravityviews\";b:1;s:20:\"publish_gravityviews\";b:1;s:29:\"delete_published_gravityviews\";b:1;s:17:\"copy_gravityviews\";b:1;s:31:\"gravityview_edit_others_entries\";b:1;s:28:\"gravityview_moderate_entries\";b:1;s:33:\"gravityview_delete_others_entries\";b:1;s:27:\"gravityview_add_entry_notes\";b:1;s:28:\"gravityview_view_entry_notes\";b:1;s:30:\"gravityview_delete_entry_notes\";b:1;s:29:\"gravityview_email_entry_notes\";b:1;s:24:\"gravityview_edit_entries\";b:1;s:22:\"gravityview_edit_entry\";b:1;s:29:\"gravityview_edit_form_entries\";b:1;s:26:\"gravityview_delete_entries\";b:1;s:24:\"gravityview_delete_entry\";b:1;s:17:\"edit_gravityviews\";b:1;s:19:\"delete_gravityviews\";b:1;s:27:\"gravityview_getting_started\";b:1;s:24:\"gravityview_support_port\";b:1;s:24:\"gravityview_view_entries\";b:1;s:31:\"gravityview_view_others_entries\";b:1;s:17:\"edit_jet_fb_forms\";b:1;s:24:\"edit_others_jet_fb_forms\";b:1;s:20:\"publish_jet_fb_forms\";b:1;s:25:\"read_private_jet_fb_forms\";b:1;s:19:\"delete_jet_fb_forms\";b:1;s:12:\"create_posts\";b:1;s:25:\"gravityforms_api_settings\";b:1;s:24:\"gravityforms_create_form\";b:1;s:27:\"gravityforms_delete_entries\";b:1;s:25:\"gravityforms_delete_forms\";b:1;s:25:\"gravityforms_edit_entries\";b:1;s:29:\"gravityforms_edit_entry_notes\";b:1;s:23:\"gravityforms_edit_forms\";b:1;s:26:\"gravityforms_edit_settings\";b:1;s:27:\"gravityforms_export_entries\";b:1;s:20:\"gravityforms_logging\";b:1;s:26:\"gravityforms_preview_forms\";b:1;s:26:\"gravityforms_system_status\";b:1;s:22:\"gravityforms_uninstall\";b:1;s:24:\"gravityforms_view_addons\";b:1;s:25:\"gravityforms_view_entries\";b:1;s:29:\"gravityforms_view_entry_notes\";b:1;s:26:\"gravityforms_view_settings\";b:1;s:25:\"gravityforms_view_updates\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:58:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:25:\"read_private_gravityviews\";b:1;s:27:\"delete_private_gravityviews\";b:1;s:26:\"delete_others_gravityviews\";b:1;s:20:\"publish_gravityviews\";b:1;s:29:\"delete_published_gravityviews\";b:1;s:17:\"copy_gravityviews\";b:1;s:31:\"gravityview_edit_others_entries\";b:1;s:28:\"gravityview_moderate_entries\";b:1;s:33:\"gravityview_delete_others_entries\";b:1;s:27:\"gravityview_add_entry_notes\";b:1;s:28:\"gravityview_view_entry_notes\";b:1;s:30:\"gravityview_delete_entry_notes\";b:1;s:29:\"gravityview_email_entry_notes\";b:1;s:24:\"gravityview_edit_entries\";b:1;s:22:\"gravityview_edit_entry\";b:1;s:29:\"gravityview_edit_form_entries\";b:1;s:26:\"gravityview_delete_entries\";b:1;s:24:\"gravityview_delete_entry\";b:1;s:17:\"edit_gravityviews\";b:1;s:19:\"delete_gravityviews\";b:1;s:27:\"gravityview_getting_started\";b:1;s:24:\"gravityview_support_port\";b:1;s:24:\"gravityview_view_entries\";b:1;s:31:\"gravityview_view_others_entries\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:21:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"gravityview_edit_entries\";b:1;s:22:\"gravityview_edit_entry\";b:1;s:29:\"gravityview_edit_form_entries\";b:1;s:26:\"gravityview_delete_entries\";b:1;s:24:\"gravityview_delete_entry\";b:1;s:17:\"edit_gravityviews\";b:1;s:19:\"delete_gravityviews\";b:1;s:27:\"gravityview_getting_started\";b:1;s:24:\"gravityview_support_port\";b:1;s:24:\"gravityview_view_entries\";b:1;s:31:\"gravityview_view_others_entries\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:11:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_gravityviews\";b:1;s:19:\"delete_gravityviews\";b:1;s:27:\"gravityview_getting_started\";b:1;s:24:\"gravityview_support_port\";b:1;s:24:\"gravityview_view_entries\";b:1;s:31:\"gravityview_view_others_entries\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:4:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:24:\"gravityview_view_entries\";b:1;s:31:\"gravityview_view_others_entries\";b:1;}}s:14:\"realestateuser\";a:2:{s:4:\"name\";s:21:\"کاربر املاک\";s:12:\"capabilities\";a:4:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:24:\"gravityview_view_entries\";b:1;s:31:\"gravityview_view_others_entries\";b:1;}}}", "on");
INSERT INTO `aor_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `aor_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `aor_options` VALUES("105", "user_count", "2", "off");
INSERT INTO `aor_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("107", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `aor_options` VALUES("128", "recovery_keys", "a:0:{}", "off");
INSERT INTO `aor_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `aor_options` VALUES("195", "recently_activated", "a:0:{}", "off");
INSERT INTO `aor_options` VALUES("201", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `aor_options` VALUES("197", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `aor_options` VALUES("198", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":true,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `aor_options` VALUES("199", "elementor_version", "3.33.4", "auto");
INSERT INTO `aor_options` VALUES("200", "elementor_install_history", "a:1:{s:6:\"3.33.4\";i:1765880643;}", "auto");
INSERT INTO `aor_options` VALUES("203", "elementor_onboarded", "1", "auto");
INSERT INTO `aor_options` VALUES("204", "_elementor_installed_time", "1765880655", "auto");
INSERT INTO `aor_options` VALUES("205", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `aor_options` VALUES("4675", "_transient_timeout_elementor_remote_info_api_data_3.33.4", "1767037509", "off");
INSERT INTO `aor_options` VALUES("4676", "_transient_elementor_remote_info_api_data_3.33.4", "a:4:{s:9:\"timestamp\";s:10:\"1766993816\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `aor_options` VALUES("4843", "_site_transient_timeout_jet_dashboard_remote_jet_plugin_list", "1767108538", "off");
INSERT INTO `aor_options` VALUES("4844", "_site_transient_jet_dashboard_remote_jet_plugin_list", "a:19:{i:0;a:9:{s:4:\"name\";s:11:\"JetElements\";s:4:\"slug\";s:29:\"jet-elements/jet-elements.php\";s:7:\"version\";s:8:\"2.7.12.3\";s:5:\"thumb\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo/jetelements.svg\";s:9:\"thumb_alt\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetelements.svg\";s:4:\"docs\";s:68:\"https://crocoblock.com/knowledge-base/article-category/jet-elements/\";s:4:\"demo\";s:43:\"https://crocoblock.com/plugins/jetelements/\";s:4:\"desc\";s:24:\"Must-have design widgets\";s:8:\"versions\";a:69:{i:0;s:8:\"2.7.12.3\";i:1;s:8:\"2.7.12.2\";i:2;s:8:\"2.7.12.1\";i:3;s:6:\"2.7.12\";i:4;s:6:\"2.7.11\";i:5;s:8:\"2.7.10.1\";i:6;s:6:\"2.7.10\";i:7;s:7:\"2.7.9.1\";i:8;s:5:\"2.7.9\";i:9;s:7:\"2.7.8.1\";i:10;s:5:\"2.7.8\";i:11;s:5:\"2.7.7\";i:12;s:5:\"2.7.6\";i:13;s:7:\"2.7.5.1\";i:14;s:5:\"2.7.5\";i:15;s:7:\"2.7.4.2\";i:16;s:7:\"2.7.4.1\";i:17;s:5:\"2.7.4\";i:18;s:5:\"2.7.3\";i:19;s:7:\"2.7.2.1\";i:20;s:5:\"2.7.2\";i:21;s:7:\"2.7.1.1\";i:22;s:5:\"2.7.1\";i:23;s:5:\"2.7.0\";i:24;s:8:\"2.6.20.1\";i:25;s:6:\"2.6.20\";i:26;s:6:\"2.6.19\";i:27;s:6:\"2.6.18\";i:28;s:8:\"2.6.17.1\";i:29;s:6:\"2.6.17\";i:30;s:6:\"2.6.16\";i:31;s:6:\"2.6.15\";i:32;s:6:\"2.6.14\";i:33;s:8:\"2.6.13.1\";i:34;s:6:\"2.6.13\";i:35;s:8:\"2.6.12.2\";i:36;s:8:\"2.6.12.1\";i:37;s:6:\"2.6.12\";i:38;s:6:\"2.6.11\";i:39;s:6:\"2.6.10\";i:40;s:5:\"2.6.9\";i:41;s:5:\"2.6.8\";i:42;s:5:\"2.6.7\";i:43;s:5:\"2.6.6\";i:44;s:5:\"2.6.5\";i:45;s:5:\"2.6.4\";i:46;s:5:\"2.6.3\";i:47;s:5:\"2.6.2\";i:48;s:5:\"2.6.1\";i:49;s:5:\"2.6.0\";i:50;s:5:\"2.5.9\";i:51;s:5:\"2.5.8\";i:52;s:5:\"2.5.7\";i:53;s:5:\"2.5.6\";i:54;s:5:\"2.5.5\";i:55;s:5:\"2.5.4\";i:56;s:5:\"2.5.3\";i:57;s:5:\"2.5.2\";i:58;s:5:\"2.5.1\";i:59;s:5:\"2.5.0\";i:60;s:5:\"2.4.1\";i:61;s:5:\"2.4.0\";i:62;s:5:\"2.3.3\";i:63;s:5:\"2.3.2\";i:64;s:5:\"2.3.1\";i:65;s:5:\"2.3.0\";i:66;s:6:\"2.2.17\";i:67;s:6:\"2.2.16\";i:68;s:6:\"2.2.15\";}}i:1;a:9:{s:4:\"name\";s:7:\"JetTabs\";s:4:\"slug\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"version\";s:8:\"2.2.12.1\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jettabs.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettabs.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-tabs/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jettabs/\";s:4:\"desc\";s:31:\"A smart way to organize content\";s:8:\"versions\";a:45:{i:0;s:8:\"2.2.12.1\";i:1;s:6:\"2.2.12\";i:2;s:6:\"2.2.11\";i:3;s:6:\"2.2.10\";i:4;s:7:\"2.2.9.2\";i:5;s:7:\"2.2.9.1\";i:6;s:5:\"2.2.9\";i:7;s:5:\"2.2.8\";i:8;s:5:\"2.2.7\";i:9;s:7:\"2.2.6.2\";i:10;s:7:\"2.2.6.1\";i:11;s:5:\"2.2.6\";i:12;s:5:\"2.2.5\";i:13;s:5:\"2.2.4\";i:14;s:7:\"2.2.3.1\";i:15;s:5:\"2.2.3\";i:16;s:5:\"2.2.2\";i:17;s:5:\"2.2.1\";i:18;s:5:\"2.2.0\";i:19;s:8:\"2.1.25.4\";i:20;s:8:\"2.1.25.3\";i:21;s:8:\"2.1.25.2\";i:22;s:8:\"2.1.25.1\";i:23;s:6:\"2.1.25\";i:24;s:6:\"2.1.24\";i:25;s:6:\"2.1.23\";i:26;s:6:\"2.1.22\";i:27;s:6:\"2.1.21\";i:28;s:6:\"2.1.20\";i:29;s:6:\"2.1.19\";i:30;s:6:\"2.1.18\";i:31;s:6:\"2.1.17\";i:32;s:6:\"2.1.16\";i:33;s:6:\"2.1.15\";i:34;s:6:\"2.1.14\";i:35;s:6:\"2.1.13\";i:36;s:6:\"2.1.12\";i:37;s:6:\"2.1.11\";i:38;s:6:\"2.1.10\";i:39;s:5:\"2.1.9\";i:40;s:5:\"2.1.8\";i:41;s:5:\"2.1.7\";i:42;s:5:\"2.1.6\";i:43;s:5:\"2.1.5\";i:44;s:5:\"2.1.4\";}}i:2;a:9:{s:4:\"name\";s:10:\"JetReviews\";s:4:\"slug\";s:27:\"jet-reviews/jet-reviews.php\";s:7:\"version\";s:7:\"3.0.0.1\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetreviews.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetreviews.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetreviews/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetreviews/\";s:4:\"desc\";s:32:\"Add reviews, comments, and rates\";s:8:\"versions\";a:26:{i:0;s:7:\"3.0.0.1\";i:1;s:5:\"3.0.0\";i:2;s:5:\"2.3.7\";i:3;s:5:\"2.3.6\";i:4;s:5:\"2.3.5\";i:5;s:5:\"2.3.4\";i:6;s:5:\"2.3.3\";i:7;s:7:\"2.3.2.1\";i:8;s:5:\"2.3.2\";i:9;s:5:\"2.3.1\";i:10;s:5:\"2.3.0\";i:11;s:5:\"2.2.7\";i:12;s:5:\"2.2.6\";i:13;s:5:\"2.2.4\";i:14;s:5:\"2.2.3\";i:15;s:5:\"2.2.2\";i:16;s:5:\"2.2.1\";i:17;s:5:\"2.2.0\";i:18;s:5:\"2.1.1\";i:19;s:5:\"2.1.0\";i:20;s:5:\"2.0.2\";i:21;s:5:\"2.0.1\";i:22;s:5:\"2.0.0\";i:23;s:5:\"1.3.0\";i:24;s:5:\"1.2.2\";i:25;s:5:\"1.2.1\";}}i:3;a:9:{s:4:\"name\";s:7:\"JetMenu\";s:4:\"slug\";s:21:\"jet-menu/jet-menu.php\";s:7:\"version\";s:6:\"2.4.18\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetmenu.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetmenu.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-menu/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetmenu/\";s:4:\"desc\";s:24:\"Build a custom mega menu\";s:8:\"versions\";a:47:{i:0;s:6:\"2.4.18\";i:1;s:6:\"2.4.17\";i:2;s:6:\"2.4.16\";i:3;s:6:\"2.4.15\";i:4;s:8:\"2.4.14.1\";i:5;s:6:\"2.4.14\";i:6;s:6:\"2.4.13\";i:7;s:6:\"2.4.12\";i:8;s:8:\"2.4.11.2\";i:9;s:8:\"2.4.11.1\";i:10;s:6:\"2.4.11\";i:11;s:6:\"2.4.10\";i:12;s:7:\"2.4.9.1\";i:13;s:5:\"2.4.9\";i:14;s:7:\"2.4.8.1\";i:15;s:5:\"2.4.8\";i:16;s:7:\"2.4.7.1\";i:17;s:5:\"2.4.7\";i:18;s:5:\"2.4.6\";i:19;s:5:\"2.4.5\";i:20;s:5:\"2.4.4\";i:21;s:5:\"2.4.3\";i:22;s:5:\"2.4.2\";i:23;s:5:\"2.4.1\";i:24;s:5:\"2.4.0\";i:25;s:5:\"2.3.0\";i:26;s:5:\"2.2.4\";i:27;s:5:\"2.2.3\";i:28;s:5:\"2.2.2\";i:29;s:5:\"2.2.1\";i:30;s:5:\"2.2.0\";i:31;s:5:\"2.1.7\";i:32;s:5:\"2.1.6\";i:33;s:5:\"2.1.5\";i:34;s:5:\"2.1.4\";i:35;s:5:\"2.1.3\";i:36;s:5:\"2.1.2\";i:37;s:5:\"2.1.1\";i:38;s:5:\"2.1.0\";i:39;s:5:\"2.0.9\";i:40;s:5:\"2.0.8\";i:41;s:5:\"2.0.7\";i:42;s:5:\"2.0.6\";i:43;s:5:\"2.0.5\";i:44;s:5:\"2.0.4\";i:45;s:5:\"2.0.3\";i:46;s:6:\"1.5.15\";}}i:4;a:9:{s:4:\"name\";s:7:\"JetBlog\";s:4:\"slug\";s:21:\"jet-blog/jet-blog.php\";s:7:\"version\";s:7:\"2.4.7.1\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblog.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblog.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-blog/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetblog/\";s:4:\"desc\";s:26:\"Create engaging blog pages\";s:8:\"versions\";a:36:{i:0;s:7:\"2.4.7.1\";i:1;s:5:\"2.4.7\";i:2;s:5:\"2.4.6\";i:3;s:7:\"2.4.5.1\";i:4;s:5:\"2.4.5\";i:5;s:7:\"2.4.4.1\";i:6;s:5:\"2.4.4\";i:7;s:7:\"2.4.3.1\";i:8;s:5:\"2.4.3\";i:9;s:7:\"2.4.2.1\";i:10;s:5:\"2.4.2\";i:11;s:5:\"2.4.1\";i:12;s:5:\"2.4.0\";i:13;s:7:\"2.3.8.1\";i:14;s:5:\"2.3.8\";i:15;s:7:\"2.3.7.1\";i:16;s:5:\"2.3.7\";i:17;s:5:\"2.3.6\";i:18;s:7:\"2.3.5.1\";i:19;s:5:\"2.3.5\";i:20;s:5:\"2.3.4\";i:21;s:5:\"2.3.3\";i:22;s:5:\"2.3.2\";i:23;s:5:\"2.3.1\";i:24;s:5:\"2.3.0\";i:25;s:6:\"2.2.17\";i:26;s:6:\"2.2.16\";i:27;s:6:\"2.2.15\";i:28;s:6:\"2.2.14\";i:29;s:6:\"2.2.13\";i:30;s:6:\"2.2.12\";i:31;s:6:\"2.2.11\";i:32;s:6:\"2.2.10\";i:33;s:5:\"2.2.9\";i:34;s:5:\"2.2.8\";i:35;s:5:\"2.2.7\";}}i:5;a:9:{s:4:\"name\";s:9:\"JetBlocks\";s:4:\"slug\";s:25:\"jet-blocks/jet-blocks.php\";s:7:\"version\";s:6:\"1.3.22\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblocks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblocks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jetblocks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetblocks/\";s:4:\"desc\";s:30:\"Enrich header & footer content\";s:8:\"versions\";a:39:{i:0;s:6:\"1.3.22\";i:1;s:6:\"1.3.21\";i:2;s:8:\"1.3.20.1\";i:3;s:6:\"1.3.20\";i:4;s:8:\"1.3.19.1\";i:5;s:6:\"1.3.19\";i:6;s:6:\"1.3.18\";i:7;s:6:\"1.3.17\";i:8;s:8:\"1.3.16.1\";i:9;s:6:\"1.3.16\";i:10;s:6:\"1.3.15\";i:11;s:6:\"1.3.14\";i:12;s:6:\"1.3.13\";i:13;s:8:\"1.3.12.1\";i:14;s:6:\"1.3.12\";i:15;s:6:\"1.3.11\";i:16;s:6:\"1.3.10\";i:17;s:5:\"1.3.9\";i:18;s:7:\"1.3.8.2\";i:19;s:7:\"1.3.8.1\";i:20;s:5:\"1.3.8\";i:21;s:5:\"1.3.7\";i:22;s:5:\"1.3.6\";i:23;s:5:\"1.3.5\";i:24;s:5:\"1.3.4\";i:25;s:5:\"1.3.3\";i:26;s:5:\"1.3.2\";i:27;s:5:\"1.3.1\";i:28;s:5:\"1.3.0\";i:29;s:6:\"1.2.10\";i:30;s:5:\"1.2.9\";i:31;s:5:\"1.2.8\";i:32;s:5:\"1.2.7\";i:33;s:5:\"1.2.6\";i:34;s:5:\"1.2.5\";i:35;s:5:\"1.2.4\";i:36;s:5:\"1.2.3\";i:37;s:5:\"1.2.2\";i:38;s:5:\"1.2.1\";}}i:6;a:9:{s:4:\"name\";s:9:\"JetTricks\";s:4:\"slug\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"version\";s:5:\"1.5.9\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jettricks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettricks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jettricks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jettricks/\";s:4:\"desc\";s:30:\"Add interactive visual effects\";s:8:\"versions\";a:42:{i:0;s:5:\"1.5.9\";i:1;s:5:\"1.5.8\";i:2;s:5:\"1.5.7\";i:3;s:5:\"1.5.6\";i:4;s:7:\"1.5.5.1\";i:5;s:5:\"1.5.5\";i:6;s:7:\"1.5.4.2\";i:7;s:7:\"1.5.4.1\";i:8;s:5:\"1.5.4\";i:9;s:5:\"1.5.3\";i:10;s:5:\"1.5.2\";i:11;s:7:\"1.5.1.1\";i:12;s:5:\"1.5.1\";i:13;s:5:\"1.5.0\";i:14;s:6:\"1.4.10\";i:15;s:5:\"1.4.9\";i:16;s:5:\"1.4.8\";i:17;s:5:\"1.4.7\";i:18;s:7:\"1.4.6.2\";i:19;s:7:\"1.4.6.1\";i:20;s:5:\"1.4.6\";i:21;s:5:\"1.4.5\";i:22;s:5:\"1.4.4\";i:23;s:5:\"1.4.3\";i:24;s:5:\"1.4.2\";i:25;s:5:\"1.4.1\";i:26;s:5:\"1.4.0\";i:27;s:5:\"1.3.9\";i:28;s:5:\"1.3.8\";i:29;s:5:\"1.3.7\";i:30;s:5:\"1.3.5\";i:31;s:5:\"1.3.4\";i:32;s:5:\"1.3.3\";i:33;s:5:\"1.3.2\";i:34;s:5:\"1.3.1\";i:35;s:5:\"1.3.0\";i:36;s:6:\"1.2.12\";i:37;s:6:\"1.2.11\";i:38;s:6:\"1.2.10\";i:39;s:5:\"1.2.9\";i:40;s:5:\"1.2.8\";i:41;s:5:\"1.2.7\";}}i:7;a:9:{s:4:\"name\";s:15:\"JetSmartFilters\";s:4:\"slug\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"version\";s:5:\"3.7.2\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsmartfilters.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsmartfilters.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetsmartfilters/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetsmartfilters/\";s:4:\"desc\";s:34:\"Advanced filters for any post type\";s:8:\"versions\";a:87:{i:0;s:5:\"3.7.2\";i:1;s:5:\"3.7.1\";i:2;s:5:\"3.7.0\";i:3;s:6:\"3.6.11\";i:4;s:6:\"3.6.10\";i:5;s:5:\"3.6.9\";i:6;s:7:\"3.6.8.2\";i:7;s:7:\"3.6.8.1\";i:8;s:5:\"3.6.8\";i:9;s:7:\"3.6.7.1\";i:10;s:5:\"3.6.7\";i:11;s:5:\"3.6.6\";i:12;s:5:\"3.6.5\";i:13;s:5:\"3.6.4\";i:14;s:7:\"3.6.3.1\";i:15;s:5:\"3.6.3\";i:16;s:5:\"3.6.2\";i:17;s:5:\"3.6.1\";i:18;s:7:\"3.6.0.1\";i:19;s:5:\"3.6.0\";i:20;s:5:\"3.5.8\";i:21;s:7:\"3.5.7.1\";i:22;s:5:\"3.5.7\";i:23;s:5:\"3.5.6\";i:24;s:5:\"3.5.5\";i:25;s:5:\"3.5.4\";i:26;s:5:\"3.5.3\";i:27;s:5:\"3.5.2\";i:28;s:5:\"3.5.1\";i:29;s:5:\"3.5.0\";i:30;s:5:\"3.4.5\";i:31;s:5:\"3.4.4\";i:32;s:5:\"3.4.3\";i:33;s:5:\"3.4.2\";i:34;s:5:\"3.4.1\";i:35;s:5:\"3.4.0\";i:36;s:5:\"3.3.2\";i:37;s:5:\"3.3.1\";i:38;s:5:\"3.3.0\";i:39;s:5:\"3.2.6\";i:40;s:5:\"3.2.5\";i:41;s:5:\"3.2.4\";i:42;s:5:\"3.2.3\";i:43;s:7:\"3.2.2.1\";i:44;s:5:\"3.2.2\";i:45;s:5:\"3.2.1\";i:46;s:5:\"3.2.0\";i:47;s:5:\"3.1.2\";i:48;s:5:\"3.1.1\";i:49;s:5:\"3.1.0\";i:50;s:5:\"3.0.4\";i:51;s:5:\"3.0.3\";i:52;s:5:\"3.0.2\";i:53;s:5:\"3.0.1\";i:54;s:5:\"3.0.0\";i:55;s:6:\"2.3.14\";i:56;s:6:\"2.3.13\";i:57;s:6:\"2.3.12\";i:58;s:6:\"2.3.11\";i:59;s:6:\"2.3.10\";i:60;s:5:\"2.3.9\";i:61;s:5:\"2.3.8\";i:62;s:5:\"2.3.7\";i:63;s:5:\"2.3.6\";i:64;s:5:\"2.3.5\";i:65;s:5:\"2.3.4\";i:66;s:5:\"2.3.3\";i:67;s:5:\"2.3.2\";i:68;s:5:\"2.3.1\";i:69;s:5:\"2.3.0\";i:70;s:5:\"2.2.3\";i:71;s:5:\"2.2.2\";i:72;s:5:\"2.2.1\";i:73;s:5:\"2.2.0\";i:74;s:5:\"2.1.1\";i:75;s:5:\"2.1.0\";i:76;s:5:\"2.0.6\";i:77;s:5:\"2.0.5\";i:78;s:5:\"2.0.4\";i:79;s:5:\"2.0.3\";i:80;s:5:\"2.0.2\";i:81;s:5:\"2.0.1\";i:82;s:5:\"2.0.0\";i:83;s:5:\"1.8.4\";i:84;s:5:\"1.8.3\";i:85;s:5:\"1.8.2\";i:86;s:5:\"1.8.1\";}}i:8;a:9:{s:4:\"name\";s:8:\"JetPopup\";s:4:\"slug\";s:23:\"jet-popup/jet-popup.php\";s:7:\"version\";s:8:\"2.0.20.3\";s:5:\"thumb\";s:72:\"https://account.crocoblock.com/free-download/images/jetlogo/jetpopup.svg\";s:9:\"thumb_alt\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetpopup.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jet-popup/\";s:4:\"demo\";s:40:\"https://crocoblock.com/plugins/jetpopup/\";s:4:\"desc\";s:30:\"Create popups that boost sales\";s:8:\"versions\";a:47:{i:0;s:8:\"2.0.20.3\";i:1;s:8:\"2.0.20.2\";i:2;s:8:\"2.0.20.1\";i:3;s:6:\"2.0.20\";i:4;s:6:\"2.0.19\";i:5;s:6:\"2.0.18\";i:6;s:8:\"2.0.17.1\";i:7;s:6:\"2.0.17\";i:8;s:6:\"2.0.16\";i:9;s:8:\"2.0.15.1\";i:10;s:6:\"2.0.15\";i:11;s:8:\"2.0.14.1\";i:12;s:6:\"2.0.14\";i:13;s:6:\"2.0.13\";i:14;s:6:\"2.0.12\";i:15;s:6:\"2.0.11\";i:16;s:6:\"2.0.10\";i:17;s:5:\"2.0.9\";i:18;s:5:\"2.0.8\";i:19;s:5:\"2.0.7\";i:20;s:5:\"2.0.6\";i:21;s:5:\"2.0.5\";i:22;s:5:\"2.0.4\";i:23;s:7:\"2.0.3.1\";i:24;s:5:\"2.0.3\";i:25;s:7:\"2.0.2.1\";i:26;s:5:\"2.0.2\";i:27;s:5:\"2.0.1\";i:28;s:5:\"2.0.0\";i:29;s:5:\"1.6.5\";i:30;s:5:\"1.6.4\";i:31;s:5:\"1.6.3\";i:32;s:5:\"1.6.2\";i:33;s:5:\"1.6.1\";i:34;s:5:\"1.6.0\";i:35;s:5:\"1.5.6\";i:36;s:5:\"1.5.5\";i:37;s:5:\"1.5.4\";i:38;s:5:\"1.5.3\";i:39;s:5:\"1.5.2\";i:40;s:5:\"1.5.1\";i:41;s:5:\"1.5.0\";i:42;s:5:\"1.4.2\";i:43;s:5:\"1.4.1\";i:44;s:5:\"1.4.0\";i:45;s:5:\"1.3.1\";i:46;s:5:\"1.3.0\";}}i:9;a:9:{s:4:\"name\";s:9:\"JetSearch\";s:4:\"slug\";s:25:\"jet-search/jet-search.php\";s:7:\"version\";s:8:\"3.5.16.1\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsearch.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsearch.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-search/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetsearch/\";s:4:\"desc\";s:27:\"Try the fastest AJAX search\";s:8:\"versions\";a:59:{i:0;s:8:\"3.5.16.1\";i:1;s:6:\"3.5.16\";i:2;s:6:\"3.5.15\";i:3;s:6:\"3.5.14\";i:4;s:6:\"3.5.13\";i:5;s:6:\"3.5.12\";i:6;s:6:\"3.5.11\";i:7;s:8:\"3.5.10.1\";i:8;s:6:\"3.5.10\";i:9;s:5:\"3.5.9\";i:10;s:5:\"3.5.8\";i:11;s:7:\"3.5.7.1\";i:12;s:5:\"3.5.7\";i:13;s:5:\"3.5.6\";i:14;s:7:\"3.5.5.1\";i:15;s:5:\"3.5.5\";i:16;s:5:\"3.5.4\";i:17;s:5:\"3.5.3\";i:18;s:7:\"3.5.2.1\";i:19;s:5:\"3.5.2\";i:20;s:5:\"3.5.1\";i:21;s:5:\"3.5.0\";i:22;s:5:\"3.4.4\";i:23;s:5:\"3.4.3\";i:24;s:5:\"3.4.2\";i:25;s:5:\"3.4.1\";i:26;s:5:\"3.4.0\";i:27;s:5:\"3.3.2\";i:28;s:5:\"3.3.1\";i:29;s:5:\"3.3.0\";i:30;s:5:\"3.2.3\";i:31;s:5:\"3.2.2\";i:32;s:5:\"3.2.1\";i:33;s:7:\"3.2.0.1\";i:34;s:5:\"3.2.0\";i:35;s:7:\"3.1.3.1\";i:36;s:5:\"3.1.3\";i:37;s:7:\"3.1.2.1\";i:38;s:5:\"3.1.2\";i:39;s:5:\"3.1.1\";i:40;s:5:\"3.1.0\";i:41;s:5:\"3.0.3\";i:42;s:5:\"3.0.2\";i:43;s:5:\"3.0.1\";i:44;s:5:\"3.0.0\";i:45;s:6:\"2.1.17\";i:46;s:6:\"2.1.16\";i:47;s:6:\"2.1.15\";i:48;s:6:\"2.1.14\";i:49;s:6:\"2.1.13\";i:50;s:6:\"2.1.12\";i:51;s:6:\"2.1.11\";i:52;s:6:\"2.1.10\";i:53;s:5:\"2.1.9\";i:54;s:5:\"2.1.8\";i:55;s:5:\"2.1.7\";i:56;s:5:\"2.1.6\";i:57;s:5:\"2.1.5\";i:58;s:5:\"2.1.4\";}}i:10;a:9:{s:4:\"name\";s:13:\"JetWooBuilder\";s:4:\"slug\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"version\";s:5:\"2.2.3\";s:5:\"thumb\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoobuilder.svg\";s:9:\"thumb_alt\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetwoobuilder.svg\";s:4:\"docs\";s:69:\"https://crocoblock.com/knowledge-base/article-category/jetwoobuilder/\";s:4:\"demo\";s:45:\"https://crocoblock.com/plugins/jetwoobuilder/\";s:4:\"desc\";s:30:\"Create custom e-commerce pages\";s:8:\"versions\";a:79:{i:0;s:5:\"2.2.3\";i:1;s:5:\"2.2.2\";i:2;s:7:\"2.2.1.1\";i:3;s:5:\"2.2.1\";i:4;s:5:\"2.2.0\";i:5;s:8:\"2.1.20.1\";i:6;s:6:\"2.1.20\";i:7;s:6:\"2.1.19\";i:8;s:8:\"2.1.18.1\";i:9;s:6:\"2.1.18\";i:10;s:6:\"2.1.17\";i:11;s:8:\"2.1.16.1\";i:12;s:6:\"2.1.16\";i:13;s:6:\"2.1.15\";i:14;s:6:\"2.1.14\";i:15;s:6:\"2.1.13\";i:16;s:6:\"2.1.12\";i:17;s:6:\"2.1.11\";i:18;s:6:\"2.1.10\";i:19;s:5:\"2.1.9\";i:20;s:5:\"2.1.8\";i:21;s:7:\"2.1.7.3\";i:22;s:7:\"2.1.7.2\";i:23;s:7:\"2.1.7.1\";i:24;s:5:\"2.1.7\";i:25;s:7:\"2.1.6.1\";i:26;s:5:\"2.1.6\";i:27;s:5:\"2.1.5\";i:28;s:5:\"2.1.4\";i:29;s:5:\"2.1.3\";i:30;s:7:\"2.1.2.1\";i:31;s:5:\"2.1.2\";i:32;s:5:\"2.1.1\";i:33;s:5:\"2.1.0\";i:34;s:5:\"2.0.5\";i:35;s:5:\"2.0.4\";i:36;s:5:\"2.0.3\";i:37;s:5:\"2.0.2\";i:38;s:5:\"2.0.1\";i:39;s:5:\"2.0.0\";i:40;s:6:\"1.12.4\";i:41;s:6:\"1.12.3\";i:42;s:6:\"1.12.2\";i:43;s:6:\"1.12.1\";i:44;s:6:\"1.12.0\";i:45;s:6:\"1.11.4\";i:46;s:6:\"1.11.3\";i:47;s:6:\"1.11.2\";i:48;s:6:\"1.11.1\";i:49;s:6:\"1.11.0\";i:50;s:6:\"1.10.5\";i:51;s:6:\"1.10.4\";i:52;s:6:\"1.10.3\";i:53;s:6:\"1.10.2\";i:54;s:6:\"1.10.1\";i:55;s:6:\"1.10.0\";i:56;s:5:\"1.9.2\";i:57;s:5:\"1.9.1\";i:58;s:5:\"1.9.0\";i:59;s:5:\"1.8.2\";i:60;s:5:\"1.8.1\";i:61;s:5:\"1.8.0\";i:62;s:6:\"1.7.12\";i:63;s:6:\"1.7.11\";i:64;s:6:\"1.7.10\";i:65;s:5:\"1.7.9\";i:66;s:5:\"1.7.8\";i:67;s:5:\"1.7.7\";i:68;s:5:\"1.7.6\";i:69;s:5:\"1.7.5\";i:70;s:5:\"1.7.4\";i:71;s:5:\"1.7.3\";i:72;s:5:\"1.7.2\";i:73;s:5:\"1.7.1\";i:74;s:5:\"1.7.0\";i:75;s:5:\"1.6.6\";i:76;s:5:\"1.6.5\";i:77;s:5:\"1.6.4\";i:78;s:5:\"1.6.3\";}}i:11;a:9:{s:4:\"name\";s:17:\"JetProductGallery\";s:4:\"slug\";s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";s:7:\"version\";s:5:\"2.2.4\";s:5:\"thumb\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo/jetproductgallery.svg\";s:9:\"thumb_alt\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetproductgallery.svg\";s:4:\"docs\";s:73:\"https://crocoblock.com/knowledge-base/article-category/jetproductgallery/\";s:4:\"demo\";s:49:\"https://crocoblock.com/plugins/jetproductgallery/\";s:4:\"desc\";s:38:\"Product gallery sliders and carousels \";s:8:\"versions\";a:54:{i:0;s:5:\"2.2.4\";i:1;s:5:\"2.2.3\";i:2;s:5:\"2.2.2\";i:3;s:5:\"2.2.1\";i:4;s:7:\"2.2.0.3\";i:5;s:7:\"2.2.0.2\";i:6;s:7:\"2.2.0.1\";i:7;s:5:\"2.2.0\";i:8;s:8:\"2.1.22.1\";i:9;s:6:\"2.1.22\";i:10;s:8:\"2.1.21.1\";i:11;s:6:\"2.1.21\";i:12;s:6:\"2.1.20\";i:13;s:6:\"2.1.19\";i:14;s:6:\"2.1.18\";i:15;s:6:\"2.1.17\";i:16;s:6:\"2.1.16\";i:17;s:6:\"2.1.15\";i:18;s:6:\"2.1.14\";i:19;s:8:\"2.1.13.2\";i:20;s:8:\"2.1.13.1\";i:21;s:6:\"2.1.13\";i:22;s:6:\"2.1.12\";i:23;s:6:\"2.1.11\";i:24;s:6:\"2.1.10\";i:25;s:5:\"2.1.9\";i:26;s:5:\"2.1.8\";i:27;s:5:\"2.1.7\";i:28;s:5:\"2.1.6\";i:29;s:5:\"2.1.5\";i:30;s:5:\"2.1.4\";i:31;s:5:\"2.1.3\";i:32;s:5:\"2.1.2\";i:33;s:5:\"2.1.1\";i:34;s:5:\"2.1.0\";i:35;s:5:\"2.0.5\";i:36;s:5:\"2.0.4\";i:37;s:5:\"2.0.3\";i:38;s:5:\"2.0.2\";i:39;s:5:\"2.0.1\";i:40;s:5:\"2.0.0\";i:41;s:5:\"1.3.1\";i:42;s:5:\"1.3.0\";i:43;s:5:\"1.2.3\";i:44;s:5:\"1.2.2\";i:45;s:5:\"1.2.1\";i:46;s:5:\"1.2.0\";i:47;s:5:\"1.1.9\";i:48;s:5:\"1.1.8\";i:49;s:5:\"1.1.7\";i:50;s:5:\"1.1.6\";i:51;s:5:\"1.1.5\";i:52;s:5:\"1.1.4\";i:53;s:5:\"1.1.3\";}}i:12;a:9:{s:4:\"name\";s:19:\"JetCompare&Wishlist\";s:4:\"slug\";s:31:\"jet-compare-wishlist/jet-cw.php\";s:7:\"version\";s:8:\"1.5.12.2\";s:5:\"thumb\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoocomparewishlist.svg\";s:9:\"thumb_alt\";s:86:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetcomparewishlist.svg\";s:4:\"docs\";s:74:\"https://crocoblock.com/knowledge-base/article-category/jetcomparewishlist/\";s:4:\"demo\";s:50:\"https://crocoblock.com/plugins/jetcomparewishlist/\";s:4:\"desc\";s:34:\"Compare and wishlist functionality\";s:8:\"versions\";a:41:{i:0;s:8:\"1.5.12.2\";i:1;s:8:\"1.5.12.1\";i:2;s:6:\"1.5.12\";i:3;s:6:\"1.5.11\";i:4;s:8:\"1.5.10.1\";i:5;s:6:\"1.5.10\";i:6;s:5:\"1.5.9\";i:7;s:7:\"1.5.8.1\";i:8;s:5:\"1.5.8\";i:9;s:5:\"1.5.7\";i:10;s:5:\"1.5.6\";i:11;s:7:\"1.5.5.2\";i:12;s:7:\"1.5.5.1\";i:13;s:5:\"1.5.5\";i:14;s:5:\"1.5.4\";i:15;s:5:\"1.5.3\";i:16;s:5:\"1.5.2\";i:17;s:5:\"1.5.1\";i:18;s:5:\"1.5.0\";i:19;s:5:\"1.4.7\";i:20;s:5:\"1.4.6\";i:21;s:5:\"1.4.5\";i:22;s:5:\"1.4.4\";i:23;s:5:\"1.4.3\";i:24;s:5:\"1.4.2\";i:25;s:5:\"1.4.1\";i:26;s:5:\"1.4.0\";i:27;s:5:\"1.3.5\";i:28;s:5:\"1.3.4\";i:29;s:5:\"1.3.3\";i:30;s:5:\"1.3.2\";i:31;s:5:\"1.3.1\";i:32;s:5:\"1.3.0\";i:33;s:5:\"1.2.4\";i:34;s:5:\"1.2.3\";i:35;s:5:\"1.2.2\";i:36;s:5:\"1.2.1\";i:37;s:5:\"1.2.0\";i:38;s:5:\"1.1.2\";i:39;s:5:\"1.1.1\";i:40;s:5:\"1.1.0\";}}i:13;a:9:{s:4:\"name\";s:9:\"JetEngine\";s:4:\"slug\";s:25:\"jet-engine/jet-engine.php\";s:7:\"version\";s:5:\"3.8.2\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetengine.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetengine.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-engine/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetengine/\";s:4:\"desc\";s:36:\"Top-notch plugin for dynamic content\";s:8:\"versions\";a:157:{i:0;s:5:\"3.8.2\";i:1;s:7:\"3.8.1.2\";i:2;s:7:\"3.8.1.1\";i:3;s:5:\"3.8.1\";i:4;s:5:\"3.8.0\";i:5;s:8:\"3.7.10.1\";i:6;s:6:\"3.7.10\";i:7;s:7:\"3.7.9.1\";i:8;s:5:\"3.7.9\";i:9;s:5:\"3.7.8\";i:10;s:5:\"3.7.7\";i:11;s:5:\"3.7.6\";i:12;s:5:\"3.7.5\";i:13;s:5:\"3.7.4\";i:14;s:5:\"3.7.3\";i:15;s:5:\"3.7.2\";i:16;s:7:\"3.7.1.2\";i:17;s:7:\"3.7.1.1\";i:18;s:5:\"3.7.1\";i:19;s:5:\"3.7.0\";i:20;s:5:\"3.6.9\";i:21;s:5:\"3.6.8\";i:22;s:7:\"3.6.7.1\";i:23;s:5:\"3.6.7\";i:24;s:7:\"3.6.6.1\";i:25;s:5:\"3.6.6\";i:26;s:5:\"3.6.5\";i:27;s:7:\"3.6.4.1\";i:28;s:5:\"3.6.4\";i:29;s:5:\"3.6.3\";i:30;s:5:\"3.6.2\";i:31;s:7:\"3.6.1.2\";i:32;s:7:\"3.6.1.1\";i:33;s:5:\"3.6.1\";i:34;s:7:\"3.6.0.1\";i:35;s:5:\"3.6.0\";i:36;s:5:\"3.5.8\";i:37;s:5:\"3.5.7\";i:38;s:5:\"3.5.6\";i:39;s:5:\"3.5.5\";i:40;s:5:\"3.5.4\";i:41;s:5:\"3.5.3\";i:42;s:5:\"3.5.2\";i:43;s:5:\"3.5.1\";i:44;s:5:\"3.5.0\";i:45;s:5:\"3.4.6\";i:46;s:5:\"3.4.5\";i:47;s:5:\"3.4.4\";i:48;s:5:\"3.4.3\";i:49;s:5:\"3.4.2\";i:50;s:5:\"3.4.1\";i:51;s:5:\"3.4.0\";i:52;s:5:\"3.3.6\";i:53;s:5:\"3.3.5\";i:54;s:5:\"3.3.4\";i:55;s:5:\"3.3.3\";i:56;s:7:\"3.3.2.1\";i:57;s:5:\"3.3.2\";i:58;s:5:\"3.3.1\";i:59;s:7:\"3.3.0.1\";i:60;s:5:\"3.3.0\";i:61;s:5:\"3.2.7\";i:62;s:5:\"3.2.6\";i:63;s:7:\"3.2.5.2\";i:64;s:7:\"3.2.5.1\";i:65;s:5:\"3.2.5\";i:66;s:5:\"3.2.4\";i:67;s:7:\"3.2.3.2\";i:68;s:7:\"3.2.3.1\";i:69;s:5:\"3.2.3\";i:70;s:5:\"3.2.2\";i:71;s:5:\"3.2.1\";i:72;s:5:\"3.2.0\";i:73;s:7:\"3.1.6.1\";i:74;s:5:\"3.1.6\";i:75;s:5:\"3.1.5\";i:76;s:5:\"3.1.4\";i:77;s:7:\"3.1.3.1\";i:78;s:5:\"3.1.3\";i:79;s:5:\"3.1.2\";i:80;s:5:\"3.1.1\";i:81;s:5:\"3.1.0\";i:82;s:7:\"3.0.9.1\";i:83;s:5:\"3.0.9\";i:84;s:5:\"3.0.8\";i:85;s:5:\"3.0.7\";i:86;s:7:\"3.0.6.1\";i:87;s:5:\"3.0.6\";i:88;s:5:\"3.0.5\";i:89;s:5:\"3.0.4\";i:90;s:7:\"3.0.3.1\";i:91;s:5:\"3.0.3\";i:92;s:5:\"3.0.2\";i:93;s:5:\"3.0.1\";i:94;s:5:\"3.0.0\";i:95;s:7:\"2.11.11\";i:96;s:7:\"2.11.10\";i:97;s:6:\"2.11.9\";i:98;s:6:\"2.11.8\";i:99;s:6:\"2.11.7\";i:100;s:6:\"2.11.6\";i:101;s:6:\"2.11.5\";i:102;s:6:\"2.11.4\";i:103;s:6:\"2.11.3\";i:104;s:6:\"2.11.2\";i:105;s:6:\"2.11.1\";i:106;s:6:\"2.11.0\";i:107;s:6:\"2.10.3\";i:108;s:6:\"2.10.2\";i:109;s:6:\"2.10.1\";i:110;s:6:\"2.10.0\";i:111;s:5:\"2.9.4\";i:112;s:5:\"2.9.3\";i:113;s:5:\"2.9.2\";i:114;s:5:\"2.9.1\";i:115;s:5:\"2.9.0\";i:116;s:6:\"2.8.10\";i:117;s:5:\"2.8.9\";i:118;s:5:\"2.8.8\";i:119;s:5:\"2.8.7\";i:120;s:5:\"2.8.6\";i:121;s:5:\"2.8.5\";i:122;s:5:\"2.8.4\";i:123;s:5:\"2.8.3\";i:124;s:5:\"2.8.2\";i:125;s:5:\"2.8.1\";i:126;s:5:\"2.8.0\";i:127;s:5:\"2.7.8\";i:128;s:5:\"2.7.7\";i:129;s:5:\"2.7.6\";i:130;s:5:\"2.7.5\";i:131;s:5:\"2.7.4\";i:132;s:5:\"2.7.3\";i:133;s:5:\"2.7.2\";i:134;s:5:\"2.7.1\";i:135;s:5:\"2.7.0\";i:136;s:5:\"2.6.4\";i:137;s:5:\"2.6.3\";i:138;s:5:\"2.6.2\";i:139;s:5:\"2.6.1\";i:140;s:5:\"2.6.0\";i:141;s:5:\"2.5.6\";i:142;s:5:\"2.5.5\";i:143;s:5:\"2.5.4\";i:144;s:5:\"2.5.3\";i:145;s:5:\"2.5.2\";i:146;s:5:\"2.5.1\";i:147;s:5:\"2.5.0\";i:148;s:6:\"2.4.13\";i:149;s:6:\"2.4.12\";i:150;s:6:\"2.4.11\";i:151;s:6:\"2.4.10\";i:152;s:5:\"2.4.9\";i:153;s:5:\"2.4.8\";i:154;s:5:\"2.4.6\";i:155;s:5:\"2.4.5\";i:156;s:5:\"2.4.4\";}}i:14;a:9:{s:4:\"name\";s:10:\"JetBooking\";s:4:\"slug\";s:27:\"jet-booking/jet-booking.php\";s:7:\"version\";s:5:\"3.8.5\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetbooking.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetbooking.svg\";s:4:\"docs\";s:57:\"https://crocoblock.com/knowledge-base/plugins/jetbooking/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetbooking/\";s:4:\"desc\";s:29:\"Complex booking functionality\";s:8:\"versions\";a:71:{i:0;s:5:\"3.8.5\";i:1;s:5:\"3.8.4\";i:2;s:5:\"3.8.3\";i:3;s:5:\"3.8.2\";i:4;s:5:\"3.8.1\";i:5;s:5:\"3.8.0\";i:6;s:5:\"3.7.3\";i:7;s:5:\"3.7.2\";i:8;s:7:\"3.7.1.1\";i:9;s:5:\"3.7.1\";i:10;s:5:\"3.7.0\";i:11;s:5:\"3.6.5\";i:12;s:5:\"3.6.4\";i:13;s:5:\"3.6.3\";i:14;s:5:\"3.6.2\";i:15;s:5:\"3.6.1\";i:16;s:7:\"3.6.0.1\";i:17;s:5:\"3.6.0\";i:18;s:5:\"3.5.2\";i:19;s:5:\"3.5.1\";i:20;s:5:\"3.5.0\";i:21;s:5:\"3.4.1\";i:22;s:5:\"3.4.0\";i:23;s:5:\"3.3.2\";i:24;s:5:\"3.3.1\";i:25;s:5:\"3.3.0\";i:26;s:5:\"3.2.2\";i:27;s:5:\"3.2.1\";i:28;s:5:\"3.2.0\";i:29;s:5:\"3.1.1\";i:30;s:5:\"3.1.0\";i:31;s:5:\"3.0.2\";i:32;s:5:\"3.0.1\";i:33;s:5:\"3.0.0\";i:34;s:5:\"2.8.0\";i:35;s:5:\"2.7.2\";i:36;s:5:\"2.7.1\";i:37;s:5:\"2.7.0\";i:38;s:5:\"2.6.3\";i:39;s:5:\"2.6.2\";i:40;s:7:\"2.6.1.1\";i:41;s:5:\"2.6.1\";i:42;s:5:\"2.6.0\";i:43;s:5:\"2.5.5\";i:44;s:5:\"2.5.4\";i:45;s:5:\"2.5.3\";i:46;s:5:\"2.5.2\";i:47;s:5:\"2.5.1\";i:48;s:5:\"2.5.0\";i:49;s:5:\"2.4.6\";i:50;s:5:\"2.4.5\";i:51;s:5:\"2.4.4\";i:52;s:5:\"2.4.3\";i:53;s:5:\"2.4.2\";i:54;s:5:\"2.4.1\";i:55;s:5:\"2.4.0\";i:56;s:5:\"2.3.5\";i:57;s:5:\"2.3.4\";i:58;s:5:\"2.3.3\";i:59;s:5:\"2.3.2\";i:60;s:5:\"2.3.1\";i:61;s:5:\"2.3.0\";i:62;s:5:\"2.2.5\";i:63;s:5:\"2.2.4\";i:64;s:5:\"2.2.3\";i:65;s:5:\"2.2.1\";i:66;s:5:\"2.2.0\";i:67;s:5:\"2.1.1\";i:68;s:5:\"2.1.0\";i:69;s:5:\"2.0.2\";i:70;s:5:\"2.0.1\";}}i:15;a:9:{s:4:\"name\";s:15:\"JetStyleManager\";s:4:\"slug\";s:39:\"jet-style-manager/jet-style-manager.php\";s:7:\"version\";s:5:\"1.3.5\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetstylemanager.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetstylemanager.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetstylemanager/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetstylemanager/\";s:4:\"desc\";s:36:\"Manage Elementor page style settings\";s:8:\"versions\";a:12:{i:0;s:5:\"1.3.8\";i:1;s:5:\"1.3.7\";i:2;s:5:\"1.3.2\";i:3;s:5:\"1.3.1\";i:4;s:5:\"1.2.0\";i:5;s:5:\"1.1.5\";i:6;s:5:\"1.1.4\";i:7;s:5:\"1.1.3\";i:8;s:5:\"1.1.2\";i:9;s:5:\"1.1.1\";i:10;s:5:\"1.1.0\";i:11;s:5:\"1.0.0\";}}i:16;a:9:{s:4:\"name\";s:14:\"JetAppointment\";s:4:\"slug\";s:53:\"jet-appointments-booking/jet-appointments-booking.php\";s:7:\"version\";s:5:\"2.3.0\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jet-appointment.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jet-appointment.svg\";s:4:\"docs\";s:70:\"https://crocoblock.com/knowledge-base/article-category/jetappointment/\";s:4:\"demo\";s:46:\"https://crocoblock.com/plugins/jetappointment/\";s:4:\"desc\";s:31:\"Create custom appointment forms\";s:8:\"versions\";a:55:{i:0;s:5:\"2.3.0\";i:1;s:7:\"2.2.6.1\";i:2;s:5:\"2.2.6\";i:3;s:5:\"2.2.5\";i:4;s:5:\"2.2.4\";i:5;s:5:\"2.2.3\";i:6;s:5:\"2.2.2\";i:7;s:5:\"2.2.1\";i:8;s:7:\"2.2.0.1\";i:9;s:5:\"2.2.0\";i:10;s:5:\"2.1.8\";i:11;s:5:\"2.1.7\";i:12;s:5:\"2.1.6\";i:13;s:5:\"2.1.5\";i:14;s:5:\"2.1.4\";i:15;s:5:\"2.1.3\";i:16;s:5:\"2.1.2\";i:17;s:5:\"2.1.1\";i:18;s:5:\"2.1.0\";i:19;s:5:\"2.0.7\";i:20;s:5:\"2.0.6\";i:21;s:7:\"2.0.5.1\";i:22;s:5:\"2.0.5\";i:23;s:5:\"2.0.4\";i:24;s:5:\"2.0.3\";i:25;s:5:\"2.0.2\";i:26;s:5:\"2.0.1\";i:27;s:5:\"2.0.0\";i:28;s:6:\"1.6.10\";i:29;s:5:\"1.6.9\";i:30;s:5:\"1.6.8\";i:31;s:5:\"1.6.7\";i:32;s:5:\"1.6.6\";i:33;s:5:\"1.6.5\";i:34;s:5:\"1.6.4\";i:35;s:5:\"1.6.3\";i:36;s:5:\"1.6.2\";i:37;s:5:\"1.6.1\";i:38;s:5:\"1.6.0\";i:39;s:5:\"1.5.7\";i:40;s:5:\"1.5.6\";i:41;s:5:\"1.5.5\";i:42;s:5:\"1.5.1\";i:43;s:5:\"1.5.0\";i:44;s:5:\"1.4.0\";i:45;s:5:\"1.3.3\";i:46;s:5:\"1.3.2\";i:47;s:5:\"1.3.1\";i:48;s:5:\"1.3.0\";i:49;s:5:\"1.2.2\";i:50;s:5:\"1.2.1\";i:51;s:5:\"1.2.0\";i:52;s:5:\"1.1.1\";i:53;s:5:\"1.1.0\";i:54;s:5:\"1.0.0\";}}i:17;a:9:{s:4:\"name\";s:12:\"JetThemeCore\";s:4:\"slug\";s:33:\"jet-theme-core/jet-theme-core.php\";s:7:\"version\";s:7:\"2.3.1.1\";s:5:\"thumb\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo/jetthemecore.svg\";s:9:\"thumb_alt\";s:80:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetthemecore.svg\";s:4:\"docs\";s:67:\"https://crocoblock.com/knowledge-base/article-category/theme-parts/\";s:4:\"demo\";s:44:\"https://crocoblock.com/plugins/jetthemecore/\";s:4:\"desc\";s:65:\"Most powerful plugin created to make building websites super easy\";s:8:\"versions\";a:34:{i:0;s:7:\"2.3.1.1\";i:1;s:5:\"2.3.1\";i:2;s:7:\"2.3.0.3\";i:3;s:7:\"2.3.0.2\";i:4;s:7:\"2.3.0.1\";i:5;s:5:\"2.3.0\";i:6;s:5:\"2.2.3\";i:7;s:7:\"2.2.2.1\";i:8;s:5:\"2.2.2\";i:9;s:5:\"2.2.1\";i:10;s:5:\"2.2.0\";i:11;s:5:\"2.1.3\";i:12;s:7:\"2.1.2.3\";i:13;s:7:\"2.1.2.2\";i:14;s:7:\"2.1.2.1\";i:15;s:5:\"2.1.2\";i:16;s:5:\"2.1.1\";i:17;s:5:\"2.1.0\";i:18;s:5:\"2.0.7\";i:19;s:5:\"2.0.6\";i:20;s:5:\"2.0.5\";i:21;s:5:\"2.0.4\";i:22;s:5:\"2.0.3\";i:23;s:5:\"2.0.2\";i:24;s:5:\"2.0.1\";i:25;s:5:\"2.0.0\";i:26;s:5:\"1.2.2\";i:27;s:5:\"1.2.1\";i:28;s:5:\"1.2.0\";i:29;s:6:\"1.1.25\";i:30;s:6:\"1.1.24\";i:31;s:6:\"1.1.23\";i:32;s:6:\"1.1.22\";i:33;s:6:\"1.1.21\";}}i:18;a:9:{s:4:\"name\";s:16:\"JetProductTables\";s:4:\"slug\";s:41:\"jet-product-tables/jet-product-tables.php\";s:7:\"version\";s:5:\"1.2.3\";s:5:\"thumb\";s:80:\"https://account.crocoblock.com/free-download/images/jetlogo/jetproducttables.svg\";s:9:\"thumb_alt\";s:84:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetproducttables.svg\";s:4:\"docs\";s:63:\"https://crocoblock.com/knowledge-base/plugins/jetproducttables/\";s:4:\"demo\";s:48:\"https://crocoblock.com/plugins/jetproducttables/\";s:4:\"desc\";s:55:\"Choose between different layouts and filtering options.\";s:8:\"versions\";a:9:{i:0;s:5:\"1.2.3\";i:1;s:5:\"1.2.2\";i:2;s:5:\"1.2.1\";i:3;s:7:\"1.2.0.1\";i:4;s:5:\"1.2.0\";i:5;s:5:\"1.1.2\";i:6;s:5:\"1.1.1\";i:7;s:5:\"1.1.0\";i:8;s:5:\"1.0.0\";}}}", "off");
INSERT INTO `aor_options` VALUES("308", "jet-license-data", "a:1:{s:12:\"license-list\";a:0:{}}", "auto");
INSERT INTO `aor_options` VALUES("4635", "_site_transient_timeout_jet_dashboard_license_expire_check", "1767031980", "off");
INSERT INTO `aor_options` VALUES("4636", "_site_transient_jet_dashboard_license_expire_check", "true", "off");
INSERT INTO `aor_options` VALUES("3572", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:7882;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4950;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2799;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2790;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:2175;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2158;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:2145;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1974;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1712;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1666;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1626;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1562;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1518;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1516;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1515;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1419;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1376;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1319;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1288;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1185;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1161;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:1099;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:1093;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:1092;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:1085;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1075;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1052;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:1051;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:1013;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:994;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:965;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:957;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:940;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:936;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:916;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:913;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:871;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:840;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:826;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:796;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:786;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:778;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:773;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:767;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:758;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:735;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:724;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:711;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:710;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:706;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:704;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:702;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:680;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:666;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:661;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:659;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:656;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:652;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:640;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:630;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:626;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:623;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:618;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:616;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:615;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:612;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:600;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:591;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:590;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:589;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:581;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:581;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:572;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:564;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:546;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:539;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:535;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:533;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:532;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:530;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:529;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:513;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:511;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:491;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:488;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:487;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:484;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:472;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:470;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:463;}s:7:\"chatbot\";a:3:{s:4:\"name\";s:7:\"chatbot\";s:4:\"slug\";s:7:\"chatbot\";s:5:\"count\";i:463;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:457;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:457;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:444;}s:8:\"products\";a:3:{s:4:\"name\";s:8:\"products\";s:4:\"slug\";s:8:\"products\";s:5:\"count\";i:436;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:433;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:429;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:427;}}", "off");
INSERT INTO `aor_options` VALUES("4842", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1767022138;s:8:\"response\";a:3:{s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.34.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:35:\"jetformbuilder/jet-form-builder.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/jetformbuilder\";s:4:\"slug\";s:14:\"jetformbuilder\";s:6:\"plugin\";s:35:\"jetformbuilder/jet-form-builder.php\";s:11:\"new_version\";s:5:\"3.5.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/jetformbuilder/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/jetformbuilder.3.5.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/jetformbuilder/assets/icon-256x256.png?rev=2998825\";s:2:\"1x\";s:67:\"https://ps.w.org/jetformbuilder/assets/icon-128x128.png?rev=2998825\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/jetformbuilder/assets/banner-772x250.png?rev=2998825\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.1\";s:6:\"tested\";s:5:\"6.7.4\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}}s:25:\"jet-engine/jet-engine.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:10:\"jet-engine\";s:6:\"plugin\";s:25:\"jet-engine/jet-engine.php\";s:11:\"new_version\";s:5:\"3.8.2\";s:3:\"url\";b:0;s:7:\"package\";b:0;}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:7:{s:40:\"ajax-loader-cache/ajax-loader-bymdez.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/ajax-loader-cache\";s:4:\"slug\";s:17:\"ajax-loader-cache\";s:6:\"plugin\";s:40:\"ajax-loader-cache/ajax-loader-bymdez.php\";s:11:\"new_version\";s:6:\"1.6.41\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/ajax-loader-cache/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/ajax-loader-cache.1.6.41.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/ajax-loader-cache/assets/icon-256x256.png?rev=2878464\";s:2:\"1x\";s:70:\"https://ps.w.org/ajax-loader-cache/assets/icon-128x128.png?rev=2878464\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/ajax-loader-cache/assets/banner-1544x500.jpg?rev=2878464\";s:2:\"1x\";s:72:\"https://ps.w.org/ajax-loader-cache/assets/banner-772x250.jpg?rev=2878464\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";b:0;}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:11:\"pwa/pwa.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"w.org/plugins/pwa\";s:4:\"slug\";s:3:\"pwa\";s:6:\"plugin\";s:11:\"pwa/pwa.php\";s:11:\"new_version\";s:5:\"0.8.2\";s:3:\"url\";s:34:\"https://wordpress.org/plugins/pwa/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.8.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:48:\"https://ps.w.org/pwa/assets/icon.svg?rev=1908485\";s:3:\"svg\";s:48:\"https://ps.w.org/pwa/assets/icon.svg?rev=1908485\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/pwa/assets/banner-1544x500.png?rev=2272148\";s:2:\"1x\";s:58:\"https://ps.w.org/pwa/assets/banner-772x250.png?rev=2272148\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:29:\"wp-parsidate/wp-parsidate.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wp-parsidate\";s:4:\"slug\";s:12:\"wp-parsidate\";s:6:\"plugin\";s:29:\"wp-parsidate/wp-parsidate.php\";s:11:\"new_version\";s:7:\"5.1.8.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-parsidate/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-parsidate.5.1.8.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";s:3:\"svg\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-parsidate/assets/banner-772x250.jpg?rev=2044005\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:39:\"persian-elementor/persian-elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/persian-elementor\";s:4:\"slug\";s:17:\"persian-elementor\";s:6:\"plugin\";s:39:\"persian-elementor/persian-elementor.php\";s:11:\"new_version\";s:6:\"2.7.15\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/persian-elementor/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/persian-elementor.2.7.15.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/persian-elementor/assets/icon-256x256.png?rev=3118204\";s:2:\"1x\";s:70:\"https://ps.w.org/persian-elementor/assets/icon-128x128.png?rev=3118204\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/persian-elementor/assets/banner-1544x500.png?rev=3255023\";s:2:\"1x\";s:72:\"https://ps.w.org/persian-elementor/assets/banner-772x250.png?rev=3255023\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:31:\"persian-gravity-forms/index.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:35:\"w.org/plugins/persian-gravity-forms\";s:4:\"slug\";s:21:\"persian-gravity-forms\";s:6:\"plugin\";s:31:\"persian-gravity-forms/index.php\";s:11:\"new_version\";s:5:\"3.0.1\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/persian-gravity-forms/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/persian-gravity-forms.3.0.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:74:\"https://ps.w.org/persian-gravity-forms/assets/icon-128x128.png?rev=1362341\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/persian-gravity-forms/assets/banner-772x250.png?rev=1362313\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:41:\"powerpack-elements/powerpack-elements.php\";O:8:\"stdClass\":17:{s:11:\"new_version\";b:0;s:14:\"stable_version\";b:0;s:4:\"name\";s:0:\"\";s:4:\"slug\";s:18:\"powerpack-elements\";s:3:\"url\";s:13:\"/?changelog=1\";s:12:\"last_updated\";s:19:\"0000-00-00 00:00:00\";s:8:\"homepage\";b:0;s:7:\"package\";s:162:\"https://powerpackelements.com/edd-sl/package_download/MTc2NzIxNDUxNToqKioqKioqOjA6Njc5OTU1OTI2ZTA4M2I1ZjBmNDU1ZjBiZGE4OTNlYjc6aHR0cHNALy9hbWxha29yLmF6aW5kbS5pcjow\";s:13:\"download_link\";s:162:\"https://powerpackelements.com/edd-sl/package_download/MTc2NzIxNDUxNToqKioqKioqOjA6Njc5OTU1OTI2ZTA4M2I1ZjBmNDU1ZjBiZGE4OTNlYjc6aHR0cHNALy9hbWxha29yLmF6aW5kbS5pcjow\";s:8:\"sections\";O:8:\"stdClass\":2:{s:11:\"description\";s:0:\"\";s:9:\"changelog\";s:0:\"\";}s:7:\"banners\";O:8:\"stdClass\":2:{s:4:\"high\";b:0;s:3:\"low\";b:0;}s:5:\"icons\";a:3:{s:2:\"1x\";s:94:\"https://amlakor.azindm.ir/wp-content/plugins/powerpack-elements/assets/images/icon-128x128.png\";s:2:\"2x\";s:94:\"https://amlakor.azindm.ir/wp-content/plugins/powerpack-elements/assets/images/icon-256x256.png\";s:7:\"default\";s:94:\"https://amlakor.azindm.ir/wp-content/plugins/powerpack-elements/assets/images/icon-256x256.png\";}s:11:\"description\";a:1:{i:0;s:0:\"\";}s:9:\"changelog\";a:1:{i:0;s:0:\"\";}s:6:\"plugin\";s:41:\"powerpack-elements/powerpack-elements.php\";s:2:\"id\";s:41:\"powerpack-elements/powerpack-elements.php\";s:6:\"tested\";N;}}s:7:\"checked\";a:18:{s:40:\"ajax-loader-cache/ajax-loader-bymdez.php\";s:6:\"1.6.41\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.14\";s:23:\"elementor/elementor.php\";s:6:\"3.33.4\";s:31:\"elementor-pro/elementor-pro.php\";s:6:\"3.33.2\";s:45:\"gp-populate-anything/gp-populate-anything.php\";s:13:\"1.0-beta-3.19\";s:29:\"gravityforms/gravityforms.php\";s:6:\"2.9.21\";s:29:\"gravityperks/gravityperks.php\";s:6:\"2.3.16\";s:27:\"gravityview/gravityview.php\";s:6:\"2.48.2\";s:47:\"gravityview-advanced-filter/advanced-filter.php\";s:5:\"4.3.1\";s:25:\"jet-engine/jet-engine.php\";s:5:\"3.8.1\";s:35:\"jetformbuilder/jet-form-builder.php\";s:7:\"3.5.2.1\";s:41:\"powerpack-elements/powerpack-elements.php\";s:7:\"2.12.14\";s:11:\"pwa/pwa.php\";s:5:\"0.8.2\";s:45:\"user-role-editor-pro/user-role-editor-pro.php\";s:6:\"4.64.6\";s:29:\"wp-parsidate/wp-parsidate.php\";s:7:\"5.1.8.2\";s:57:\"gravityformsadvancedpostcreation/advancedpostcreation.php\";s:5:\"1.4.0\";s:39:\"persian-elementor/persian-elementor.php\";s:6:\"2.7.15\";s:31:\"persian-gravity-forms/index.php\";s:5:\"3.0.1\";}}", "off");
INSERT INTO `aor_options` VALUES("190", "_site_transient_wp_plugin_dependencies_plugin_data", "a:1:{s:9:\"elementor\";a:35:{s:4:\"name\";s:84:\"وب‌سایت ساز المنتور &#8211; فراتر از یک صفحه‌ساز\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.34.0\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6088;i:4;i:218;i:3;i:110;i:2;i:106;i:1;i:636;}s:11:\"num_ratings\";i:7158;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:109;s:24:\"support_threads_resolved\";i:90;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:22:\"2025-12-22 12:28pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:26297:\"<p><iframe loading=\"lazy\" title=\"Elementor - The Leading Platform for Web Creators\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/le72grP_Q6k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>عنوان</strong>. عنوان‌های چشم نواز را اضافه کنید.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>نماد</strong>. یک یا چند نماد از بیش از ۶۰۰ نماد را در دسترس قرار دهید.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>فهرست نماد</strong>. از هر نمادی برای ایجاد یک لیست گلوله استفاده کنید.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>نوار پیشرفت</strong>. شامل یک نوار پیشرفت در حال افزایش است.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>جمع‌کننده</strong>. از جمع‌کننده برای پنهان کردن یا نمایش محتوا، مانند پرسش‌های متداول، استفاده کنید.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>هشدار</strong>. یک جعبه هشدار رنگی برای جلب توجه بازدیدکنندگان قرار دهید.</li>\n<li><strong>HTML</strong>. کد را در برگه وارد کنید.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>لنگر فهرست</strong>. هر منو را به این لنگر پیوند دهید.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>نقشه‌های گوگل</strong>. نقشه‌ها را در برگه جاسازی کنید.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>تقسیم‌کننده</strong>. مطالب را با یک تقسیم‌کننده طراحی شده جدا کنید.</li>\n<li><strong>فاصله‌گذار</strong>. فاصله بین عناصر اضافه کنید..</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>و شمارش&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>مگا منو</strong>: منوهای پیشرفته را برای پیمایش بهتر و نمایش محتوای پیچیده سفارشی کنید.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 به یک جامعه جهانی بپیوندید.</h4>\n<p>به جامعه جهانی‌ای بپیوندید که به یکدیگر کمک می‌کند تا به اهداف خود دست یابند.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href=\"https://go.elementor.com/wp-repo-description-tab-youtube-channel/\" rel=\"nofollow ugc\">YouTube Channel</a>.</li>\n<li>Access our <a href=\"https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/\" rel=\"nofollow ugc\">Academy</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-help-center/\" rel=\"nofollow ugc\">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/\" rel=\"nofollow ugc\">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/\" rel=\"nofollow ugc\">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1959:\"<h4>حداقل نیازمندی‌ها</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP نسخه ۷.۴ یا بالاتر</li>\n<li>MySQL نسخه 5.0 یا بالاتر</li>\n</ul>\n<h4>الزامات توصیه شده</h4>\n<ul>\n<li>PHP نسخه 8.1 یا بالاتر</li>\n<li>MySQL نسخه 5.6 یا بالاتر</li>\n<li>محدودیت حافظه وردپرس ۶۴ مگابایت یا بیشتر (۱۲۸ مگابایت یا بالاتر ترجیح داده می‌شود)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>فرایند نصب</h4>\n<ol>\n<li>با استفاده از نصب‌کننده افزونه داخلی وردپرس نصب کنید، یا فایل فشرده را استخراج کنید و محتویات را در <code>wp-content/plugins/</code> پوشه نصب وردپرس خود رها کنید.</li>\n<li>افزونه را از طریق فهرست &#8216;افزونه‌ها&#8217; در وردپرس فعال کنید.</li>\n<li>برو به برگه‌ها &gt; افزودن جدید</li>\n<li>دکمه &#8216;ویرایش با المنتور&#8217; را فشار دهید.</li>\n<li>اکنون می‌توانید ابزارک‌ها را از پانل سمت چپ به قسمت محتوا بکشید و رها کنید، همچنین بخش‌ها و ستون‌های جدیدی را که ساختار صفحه را تشکیل می‌دهند اضافه کنید.</li>\n</ol>\n<p>برای مستندات و آموزش‌ها به <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">پایگاه دانش</a> ما مراجعه کنید.</p>\n\";s:3:\"faq\";s:7130:\"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nچگونه المنتور را نصب کنم؟\n</h4>\n<p>\n<p>برای نصب نسخه رایگان المنتور مراحل زیر را دنبال کنید:<br />\nاز داشبورد وردپرس شما -&gt; به افزونه‌ها بروید -&gt; روی «افزودن جدید» کلیک کنید -&gt; در قسمت جستجو المنتور را وارد کنید و سازنده وب‌سایت المنتور را انتخاب کنید.<br />\nنصب -&gt; پس از نصب روی فعال کردن کلیک کنید.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nآیا المنتور با تمام پوسته‌ها کار می‌کند؟\n</h4>\n<p>\n<p>المنتور با تمام پوسته‌هایی را که به استانداردهای کدنویسی وردپرس تعیین شده توسط Codex آن احترام میگذارد، کار می‌کند. پیشنهاد می‌شود از <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">پوسته سلام</a> المنتور استفاده کنید، یک بوم خالی سبک وزن ، برای لذت بردن از انعطاف‌پذیری کامل هنگام استفاده از المنتور و بهینه سازی تجربه خود.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nآیا المنتور با گوتنبرگ سازگار است؟\n</h4>\n<p>\n<p>المنتور و گوتنبرگ به طور یکپارچه با هم کار می کنند. به عنوان یک کاربر، می توانید به راحتی تصمیم بگیرید که در هر نقطه از ویرایش سایت خود از کدام ویرایشگر استفاده کنید.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nآیا می‌توانم یک فروشگاه اینترنتی ایجاد کنم؟\n</h4>\n<p>\n<p>بله، با سازنده ووکامرس المنتور پرو می توانید هر صفحه از فروشگاه خود را سفارشی کنید تا یک تجربه مشتری شگفت انگیز ایجاد کنید که باعث فروش می شود.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nآیا با سایر افزونه‌های وردپرس کار می‌کند؟\n</h4>\n<p>\n<p>تقریباً با همه افزونه ها کار می کند. اگر با مشکل ناسازگاری مواجه شدید، لطفاً آن را به ما و افزونه‌ای که با المنتور مغایرت دارد گزارش دهید.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nآیا باید بدانم چگونه کدنویسی کنم؟\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>از آنجایی که المنتور سرعت و عملکرد را در اولویت قرار می دهد، با هر نسخه جدید المنتور از عملکرد بهتر و سریع تری لذت می برید. هنگام آزمایش طرح‌بندی صفحه مشابه در نسخه‌های قدیمی‌تر، می‌توانید بهبود عملکرد قابل توجهی را مشاهده کنید، از امتیاز 82 در Google PageSpeed Insight در نسخه 3.1 به امتیاز 95 i در نسخه 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nآیا سایت من با المنتور امن است؟\n</h4>\n<p>\n<p>امنیت وب سایت شما برای ما بسیار مهم است و ما اقدامات پیشگیرانه ای را برای اطمینان از ایمن بودن وب سایت شما انجام می دهیم. المنتور دارای گواهینامه ISO 27001 است و دارای یک تیم اختصاصی از متخصصان امنیتی است که بهترین شیوه های صنعت را برای حداکثر امنیت و انطباق، 24/7 پیاده سازی می کنند.</p>\n<p>همچنین یک برنامه امنیتی مدیریت شده جایزه اشکال وجود دارد که با فعال کردن 24/7/365 شناسایی آسیب‌پذیری crowdsourced از قدرت جامعه استفاده می‌کند.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nآیا می‌توانم قالب‌ها را جداگانه بخرم؟\n</h4>\n<p>\n<p>البته می‌توانید از هر قالبی که از المنتور پشتیبانی می‌کند، استفاده کنید.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nآیا المنتور با انواع پست و پست سفارشی سازگار است؟\n</h4>\n<p>\n<p>البته! می‌توانید تعیین کنید کدام نوع پست المنتور را در صفحه تنظیمات فعال می‌کند.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nتفاوت بین افزونه رایگان المنتور و المنتور پرو چیست\n</h4>\n<p>\n<p>نسخه رایگان المنتور به شما امکان می دهد درگ انقلابی ما را کاوش کنید. ویرایشگر زنده، ویجت ها و قالب های اولیه را رها کنید.المنتور پرو (Essential، Advanced، Expert، Studio و Agency) شما را با ابزارهای حرفه ای تری توانمند می کند که گردش کار شما را سرعت می بخشد، به شما امکان دسترسی به پشتیبانی از نیروی انسانی را می دهد، به شما کمک می کند محتوای پیشرفته تری بسازید، و بازدیدکنندگان را تبدیل کنید. مقایسه کامل را اینجا ببینید.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nچگونه می‌توانم مشارکت کننده شوم\n</h4>\n<p>\n<p>اگر می‌خواهید کمک کنید، به <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">مخزن Elementor GitHub</a> ما بروید و ببینید کجا می‌توانید کمک کنید.<br />\nهمچنین می‌توانید از طریق <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a> یک زبان جدید اضافه کنید. ما یک راهنمای کوتاه ایجاد کرده‌ایم که <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">نحوه ترجمه و بومی‌سازی افزونه را توضیح می‌دهد</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:2300:\"<h4>3.34.0 &#8211; 2025-12-22</h4>\n<ul>\n<li>New: Introducing Atomic Tabs &#8211; enabling flexible and fully customizable tab layouts with nested Atomic Elements &#8211; Editor V4</li>\n<li>New: Introducing Entrance Interactions to add lightweight motion and bring elements to life as they appear &#8211; Editor V4</li>\n<li>Tweak: Replaced the legacy V3 container wrapper with the optimized V4 wrapper for improved markup &#8211; Editor V4</li>\n<li>Tweak: Improved frontend link control output to ensure consistent rendering &#8211; Editor V4 (<a href=\"https://github.com/elementor/elementor/issues/32233\" rel=\"nofollow ugc\">#32233</a>)</li>\n<li>Tweak: Added reset option inside popovers &#8211; Editor V4</li>\n<li>Tweak: Updated Border control layout for a clearer and more consistent editing workflow &#8211; Editor V4</li>\n<li>Tweak: Added <code>span</code> option inside the Paragraph atom &#8211; Editor V4</li>\n<li>Tweak: Improved transitions to better support logical properties &#8211; Editor V4</li>\n<li>Tweak: Improved dropdown folder behavior and resolved related UI issues in Template Library</li>\n<li>Tweak: Merged &#8220;Import/Export Customization&#8221; feature into the version</li>\n<li>Tweak: Added <code>builder_content_data</code> filter for extending Template Library and Global Widget content (props <a href=\"https://github.com/dgwatkins\" rel=\"nofollow ugc\">@dgwatkins</a>)</li>\n<li>Tweak: Applied CSS logical properties in Icon Box widget</li>\n<li>Tweak: Applied CSS logical properties in Icon List widget</li>\n<li>Tweak: Applied CSS logical properties in text alignment controls and fixed RTL rendering in the Editor</li>\n<li>Fix: Local Transform values overridden Class-level Transform defaults even when unchanged &#8211; Editor V4</li>\n<li>Fix: Fatal error when opening pages containing atomic elements while the V4 experiment is deactivated &#8211; Editor V4</li>\n<li>Fix: Hover Scale transform set through Class did not save correctly &#8211; Editor V4</li>\n<li>Fix: PHP 8.4 deprecation notices related to deprecated <code>E_STRICT</code> constant</li>\n<li>Fix: Missing CSS regeneration after clearing cached files on pages containing dynamic tags</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3148:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:18416:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Très bon constructeur.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/gbosbm/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/16363652899d37f0387fc9b2370595e64e3ec528054422925a25c1ce18aea8d2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/16363652899d37f0387fc9b2370595e64e3ec528054422925a25c1ce18aea8d2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/gbosbm/\" class=\"reviewer-name\">BONNET <small>(gbosbm)</small></a> در <span class=\"review-date\">دسامبر 25, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor facilite la création de site web grâce à ses nombreuses fonctions, et les personnalisations qui permettent de se distinguer des autres sites. Il offre également une prise en main intuitive, accessible aussi bien aux débutants qu’aux utilisateurs avancés</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very good overall!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/jsug34/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3b43aa50d7a26772b257dc9f78dc2d00e40c9e996a7f574d2b242385b4b67dc9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3b43aa50d7a26772b257dc9f78dc2d00e40c9e996a7f574d2b242385b4b67dc9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/jsug34/\" class=\"reviewer-name\">jsug34</a> در <span class=\"review-date\">دسامبر 23, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I’ve been using Elementor for 2 years and I’m very happy with it. It’s easy to use, creative, and helped me build the exact website I wanted. However, recent updates can be unstable. After updating to 3.34.0 yesterday, I noticed unexpected spacing/line breaks and some overlapping elements, even on layouts that were previously perfectly calibrated. Waiting for a patch before making further edits.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">One of the best page bulder.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/rakibhossainraju/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e0c45ffd18f23598c4792c9db6841064ec4a5d2f7a4970486547799b5b6574eb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e0c45ffd18f23598c4792c9db6841064ec4a5d2f7a4970486547799b5b6574eb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rakibhossainraju/\" class=\"reviewer-name\">Rakib Hossain Raju <small>(rakibhossainraju)</small></a> در <span class=\"review-date\">دسامبر 21, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I have been using this page builder for quite some time. Before that I have used other Page Builders but this one is so far the best for me. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The ecosystem is huge and the community is realy nice.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Easy to Use and Powerful Page Builder</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/deepanshigarg/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/801efa1ef614c59ea2187e22bb4cdfd9b52fc9a2041d843f6a4e673577e1489f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/801efa1ef614c59ea2187e22bb4cdfd9b52fc9a2041d843f6a4e673577e1489f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/deepanshigarg/\" class=\"reviewer-name\">deepanshigarg</a> در <span class=\"review-date\">دسامبر 19, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor Website Builder makes designing pages very easy, even for beginners. The drag-and-drop editor is smooth and intuitive, and there are many useful widgets and design options. It helped me create professional-looking pages without coding. A great choice for building and customizing WordPress websites.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Elementor 3.33.5 Update several critical front-end widgets stopped working</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/ulgo/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/dcb4ad0a1b1e2c37cb45d9f1ecca5f6e8de1885755241633afc4c6efe1a7fe8c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/dcb4ad0a1b1e2c37cb45d9f1ecca5f6e8de1885755241633afc4c6efe1a7fe8c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ulgo/\" class=\"reviewer-name\">ulgo</a> در <span class=\"review-date\">دسامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>After updating from <strong>Elementor 3.33.4 to 3.33.5</strong>, several critical front-end widgets stopped working:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>The <strong>Google Reviews / Rating widget</strong> no longer renders and disappears completely.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Custom HTML/JS widgets</strong> (e.g., small interactive tools) only display as static text blocks, and embedded JavaScript does not execute.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Rolling back to <strong>3.33.4</strong> immediately restores full functionality.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Environment:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Hosting: <strong>IONOS Managed WordPress</strong></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Elementor Pro active</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>No other changes to theme or plugins except the Elementor update.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Impact:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Essential front-end functionality is broken.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Custom tools and third-party widgets cannot be used.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>A rollback is currently the only way to keep the site operational.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Expectation:</strong><br />Please release a <strong>hotfix or patch (3.33.6 or 3.34.x)</strong> to restore compatibility for Google Reviews and allow custom HTML/JS widgets to function as before.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Love it!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/rbmueller/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/90fad29eadd72699174c29d23fa3b372f785599c71eeb418b535a1616057f10c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/90fad29eadd72699174c29d23fa3b372f785599c71eeb418b535a1616057f10c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rbmueller/\" class=\"reviewer-name\">Robin <small>(rbmueller)</small></a> در <span class=\"review-date\">دسامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Very easy to understand and powerfull. Best pagebuilder we have used so far.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The last update broke the whole site, I had to rollback</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/kris006/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9bbd3657eef146c49965f460ad4161f6f28f8788ce80dd8dde44d372fac089c2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9bbd3657eef146c49965f460ad4161f6f28f8788ce80dd8dde44d372fac089c2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/kris006/\" class=\"reviewer-name\">kris006</a> در <span class=\"review-date\">دسامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>The last update broke the whole site, I had to rollback</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Update Broke many websites</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/atx/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a2b1fdc2a78927a03ebecbb1c0b8136620422b25f65d65d18223c2f17bff034e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a2b1fdc2a78927a03ebecbb1c0b8136620422b25f65d65d18223c2f17bff034e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/atx/\" class=\"reviewer-name\">Testing Things <small>(AtX)</small></a> در <span class=\"review-date\">دسامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'m sorry but a popular plugin like this one should never break websites. This happened to many people during the last update which doesn\'t make us feel comfortable using it... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>And that is not the first time by the way... My website broke at least three times during the past years, and not because of a misconfiguration or another plugin, but because of an automated Elementor update overnight.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This time the woocommerce login and account pages were impacted</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">VERSION 3.33.5 BROKE THE TEXT EDITOR - THANKS FOR NOTHING!!!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/wordoppressed345345/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a601541e053b00a111d360da6c9836f6838d8b3b2c70160614cceb867a54af1c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a601541e053b00a111d360da6c9836f6838d8b3b2c70160614cceb867a54af1c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/wordoppressed345345/\" class=\"reviewer-name\">wordoppressed345345</a> در <span class=\"review-date\">دسامبر 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>WE USED TO BE ABLE TO DROP SHORTCODES INTO THE TEXT EDITOR WHICH MADE CHANGING ATTRIBUTES (EX. TEXT SIZE, ORIENTATION, ETC.) QUICK AND EASY. OF COURSE THEY KILLED THAT FUNCTIONALITY.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>EVER NOTICE THAT THESE UPDATES ONLY BREAK THINGS?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works ok but feel trapped in it</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/petersonrk/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/895f0db4bf7c487580c456caf9e2fcd2bdb5b3d4fb9966e2417cbf371a2e53f1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/895f0db4bf7c487580c456caf9e2fcd2bdb5b3d4fb9966e2417cbf371a2e53f1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/petersonrk/\" class=\"reviewer-name\">petersonrk</a> در <span class=\"review-date\">دسامبر 17, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor feels like it gets worse as they add features that I don\'t use. It now takes too long to load and sometimes won\'t let me edit a page. </p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:339:\"صفحه ساز المنتور همه چیز را در خود جای داده : صفحه سازی با قابلیت کشیدن و رها کردن عناصر ، طراحی پیکسلی عالی ، ویرایشگر رسپانسیو برای نسخه تلفن همراه و چیزهای زیاد دیگر. همین الان شروع کنید!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:190:\"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:387:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:6:\"3.32.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:6:\"3.32.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip\";s:6:\"3.32.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:6:\"3.32.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip\";s:6:\"3.32.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:6:\"3.32.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip\";s:6:\"3.33.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.0.zip\";s:12:\"3.33.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta1.zip\";s:12:\"3.33.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta2.zip\";s:12:\"3.33.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta3.zip\";s:12:\"3.33.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta4.zip\";s:11:\"3.33.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev1.zip\";s:11:\"3.33.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev2.zip\";s:11:\"3.33.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev3.zip\";s:11:\"3.33.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev4.zip\";s:6:\"3.33.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.1.zip\";s:6:\"3.33.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:6:\"3.33.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.3.zip\";s:6:\"3.33.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.4.zip\";s:6:\"3.33.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.5.zip\";s:6:\"3.33.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.6.zip\";s:6:\"3.34.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip\";s:12:\"3.34.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta1.zip\";s:12:\"3.34.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta2.zip\";s:12:\"3.34.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta3.zip\";s:11:\"3.34.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev1.zip\";s:11:\"3.34.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev2.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:84:\"وب‌سایت ساز المنتور &#8211; فراتر از یک صفحه‌ساز\";}}", "off");
INSERT INTO `aor_options` VALUES("165", "can_compress_scripts", "1", "on");
INSERT INTO `aor_options` VALUES("175", "current_theme", "Hello Child", "auto");
INSERT INTO `aor_options` VALUES("176", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1766818461;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `aor_options` VALUES("177", "theme_switched", "", "auto");
INSERT INTO `aor_options` VALUES("1564", "_site_transient_timeout_browser_89db729cfcdc129111f017b0e7ac324a", "1767169639", "off");
INSERT INTO `aor_options` VALUES("126", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1765880622;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `aor_options` VALUES("127", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"ee201cceec3030105765a602aadbbb50\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `aor_options` VALUES("225", "wpp_settings", "a:18:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:12:\"enable_fonts\";s:6:\"enable\";s:10:\"conv_title\";s:6:\"enable\";s:13:\"conv_contents\";s:6:\"enable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:9:\"conv_cats\";s:6:\"enable\";s:11:\"conv_arabic\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:16:\"months_name_type\";s:7:\"persian\";s:20:\"disable_widget_block\";s:6:\"enable\";s:15:\"conv_page_title\";s:6:\"enable\";s:17:\"date_in_admin_bar\";s:6:\"enable\";}", "auto");
INSERT INTO `aor_options` VALUES("226", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("227", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `aor_options` VALUES("228", "wp_parsi_statistics_ver", "1.5", "auto");
INSERT INTO `aor_options` VALUES("178", "hello_theme_version", "3.4.5", "auto");
INSERT INTO `aor_options` VALUES("181", "elementor_connect_site_key", "a1c93bd1b94196dc7a90ebef2b306f4f", "auto");
INSERT INTO `aor_options` VALUES("182", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1767031981;s:5:\"value\";s:7987:\"[{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `aor_options` VALUES("4670", "_site_transient_theme_roots", "a:3:{s:11:\"hello-child\";s:7:\"/themes\";s:15:\"hello-elementor\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";}", "off");
INSERT INTO `aor_options` VALUES("191", "elementor_active_kit", "6", "auto");
INSERT INTO `aor_options` VALUES("192", "elementor_font_display", "swap", "auto");
INSERT INTO `aor_options` VALUES("202", "_elementor_ab_testing_data", "a:2:{s:7:\"timeout\";i:1765896844;s:5:\"value\";s:274:\"[{\"coreOnboarding\":{\"emphasizeConnectBenefits101\":false,\"embedConnectInOnboarding102\":false,\"onboardingStartsWithLogin103\":false,\"offerThemeChoicesHelloBiz201\":false,\"emphasizeThemeValueAudience202\":false,\"updateCopyVisuals401\":false,\"reduceHierarchyBlankOption402\":false}}]\";}", "off");
INSERT INTO `aor_options` VALUES("168", "finished_updating_comment_type", "1", "auto");
INSERT INTO `aor_options` VALUES("156", "wp_notes_notify", "1", "on");
INSERT INTO `aor_options` VALUES("137", "_site_transient_browser_3c9fc7ddec9b58823c1c96756dbd45d8", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"142.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `aor_options` VALUES("1566", "_site_transient_timeout_php_check_986ab27a5c44eb5941b7e3b238532f66", "1767169639", "off");
INSERT INTO `aor_options` VALUES("1567", "_site_transient_php_check_986ab27a5c44eb5941b7e3b238532f66", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `aor_options` VALUES("2046", "_site_transient_community-events-3e26f0c413d256ac3a730a52af2ff18c", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"151.233.195.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `aor_options` VALUES("144", "_transient_feed_9ba2df8849616f02166b8f7242d75067", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Dec 2025 01:48:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61384\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:79:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۹\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://fa.wordpress.org/2025/12/06/wp-fa-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://fa.wordpress.org/2025/12/06/wp-fa-6-9/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Dec 2025 00:36:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"اخبار وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:567:\"به وردپرس ۶.۹ خوش آمدید وردپرس ۶.۹ ارتقاهای بزرگی را در نحوه همکاری و خلق محتوا توسط تیم‌ها به ارمغان می‌آورد. ویژگی جدید یادداشت‌ها (Notes) امکان ثبت دیدگاه در سطح بلوک را هنگام نوشتن نوشته‌ها و برگه‌ها فراهم می‌کند که فرآیند بازبینی را ساده می‌سازد. در همین حال، پالت فرمان (Command Palette) گسترش‌یافته، پیمایش و [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10526:\"\n<h2 class=\"wp-block-heading has-vazirmatn-font-family\">به وردپرس ۶.۹ خوش آمدید</h2>\n\n\n\n<p>وردپرس ۶.۹ ارتقاهای بزرگی را در نحوه همکاری و خلق محتوا توسط تیم‌ها به ارمغان می‌آورد. ویژگی جدید <strong>یادداشت‌ها (Notes)</strong> امکان ثبت دیدگاه در سطح بلوک را هنگام نوشتن نوشته‌ها و برگه‌ها فراهم می‌کند که فرآیند بازبینی را ساده می‌سازد. در همین حال، <strong>پالت فرمان (Command Palette)</strong> گسترش‌یافته، پیمایش و عملیات در سراسر پیشخوان را برای کاربران حرفه‌ای سریع‌تر می‌کند.</p>\n\n\n\n<p><strong>رابط برنامه‌نویسی قابلیت‌ها (Abilities API)</strong> جدید، یک سیستم مجوزدهی استاندارد و قابل خواندن توسط ماشین ارائه می‌دهد که در را برای گردش‌کارهای خودکار و مبتنی بر هوش مصنوعی نسل بعدی باز می‌کند. این نسخه همچنین بهبودهای عملکردی قابل‌توجهی برای بارگذاری سریع‌تر صفحات ارائه می‌دهد و چندین بلوک کاربردی جدید را در کنار قابلیت کشیدن و رها کردن (Drag and Drop) بصری‌تر اضافه می‌کند تا به سازندگان کمک کند محتوای غنی‌تر و پویاتری بسازند.</p>\n\n\n\n<h3 class=\"wp-block-heading has-vazirmatn-font-family\">معرفی یادداشت‌ها: همکاری یکپارچه در سطح بلوک</h3>\n\n\n\n<p><strong>هوشمندانه‌تر همکاری کنید: بازخورد را دقیقاً همان‌جا که کار می‌کنید بگذارید.</strong></p>\n\n\n\n<p>با یادداشت‌هایی که مستقیماً به بلوک‌ها در ویرایشگر نوشته متصل می‌شوند، تیم شما می‌تواند هماهنگ بماند، تغییرات را ردیابی کند و بازخوردها را به عمل تبدیل کند؛ همه در یک مکان. چه روی متن کار کنید و چه در حال اصلاح طراحی در نوشته‌ها یا برگه‌های خود باشید، همکاری به‌صورت یکپارچه روی بوم طراحی اتفاق می‌افتد.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&amp;ssl=1\" alt=\"View of people interacting with notes in a post.\" class=\"wp-image-19428\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">پالت فرمان در سراسر پیشخوان</h3>\n\n\n\n<p><strong>ابزارهای شما همیشه در دسترس هستند.</strong></p>\n\n\n\n<p>از هر بخشی از پیشخوان به <strong>پالت فرمان</strong> دسترسی داشته باشید؛ چه در حال نوشتن آخرین پست خود باشید، چه غرق در طراحی در ویرایشگر سایت، و چه در حال مرور افزونه‌های خود. هر چیزی که نیاز دارید، تنها با چند ضربه روی کیبورد در دسترس است.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&amp;ssl=1\" alt=\"Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts.\" class=\"wp-image-19430\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">متن متناسب با کانتینر (Fit text to container)</h3>\n\n\n\n<p><strong>محتوایی که تطبیق می‌یابد.</strong></p>\n\n\n\n<p>یک گزینه تایپوگرافی جدید برای بلوک‌های متنی به بلوک‌های پاراگراف و تیتر اضافه شده است. این گزینه جدید به‌طور خودکار اندازه فونت را تنظیم می‌کند تا ظرف خود را کاملاً پر کند؛ این ویژگی برای بنرها، فراخوان‌ها (Callouts) و لحظات برجسته در طراحی شما ایده‌آل است.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&amp;ssl=1\" alt=\"&quot;Novem&quot; text selected and stretching across the interface.\" class=\"wp-image-19431\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">رابط برنامه‌نویسی قابلیت‌ها (The Abilities API)</h3>\n\n\n\n<p><strong>قفل‌گشایی از نسل بعدی تعاملات سایت.</strong></p>\n\n\n\n<p>وردپرس ۶.۹ با <strong>API یکپارچه قابلیت‌ها</strong>، زمینه را برای آینده اتوماسیون فراهم می‌کند. با ایجاد یک رجیستری استاندارد برای عملکرد سایت، توسعه‌دهندگان اکنون می‌توانند اقدامات را به‌طور پیوسته در هر زمینه‌ای &#8211; از PHP و اندپوینت‌های REST گرفته تا عامل‌های هوش مصنوعی &#8211; ثبت، اعتبارسنجی و اجرا کنند. این امر راه را برای تجربه‌های هوشمندتر و متصل‌تر در وردپرس هموار می‌کند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&amp;ssl=1\" alt=\"Abstract view of circles around a plugin icon with sparkles, indicating AI functionality.\" class=\"wp-image-19432\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">بهبودهای دسترسی‌پذیری</h2>\n\n\n\n<p>بیش از ۳۰ اصلاح دسترسی‌پیذیری، تجربه هسته وردپرس را دقیق‌تر کرده است. این به‌روزرسانی‌ها اعلام‌های صفحه‌خوان (Screen Reader) را بهبود می‌بخشند، محتوای غیرضروری تولید شده توسط CSS را از فناوری‌های کمکی مخفی می‌کنند، مشکلات قرارگیری مکان‌نما را رفع می‌کنند و اطمینان حاصل می‌کنند که تمرکز تایپ (Focus) حتی زمانی که کاربران روی یک پیشنهاد تکمیل خودکار کلیک می‌کنند، حفظ شود.</p>\n\n\n\n<h2 class=\"wp-block-heading\">ارتقای عملکرد</h2>\n\n\n\n<p>وردپرس ۶.۹ بهبودهای قابل‌توجهی در عملکرد فرانت‌اند (Frontend) ارائه می‌دهد و تجربه بارگذاری سایت را برای بازدیدکنندگان بهینه می‌کند. نسخه ۶.۹ دارای <strong>LCP (بزرگترین ترسیم محتوایی)</strong> بهبودیافته است که از طریق سبک‌های بلوک درخواستی (On-demand) برای پوسته‌های کلاسیک، فشرده‌سازی سبک‌های پوسته بلوکی و افزایش محدودیت برای سبک‌های درون‌خطی (Inline styles) حاصل شده است. این تغییرات موانع رندر صفحه را حذف کرده و مسیر رندر را با کم‌اولویت کردن اسکریپت‌های غیرضروری پاکسازی می‌کند.</p>\n\n\n\n<p>این نسخه با افزایش‌های عملکردی بسیار بیشتری همراه است، از جمله کوئری‌های دیتابیس بهینه‌شده، کشینگ اصلاح‌شده، بهبود اجرای WP Cron و یک بافر خروجی جدید برای بهبود قالب که در را برای بهینه‌سازی‌های آینده باز می‌کند.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">و بسیاری موارد دیگر</h2>\n\n\n\n<p>برای مشاهده نمای کلی و جامع از تمام ویژگی‌های جدید و بهبودها در وردپرس ۶.۹، لطفاً از وب‌سایت نمایش ویژگی‌ها بازدید کنید.</p>\n\n\n\n<h2 class=\"wp-block-heading\">تیم انتشار ۶.۹</h2>\n\n\n\n<p>هر نسخه توسط تیمی اختصاصی از مشارکت‌کنندگان مشتاق به دست شما می‌رسد که به حفظ مسیر و حرکت روان کارها کمک می‌کنند. تیمی که نسخه ۶.۹ را رهبری کرده، گروهی از مشارکت‌کنندگان با تخصص‌های مختلف است که همیشه آماده حمایت از ایده‌ها، رفع موانع و حل مشکلات هستند.</p>\n\n\n\n<h3 class=\"wp-block-heading\">تشکر از مشارکت‌کنندگان</h3>\n\n\n\n<p>ماموریت وردپرس دموکراتیزه کردن انتشار و تجسم آزادی‌هایی است که با متن‌باز (Open Source) بودن همراه است. جامعه‌ای جهانی و متنوع از افرادی که برای تقویت این نرم‌افزار همکاری می‌کنند، از این تلاش پشتیبانی می‌کنند.</p>\n\n\n\n<p>وردپرس ۶.۹ بازتاب‌دهنده تلاش‌های خستگی‌ناپذیر و اشتیاق بیش از <strong>۹۰۰ مشارکت‌کننده</strong> در کشورهایی در سراسر جهان است. این نسخه همچنین پذیرای بیش از <strong>۲۷۹ مشارکت‌کننده بار اولی</strong> بود!</p>\n\n\n\n<p>همکاری آن‌ها بیش از <strong>۳۴۰ بهبود و اصلاح</strong> را ارائه کرد و انتشاری پایدار را برای همه تضمین نمود – گواهی بر قدرت و توانایی جامعه متن‌باز وردپرس.</p>\n\n\n\n<p>برای مشاهدهٔ جامع تمام ویژگی‌ها و بهبودهای جدید در وردپرس ۶.۹، آن را به‌روز و امتحان کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://fa.wordpress.org/2025/12/06/wp-fa-6-9/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"خطرات استفاده از محصولات نال و کرک شده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 09:39:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1120\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:515:\"استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&#160;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم. 1. احترام به [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13685:\"\n<p>استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&nbsp;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>1. احترام به قانون کپی‌رایت</strong></h4>\n\n\n\n<p>هر نرم‌افزاری که توسط توسعه‌دهندگان یا تیم‌های برنامه‌نویسی تولید می‌شود، نتیجه‌ زحمت، زمان و هزینه‌ زیادی است. اکثر این نرم‌افزارها نسخه‌های رایگان یا آزمایشی نیز ارائه می‌دهند تا کاربران بتوانند قبل از خرید، آن‌ها را امتحان کنند.<br>استفاده از نسخه‌های نال شده این محصولات، نه تنها نقض قانون کپی‌رایت، بلکه یک عمل غیر اخلاقی محسوب می‌شود. این کار نه تنها زحمات توسعه‌دهنده را بی‌ارزش می‌کند، بلکه توسعه و نوآوری در نرم‌افزارها را نیز کاهش می‌دهد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. خطرات امنیتی</strong></h4>\n\n\n\n<p>استفاده از محصولات نال می‌تواند امنیت شما و وب‌سایتتان را به شدت به خطر بیندازد.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>محصول نال چیست؟</strong><strong><br></strong>محصولات نال در واقع نسخه‌های غیرقانونی نرم‌افزارهایی هستند که سیستم لایسنس آن‌ها دور زده شده است. این نسخه‌ها اغلب توسط افرادی عرضه می‌شوند که اهداف نامعلومی دارند، از جمله تزریق کدهای مخرب.</li>\n\n\n\n<li><strong>عدم دریافت به‌روزرسانی‌ها</strong><strong><br></strong>یکی از بزرگ‌ترین مزایای محصولات اصلی، ارائه به‌روزرسانی‌های منظم برای رفع باگ‌ها و ارتقای امنیت است. کاربران محصولات نال، این آپدیت‌ها را دریافت نمی‌کنند و در نتیجه، سایت آن‌ها در برابر حملات سایبری آسیب‌پذیر می‌شود.</li>\n\n\n\n<li><strong>عدم پشتیبانی</strong><strong><br></strong>محصولات پرمیوم معمولاً با پشتیبانی کامل توسعه‌دهندگان همراه هستند. کاربران محصولات نال به این پشتیبانی دسترسی ندارند و در صورت بروز مشکل، باید خودشان آن را حل کنند.</li>\n\n\n\n<li><strong>کدهای مخرب</strong><strong><br></strong>محصولات نال اغلب شامل کدهای مخربی هستند که می‌توانند اطلاعات حساس شما مانند رمزهای عبور، اطلاعات بانکی و حتی اطلاعات مشتریان شما را به سرقت ببرند. این مسئله به ویژه برای سایت‌های فروشگاهی و کسب‌وکارهای آنلاین بسیار خطرناک است.</li>\n\n\n\n<li><strong>سو استفاده از منابع سرور</strong><strong><br></strong>استفاده از محصولات نال در برخی موارد منجر به سوء استفاده هکرها از منابع سرور، ارسال ایمیل‌های تبلیغاتی، دریافت دسترسی و تلاش برای نفوذ به سرور و هک کردن آن می‌شود که می‌تواند نتایج مخرب و مشکل زایی برای سرور و یا آدرس IP آن و حتی سایت‌های مشترک دیگر میزبانی‌شده بر روی آن داشته باشد.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>3. تاثیرات منفی بر سئو</strong></h4>\n\n\n\n<p>استفاده از محصولات نال ممکن است باعث ایجاد لینک‌های اسپم، پاپ‌آپ‌های تبلیغاتی و حتی تغییرات مخفی در کد سایت شود. این موارد ممکن است باعث کاهش رتبه سایت شما در موتورهای جستجو شده و اعتماد کاربران را نیز از بین ببرد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>4. انگیزه‌های ارائه‌دهندگان محصولات نال</strong></h4>\n\n\n\n<p>افرادی که محصولات نال را ارائه می‌دهند، معمولاً به دنبال منافع شخصی هستند. برخی از انگیزه‌های آن‌ها عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>تزریق تبلیغات و لینک‌های اسپم به سایت شما.</li>\n\n\n\n<li>سرقت اطلاعات شخصی مانند نام کاربری، رمز عبور، ایمیل و اطلاعات مالی.</li>\n\n\n\n<li>آلوده کردن فایل‌ها و سرورهای شما به بدافزارها.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چگونه بفهمیم یک محصول نال است؟</strong></h3>\n\n\n\n<p>تشخیص محصولات نال برای افرادی که با ویژگی‌های نسخه‌های اورجینال آشنا نیستند، ممکن است دشوار باشد. اما با چند نکته ساده می‌توان از خرید این محصولات جلوگیری کرد:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>فروشگاه عرضه‌کننده محصول:</strong><strong><br></strong>هر محصول تجاری، تنها در فروشگاه رسمی تولیدکننده آن به فروش می‌رسد. اگر یک فروشگاه دیگر، از جمله فروشگاه‌های ایرانی، محصولاتی مانند قالب وودمارت (WoodMart)، افزونه المنتور (Elementor) یا سایر افزونه‌ها و قالب‌های پرمیوم را با عنوان نگارش اصل و اورجینال ارائه کند، در حال فروش نسخه نال محصول است. توجه داشته باشید هیچ وب‌سایتی از این امر مستثنی نیست.</li>\n\n\n\n<li><strong>قیمت غیرمعقول:</strong><strong><br></strong>محصولات نال معمولاً با قیمتی بسیار کمتر از نسخه اورجینال به فروش می‌رسند. اگر یک قالب یا افزونه با قیمت بسیار پایین‌تر از سایت اصلی عرضه شود، احتمال نال بودن آن بسیار زیاد است.</li>\n\n\n\n<li><strong>عدم ارائه لایسنس معتبر:</strong><strong><br></strong>محصولات اصلی همراه با یک لایسنس معتبر عرضه می‌شوند که امکان فعال‌سازی و دریافت به‌روزرسانی‌ها را فراهم می‌کند. اگر محصولی فاقد لایسنس معتبر باشد یا لایسنس غیرقابل تأیید ارائه دهد، احتمالاً نال شده است.</li>\n\n\n\n<li><strong>بررسی نظرات کاربران و اعتبار فروشنده:</strong><strong><br></strong>پیش از خرید، نظرات کاربران را بررسی کنید و از معتبر بودن فروشگاه اطمینان حاصل کنید. فروشگاه‌های معتبر اطلاعات واضحی درباره محصولات ارائه می‌دهند و به سوالات کاربران پاسخ شفاف می‌دهند.</li>\n\n\n\n<li><strong>محصولات نگارش اصلی کد شده نمی‌باشند</strong><strong><br></strong>باید توجه داشته باشید که وردپرس بر اساس GPL و کد باز (Open Source) منتشر شده است. این به این معنی است که تمامی افزونه‌ها و پوسته‌های مرتبط با آن، باید به صورت کد باز منتشر شوند، حتی هر افزونه و یا پوسته‌ای که نگارش Premium یا Pro باشد باید به صورت Open Source به کاربران ارائه شوند، حال آنکه متاسفانه بسیاری از فروشگاه‌های ایرانی، نسخه‌های Premium و Pro را که کد باز هستند، کدگذاری کرده و با دخل تصرف بیشتر و یا اضافه کردن سیستم‌های لایسنس پیچیده‌تر، سعی در فروش بیشتر و در نتیجه پیچیده‌تر کردن محصول نهایی می‌کنند که این کار در نهایت منجر به سنگین‌تر شدن سایت و زمان بارگذاری بیشتر سایت و مشکلات دیگر می‌شود.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چطور محصولات اورجینال بخریم؟</strong></h3>\n\n\n\n<p>با توجه به مشکلات خرید دلاری برای کاربران ایرانی، می‌توانید از روش‌های زیر استفاده کنید:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>سایت‌های واسطه:</strong><strong><br></strong>برخی از سایت‌های معتبر واسطه ایرانی امکان خرید دلاری را برای شما فراهم می‌کنند. این سایت‌ها با دریافت مبلغ ریالی، محصول مورد نظر شما را از سایت اصلی خریداری کرده و اطلاعات لایسنس را در اختیار شما قرار می‌دهند. قبل از استفاده از خدمات این سایت‌ها، اعتبار آن‌ها را بررسی کنید.</li>\n\n\n\n<li><strong>دوستان یا آشنایان دارای حساب بین‌المللی:</strong><strong><br></strong>اگر دوستان یا آشنایانی دارید که دسترسی به کارت‌های بین‌المللی مانند مسترکارت یا ویزا کارت دارند، می‌توانید از آن‌ها برای خرید محصولات کمک بگیرید.</li>\n\n\n\n<li><strong>پیشنهاد دیگر: استفاده از تخفیف‌ها و باندل‌ها</strong><strong><br></strong>بسیاری از توسعه‌دهندگان محصولات وردپرس، در بازه‌های زمانی خاص مانند جمعه سیاه (Black Friday) یا مناسبت‌های دیگر، تخفیف‌های چشمگیری ارائه می‌دهند. با کمی برنامه‌ریزی می‌توانید محصولات اورجینال را با هزینه کمتری خریداری کنید.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>جمع‌بندی:</strong></h3>\n\n\n\n<p>خرید محصولات اصلی، علاوه بر حمایت از توسعه‌دهندگان، به شما این امکان را می‌دهد که از امکانات زیر بهره‌مند شوید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>پشتیبانی مداوم:</strong> حل مشکلات و پاسخ به سوالات شما.</li>\n\n\n\n<li><strong>دریافت به‌روزرسانی‌ها:</strong> محافظت سایت در برابر آسیب‌پذیری‌ها.</li>\n\n\n\n<li><strong>دسترسی به امکانات کامل و مستندات:</strong> بهره‌گیری از تمامی قابلیت‌های محصول به صورت بهینه.</li>\n</ul>\n\n\n\n<p>با خرید نسخه‌های اورجینال، هم امنیت و عملکرد سایت خود را تضمین می‌کنید و هم به توسعه تکنولوژی‌های بهتر کمک می‌کنید.</p>\n\n\n\n<p>استفاده از محصولات نال نه تنها غیراخلاقی و غیرقانونی است، بلکه می‌تواند خطرات جدی برای امنیت، عملکرد و اعتبار سایت شما ایجاد کند. به جای انتخاب این محصولات، از نسخه‌های رایگان یا لایسنس‌دار استفاده کنید. این کار نه تنها باعث حمایت از توسعه‌دهندگان می‌شود، بلکه امنیت و کیفیت سایت شما را تضمین می‌کند.</p>\n\n\n\n<p>اگر هزینه یک محصول برایتان بالا است، به دنبال جایگزین‌های رایگان یا تخفیف‌های فصلی باشید، اما هرگز امنیت و اعتبار خود را فدای استفاده از محصولات نال نکنید.</p>\n\n\n\n<p><strong>نوشته شده توسط:</strong> <a href=\"https://profiles.wordpress.org/asadiy4n/\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/asadiy4n/\">حسین اسدیان</a> و <a href=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\" data-type=\"link\" data-id=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\">تیم وردپرس فارسی</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:235:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۷\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/11/17/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b7-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 17 Nov 2024 20:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1103\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:527:\"به وردپرس ۶.۷ خوش آمدید! وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11038:\"\n<h2 class=\"wp-block-heading has-huge-font-size\"><strong>به وردپرس ۶.۷ خوش آمدید!</strong></h2>\n\n\n\n<p>وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت خود را با یک نمای کلان طراحی کنید و از جزئیات فاصله بگیرید تا تصویر کلی را به زندگی بیاورید</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معرفی پوسته Twenty Twenty-Five<br>امکان بی‌پایان بدون پیچیدگی</strong></h4>\n\n\n\n<p>پوسته Twenty Twenty-Five یک پوسته انعطاف‌پذیر و متمرکز بر طراحی را ارائه می‌دهد که به شما این امکان را می‌دهد تا سایت‌های خیره‌کننده‌ای را به سادگی بسازید. زیبایی‌شناسی خود را با مجموعه‌ای از گزینه‌های سبک، الگوهای بلوک و پالت‌های رنگی سفارشی کنید. این پوسته که به اصول اساسی خود پایبند است، واقعاً می‌تواند با شما رشد کند</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px;height:auto\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>تصویر کلی را با ویژگی Zoom Out ببینید<br>محتوای خود را از یک دیدگاه جدید کاوش کنید</strong></h4>\n\n\n\n<p>محتوای خود را به‌طور کامل و به شیوه‌ای بی‌سابقه ویرایش و مرتب کنید. نمای وسیع‌تری از سایت شما این امکان را می‌دهد که الگوها را به دلخواه خود اضافه، ویرایش، جابجا یا حذف کنید. معمار درون خود را در آغوش بگیرید</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-zoom-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>بلوک‌ها و فیلدهای سفارشی را بدون دردسر (یا کدنویسی) متصل کنید<br>راهی ساده برای ایجاد محتوای پویا</strong></h4>\n\n\n\n<p>این ویژگی یک رابط کاربری جدید برای اتصال بلوک‌ها به فیلدهای سفارشی معرفی می‌کند و کنترل محتوای پویا را به‌طور مستقیم در ویرایشگر قرار می‌دهد. بلوک‌ها را تنها با چند کلیک به فیلدها متصل کنید و انعطاف‌پذیری و کارایی را در هنگام ساخت افزایش دهید. مشتریان شما، شما را دوست خواهند داشت—انگار که قبلاً دوست نداشتند!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-block-bindings-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معمار درون فونت‌شناس خود را در آغوش بگیرید<br>بخش جدید سبک، امکانات جدید</strong></h4>\n\n\n\n<p>با افزودن جدید به رابط Styles، اندازه‌های پیش‌فرض فونت را ایجاد، ویرایش، حذف و اعمال کنید. می‌توانید تنظیمات پیش‌فرض پوسته را نادیده بگیرید یا اندازه فونت سفارشی خود را ایجاد کنید که شامل تایپوگرافی سیال برای مقیاس‌بندی پاسخگو باشد. به جزئیات بپردازید!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-font-presets-2.png?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>عملکرد</strong></h4>\n\n\n\n<p>وردپرس ۶.۷ به‌روزرسانی‌های مهمی در زمینه عملکرد ارائه می‌دهد، از جمله بارگذاری سریع‌تر الگوها، پیش‌نمایش‌های بهینه‌شده در مؤلفه‌های نمای داده، بهبود پشتیبانی از PHP 8+ و حذف کدهای منسوخ، اندازه‌های خودکار برای تصاویر بارگذاری شده به‌صورت تنبل و پردازش کارآمدتر برچسب‌ها در API HTML.</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>دسترس‌پذیری</strong></h4>\n\n\n\n<p>بیش از ۶۵ اصلاح و بهبود در زمینه دسترس‌پذیری بر جنبه‌های بنیادی تجربه وردپرس تمرکز دارد، از بهبود مؤلفه‌های رابط کاربری و ناوبری با کیبورد در ویرایشگر، تا عنوان دسترس‌پذیر در صفحه‌های ورود به وردپرس و برچسب‌گذاری واضح‌تر در سرتاسر.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-heic-1.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>پشتیبانی از تصاویر HEIC</strong><br>پشتیبانی از تصاویر HEIC مدیریت رسانه را بهبود می‌بخشد و امکان استفاده از تصاویر با کیفیت بالا و فضای بهینه را در تمام بلوک‌ها فراهم می‌کند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-streamlined-query-loops.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>بلوک Query Loop بهینه‌شده</strong><br>بهبودهای انجام‌شده در بلوک Query Loop قابلیت استفاده را افزایش می‌دهد و با خودکارسازی تنظیمات پیش‌فرض و تجمیع گزینه‌های کلیدی، سفارشی‌سازی را آسان‌تر می‌کند</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-preview-dropdown.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>گسترش منوی کشویی پیش‌نمایش</strong><br>بهبودهای انجام‌شده در گزینه‌های پیش‌نمایش به افزونه‌ها و پوسته‌ها این امکان را می‌دهد که موارد سفارشی را به منوی کشویی اضافه کنند و نحوه پیش‌نمایش محتوا را غنی‌تر کنند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-site-background.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>سفارشی‌سازی پس‌زمینه سایت</strong><br>ابزارهای بهبود یافته پس‌زمینه، سفارشی‌سازی بلوک‌ها را افزایش می‌دهند و امکان تنظیمات جهانی را فراهم می‌کنند، که به حفظ انسجام در سرتاسر سایت کمک کرده و تلاش‌های طراحی را ساده‌تر می‌سازد.</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-template-registration.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>API ثبت الگو</strong><br>این API جدید ثبت الگوهای سفارشی را برای افزونه‌ها ساده‌تر می‌کند و امکان نادیده‌گیری پوسته و ایجاد الگوهای سفارشی برای دسته‌بندی‌ها را برای انعطاف‌پذیری بیشتر فراهم می‌آورد</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-refined-pages.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>نمای بهبود یافته صفحات در ویرایشگر سایت</strong><br>ویرایش را با نمای صفحات بهبود یافته که گزینه‌های فیلتر سفارشی را ارائه می‌دهند، ساده‌تر کنید. با تغییر نمایش فیلترها، به نمای‌های بهینه‌شده‌ای مانند منتشر شده و پیش‌نویس‌ها بدون شلوغی دسترسی پیدا کنید.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>برای مشاهدهٔ جامع تمام ویژگی‌ها و بهبودهای جدید در وردپرس ۶.۷، آن را به‌روز و امتحان کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۶\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/07/16/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 08:08:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1080\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:646:\"وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از: پالت‌های رنگ و مجموعه‌های فونت انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5177:\"\n<p>وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پالت‌های رنگ و مجموعه‌های فونت</li>\n\n\n\n<li>پیش‌نمایش سریع برای برگه‌ها</li>\n\n\n\n<li>بازگرداندن به‌روزرسانی‌های خودکار افزونه</li>\n\n\n\n<li>باز‌نویسی‌ها</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"567\" src=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png\" alt=\"\" class=\"wp-image-1081\" srcset=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png 1024w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-300x166.png 300w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-768x426.png 768w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1536x851.png 1536w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-2048x1135.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پالت‌های رنگ و مجموعه‌های فونت</h2>\n\n\n\n<p><strong>انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.</strong><br>سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را ارائه می‌کنند و امکان سفارشی‌سازی را بدون تغییر استایل گسترده‌تر سایت، فراتر از تنظیمات رنگ یا تایپوگرافی فراهم می‌کنند.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پیش‌نمایش سریع برای برگه‌ها</h2>\n\n\n\n<p><strong>گردش کاری خود را با چیدمان جدیدی که برای برگه‌ها ایجاد شده‌است، ساده کنید.&nbsp;</strong><br>تمام برگه‌هایتان و پیش‌نمایش هر برگهٔ انتخابی را قبل از ویرایش از طریق یک چیدمان جدید پهلو به پهلو در ویرایشگر سایت مشاهده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بازگرداندن به‌روزرسانی‌های خودکار افزونه</h2>\n\n\n\n<p><strong>افزونه‌های خود را با خیال راحت بصورت خودکار به‌روزرسانی کنید.</strong><br>از سهولت به‌روزرسانی خودکار افزونه‌ها با ایمنی بازگرداندن در صورت بروز مشکل، لذت ببرید و امنیت سایتتان را بهبود ببخشید و در عین حال مدت از کار افتادن احتمالی سایت را به حداقل برسانید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">باز‌نویسی‌ها</h2>\n\n\n\n<p><strong>افزودن قابلیت سفارشی‌سازی محتوا در الگوهای همگام‌سازی شده.</strong><br>اجازه می‌دهد که قطعات خاصی از محتوا در هر نمونه از یک الگوی همگام‌سازی‌شده را سفارشی و در عین حال سبکی ثابت را برای همه نمونه‌ها حفظ کنید و به‌روزرسانی‌های آینده را ساده‌تر می‌کند. در حال حاضر، می‌توانید برای بلوک‌های عنوان، پاراگراف، دکمه و تصویر، از باز‌نویسی‌ها استفاده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<p>ه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-6/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1080\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/04/02/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 07:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1076\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از: با کتابخانه فونت آشنا شوید بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید. فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7323:\"\n<p>وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از:<br></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>کتابخانه فونت جدید</li>\n\n\n\n<li>پس زمینه و ابزار سایه پیشرفته</li>\n\n\n\n<li>جزئیات بیشتری در اصلاحات استایل</li>\n\n\n\n<li>کنترل بهتر لینک</li>\n\n\n\n<li>نماهای داده جدید</li>\n\n\n\n<li>به‌روزرسانی عملکرد</li>\n\n\n\n<li>بهبود دسترسی</li>\n\n\n\n<li></li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid.png\"><img decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png\" alt=\"\" class=\"wp-image-1077\" srcset=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png 1024w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-300x169.png 300w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-768x432.png 768w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1536x864.png 1536w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-2048x1153.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">با کتابخانه فونت آشنا شوید</h2>\n\n\n\n<p>بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید.</p>\n\n\n\n<p>فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی سفارشی به سازندگان سایت و ناشران، حق انتخاب بیشتری می‌دهد.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پس زمینه و ابزار سایه پیشرفته</h2>\n\n\n\n<p>با استفاده از ابزارهای طراحی به‌روز، راه‌های بیشتری برای افزودن جذابیت بصری به چیدمان‌ها بیابید. تنظیمات اندازه، تکرار و نقطه کانونی را روی تصاویر پس زمینه خود کنترل کنید تا آن‌ها را با هم ترکیب و یا برجسته کنید. با افزودن پشتیبانی از سایه‌ها به بلوک‌های بیشتر، در طرح‌هایتان عمق بصری ایجاد و یا کمی هویت به آن‌ها تزریق کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جزئیات بیشتری را از اصلاحات استایل خود دریافت کنید</h2>\n\n\n\n<p>پروژه‌های خلاقانه را با داشتن تصویر کامل‌تری از آنچه انجام شده است — و آنچه می‌توانید به آن برگردید، انجام بدهید. جزئیاتی مانند نشان‌های زمانی، خلاصه‌ی سریع و فهرست صفحه‌بندی‌شده‌ی همه ویرایش‌ها را دریافت کنید. برای مشاهده تغییرات، خارج از آنچه روی آن کار می‌کنید، به ویرایش‌های موجود در کتابچه سبک نگاه کنید. اکنون رونوشت‌ها برای الگوها و اجزای قالب نیز در دسترس است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">کنترل بهتر لینک</h2>\n\n\n\n<p>پیوندها را به راحتی با تجربه پیوندسازی قابل درک‌تر ایجاد و مدیریت کنید، با یک رابط کاربری ساده و میانبرهایی برای کپی کردن پیوندها.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">نماهای داده جدید را کاوش کنید</h2>\n\n\n\n<p>هر بخش از سایت شما با کتابخانه‌ای از اطلاعات و داده‌ها همراه است — اکنون، می‌توانید آنچه را که نیاز دارید به سرعت پیدا کنید و آن را هر طور که دوست دارید سازماندهی کنید. نماهای داده برای صفحات، قالب‌ها، الگوها و بخش‌های قالب به شما امکان می‌دهد داده‌ها را در یک نمای جدول یا شبکه‌ای مشاهده کنید، با گزینه‌هایی برای تغییر زمینه‌ها و ایجاد تغییرات دسته‌جمعی.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">به‌روزرسانی عملکرد</h2>\n\n\n\n<p>این نگارش شامل بیش از ۱۱۰ به روز‌رسانی عملکرد، با افزایش چشمگیر سرعت و کارایی در ویرایشگر پست و ویرایشگر سایت است. بارگیری بیش از دو برابر سریعتر از نگارش ۶٫۴ است، با سرعت پردازش ورودی تا پنج برابر سریعتر از نگارش قبلی. زمان بارگذاری سایت‌های ترجمه شده تا ۲۵٪ در این نگارش بهبود یافته‌ است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بهبود دسترسی</h2>\n\n\n\n<p>این نگارش شامل بیش از ۶۵ بهبود دسترسی‌پذیری در سراسر پلتفرم است که آن را بیش از همیشه در دسترس قرار می‌دهد. این شامل یک اصلاح مهم است که دسترسی به منوهای فرعی مدیریت را برای کاربران صفحه‌خوان و دیگرانی که با صفحه‌کلید پیمایش می‌کنند، رفع انسداد می‌کند. این نگارش همچنین اصلاحاتی را برای کنتراست رنگ در حالت‌های تمرکز مدیر، موقعیت‌یابی عناصر و فوکوس مکان‌نما و موارد بسیار دیگر، اضافه می‌کند که به بهبود تجربه وردپرس برای همه کمک می‌کند.</p>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://fa.wordpress.org/2023/11/07/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-6-4-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 11:20:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=905\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:600:\"این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1955:\"\n<p>این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف بی‌نظیر ساختار با بلوک‌ها را کشف کنید و به ایده‌های خود اجازه بدهید که پرواز کنند.</p>\n\n\n\n<p>بسیاری از ویژگی‌ها و بهبودهای وردپرس 6.4 در دسته &#8220;کوچک اما قدرتمند&#8221; قرار دارند. همراه با زیبایی چند منظوره قالب Twenty Twenty-Four (دو هزار و بیست و چهار)، این به‌روزرسانی‌ها به خالقان محتوا و توسعه‌دهندگان سایت کمک می‌کنند تا زمان و تلاش خود را صرفه‌جویی کنند و در عین حال تجربه وردپرس با ارزش و کم دردسر را که جهان انتظار دارده است، ارائه دهند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/files/2024/02/tt41.png\"><img decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2024/02/tt41.png\" alt=\"وردپرس 6.4\" class=\"wp-image-906\" srcset=\"https://fa.wordpress.org/files/2024/02/tt41.png 1024w, https://fa.wordpress.org/files/2024/02/tt41-300x195.png 300w, https://fa.wordpress.org/files/2024/02/tt41-768x500.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\">وردپرس 6.4</figcaption></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۳\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2023/08/20/wordpress-6-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 20 Aug 2023 20:15:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:513:\"با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2248:\"\n<p>با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها و پیمایش به روز شده ای را خواهید دید که به شما کمک می کند با تلاش کمتر کار کنید و ایجاد کنید، ابزارهایی طراحی کنید که کنترل بیشتری بر طرح بندی به شما می‌دهد، و عملکردهای افزوده شده‌ای را که تجربه ساخت سایت را غنی می کند. وردپرس 6.3 فصل مهمی را در تکامل وردپرس به عنوان ابزاری برای بیان مشخص می‌کند. این نقطه اوج سال‌ها کار صدها مشارکت‌کننده است که تجربه ویرایش قوی‌تر و منسجم‌تری را برای ساخت وب‌سایت‌هایی با بلوک به ارمغان می‌آورد. این به تلاش برای قابل دسترس ساختن انتشار وب برای همه ادامه می دهد &#8211; بنابراین فقط یک شروع جدید است!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/08/site-editor-2.png?resize=1024%2C666&amp;ssl=1\" alt=\"\" /></figure>\n\n\n\n<p>وردپرس جدید را از لینک زیر دریافت نمایید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"858\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 07:13:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=760\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:580:\"وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد. تازه‌ترین نگارش راهنمای زمینهٔ وردپرس را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید. برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10296:\"\n<p>وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد.</p>\n\n\n\n<div class=\"wp-block-jetpack-tiled-gallery alignfull is-style-rectangular\"><div class=\"tiled-gallery__gallery\"><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:66.70764%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"763\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-site-editor/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.29236%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"764\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-navigation/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"765\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-block-inserter/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"766\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-split-controls-fixed/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"767\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-openverse/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-headers.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"768\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-headers/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-headers.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"769\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-out-of-beta/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"770\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-distraction-free/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"771\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-custom-css/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"772\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-copy-paste/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div></div></div>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-2/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"760\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۸\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/2020/12/09/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b5%d9%ab%db%b8-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Dec 2020 14:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=662\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:611:\"&#8212; سه نیروی اساسی مدیریت ابزارک‌ها با بلوک‌ها بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16226:\"\n<p class=\"has-text-align-center has-white-color has-text-color\">&#8212;</p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\"> سه نیروی اساسی </h2>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" src=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png\" alt=\"\" class=\"wp-image-698 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png 1024w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-300x225.png 300w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-768x576.png 768w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-440x330.png 440w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">مدیریت ابزارک‌ها با بلوک‌ها</h3>\n\n\n\n<p>بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون کد گرفته تا کتابخانه گسترده بلوک‌های اصلی و شخص ثالث. برای توسعه‌دهندگانمان، شما می‌توانید جزئیات بیشتر را در <a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\">یادداشت توسعه ابزارک‌ها</a> پیدا کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"811\" src=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png\" alt=\"\" class=\"wp-image-697 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png 1024w, https://fa.wordpress.org/files/2021/07/about-query-loop-300x238.png 300w, https://fa.wordpress.org/files/2021/07/about-query-loop-768x608.png 768w, https://fa.wordpress.org/files/2021/07/about-query-loop.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمایش نوشته‌ها با بلوک‌ها و الگوهای جدید</h3>\n\n\n\n<p>بلوک چرخه درخواست امکان نمایش نوشته‌ها را براساس پارامترهای تعیین‌شده فراهم می‌کند؛ نظیر یک چرخه PHP بدون کدنویسی. به آسانی نوشته‌های یک دسته خاص را نمایش دهید یا کارهایی نظیر ایجاد یک برگه نمونه کار یا یک برگه کامل از دستورات آشپزی مورد علاقه شما انجام دهید. به بلوک آخرین نوشته‌ها به عنوان یک بلوک بسیار پیچیده و قوی فکر کنید! به علاوه، پیشنهادات الگو باعث می‌شود تا ایجاد لیستی از نوشته‌ها با طراحی مورد نظرتان آسان‌تر از گذشته قابل انجام باشد.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png\" alt=\"\" class=\"wp-image-699 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png 1024w, https://fa.wordpress.org/files/2020/12/about-template-300x195.png 300w, https://fa.wordpress.org/files/2020/12/about-template-768x499.png 768w, https://fa.wordpress.org/files/2020/12/about-template.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">ویرایش قالب اطراف نوشته‌ها</h3>\n\n\n\n<p>شما می‌توانید از ویرایشگر بلوک آشنا برای ویرایش قالب‌هایی که محتوای شما را در اختیار دارند استفاده کنید—به سادگی یک بلوک پوسته یا یک پوسته را که این ویژگی را انتخاب کرده است فعال کنید. از ویرایش نوشته‌ها به ویرایش برگه‌های خود بروید و دوباره بازگردید، همه اینها در حالی‌است که از ویرایشگر بلوک آشنا استفاده می‌کنید. بیش از ۲۰ بلوک جدید سارگاز با پوسته‌ها در دسترس است. در مورد این قابلیت و اینکه چطور می‌توان آن را تجربه کرد در یادداشت‌های انتشار بخوانید.</p>\n</div></div>\n\n\n\n<p> </p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">سه همیار گردش کار</h2>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-list-view.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"803\" src=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png\" alt=\"\" class=\"wp-image-700 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png 1024w, https://fa.wordpress.org/files/2020/12/about-list-view-300x235.png 300w, https://fa.wordpress.org/files/2020/12/about-list-view-768x602.png 768w, https://fa.wordpress.org/files/2020/12/about-list-view.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمای کلی ساختار برگه</h3>\n\n\n\n<p>گاهی شما نیاز به یک برگه فرود ساده نیاز داری ، اما گاهی نیاز به یک چیز قوی‌تر دارید. با اضافه شدن بلوک‌ها‌ی بیشتر، ادغام الوگها، و آسان شده ایجاد محتوا، راه‌حل‌های جدیدی لازم است تا بتوان محتوای پیچیده را به راحتی جستجو کرد. مشاهده فهرستی بهترین راه برای پرش بین لایه‌های محتوا و بلوک‌های تو در تو است. از آنجا که مشاهده فهرستی به شما یک نمای کلی از تمام بلوک‌های محتوای شما می‌دهد، اکنون می‌توانید به سرعت و دقیق به بلوک مورد نیاز خود بروید. آماده تمرکز کامل بر روی محتوای خود هستید؟ این را متناسب با گردش کار خود روشن یا خاموش کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"555\" src=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png\" alt=\"\" class=\"wp-image-701 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png 1024w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-300x163.png 300w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-768x416.png 768w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">الگوهای پیشنهادی برای بلوک‌ها</h3>\n\n\n\n<p>شروع در این نسخه ابزار دگرگونی الگو که الگوهای بلوک را بر اساس بلوکی که استفاده می‌کنید پیشنهاد می‌دهد. هم‌اکنون، می‌توانید این را در بلوک کوئری و بلوک آیکون شبکه‌های اجتماعی استفاده نمایید. با اضافه شدن الگوهای بیشتر، شما می‌توانید از نحوه سبک دادن به سایت خود بدون اینکه هرگز از ویرایشگر خارج شوید الهام بگیرید!</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-duotone.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"837\" src=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png\" alt=\"\" class=\"wp-image-702 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png 1024w, https://fa.wordpress.org/files/2020/12/about-duotone-300x245.png 300w, https://fa.wordpress.org/files/2020/12/about-duotone-768x628.png 768w, https://fa.wordpress.org/files/2020/12/about-duotone.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">سبک‌دهی و رنگ‌آمیزی تصاویر</h3>\n\n\n\n<p>با جلوه دوتون عکس‌ها و بلوک‌های پوشش را رنگی کنید! دوتون می‌تواند رنگ‌های زیادی را به طرح و سبک عکس‌های شما (یا ویدئوهایی در بلوک پوشش) برای ادغام خوب در پوسته‌های شما اضافه کند. شما می‌توانید جلوه دوتون را به عنوان یک فیلتر سیاه و سفید تصور کنید، اما به جای اینکه سایه‌ها سیاه و سفید و هایلایت باشند، رنگ‌های خود را برای سایه‌ها و هایلایت‌ها انتخاب می‌کنید. چیزهای بیشتری برای آموختن کارکرد آن در مستندات وجود دارد.</p>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">برای توسعه‌دهندگان که بررسی کنند</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1020\" height=\"610\" src=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\" alt=\"\" class=\"wp-image-703\" srcset=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png 1020w, https://fa.wordpress.org/files/2020/12/about-theme-json-300x179.png 300w, https://fa.wordpress.org/files/2020/12/about-theme-json-768x459.png 768w\" sizes=\"auto, (max-width: 1020px) 100vw, 1020px\" /></a></figure>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:50%\">\n<h3 class=\"wp-block-heading\">Theme.json</h3>\n\n\n\n<p>معرفی APIهای تنظیمات عمومی و سبک‌های عمومی: تنظیمات ویرایشگر، ابزارهای شخصی‌سازی در دسترس، و سبک‌های بلوک‌ها را با استفاده از پرونده theme.json در پوسته فعال کنترل کنید. این پرونده پیکربندی قابلیت‌ها و مجموعه سبک‌های پیش‌فرض برای سایت و بلوک‌ها را فعال یا غیرفعال می‌کند. اگر شما پوسته می‌سازید، شما می‌توانید این ویژگی جدید مفید را آزمایش کنید. برای اینکه بدانید هم‌اکنون چه چیزی در دسترس است و چگونه کار می‌کند، <a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">این توضیحات فنی را بخوانید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">کنار گذاشتن پشتیبانی از اینترنت اکسپلورر ۱۱</h3>\n\n\n\n<p>در این انتشار، پشتیبانی از اینترنت اکسپلورر ۱۱ کنار گذاشته شده است. این یعنی شما ممکن است نیاز به مدیریت مشکلاتی روی وبگاه‌تان داشته باشید که در آینده رفع نخواهند شد. اگر در حال حاضر از اینترنت اکسپلورر ۱۱ استفاده می‌کنید، اکیدا پیشنهاد می‌کنیم که <a href=\"https://browsehappy.com/\">به مرورگر مدرن‌تری نقل مکان کنید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی از WebP</h3>\n\n\n\n<p>WebP یک قالب ذخیره تصویر مدرن است که امکان فشرده‌سازی بی‌اتلاف و یا بااتلاف بهبودیافته را برای تصاویر در فضای وب فراهم می‌کند. تصاویر WebP به طور میانگین حدود ۳۰٪ کم‌حجم‌تر از معادل‌های‌شان در قالب‌های JPEG و PNG هستند که این یعنی وب‌گاه‌ها سریع‌تر شده و پهنای باند کم‌تری مصرف می‌کنند.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی بلوک اضافی</h3>\n\n\n\n<p>به عنوان قابلیتی بسط داده شده بر روی پشتیبانی بلوک پیاده‌سازی شده در وردپرس <a href=\"https://make.wordpress.org/core/2020/11/18/block-supports-in-wordpress-5-6/\">۵٫۶</a> و <a href=\"https://make.wordpress.org/core/2021/02/24/changes-to-block-editor-components-and-blocks/\">۵٬۷</a>، وردپرس ۵٫۸ چندین پرچم و گزینه پشتیبانی بلوک جدید را برای سفارشی‌سازی بلوک‌های ثبت شده معرفی می‌کند. اطلاعات بیشتر در <a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\">یادداشت توسعه پشتیبانی بلوک</a> در دسترس است.</p>\n</div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h3>\n\n\n\n<p>آخرین نگارش از راهنمای میدانی وردپرس را بررسی کنید. این یادداشت‌های توسعه‌دهنده برای هر تغییری که شاید بخواهید از آنها آگاه باشید را برجسته می‌کند. <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">راهنمای میدانی وردپرس .۵.۸</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/08/11/wp-persian-55/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2020 20:42:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=641\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:570:\"در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت. سرعت عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری نوشته‌ها و برگه‌ها سریعتر شدند. تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند. در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8171:\"\n<p>در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت.</p>\n\n\n\n<h2 class=\"wp-block-heading\">سرعت</h2>\n\n\n\n<p><strong>عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری</strong> <strong>نوشته‌ها و برگه‌ها سریعتر شدند.</strong></p>\n\n\n\n<p>تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند.</p>\n\n\n\n<p>در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل مشاهده می‌شوند، برای بارگذاری صبر می‌کنند. واژه تکنیکال آن &#8216;lazy loading&#8217; است.</p>\n\n\n\n<p>روی موبایل، لِیزی-لود می‌تواند مرورگرها را از دریافت پرونده‌های درنظرگرفته‌شده برای سایر دستگاه‌ها باز دارد. آن می‌تواند باعث صرفه‌جویی خوانندگان شما در داده شود — و کمک کند عمر باتری حفظ شود.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جستجو</h2>\n\n\n\n<p><strong>به نقشهٔ سایت جدید سلام کنید.</strong></p>\n\n\n\n<p>سایت‌های وردپرس با موتورهای جستجو به خوبی کار می‌کنند.</p>\n\n\n\n<p>اکنون، به طور پیش‌فرض، وردپرس ۵.۵ دارای یک نقشهٔ سایت XML است که به موتورهای جستجو کمک می‌کند تا از همان دقایقی آغاز کار، مهم‌ترین برگه‌های شما را کشف کنند.</p>\n\n\n\n<p>بنابراین تعداد بیشتری از افراد سایت شما را زودتر پیدا می‌کنند و به شما فرصت بیشتری می‌دهند تا مشارکت داشته باشند، آنها را حفظ نمایید و به مشترکین، مشتریان یا هر آن‌چه که با تعریف موفقیت شما مناسب باشد، تبدیل نمایید.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group has-background\" style=\"background-color:#ebcd3d\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"has-background wp-block-heading\" style=\"background-color:#ebcd3d\">امنیت</h2>\n\n\n\n<p><strong>به‌روزرسانی‌های خودکار برای افزونه‌ها و پوسته‌ها</strong></p>\n\n\n\n<p>اکنون می‌توانید افزونه‌ها و پوسته‌ها را تنظیم نمایید تا به صورت خودکار در مدیریت وردپرس به‌روزرسانی شوند — یا نه! —. بنابراین همیشه می‌دانید سایت شما آخرین کد موجود را اجرا می‌نماید.</p>\n\n\n\n<p>همچنین می‌توانید برای هر افزونه یا پوسته‌ای که نصب نموده‌اید، به‌روزرسانی‌های خودکار را روشن یا خاموش نمایید — همه در همان صفحه‌هایی که همیشه از آن‌ها استفاده شده است.</p>\n\n\n\n<p><strong>به‌روزرسانی با بارگذاری پروندهٔ ZIP</strong> <strong>شده</strong></p>\n\n\n\n<p>اگر به‌روزرسانی افزونه‌ها و پوسته‌هایتان به صورت دستی انجام می‌شود، اکنون این کار نیز ساده‌تر است — فقط یک پروندهٔ ZIP را بارگذاری نمایید.</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group has-background\" style=\"background-color:#f3ecda\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"wp-block-heading\">نکات برجسته از بلوک ویرایشگر</h2>\n\n\n\n<p>یک بار دیگر، تازه‌ترین نگارش وردپرس فهرست طولانی از ویژگی‌های جدید هیجان‌انگیز را برای ویرایشگر بلوک منتشر نمود. برای نمونه:</p>\n\n\n\n<h4 class=\"wp-block-heading\">الگوهای بلوک</h4>\n\n\n\n<p>الگوهای بلوک جدید ایجاد طرح‌های زیبا، پیچیده را با کمک ترکیبی از متن و رسانه که می‌توانید آنها را مخلوط و متناسب با داستانتان کنید، ساده و سرگرم‌کننده می‌کند.</p>\n\n\n\n<p>شما همچنین می‌توانید الگوهای بلوک را در طیف گسترده‌ای از افزونه‌ها و پوسته‌ها، با تعداد زیادی که بیشتر از همیشه اضافه شده، پیدا کنید. هر یک از آنها را از یک کشویی انتخاب کنید — فقط کلیک کنید و بروید!</p>\n\n\n\n<h4 class=\"wp-block-heading\">ویرایش تصویر توکار</h4>\n\n\n\n<p>تصاویرتان را به درستی از بلوک تصویر برش داده‌، بچرخانید، و زوم نمایید. اگر زمان زیادی را صرف تصاویر می‌نمایید، این می‌تواند در وقت شما ساعت‌ها صرفه‌جویی نماید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">پوشه بلوک جدید</h4>\n\n\n\n<p>حالا این ساده‌تر از هر زمانی است که بلوک موردنیازتان را پیدا کنید. پوشه بلوک جدید برای ویرایشگر بلوک ساخته شده، پس شما می‌توانید نوع‌های بلوک جدیدی برای سایتتان بدون خروج از ویرایشگر نصب کنید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">و خیلی بیشتر.</h4>\n\n\n\n<p>هایلایت‌های بالا بخش کوچکی از امکانات ویرایشگر بلوک جدید است که شما نصب کردید. ویرایشگر بلوک را باز کنید و لذت ببرید!</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">دسترس‌پذیری</h2>\n\n\n\n<p>هر نگارش پیشرفت‌هایی را به تجربهٔ دستر‌س‌پذیری انتشار می‌افزاید، و این دربارهٔ وردپرس ۵.۵ نیز صدق می‌کند.</p>\n\n\n\n<p>هم‌اکنون می‌توانید پیوندها را در صفحه رسانه و کادر مودال با یک دکمه، بجای تلاش برای هایلایت کردن یک خط از متن کپی کنید.</p>\n\n\n\n<p>همچنین شما می‌توانید جعبه‌های متا را با صفحه کلید حرکت دهید، و عکس‌ها را در وردپرس با دستگاه کمک‌کننده خود ویرایش کنید، همان‌گونه که این می‌تواند دستورالعمل‌های موجود را در ویرایشگر تصویر بخواند.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#ffffff\">&#8230;..</p>\n\n\n\n<h5 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h5>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵.۵ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را جلا می‌دهند، <a href=\"https://make.wordpress.org/core/wordpress-5-5-field-guide/\">راهنمای زمینه وردپرس ۵.۵</a> را بررسی نمایید.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 16 Dec 2025 10:22:37 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 06 Dec 2025 01:48:07 GMT\";s:4:\"link\";s:61:\"<https://fa.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1765923757;s:23:\"__cache_expiration_time\";i:1765923757;}", "off");
INSERT INTO `aor_options` VALUES("146", "_transient_feed_mod_9ba2df8849616f02166b8f7242d75067", "1765880557", "off");
INSERT INTO `aor_options` VALUES("157", "db_upgraded", "", "on");
INSERT INTO `aor_options` VALUES("149", "_transient_feed_813f86eb29c12d6094f1acd1445797e5", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"تیم وردپرس فارسی – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://fa.wordpress.org/team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 19:56:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61384\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"تیم وردپرس فارسی – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://fa.wordpress.org/team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"آموزش مشارکت در ترجمه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 03:50:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=222\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:650:\"مقدمه‌ای بر ترجمه وردپرس فارسی وردپرس به‌عنوان یک سیستم مدیریت محتوای متن‌باز، توسط میلیون‌ها نفر در سراسر جهان استفاده می‌شود. این سیستم با پشتیبانی از افزونه‌ها، پوسته‌ها، و ابزارهای متنوع، به کاربران این امکان را می‌دهد تا وب‌سایت‌های خود را به شکلی کاملاً شخصی‌سازی‌شده مدیریت نمایند. با وجود این امکانات، وردپرس برای کاربران غیربومی تنها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:37076:\"<h2 class=\"wp-block-heading has-medium-font-size\"><strong>مقدمه‌ای بر ترجمه وردپرس فارسی</strong></h2>\n\n\n\n<p>وردپرس به‌عنوان یک سیستم مدیریت محتوای متن‌باز، توسط میلیون‌ها نفر در سراسر جهان استفاده می‌شود. این سیستم با پشتیبانی از افزونه‌ها، پوسته‌ها، و ابزارهای متنوع، به کاربران این امکان را می‌دهد تا وب‌سایت‌های خود را به شکلی کاملاً شخصی‌سازی‌شده مدیریت نمایند. با وجود این امکانات، وردپرس برای کاربران غیربومی تنها در صورتی مفید خواهد بود که به زبان مادری آن‌ها ترجمه شود.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/wp-translate.jpg\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/team/files/2025/02/wp-translate-1024x576.jpg\" alt=\"\" class=\"wp-image-315\" style=\"width:684px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/wp-translate-1024x576.jpg 1024w, https://fa.wordpress.org/team/files/2025/02/wp-translate-300x169.jpg 300w, https://fa.wordpress.org/team/files/2025/02/wp-translate-768x432.jpg 768w, https://fa.wordpress.org/team/files/2025/02/wp-translate.jpg 1280w\" sizes=\"(max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>ترجمه وردپرس فراتر از برگردان متن‌های ساده است؛ این فرآیند شامل تطبیق مفاهیم و عملکردهای وردپرس با فرهنگ، زبان و نیازهای کاربران محلی می‌باشد. در نتیجه، تجربه کاربری بهتری برای کاربران فارسی‌زبان فراهم می‌شود.</p>\n\n\n\n<p>جامعه وردپرس به‌طور داوطلبانه و با تکیه بر همکاری‌های جهانی، فرآیند ترجمه را انجام می‌دهد. این مشارکت هم به بهبود کیفیت ترجمه‌ها کمک می‌کند و هم دسترسی کاربران به وردپرس را تسهیل می‌نماید. برای پیوستن به این جامعه مترجمان، تنها کافی است علاقه‌مند به زبان فارسی و وردپرس باشید.</p>\n\n\n\n<p>در این نوشته به آموزش ترجمه وردپرس فارسی، افزونه‌ها و پوسته‌های آن می‌پردازیم.</p>\n\n\n\n<h2 class=\"wp-block-heading has-medium-font-size\"><strong>چرا ترجمه وردپرس فارسی اهمیت دارد؟</strong></h2>\n\n\n\n<p>وردپرس به‌عنوان یکی از محبوب‌ترین سیستم‌های مدیریت محتوا در جهان، به میلیون‌ها کاربر در سراسر دنیا امکان ساخت وب‌سایت‌ها را می‌دهد. یکی از عوامل موفقیت وردپرس، <strong>انعطاف‌پذیری و جامعه گسترده‌ای</strong> است که به طور مستمر در بهبود آن مشارکت می‌نمایند.</p>\n\n\n\n<p>در این میان، ترجمه وردپرس به زبان‌های مختلف نقش کلیدی در دسترسی بهتر کاربران به این ابزار قدرتمند ایفا می‌کند. وردپرس فارسی نیز با ارائه رابط کاربری و مستندات به زبان فارسی، تجربه کاربران ایرانی را بهبود می‌بخشد. اما این دستاورد تنها به کمک <strong>مشارکت داوطلبانه جامعه مترجمان</strong> امکان‌پذیر است.</p>\n\n\n\n<p>این مقاله به شما کمک می‌کند تا با فرآیند ترجمه وردپرس فارسی آشنا شوید و بتوانید به راحتی به این پروژه جهانی بپیوندید. با مشارکت در ترجمه، نه تنها مهارت‌های خود را تقویت می‌نمایید، بلکه در ساخت ابزارهای دیجیتال برای دیگر فارسی‌زبانان نیز نقش موثری خواهید داشت.</p>\n\n\n\n<span id=\"more-222\"></span>\n\n\n\n<h2 class=\"wp-block-heading has-medium-font-size\"><strong>نحوه ثبت‌نام و ورود به سیستم ترجمه وردپرس</strong></h2>\n\n\n\n<p>برای مشارکت در ترجمه وردپرس فارسی، اولین گام ثبت‌نام و ورود به سیستم ترجمه وردپرس است. این سیستم به شما امکان می‌دهد تا به صورت آنلاین ترجمه‌ها را مشاهده، ویرایش و پیشنهادهای خود را ارسال نمایید. در ادامه، مراحل ثبت‌نام و ورود را بررسی می‌کنیم:</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱. ایجاد حساب کاربری در WordPress.org</strong></p>\n\n\n\n<p>برای مشارکت در ترجمه وردپرس، نیاز به یک حساب کاربری در وب‌سایت <a href=\"https://wordpress.org/\">WordPress.org</a> دارید. اگر هنوز حساب کاربری ندارید، مراحل زیر را دنبال نمایید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به صفحه <a href=\"https://login.wordpress.org/register?locale=fa_IR\">ثبت‌نام</a> بروید.</li>\n\n\n\n<li>نام کاربری و آدرس ایمیل خود را وارد نمایید.</li>\n\n\n\n<li>ایمیلی حاوی پیوند تأیید دریافت خواهید کرد. روی آن کلیک نمایید و رمز عبور خود را تنظیم کنید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image alignleft size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2024/12/image-1.png\"><img decoding=\"async\" width=\"589\" height=\"877\" src=\"https://fa.wordpress.org/team/files/2024/12/image-1.png\" alt=\"\" class=\"wp-image-242\" style=\"width:333px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2024/12/image-1.png 589w, https://fa.wordpress.org/team/files/2024/12/image-1-201x300.png 201w\" sizes=\"(max-width: 589px) 100vw, 589px\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2024/12/image.png\"><img decoding=\"async\" width=\"528\" height=\"815\" src=\"https://fa.wordpress.org/team/files/2024/12/image.png\" alt=\"\" class=\"wp-image-240\" style=\"width:321px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2024/12/image.png 528w, https://fa.wordpress.org/team/files/2024/12/image-194x300.png 194w\" sizes=\"(max-width: 528px) 100vw, 528px\"></a></figure>\n\n\n\n<p class=\"has-small-font-size\"></p>\n\n\n\n<p><strong>نکته مهم در مورد ثبت نام:</strong></p>\n\n\n\n<p class=\"has-light-grey-2-background-color has-background\">وردپرس در سیاست‌های ضد هرزنامه خود ثبت نام را برای همه کاربرهای جدید بسته است، به همین دلیل ایمیل تاییدیه بعد از انجام کار بالا برای شما ارسال نخواهد شد، اگر از قبل در وردپرس حساب کاربری ندارید و نیاز به حساب جدید دارید، بعد از انجام کار بالا باید یک ایمیل با ایمیل ثبت‌نامی به آدرس <a href=\"mailto:forum-password-resets@wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">forum-password-resets@wordpress.org</a> ارسال کنید و در متن ایمیل (به انگلیسی) توضیح بدید که برای چی نیاز دارید که حساب کاربری جدید بسازید. بعد از مکاتبه با وردپرس و طی کردن این مرحله حساب شما فعال خواهد شد.</p>\n\n\n\n<div style=\"height:27px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. ورود به سیستم ترجمه</strong></p>\n\n\n\n<p>پس از ایجاد حساب کاربری، می‌توانید به سیستم ترجمه وردپرس دسترسی پیدا نمایید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به صفحه <a href=\"https://translate.wordpress.org/locale/fa/\">ورود وردپرس</a> بروید. با استفاده از اطلاعات حساب کاربری خود، وارد سیستم شوید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-1.png\"><img loading=\"lazy\" decoding=\"async\" width=\"548\" height=\"799\" src=\"https://fa.wordpress.org/team/files/2025/02/image-1.png\" alt=\"\" class=\"wp-image-260\" style=\"width:366px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-1.png 548w, https://fa.wordpress.org/team/files/2025/02/image-1-206x300.png 206w\" sizes=\"auto, (max-width: 548px) 100vw, 548px\"></a></figure>\n\n\n\n<p></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ورود، می‌توانید پروژه‌های ترجمه فعال را مشاهده و پروژه مورد نظر خود را انتخاب نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. شروع به مشارکت در ترجمه</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ورود به سیستم، به بخش <a href=\"https://translate.wordpress.org/locale/fa/\">زبان فارسی</a> بروید.</li>\n\n\n\n<li>یک پروژه، افزونه یا پوسته را انتخاب نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"362\" src=\"https://fa.wordpress.org/team/files/2025/02/image-1024x362.png\" alt=\"\" class=\"wp-image-258\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-1024x362.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-300x106.png 300w, https://fa.wordpress.org/team/files/2025/02/image-768x271.png 768w, https://fa.wordpress.org/team/files/2025/02/image-1536x543.png 1536w, https://fa.wordpress.org/team/files/2025/02/image.png 1868w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>بعد از ورود به پروژه بخش‌ها و رشته‌های قابل ترجمه مشخص است. زیر پروژه <strong>Stable (latest release)</strong> در این بخش دارای اولویت بالاتری برای ترجمه است و از اینجا شروع می‌کنیم.<br></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-2.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"154\" src=\"https://fa.wordpress.org/team/files/2025/02/image-2-1024x154.png\" alt=\"\" class=\"wp-image-265\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-2-1024x154.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-2-300x45.png 300w, https://fa.wordpress.org/team/files/2025/02/image-2-768x116.png 768w, https://fa.wordpress.org/team/files/2025/02/image-2-1536x231.png 1536w, https://fa.wordpress.org/team/files/2025/02/image-2.png 1866w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>با باز کردن هر رشته می‌توانید پیشنهادهای ترجمه خود را ارسال نمایید یا ترجمه‌های موجود را بازبینی و اصلاح نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-3.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"585\" src=\"https://fa.wordpress.org/team/files/2025/02/image-3-1024x585.png\" alt=\"\" class=\"wp-image-267\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-3-1024x585.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-3-300x171.png 300w, https://fa.wordpress.org/team/files/2025/02/image-3-768x439.png 768w, https://fa.wordpress.org/team/files/2025/02/image-3.png 1122w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"><strong>نکته:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ارسال ترجمه، مدیران پروژه یا مترجمان ارشد ترجمه‌های شما را بررسی و تأیید می‌نمایند. با افزایش مشارکت و دقت در ترجمه‌ها، می‌توانید به یکی از اعضای فعال جامعه مترجمان وردپرس تبدیل شوید.</li>\n\n\n\n<li><strong>بخش‌های مختلف وردپرس از نظر حساسیت ترجمه اولویت‌بندی دارند.</strong> اگر تازه‌کار هستید، بهتر است ابتدا ترجمه افزونه‌ها را انجام دهید. ترجمه هسته وردپرس بیشترین حساسیت را دارد و نیازمند دقت، تجربه و آشنایی بیشتر با استانداردهای ترجمه است.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>نکات ترجمه صحیح در وردپرس و تایید شدن آن‌ها</strong></h2>\n\n\n\n<p>ترجمه وردپرس نه‌تنها به برگرداندن متن‌ها از زبان اصلی به فارسی محدود می‌شود، بلکه شامل ارائه ترجمه‌هایی است که مفهوم، کاربردپذیری، و تجربه کاربری مناسبی داشته باشند. در ادامه، نکات عملی برای داشتن ترجمه‌های صحیح و مؤثر ارائه شده است که رعایت آن‌ها واجب و ضروری است:</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱. استفاده و پیروی از واژه‌نامه وردپرس (WordPress Glossary)</strong></p>\n\n\n\n<p>واژه‌نامه ترجمه وردپرس (Glossary) یک ابزار کلیدی برای مترجمان است. با استفاده از این واژه‌نامه می‌توانید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از معادل‌های رسمی و استاندارد استفاده نمایید.</li>\n\n\n\n<li>یکپارچگی ترجمه‌ها را تضمین کنید.</li>\n</ul>\n\n\n\n<p>واژه‌نامه وردپرس شامل اصطلاحات رایج و استانداردهایی است که در ترجمه‌ها استفاده می‌شوند. این ابزار کمک می‌نماید تا ترجمه‌ها یکپارچگی بیشتری داشته باشند.<br>برای مشاهده واژه‌نامه، می‌توانید به بخش “<a href=\"https://translate.wordpress.org/locale/fa/default/glossary/\">WordPress Translation Glossary</a>” مراجعه نمایید.</p>\n\n\n\n<p>این واژه‌نامه به صورت تصویر زیر شمارو هنگام ترجمه همراهی و کمک می‌کند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-4.png\"><img loading=\"lazy\" decoding=\"async\" width=\"511\" height=\"414\" src=\"https://fa.wordpress.org/team/files/2025/02/image-4.png\" alt=\"\" class=\"wp-image-271\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-4.png 511w, https://fa.wordpress.org/team/files/2025/02/image-4-300x243.png 300w\" sizes=\"auto, (max-width: 511px) 100vw, 511px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. مفهوم را به جای متن ترجمه نمایید</strong></p>\n\n\n\n<p>در ترجمه، به اصل متن پایبند باشید اما تمرکز شما باید بر انتقال صحیح مفهوم باشد، بسیاری از اصطلاحات وردپرس نیاز به تطبیق با فرهنگ و زبان فارسی دارند. متن را به دلخواه تغییر ندهید و سلیقه خود را در ترجمه لحاظ نکنید.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به جای ترجمه کلمه‌به‌کلمه “Custom Post Type”، می‌توانید از عبارت “نوع نوشته سفارشی” استفاده نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. به سازگاری و یکنواختی پایبند باشید</strong></p>\n\n\n\n<p>برای ایجاد تجربه کاربری بهتر، لازم است در تمام ترجمه‌ها از واژه‌ها و عبارات یکسان استفاده نمایید. استفاده از واژه‌نامه وردپرس و بررسی ترجمه‌های تأییدشده دیگر می‌تواند کمک زیادی کند.</p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. به اصول نگارشی فارسی توجه نمایید</strong></p>\n\n\n\n<p>رعایت اصول نگارشی، مانند استفاده از نیم‌فاصله، نشانه‌گذاری مناسب، و دستور زبان فارسی، تأثیر زیادی بر کیفیت ترجمه خواهد داشت.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به جای “این ابزار می تواند” از “این ابزار می‌تواند” استفاده نمایید.</li>\n\n\n\n<li>در ترجمه حتماً از نیم‌فاصله در جای درست استفاده نمایید. کلماتی مانند “پوسته‌ ها” و “بلوک‌ ها” که بدون نیم‌فاصله نوشته شوند، تأیید نخواهند شد.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. از صفحه‌کلید فارسی و استاندارد استفاده نمایید.</strong><br>وجود کاراکترهای غیراستاندارد مانند “ي” و “ك” در ترجمه باعث رد شدن آن خواهد شد.</p>\n\n\n\n<p>از “هٔ” (ی کوچک) به‌درستی استفاده نمایید. در کلماتی مانند “صفحهٔ قبلی” حتماً از “ٔ” استفاده شود. این کاراکتر با “ه همزه‌دار” یا “همزه” متفاوت است و در صفحه‌کلید استاندارد با کلید Shift + N نوشته می‌شود.</p>\n\n\n\n<p>در انجام ترجمه با موبایل حتما دقت کنید که صفحه‌کلید شما فارسی باشد. (در سیستم عامل ios معمولا صفحه‌کلید عربی است)</p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۶. سازگاری با متن اصلی را حفظ نمایید</strong></p>\n\n\n\n<p>ترجمه باید با متن اصلی از نظر ساختار و مفهوم همخوانی داشته باشد. به ویژه در مواردی که رشته‌های ترجمه متغیر یا کد دارند، باید آن‌ها را دقیقاً به همان شکل در ترجمه حفظ نمایید.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>“Welcome, %s!” به شکل “خوش آمدید، %s!” ترجمه شود.</li>\n\n\n\n<li><strong>علائم خاص مانند (%s) را دقیقاً مطابق با متن اصلی ترجمه نمایید.</strong> تمامی علائم و کاراکترهای ویژه باید دقیقاً همان‌طور که در متن اصلی آمده‌اند، در ترجمه نیز قرار گیرند.</li>\n\n\n\n<li>به‌عنوان‌مثال، نباید علامت “%” را به “٪” تغییر دهید. همچنین علائمی مانند کاما (،)، درصد (%)، هش (#)، و (&amp;) و تگ‌های HTML باید بدون تغییر باقی بمانند.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۷. از ترجمه ماشینی استفاده نکنید</strong></p>\n\n\n\n<p>ابزارهای ترجمه ماشینی می‌توانند به سرعت کار شما کمک کنند، اما همواره باید بازبینی و اصلاح شوند. این ابزارها معمولاً مفهوم یا سبک متن را به درستی درک نمی‌کنند. ترجمه‌های مستقیم ماشینی تایید نمی‌شوند.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۸. به بخش پیشنهادها توجه نمایید</strong></p>\n\n\n\n<p>به بخش پیشنهادها توجه نمایید، اما به آن کاملاً اعتماد نکنید. این بخش بر اساس حافظه ترجمه، پیشنهادهایی ارائه می‌دهد. اگر در حال ترجمه افزونه هستید، ممکن است این پیشنهادات کمک‌کننده باشند، اما برای ترجمه خود وردپرس باید دقت نمایید که پیشنهاد ارائه‌شده از هسته وردپرس باشد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-5.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"593\" src=\"https://fa.wordpress.org/team/files/2025/02/image-5-1024x593.png\" alt=\"\" class=\"wp-image-272\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-5-1024x593.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-5-300x174.png 300w, https://fa.wordpress.org/team/files/2025/02/image-5-768x445.png 768w, https://fa.wordpress.org/team/files/2025/02/image-5.png 1152w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۹. از بازبینی نهایی غافل نشوید</strong></p>\n\n\n\n<p>قبل از ارسال ترجمه، حتماً آن را بازبینی نمایید تا از صحت ترجمه، اصول نگارشی و روان بودن متن مطمئن شوید.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱۰. با جامعه مترجمان همکاری نمایید</strong></p>\n\n\n\n<p>یکی از مزایای ترجمه وردپرس، همکاری با جامعه‌ای از مترجمان است. از بازخوردهای دیگر مترجمان استفاده نمایید و در صورت شک، از آن‌ها سؤال کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://t.me/wpdevelopers\">عضویت در گروه تلگرام مترجمان</a></div>\n</div>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱۱. آزمایش و بررسی ترجمه در عمل</strong></p>\n\n\n\n<p>ترجمه‌ها را روی محیط وردپرس آزمایش کنید تا از مناسب بودن آن‌ها در محیط کاربری مطمئن شوید. این کار به شما کمک می‌کند تا خطاها و مشکلات احتمالی را پیش از تأیید نهایی برطرف نمایید. ابزارهایی مانند <a>Loco Translate</a> یا بخش <a href=\"https://translate.wordpress.org/locale/fa/default/wp-plugins/\">ویرایش زنده</a> GlotPress در بخش افزونه‌ها به شما این امکان را می‌دهند.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-6.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"360\" src=\"https://fa.wordpress.org/team/files/2025/02/image-6-1024x360.png\" alt=\"\" class=\"wp-image-279\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-6-1024x360.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-6-300x105.png 300w, https://fa.wordpress.org/team/files/2025/02/image-6-768x270.png 768w, https://fa.wordpress.org/team/files/2025/02/image-6-1536x540.png 1536w, https://fa.wordpress.org/team/files/2025/02/image-6.png 1900w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>با رعایت این نکات، می‌توانید ترجمه‌های باکیفیتی ارائه دهید که تجربه کاربران فارسی‌زبان وردپرس را بهبود بخشد و به گسترش این پلتفرم کمک نماید.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">چالش‌های رایج در ترجمه وردپرس و راه‌حل‌ها</h3>\n\n\n\n<p>در فرآیند ترجمه وردپرس، ممکن است با چالش‌هایی روبه‌رو شوید که کیفیت و سرعت ترجمه را تحت تأثیر قرار دهند. شناخت این چالش‌ها و راه‌حل‌های مناسب، به شما کمک می‌نماید تا فرآیند ترجمه را بهینه‌تر انجام دهید. در ادامه، به برخی از رایج‌ترین چالش‌ها و راهکارهای پیشنهادی پرداخته‌ایم:</p>\n\n\n\n<p class=\"has-charcoal-0-color has-text-color has-link-color has-normal-font-size wp-elements-79296ebdfacd39b15d4f8cd584f1f73f\"><strong>۱. ابهام در پذیرش ترجمه‌ها و تایید نشدن آن‌ها</strong></p>\n\n\n\n<p>گاهی پیشنهادهای ترجمه شما مدت زیادی منتظر تأیید می‌مانند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>با مدیران ترجمه پروژه از طریق گروه تلگرام در ارتباط باشید و از آن‌ها برای بازبینی درخواست نمایید.</li>\n\n\n\n<li>وضعیت‌های ترجمه خود را بررسی نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-7.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"131\" src=\"https://fa.wordpress.org/team/files/2025/02/image-7-1024x131.png\" alt=\"\" class=\"wp-image-280\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-7-1024x131.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-7-300x38.png 300w, https://fa.wordpress.org/team/files/2025/02/image-7-768x98.png 768w, https://fa.wordpress.org/team/files/2025/02/image-7.png 1318w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>ممکن است ترجمه شما توسط مدیران در بخش Fuzzy یا Changes requested قرار گرفته باشد. این حالت یعنی ترجمه شما ایرادی داشته و تایید نشده است و ویرایشگر مربوطه آن را برای تغییر و اصلاح به خود شما ارجاع داده است. پیشنهاد ترجمه اصلاح شده شما بعد از ارسال مجدد بررسی می‌شود.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>به قسمت بحث‌ها (Disscussion) توجه کنید.</strong></li>\n</ul>\n\n\n\n<p>در بخش Disscussion که در سمت راست ترجمه هر رشته در دسترس است ممکن است دیدگاهی از طرف مدیر یا ویرایشگر آن پروژه برای شما ارسال شده باشد. در این بخش می‌توانید به تبادل نظر و گفتگو بپردازید.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-8.png\"><img loading=\"lazy\" decoding=\"async\" width=\"753\" height=\"526\" src=\"https://fa.wordpress.org/team/files/2025/02/image-8.png\" alt=\"\" class=\"wp-image-288\" style=\"width:593px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-8.png 753w, https://fa.wordpress.org/team/files/2025/02/image-8-300x210.png 300w\" sizes=\"auto, (max-width: 753px) 100vw, 753px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>اگر مشارکت شما ادامه‌دار و مؤثر باشد، می‌توانید به عضویت تیم مترجمان ارشد درآیید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. عبارات فنی و نامفهوم</strong></p>\n\n\n\n<p>عبارات فنی یا کدها در متن اصلی ممکن است باعث سردرگمی شوند، به‌ویژه اگر با اصطلاحات برنامه‌نویسی آشنایی کافی نداشته باشید.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از واژه‌نامه‌ وردپرس استفاده نمایید.</li>\n\n\n\n<li>اگر عبارت کاملاً نامفهوم است، با جامعه مترجمان مشورت کنید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. رعایت استانداردهای نگارشی</strong></p>\n\n\n\n<p>رعایت نیم‌فاصله، نقطه‌گذاری و سایر استانداردهای نگارشی ممکن است در طول ترجمه فراموش شود.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از ابزارهای ویرایش متن با قابلیت بررسی نگارشی (مانند ویراستیار) استفاده نمایید.</li>\n\n\n\n<li>پیش از ارسال، متن ترجمه‌شده را بازبینی نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. واژه‌های بدون معادل فارسی مناسب</strong></p>\n\n\n\n<p>برخی از واژه‌ها، مانند اصطلاحات تخصصی یا مفاهیم نوین، معادل دقیقی در فارسی ندارند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از معادل‌های جاافتاده در واژه‌نامه وردپرس استفاده نمایید.</li>\n\n\n\n<li>اگر معادل مناسبی وجود ندارد، توضیح ساده و روانی ارائه دهید که برای کاربران قابل درک باشد.</li>\n\n\n\n<li>با مدیران ترجمه در میان بگذارید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. طولانی بودن برخی رشته‌ها</strong></p>\n\n\n\n<p>رشته‌هایی که بیش از حد طولانی هستند ممکن است خوانایی را کاهش دهند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>ترجمه را به بخش‌های کوتاه‌تر تقسیم کنید تا خوانایی افزایش یابد.</li>\n\n\n\n<li>از جملات روان و ساده استفاده نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۶. تداخل با ترجمه‌های دیگر</strong></p>\n\n\n\n<p>ممکن است چند نفر روی یک پروژه کار کنند و ترجمه‌ها با یکدیگر ناسازگار باشند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از ابتدا واژه‌نامه‌ها و استانداردهای پروژه را مرور کنید.</li>\n\n\n\n<li>همکاری و تعامل با دیگر مترجمان را جدی بگیرید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۷. مدیریت زمان و حجم کار</strong></p>\n\n\n\n<p>پروژه‌های بزرگ مانند ترجمه هسته وردپرس یا افزونه‌های معروف ممکن است زمان زیادی ببرند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>ابتدا روی رشته‌های مهم‌تر و پرکاربردتر تمرکز نمایید.</li>\n\n\n\n<li>فقط رشته‌های کوتاه و تک کلمه‌ای رو ترجمه نکنید.</li>\n\n\n\n<li>مشارکت را به‌صورت تیمی انجام دهید تا بار کار تقسیم شود.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>نکات نهایی ترجمه وردپرس فارسی</strong></h3>\n\n\n\n<p><strong>۱. پایبندی به زبان فارسی</strong></p>\n\n\n\n<p>تحت هیچ شرایطی در ترجمه از کلمات انگلیسی یا فینگلیش استفاده نکنید. فارسی نوشتن کلمه انگلیسی (مثال: پست‌تایپ) مجاز نیست.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. ساده‌نویسی و روان‌نویسی</strong></p>\n\n\n\n<p>از کلمات پیچیده و جملات طولانی پرهیز نمایید. سادگی و روانی ترجمه، تجربه کاربری بهتری برای مخاطبان فراهم می‌کند.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. تنظیم طول متن‌ها</strong></p>\n\n\n\n<p>ترجمه‌ها باید از نظر طول با متن اصلی هماهنگ باشند. این موضوع به‌ویژه در مواردی که فضا محدود است، مانند دکمه‌ها یا منوها، اهمیت دارد.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. همکاری با دیگر مترجمان</strong></p>\n\n\n\n<p>با دیگر مترجمان در پروژه‌ها همکاری نمایید و از بازخورد آن‌ها برای بهبود کار خود استفاده کنید. همچنین می‌توانید ترجمه‌های پیشنهادی آن‌ها را مطالعه و ایده بگیرید.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. استفاده از قابلیت‌های GlotPress</strong></p>\n\n\n\n<p>در پلتفرم ترجمه وردپرس (GlotPress)، قابلیت‌هایی وجود دارد که می‌توانند کار شما را آسان‌تر نمایند:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>فیلتر رشته‌ها</strong>: برای تمرکز روی ترجمه‌های ناقص یا رشته‌های خاص.</li>\n\n\n\n<li><strong>حالت جستجو</strong>: برای یافتن کلمات یا عبارات خاص در تمام پروژه.</li>\n</ul>\n\n\n\n<p><strong>۶. ابزارهای کمکی آنلاین</strong></p>\n\n\n\n<p>برای بهبود کیفیت ترجمه، می‌توانید از ابزارهای آنلاین مانند Google Translate، DeepL یا <a href=\"https://targoman.ir/\">ترگمان</a> استفاده نمایید. این ابزارها به‌ویژه در ارائه ترجمه اولیه رشته‌های طولانی مفید هستند، اما باید توجه داشته باشید که ترجمه‌ها نیاز به بازبینی و اصلاح و جایگزینی با واژه‌نامه را دارند تا با استانداردهای وردپرس مطابقت داشته باشند.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>پایان: گامی در جهت بهبود وردپرس فارسی</strong></h3>\n\n\n\n<p>مشارکت در ترجمه وردپرس فارسی نه تنها فرصتی برای یادگیری و ارتقای مهارت‌های زبانی و فنی شماست، بلکه اقدامی ارزشمند برای بهبود تجربه کاربری میلیون‌ها کاربر فارسی‌زبان به‌شمار می‌رود. ترجمه باکیفیت و استاندارد، استفاده از وردپرس را ساده‌تر و لذت‌بخش‌تر می‌نماید و جامعه‌ای قوی‌تر و پویا‌تر ایجاد می‌کند.</p>\n\n\n\n<p>در این مقاله، با مراحل مختلف مشارکت در ترجمه، ابزارهای مورد نیاز، چالش‌ها و راهکارها آشنا شدید. هر یک از شما می‌توانید با اختصاص زمان و استفاده از راهنمایی‌های ارائه‌شده، تأثیری مثبت و ماندگار در این پروژه جهانی داشته باشید.</p>\n\n\n\n<p>اگر شما هم به وردپرس علاقه دارید، اکنون زمان مناسبی برای شروع مشارکت است. با ثبت‌نام در بخش ترجمه و همکاری با دیگر اعضای جامعه مترجمان، به یکی از ستون‌های اصلی در توسعه و پیشرفت وردپرس فارسی تبدیل شوید.</p>\n\n\n\n<p>با همکاری، تعهد و تلاش جمعی، می‌توانیم وردپرس فارسی را به سطحی جدید برسانیم و به کاربران بیشتری کمک کنیم تا از این ابزار قدرتمند به ساده‌ترین و بهترین شکل ممکن بهره‌مند شوند.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>این نوشته به مرور به‌روز خواهد شد و موارد و نکات جدیدتر به آن اضافه خواهد شد.</p>\n\n\n\n<p><strong>در صورت داشتن سؤال یا نیاز به راهنمایی، از بخش دیدگاه‌ها استفاده نمایید و پرسش خود را در اینجا مطرح کنید تا راهنمایی لازم دریافت نمایید.</strong></p>\n</blockquote>\n\n\n<div class=\"wp-block-post-author has-large-font-size\"><div class=\"wp-block-post-author__avatar\"><img alt=\"\" src=\"https://secure.gravatar.com/avatar/205c7baf65283c61a8c0a6b6559680fda83297a11c809ec031f5200073e65e0d?s=96&amp;d=mm&amp;r=g\" srcset=\"https://secure.gravatar.com/avatar/205c7baf65283c61a8c0a6b6559680fda83297a11c809ec031f5200073e65e0d?s=192&amp;d=mm&amp;r=g 2x\" class=\"avatar avatar-96 photo\" height=\"96\" width=\"96\"></div><div class=\"wp-block-post-author__content\"><p class=\"wp-block-post-author__byline\">نوشته شده توسط سعید فرد از وردپرس فارسی</p><p class=\"wp-block-post-author__name\"><a href=\"https://profiles.wordpress.org/saeedfard/\" target=\"_self\">Saeed Fard</a></p></div></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"پیوستن به گروه مترجمین و توسعه دهندگان وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 21 Apr 2024 16:51:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=201\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:605:\"با درود،با توجه به محدودیت‌هایی که در Slack برای کاربران ایرانی وجود دارد، تیم وردپرس فارسی، از تلگرام برای هماهنگی و ارتباط تیم استفاده می‌کند. لذا از تمامی مترجمین و توسعه دهندگان فارسی، درخواست می‌شود تا در گروه تلگرامی “توسعه دهندگان وردپرس فارسی” به آدرس زیر: https://t.me/wpdevelopers و همچنین کانال مربوطه به آدرس: https://t.me/fa_wordpress عضو [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:22925:\"<p>با درود،<br>با توجه به محدودیت‌هایی که در Slack برای کاربران ایرانی وجود دارد، تیم وردپرس فارسی، از تلگرام برای هماهنگی و ارتباط تیم استفاده می‌کند. لذا از تمامی مترجمین و توسعه دهندگان فارسی، درخواست می‌شود تا در گروه تلگرامی “توسعه دهندگان وردپرس فارسی” به آدرس زیر:</p>\n\n\n\n<p class=\"has-text-align-center\"><a href=\"https://t.me/wpdevelopers\">https://t.me/wpdevelopers</a></p>\n\n\n\n<p>و همچنین کانال مربوطه به آدرس:</p>\n\n\n\n<p class=\"has-text-align-center\"><a href=\"https://t.me/fa_wordpress\">https://t.me/fa_wordpress</a></p>\n\n\n\n<p>عضو شوند تا هماهنگی‌های لازم برای ترجمه‌ها و توسعه‌ها، صورت پذیرد. ضمنا جهت ارتباط بهتر و پیگیری‌های مورد نیاز، لطفا در زیرگروه “معرفی مترجمین”، <strong>ایمیل مربوط به حساب کاربری وردپرس</strong> خود و <strong>شناسه تلگرام</strong> خود را اعلام نمایید تا ارتباط بهتر و سریعتری برای موارد مورد نیاز صورت پذیرد.</p>\n\n\n\n<p>با سپاس</p>\n\n\n\n<p dir=\"ltr\"><a href=\"https://profiles.wordpress.org/farhad0/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farhad0</a> <a href=\"https://profiles.wordpress.org/man4toman/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>man4toman</a> <a href=\"https://profiles.wordpress.org/saeedfard/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>SaeedFard</a> <a href=\"https://profiles.wordpress.org/sushyant/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sushyant</a> <a href=\"https://profiles.wordpress.org/asadiy4n/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>asadiy4n</a> <a href=\"https://profiles.wordpress.org/cg-team/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>CG-TEAM</a> <a href=\"https://profiles.wordpress.org/1farakav/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>1farakav</a> <a href=\"https://profiles.wordpress.org/ach1992/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ach1992</a> <a href=\"https://profiles.wordpress.org/aminfa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aminfa</a> <a href=\"https://profiles.wordpress.org/hadi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hadi</a>.omid <a href=\"https://profiles.wordpress.org/yazdaniwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yazdaniwp</a> <a href=\"https://profiles.wordpress.org/aminomidi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aminomidi</a> <a href=\"https://profiles.wordpress.org/360messenger/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>360messenger</a> <a href=\"https://profiles.wordpress.org/addeveloper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>addeveloper</a> <a href=\"https://profiles.wordpress.org/affiliatenetworks/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>affiliatenetworks</a> <a href=\"https://profiles.wordpress.org/ahangarha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ahangarha</a> <a href=\"https://profiles.wordpress.org/aliarjini/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aliarjini</a> <a href=\"https://profiles.wordpress.org/aliasghar1112/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aliasghar1112</a> <a href=\"https://profiles.wordpress.org/aligholami/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aligholami</a> <a href=\"https://profiles.wordpress.org/alirashidnahal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alirashidnahal</a> <a href=\"https://profiles.wordpress.org/alixo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alixo</a> <a href=\"https://profiles.wordpress.org/alizadegan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alizadegan</a> <a href=\"https://profiles.wordpress.org/amatris/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amatris</a> <a href=\"https://profiles.wordpress.org/ameskaran/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ameskaran</a> <a href=\"https://profiles.wordpress.org/amirarshia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirarshia</a> <a href=\"https://profiles.wordpress.org/amirhosseinhpv/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirhosseinhpv</a> <a href=\"https://profiles.wordpress.org/amirhpcom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirhpcom</a> <a href=\"https://profiles.wordpress.org/antialiasfactory/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>antialiasfactory</a> <a href=\"https://profiles.wordpress.org/ardalan13/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ardalan13</a> <a href=\"https://profiles.wordpress.org/ariankeshavarz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ariankeshavarz</a> <a href=\"https://profiles.wordpress.org/armansiahloo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>armansiahloo</a> <a href=\"https://profiles.wordpress.org/armenab1/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>armenab1</a> <a href=\"https://profiles.wordpress.org/arshen/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Arshen</a> <a href=\"https://profiles.wordpress.org/arvancloud/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>arvancloud</a> <a href=\"https://profiles.wordpress.org/as911/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>as911</a> <a href=\"https://profiles.wordpress.org/asterids/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>asterids</a> <a href=\"https://profiles.wordpress.org/aydin714/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aydin714</a> <a href=\"https://profiles.wordpress.org/basemax/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>basemax</a> <a href=\"https://profiles.wordpress.org/bbkysf/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bbkysf</a> <a href=\"https://profiles.wordpress.org/blackswanlab/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>blackswanlab</a> <a href=\"https://profiles.wordpress.org/bmoudi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bmoudi</a> <a href=\"https://profiles.wordpress.org/chilisearch/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chilisearch</a> <a href=\"https://profiles.wordpress.org/dedidata/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dedidata</a> <a href=\"https://profiles.wordpress.org/digikotcom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>digikotcom</a> <a href=\"https://profiles.wordpress.org/djamir121/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>djamir121</a> <a href=\"https://profiles.wordpress.org/domiinodev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>domiinodev</a> <a href=\"https://profiles.wordpress.org/ebrahimzadeh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ebrahimzadeh</a> <a href=\"https://profiles.wordpress.org/ee_persian/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ee_persian</a> <a href=\"https://profiles.wordpress.org/elementorir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>elementorir</a> <a href=\"https://profiles.wordpress.org/ercmanager1/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ercmanager1</a> <a href=\"https://profiles.wordpress.org/esmailfadaei/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>esmailfadaei</a> <a href=\"https://profiles.wordpress.org/farokhheidari/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farokhheidari</a> <a href=\"https://profiles.wordpress.org/farshadhz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farshadhz</a> <a href=\"https://profiles.wordpress.org/feredi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>feredi</a> <a href=\"https://profiles.wordpress.org/foadadeli/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>foadadeli</a> <a href=\"https://profiles.wordpress.org/gamefa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>gamefa</a> <a href=\"https://profiles.wordpress.org/ghasemi71ir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ghasemi71ir</a> <a href=\"https://profiles.wordpress.org/ghtali/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ghtali</a> <a href=\"https://profiles.wordpress.org/glboy/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>glboy</a> <a href=\"https://profiles.wordpress.org/goudarz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Goudarz</a> <a href=\"https://profiles.wordpress.org/h71/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>h71</a> <a href=\"https://profiles.wordpress.org/ham3da/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ham3da</a> <a href=\"https://profiles.wordpress.org/hanieh729/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hanieh729</a> <a href=\"https://profiles.wordpress.org/hassantafreshi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hassantafreshi</a> <a href=\"https://profiles.wordpress.org/hitsteps/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hitsteps</a> <a href=\"https://profiles.wordpress.org/hosseinsadeghi69/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hosseinsadeghi69</a> <a href=\"https://profiles.wordpress.org/hsnshfn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hsnshfn</a> <a href=\"https://profiles.wordpress.org/imikiani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>imikiani</a> <a href=\"https://profiles.wordpress.org/infomtaghavi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>infomtaghavi</a> <a href=\"https://profiles.wordpress.org/irangold/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>irangold</a> <a href=\"https://profiles.wordpress.org/irdb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>irdb</a> <a href=\"https://profiles.wordpress.org/johnbozorgi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>johnbozorgi</a> <a href=\"https://profiles.wordpress.org/kafrashi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kafrashi</a> <a href=\"https://profiles.wordpress.org/kamalireal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kamalireal</a> <a href=\"https://profiles.wordpress.org/kamrankhorsandi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kamrankhorsandi</a> <a href=\"https://profiles.wordpress.org/kashani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kashani</a> <a href=\"https://profiles.wordpress.org/khorshidlab/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>khorshidlab</a> <a href=\"https://profiles.wordpress.org/longman2020/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>longman2020</a> <a href=\"https://profiles.wordpress.org/lord_viper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lord_viper</a> <a href=\"https://profiles.wordpress.org/lusha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lusha</a> <a href=\"https://profiles.wordpress.org/m0911/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>m0911</a> <a href=\"https://profiles.wordpress.org/mahdi6489/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdi6489</a> <a href=\"https://profiles.wordpress.org/mahdiebrahimii/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdiebrahimii</a> <a href=\"https://profiles.wordpress.org/mahdiyerezaie/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdiyerezaie</a> <a href=\"https://profiles.wordpress.org/mahdyarme/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdyarme</a> <a href=\"https://profiles.wordpress.org/mainseo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mainseo</a> @manzoorwani.jk <a href=\"https://profiles.wordpress.org/mashhadcode/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mashhadcode</a> <a href=\"https://profiles.wordpress.org/masoudnkh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>masoudnkh</a> <a href=\"https://profiles.wordpress.org/matinbeigi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matinbeigi</a> <a href=\"https://profiles.wordpress.org/mazraee/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mazraee</a> <a href=\"https://profiles.wordpress.org/mehdibolourian/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehdibolourian</a> <a href=\"https://profiles.wordpress.org/mehr/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Mehr</a>.Ban <a href=\"https://profiles.wordpress.org/mehrshad81/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehrshad81</a> <a href=\"https://profiles.wordpress.org/mehrshaddarzi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehrshaddarzi</a> <a href=\"https://profiles.wordpress.org/mhmanavi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mhmanavi</a> <a href=\"https://profiles.wordpress.org/michaelpk/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michaelpk</a> <a href=\"https://profiles.wordpress.org/mihanwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mihanwp</a> <a href=\"https://profiles.wordpress.org/milad47/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Milad47</a> <a href=\"https://profiles.wordpress.org/mo0orteza/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Mo0orTeZa</a> <a href=\"https://profiles.wordpress.org/moccc/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>moccc</a> <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohadeseghasemi</a> <a href=\"https://profiles.wordpress.org/mohammad9574/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohammad9574</a> <a href=\"https://profiles.wordpress.org/mohammadhero/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohammadhero</a> <a href=\"https://profiles.wordpress.org/mohsengham/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohsengham</a> <a href=\"https://profiles.wordpress.org/mohsenpazhoohiyani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohsenpazhoohiyani</a> <a href=\"https://profiles.wordpress.org/mojtaba-taheri/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mojtaba-taheri</a> <a href=\"https://profiles.wordpress.org/mojtabad/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mojtabad</a> <a href=\"https://profiles.wordpress.org/moreconvert/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>moreconvert</a> <a href=\"https://profiles.wordpress.org/mostafa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mostafa</a>.s1990 <a href=\"https://profiles.wordpress.org/mostafarouz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mostafarouz</a> <a href=\"https://profiles.wordpress.org/motefaghehi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>motefaghehi</a> <a href=\"https://profiles.wordpress.org/motlaqcode/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>motlaqcode</a> <a href=\"https://profiles.wordpress.org/mralidoosti/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mralidoosti</a> <a href=\"https://profiles.wordpress.org/msn6060/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>msn6060</a> <a href=\"https://profiles.wordpress.org/msninsider/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>msninsider</a> <a href=\"https://profiles.wordpress.org/narimonfund/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>narimonfund</a> <a href=\"https://profiles.wordpress.org/native0098/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>native0098</a> <a href=\"https://profiles.wordpress.org/navidos/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>navidos</a> <a href=\"https://profiles.wordpress.org/niloomand/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>niloomand</a> <a href=\"https://profiles.wordpress.org/nima78600/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nima78600</a> <a href=\"https://profiles.wordpress.org/nirweb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nirweb</a> <a href=\"https://profiles.wordpress.org/novinhub/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>novinhub</a> <a href=\"https://profiles.wordpress.org/otoraby/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>otoraby</a> <a href=\"https://profiles.wordpress.org/parnibraan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parnibraan</a> <a href=\"https://profiles.wordpress.org/parselearn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parselearn</a> <a href=\"https://profiles.wordpress.org/parsmizban/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parsmizban</a> <a href=\"https://profiles.wordpress.org/pash2048/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pash2048</a> <a href=\"https://profiles.wordpress.org/payzito/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>payzito</a> @pctricks.ir <a href=\"https://profiles.wordpress.org/pedramrahimi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pedramrahimi</a> <a href=\"https://profiles.wordpress.org/pegahnorozi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pegahnorozi</a> <a href=\"https://profiles.wordpress.org/peprodev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>peprodev</a> <a href=\"https://profiles.wordpress.org/persianscript/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Persianscript</a> <a href=\"https://profiles.wordpress.org/piman/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>piman</a> <a href=\"https://profiles.wordpress.org/pingmeter/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pingmeter</a> <a href=\"https://profiles.wordpress.org/poolito/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>poolito</a> <a href=\"https://profiles.wordpress.org/porsline/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>porsline</a> <a href=\"https://profiles.wordpress.org/poshtibancom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>poshtibancom</a> <a href=\"https://profiles.wordpress.org/qodeinteractive/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>qodeinteractive</a> <a href=\"https://profiles.wordpress.org/qwerty13/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>qwerty13</a> <a href=\"https://profiles.wordpress.org/rahmatmajidi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rahmatmajidi</a> <a href=\"https://profiles.wordpress.org/rajaeinet/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rajaeinet</a> <a href=\"https://profiles.wordpress.org/rarathemesupport/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rarathemesupport</a> <a href=\"https://profiles.wordpress.org/sadeghpm/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sadeghpm</a> <a href=\"https://profiles.wordpress.org/saeed_same/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>saeed_same</a> <a href=\"https://profiles.wordpress.org/safelayout/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>safelayout</a> <a href=\"https://profiles.wordpress.org/sahabi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sahabi</a> <a href=\"https://profiles.wordpress.org/sajjadtalebi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sajjadtalebi</a> <a href=\"https://profiles.wordpress.org/salamzadeh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Salamzadeh</a> <a href=\"https://profiles.wordpress.org/salarlotfi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salarlotfi</a> <a href=\"https://profiles.wordpress.org/salemi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salemi</a> <a href=\"https://profiles.wordpress.org/salman1990/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salman1990</a> <a href=\"https://profiles.wordpress.org/samanehmirrajabi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>samanehmirrajabi</a> <a href=\"https://profiles.wordpress.org/samtemehr/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>samtemehr</a> <a href=\"https://profiles.wordpress.org/saniamohammadi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>saniamohammadi</a> <a href=\"https://profiles.wordpress.org/sareham238/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sareham238</a> <a href=\"https://profiles.wordpress.org/sazmankav/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sazmankav</a> <a href=\"https://profiles.wordpress.org/seramo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>seramo</a> <a href=\"https://profiles.wordpress.org/shayanfp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>shayanfp</a> <a href=\"https://profiles.wordpress.org/shokrino/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>shokrino</a> <a href=\"https://profiles.wordpress.org/silvercover/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>silvercover</a> <a href=\"https://profiles.wordpress.org/sinashams/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sinashams</a> <a href=\"https://profiles.wordpress.org/smm1378/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>smm1378</a> <a href=\"https://profiles.wordpress.org/smrm/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>smrm</a> <a href=\"https://profiles.wordpress.org/soheilmir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>soheilmir</a> <a href=\"https://profiles.wordpress.org/sunyniazi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sunyniazi</a> <a href=\"https://profiles.wordpress.org/tadeha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tadeha</a> <a href=\"https://profiles.wordpress.org/translationsbysemperplugins/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>translationsbysemperplugins</a> <a href=\"https://profiles.wordpress.org/tsina/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tsina</a> <a href=\"https://profiles.wordpress.org/untashgaal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>untashgaal</a> <a href=\"https://profiles.wordpress.org/vadatiertebat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>vadatiertebat</a> <a href=\"https://profiles.wordpress.org/weloper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>weloper</a> <a href=\"https://profiles.wordpress.org/worldless/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>worldless</a> <a href=\"https://profiles.wordpress.org/wpvar/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>wpvar</a> <a href=\"https://profiles.wordpress.org/yashar_hv/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yashar_hv</a> <a href=\"https://profiles.wordpress.org/yasser1992/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yasser1992</a> <a href=\"https://profiles.wordpress.org/ynproduct/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ynproduct</a> <a href=\"https://profiles.wordpress.org/zareidev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>zareidev</a> <a href=\"https://profiles.wordpress.org/zeroone2021/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>zeroone2021</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:245:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"201\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"معرفی تیم وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Feb 2024 13:06:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=145\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"تیم وردپرس فارسی یک تشکیل کاملا مستقل است که وابسته به هیچگونه سازمان و یا شرکتی نمی باشد، پروژه وردپرس فارسی به هیچ شخص و یا گروه خاصی تعلق ندارد و توسط تیم وردپرس فارسی که به صورت داوطلبانه فعالیت می کنند، اداره می شود. این بخش از سایت وردپرس، مخصوص تیم وردپرس فارسی می‌باشد. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:75228:\"<p>تیم وردپرس فارسی یک تشکیل کاملا مستقل است که وابسته به هیچگونه سازمان و یا شرکتی نمی باشد، پروژه وردپرس فارسی به هیچ شخص و یا گروه خاصی تعلق ندارد و توسط تیم وردپرس فارسی که به صورت داوطلبانه فعالیت می کنند، اداره می شود. این بخش از سایت وردپرس، مخصوص تیم وردپرس فارسی می‌باشد. شما می‌توانید اخبار و رویدادهای مربوط به تیم وردپرس فارسی را در اینجا دنبال کنید و در صورت تمایل در ترجمه وردپرس مشارکت کنید.</p>\n\n\n\n<h2 class=\"wp-block-heading\">اعضای تیم وردپرس فارسی</h2>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center\">مدیران بخش فارسی وردپرس</h3>\n\n\n\n<div class=\"wp-block-group is-content-justification-space-between is-layout-flex wp-container-core-group-is-layout-9366075c wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-671c4991 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/farhad0\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/0ebc32f2dc5921020c3b62738f4fa058?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/farhad0\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/farhad0\">فرهاد سخایی</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-671c4991 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/man4toman\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/0223bc303222e11c85b7e780e929bafa?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/man4toman\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/man4toman\" target=\"_blank\" rel=\"noreferrer noopener\">مرتضی گرانسایه</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-d7b04dc7 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/saeedfard\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/218e2e8376f15e9d72de62b7a3c28fd4?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-text-align-center has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/saeedfard\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/saeedfard\" target=\"_blank\" rel=\"noreferrer noopener\">سعید فرد</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-d7b04dc7 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/sushyant\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/6a35a072c0766d41217d17317f3ea057?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/sushyant\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/sushyant\" target=\"_blank\" rel=\"noreferrer noopener\">سوشیانت زوار زاده</a></strong></p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">ویراستاران ترجمه پروژه‌های وردپرس</h2>\n\n\n\n<div style=\"clear:both;overflow: hidden\">\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/1farakav/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2ac90d3243016ceb85b794693cb21517?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>1farakav</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/360messenger/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/15e0ea462c4401f4f72ecac44e3d748c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>360messenger</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ach1992/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/210dd07c37484e1ee09f39e0dbe5a98e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ACh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/addeveloper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cdfb2b2f869b117b3c7a717f1a0f5199?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ADDeveloper</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/affiliatenetworks/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e7f2577d1c64018b09ee9113cd006c8c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>affiliatenetworks</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ahangarha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a7f24279a1c7eb9edfcd4bbfa6405844?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ahangarha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/translationsbysemperplugins/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/613ec4dc7a0323e1e04e0484b532e570?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>AIOSEO Translations</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alizadegan/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b596479b88c6b78ca32bc068be75bbf7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Alizadegan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aliarjini/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cf8c1b74d58c3b8ea98b3262e0ae7ebe?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ali arjini</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alixo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d60e3dc2dee03a210fe16337c2021c1c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Esmaeili</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aligholami/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/32919c054088aa3dff571ab81c3f5d76?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Gholami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alirashidnahal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d2cc791ce1a9291e06775a1b24c3197e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Rashidnahal</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/as911/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/28dc5ad2aa7ccc44413057b033a536d4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Alireza Sedghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amatris/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/24758bce866aeb6316f1256e3a1244e2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amatris</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ameskaran/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9cb2521ac836b8c7f042396f1f39a914?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ameskaran</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aminfa/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/91a34f1a502004701d8ad2c1e715f3a6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amin askari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sazmankav/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bcb756ce8bff9ae05111fc4dc73b8eaa?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amin Mahjoor</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aminomidi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3959eb01b3eca2ac83ec36cbf9f0e9a5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amin Omidi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirarshia/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/347edea6a33c515fdf20f24240307c20?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amirarshia</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/djamir121/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e8eb5ca949a93d2606dc215593e0b2f3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>AMIR Heydari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirhpcom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a4b904ff316d7c98496108e651441624?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amirhossein Hosseinpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirhosseinhpv/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2f6329ce417480573782224099734deb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amirhp-com</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/native0098/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/89f22ae87a917b049b02728446c52372?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ARash Ghanei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ardalan13/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/760d071079d3ab12e22c545501811838?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ardalan Davoudi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aliasghar1112/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3ffb886ffd1fe939559438c733b3a453?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>arian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ariankeshavarz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/91d82f7845cd8c3cf4354b8362a669f4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Arian Keshavarz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/armansiahloo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1e3fd783b8d49b7f08c8e153548f5673?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>arman siahloo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/arvancloud/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/08b43a96759f4737ef6d334030e7b873?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ArvanCloud</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/asadiy4n/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d81955a0f2c8d1b676735b19840fe957?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Asadiyan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/asterids/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/99ad47b6ac94e4d14028d774771f68bc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>asterids</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aydin714/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8c78459453fee125531ec04d413c7c26?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>aydin714</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/bbkysf/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3276f73903245fe62deffb331ee11de5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Babak Yousefzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/bmoudi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fcc97bddef8d4e7b89a1911c06d75697?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Bijan Moudi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/blackswanlab/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1fd03d88ea9dc937939fd0d655df155b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>BlackSwan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/chilisearch/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cc10b45b85557af4b3b5c6022c4f4a05?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Chili Search</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/dedidata/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f69a56c77882b62840c5f2a40cd1b087?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>DediData</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/digikotcom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/381714b60533b546fa0b824717122524?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>digikot.com</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/domiinodev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ec7ccdac8fceb213e8e367ea310acc3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Domino dev</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parnibraan/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c121b76ce158eb2a7b88d7535d50e69e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ehsaan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ercmanager1/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/64cb2605e604942bc16980498672f36e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ercmanager1</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ee_persian/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/319abf373a18f8bb53935a50ea681fdc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>esmail ebrahimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/esmailfadaei/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/db9d5507ce8b01a54c1b2c48593c16d7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>esmailfadaei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/feredi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3f7819027cef1619a8ab2fa678042736?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Farhad Fariborzi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/farokhheidari/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9da3725eed363a40e6c1a9e4ce59a818?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>farokhheidari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/farshadhz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bae20c1e448d7ed3205e061f2b6571e5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>farshadhz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/arshen/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5ad52ff159fc7d8fc5fe85288cb82319?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Foad Tahmasebi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ghtali/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/81ea8ef483e5fc8d53184fbfbe8c4f8e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ghtali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/goudarz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5f663c942d32cc77e51b7ae94a199023?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Goudarz Jafari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hadiomid/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f8ecf070e8d4649c5f03c36a66171eb9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>hadi.omid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/silvercover/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3ced7aa268d0a80d29cee2731a5f589a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hamed Takmil</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yazdaniwp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f62756a112ab1b86500c54beaea6dfbd?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hamid Reza Yazdani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hanieh729/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2cec9118b4afb3d5005c6ba298a5a8cb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hanieh Ramzanpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hsnshfn/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8ae345e1d37b9c3c8eb9470f28929a75?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hassan Shafiian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hassantafreshi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/99a72de762392a5a5efbf36a4367f793?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>hassantafreshi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hitsteps/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1adb81e2590e1f3fa943e6865dbf459?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hitsteps</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/h71/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8415a8ca663844689b6b0e5f49108e3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hossein</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hosseinsadeghi69/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ec5e64b66b43016fa7b635e026569986?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hossein Sadeghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/glboy/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/39910273e5a04bb79c64aa0c261d09dc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>idehweb</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/imikiani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/17575b917994c7f0273929220bb7f92f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Iman Kiani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/infomtaghavi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/796b1ab5fe2646f3ea525b01adbd5599?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>infomtaghavi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/irangold/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/901682cf57b32039d9559850f0871070?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>irangold</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/irdb/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e0ab2d106c7cae38d826b9ccd0b427e8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>irdb</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ham3da/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f2d495a9435381aada34ba96535f1337?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Javad Ehteshami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pash2048/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0bf24dc164ac15d58404ce6ccdf0e41c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>javad jazandari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/johnbozorgi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cb66664459d45128adcff3ae34c99f4b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>John Bozorgi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kafrashi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/897230e3d4bc2af09e8cfc169fbc9ec4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>kafrashi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kamrankhorsandi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c134f741d1a58ce5713dca362c454b27?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Kamran Khorsandi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/gamefa/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4a5f0fbba8fbc26592b2ec5a84b62f4c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>kasra naraghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/khorshidlab/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1005c02764ed93db28fc02af34cf9cc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Khorshid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/longman2020/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c3867746448950074bf44902501e851e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>longman2020</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/lusha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/eb729c02496909a29b353fa110ff3abb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>lumarsha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mazraee/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ad7313e9868d0d311cbcd8df3a712fe3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>M. Mazraee</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdiebrahimii/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fe5eecdeba173ac42d31c888bff1b2a0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mahdi Ebrahimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdiyerezaie/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ccef3bc24c6020bad21752125d53bdd3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mahdiyerezaie</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdyarme/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d0bf590292d00fefbc17b24e7388ea88?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mahdyar Hasanpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mainseo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1ad550fce817bb096a7fe0eedefd0a41?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mainseo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/manzoorwanijk/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ff0fc68d4d69124a38b4aed217a74ff5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Manzoor Wani (a11n)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mashhadcode/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9b1414b9617f8e7345a01d10073030b9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mashhadcode</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/masoudnkh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ba3555901bd8c8f5a160af53e67b8ab8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Masoud NKH</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/matinbeigi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c9c10181d66be41f25c2fbe17658011e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Matin Beigi (Rick Sanchez)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/basemax/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3cfbe47b6fb1f7c03467b2be20a1904f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Max Base</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/antialiasfactory/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1120e8649e76041919b334447228ffd7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Maziar Firuzmand</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/m0911/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/73faf14ee55c29babb265e20ac22beff?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Abdollahi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehdibolourian/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f64880371f196af7f5d3490954f5d08d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Bolourian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/msn6060/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f82de68ee8cac799acd5b841e5dbf026?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Soltani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrban/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/301e39948cca7b82c50222dce2f6464c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehr@Ban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrshaddarzi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d88c9733e7ed1deda936e848ee629e63?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehrshad Darzi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrshad81/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2fada5712ee0951795edd9b43eef90a3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehrshad MTI</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/weloper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/298fae8b228d3d680c5b6b37b1caddb3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mersad GHasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mhmanavi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c1ce302525f2e6e3f63d1535d86b178a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mhmanavi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/michaelpk/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/82343eb50a4d3334144ed232ad8dfacf?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>michaelpk</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mihanwp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/14144c1a63d0d1cf77ce4629ed77559c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>MihanWP</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/lord_viper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fed8d40c5a576989ab0536611af3aea2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mobin Ghasempoor</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/moccc/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a175d00ddc61fdf6b7193fc7a8a82ab4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>moccc</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohadeseghasemi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/647aa1d91813a72b594705fdc93ee3fe?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohadese Ghasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohammad9574/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1b213544ccfcc3eae61e4640eaa4733a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Ahmadi Akbari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ghasemi71ir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7173544c295e4da83c06463894924e24?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Ghasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohammadhero/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d3cc70e26610175df37e29ad3058476b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Hero</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kamalireal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7d12ca5dd6b28c06fb3e6d9bab35d98c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>MohammadReza Kamali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohsenpazhoohiyani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1ec0de464dfa603266aafb57893190a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Moh Sen</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohsengham/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/64d4e212c9263a72b2fcadbe3951342f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohsen Ghiasi Ravari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mojtaba-taheri/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dadbd3df6db151c924279a85333be5d3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mojtaba</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mojtabad/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bad8c41e73e002d4a356b6f45ea5cbea?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mojtaba Darvishi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/moreconvert/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4aec5812e3db8673416ae1130567d24a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>moreconvert</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mo0orteza/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ff676fc8aefcaba0a322e26cf9b6e33c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Morteza Gholami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mostafarouz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/61cd3a411bf24f29129cc5f6671ca54a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mostafarouz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pctricksir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f3de891086460ebc9d49285dd875d392?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mostafa Shiraali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mostafas1990/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e3631726d155eac3e02f76ce86675b5e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mostafa Soufi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/motefaghehi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ab18b632dcc092fa8f9186aeda372ca6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Motefaghehi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/motlaqcode/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1b483f0e8a37f692326fa773f13fdc67?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>motlaq.code</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mralidoosti/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a3fb02547f4c5c7b52a0e8f62808e5f2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mr.Alidoosti</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/msninsider/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cbde60e0b6889dce753b42c8902ef5c0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>msninsider</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/narimonfund/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5285b112df84b46bdbb74863578eb613?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>narimonfund</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/navidos/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7dcc163b0e899db1292b87e75f40bda4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Navid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kashani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b36d7087386d76b7a19108b02f98f106?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Navid Kashani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/milad47/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/37274b79cf0175321cb7643fbee5df94?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Nejad (drdgtal.ir)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/niloomand/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0cd10486b080d82bfe48daa6230dd935?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Niloufar Firouzmand</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/nima78600/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d748601773ad0279e56aa3c4019115b6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Nima</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/nirweb/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c7415431eace690f62db1308c0ad64d9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>NirWp Team</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/novinhub/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/322d3edcc25fe18b82e463a283cef232?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>novinhub</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rajaeinet/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fd7b9df37ca332d1442a0ce3967a7c44?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Omid Rajaei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/otoraby/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/60ae94ff71f9b47157b12f662edf29c7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>otoraby</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parselearn/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fdaf2d63dcac607c3369add863f92d49?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Parsa</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rahmatmajidi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3fec48b6acbb1532a33452201fe96f1b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>parsamajidi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/saeed_same/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/696fc497c9a2c917559f87d052bc3567?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br></a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parsmizban/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f9456e0a85245eddae6ead8ff0fd73ec?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pars Mizban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/payzito/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2a81c9c4689f2161249bd7a7af97fcd2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Payzito</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pegahnorozi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3516a004a13a9aabf580b1af90709f38?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>pegahnorozi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/peprodev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ab681a56b7c8835bd5e9115cd2168967?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pepro Dev. Group</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/persianscript/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ef45e608481190c18b2af07af5723f9b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>PersianScript</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/piman/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/6d47c40bb24abd6a4635f8a938833595?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Peyman Naeimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pingmeter/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fef2f4fcb95ba6066ef881890471b601?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pingmeter</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/poolito/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f492c9b739e0f81689cdac49f18045d4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Poolito</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/porsline/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/aa21f1b133d19e3ec284b54f6f66e8d1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>porsline</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/poshtibancom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/efe7c8e18dc355f38c206462e2a8fd89?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Poshtiban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/qodeinteractive/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b3112ae650270b077c3757e194e07b12?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Qode</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rarathemesupport/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fd7624354ed1954db2857defe5d41717?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Rara Themes Support</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/vadatiertebat/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e19ecf951917ba4664ad0dcb920a86f7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Rasool Vahdati</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sadeghpm/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c63f816d8d209d003b333883a5116d0a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sadeghpm</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/safelayout/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0d8556a5f60d79d46e4a0d99ec3bb01e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>safelayout</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sahabi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/713bcf163578d7beaf4fc5633068ee2e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sahabi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sajjadtalebi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/41fdeae6932388edea980feab1ea8878?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sajjad talebi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salarlotfi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/19796781761750c8f461faa560255f72?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>salar lotfi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/samanehmirrajabi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3c249b6aea6b218f100a646dd4236322?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Samaneh Mirrajabi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/samtemehr/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fb8da7c62925a0f0747d979f5416c005?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>samtemehr</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/saniamohammadi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4b1289fe9c88fa85980f32b1da0ffa32?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sania Mohammadi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sareham238/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dfda29e07b9ef724e74a5489462acc1d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sareham238</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salamzadeh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/981c633c2e04866c36713f4c771ead61?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sasan Salamzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ebrahimzadeh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/6a6a7c553627a2f0b1f229ef896f9593?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sekineh Ebrahimzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/seramo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/59a56d919279eb8c099e9ecfde2ac1b1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>seramo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/shayanfp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e2bd4472eb102fb2523f618f354d20bb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Shayan Farhang Pazhooh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/shokrino/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2c5113e52a9ead1d847a053680b929f5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Shokrino Team</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salemi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9d8d335ac6f18b9d70529ec181e07825?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Siavash</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sinashams/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5bc3dc3c1c481092e57d5ee7aaad8d4c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sina Shamsizadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/smm1378/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d11d16690e254682f881b95a8906e9b6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>smm1378</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/smrm/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/917f43c1bc06d82d93b33c6feb567ee3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>smrmkh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/soheilmir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dd162394cad442a9d41f6e61e9699fcc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>soheilmir</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sunyniazi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9118863f478aacf17e28c9c8eaaac868?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sunyniazi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/tadeha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d9d8d1fe52190dd5533faa32084601ba?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>tadeha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/tsina/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5175589803cc8209f9d14ff51f21ba6f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>tsina</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/untashgaal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c80bf7c5fe758586a0dd3c57abfa18f8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Untashgaal</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/worldless/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/647edccfb36251fa1088ac69ddf24e3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>worldless</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/wpvar/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2e7c768382cbc3d2f0a927caea2b8b83?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>wpvar</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yasser1992/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7ff577dff2645a4cbd9aaad68cb71b4e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yaser Shahi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yashar_hv/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/69e51bde3535a671976159ba988d1fc1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yashar</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ynproduct/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/72bcce1fa00e869b00a3ccabff95c6e0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ynproduct</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/cg-team/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b7b3d45881027c27ef020c17b8750480?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yousefzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/zareidev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fcbc5c441416e2c6ea8f9c9b23001a4d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>zarei_dev</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/armenab1/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9c8a84d3ceae3eaa3a7c8b0ad998109b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Արմեն</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/elementorir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d0e9b9be12b8164adb0adf91a980236f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>المنتور فارسی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdi6489/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d35bb6a22a417637fc73beeb92600be1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>تندر وردپرس</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/zeroone2021/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/75478f3f1929f976951d668ee1e364a3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>دنیای صفر و یک دیجیتالی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salman1990/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f05fafc0856c43643dd36628b34b9944?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>سلمان محمدی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/qwerty13/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e802e5ac490da7d1029b7029265249ef?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>مرتضی رستگار</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pedramrahimi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b545db4131a739d2348816b3c6ee12ae?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>پدرام رحیمی</a>\n</div>\n<div class=\"clear:both;content: \'\';display: flex-row;\"></div>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center\"><strong><a href=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" data-type=\"link\" data-id=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" target=\"_blank\" rel=\"noreferrer noopener\">مشاهده لیست کامل توسعه دهندگان بخش فارسی</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">استفاده کنندگان زبان فارسی وردپرس</h2>\n\n\n\n<p>تا سال 2024، 44.26٪ از کل وبسایت های اینترنت از وردپرس استفاده می‌کنند. این مقدار برابر با چیزی حدود ۸۱۰ میلیون وب‌سایت می‌شود و این شماره به سرعت در حال افزایش است. بیش از ۵۰۰ وب‌سایت هر روز با وردپرس ساخته می‌شود. از میان این وب سایت‌ها چیزی حدود ۸۱ میلیون وب سایت، به زبان فارسی می‌باشند (یک دهم درصد)</p>\n\n\n\n<h2 class=\"wp-block-heading\">تاریخچه فعالیت تیم وردپرس فارسی</h2>\n\n\n\n<p>فعالیت تیم وردپرس فارسی تقریبا از ابتدای بوجود آمدن وردپرس شکل گرفت و در فروردین ۱۳۸۶ انتشار افزونه تاریخ شمسی برای وردپرس توسط آقای <a href=\"https://profiles.wordpress.org/mani_monaj\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/mani_monaj\">مانی منجّمی</a>، سرعت بومی‌سازی وردپرس را دو چندان کرد. فعالیت‌های این دوستان و همچنین کاربر <a href=\"https://profiles.wordpress.org/gonahkar\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/gonahkar\">Gonahkar</a> باعث افزایش چشمگیر محبوبیت وردپرس، در میان کاربران وب فارسی زبان شد.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:164:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"واژه‌نامه رسمی وردپرس فارسی منتشر شد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:236:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Feb 2024 21:23:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://fa.wordpress.org/team/?p=98\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:609:\"واژه‌نامه وردپرس فارسی بر اساس واژه‌های پرتکرار در هسته وردپرس و بخش مدیریت آن ایجاد شده است. شما مترجم عزیز می‌توانید در هنگام ترجمه وردپرس در بخش ترجمه آنلاین وردپرس فارسی، از پیشنهادات ترجمه‌ای که بر اساس این واژه‌نامه به شما داده می‌شود استفاده نمایید و ترجمه خود را ساده‌تر و روان‌تر انجام دهید. این واژه‌نامه شامل بیش [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2087:\"<p><a href=\"https://translate.wordpress.org/locale/fa/default/glossary/\">واژه‌نامه وردپرس فارسی</a> بر اساس واژه‌های پرتکرار در هسته وردپرس و بخش مدیریت آن ایجاد شده است. شما مترجم عزیز می‌توانید در هنگام ترجمه وردپرس در بخش <a rel=\"noreferrer noopener\" href=\"https://translate.wordpress.org/locale/fa/\" target=\"_blank\">ترجمه آنلاین وردپرس فارسی</a>، از پیشنهادات ترجمه‌ای که بر اساس این واژه‌نامه به شما داده می‌شود استفاده نمایید و ترجمه خود را ساده‌تر و روان‌تر انجام دهید.</p>\n\n\n\n<p>این واژه‌نامه شامل بیش از ۱۲۰۰ واژه و عبارت می‌باشد و به دلیل تعداد زیاد کلمات و عبارت‌های درج شده در آن، ممکن است نیاز به بهبود بیشتر نیز داشته باشد. لذا در صورتی که مایل به بهبود این واژه‌نامه هستید می‌توانید پیشنهادات خود را در مورد بهبود ترجمه واژه‌ها به صورت دیدگاه (Comment) بر روی <a href=\"https://docs.google.com/spreadsheets/d/1SrhQknH-gipzFXI6TCu1KEXUF9QivkCo3jp6yJy3CRE/edit?usp=sharing\" target=\"_blank\" rel=\"noreferrer noopener\">منبع Google Sheet این واژه‌نامه</a> ارائه نمایید. ضمنا در صورتی که نیاز به بحث و گفتگو در مورد واژه‌ای دارید، می‌توانید به بخش <a href=\"https://t.me/wpdevelopers\" target=\"_blank\" rel=\"noreferrer noopener\">گفتگوهای مربوط به تیم وردپرس فارسی</a> مراجعه و اقدام به عضویت و ورود نمایید. گردآوری این واژه‌نامه با تلاش <a href=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" target=\"_blank\" rel=\"noreferrer noopener\">تیم وردپرس فارسی</a> انجام شده است.<br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:232:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"98\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"برگزاری تولد وردپرس در میتاپ بندرعباس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:247:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 May 2023 06:17:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=102\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:469:\"به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم. از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید. تاریخ برگزاری رویداد: شنبه 6 خرداد، ساعت 18:00 الی 20:15 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3337:\"<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2023/05/poster-wordpress-2-1024x1024-1.jpg\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/poster-wordpress-2-1024x1024-1.jpg\" alt=\"\" class=\"wp-image-817\"></a></figure>\n\n\n\n<p>به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم.</p>\n\n\n\n<p>از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<p>تاریخ برگزاری رویداد: <strong>شنبه 6 خرداد، ساعت 18:00 الی 20:15</strong></p>\n\n\n\n<p>محل برگزاری: <strong>بندرعباس، خیابان آیت الله غفاری شمالی، ساختمان پارک علم و فناوری هرمزگان، سالن کنفرانس</strong></p>\n\n\n\n<p>ظرفیت: <strong>50 نفر</strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<h2 class=\"wp-block-heading\">ثبت نام در میتاپ</h2>\n\n\n\n<p>شرکت در این رویداد رایگان است اما حتما برای حضور باید در آن ثبت نام کنید.<br>برای ثبت نام در میتاپ وردپرس بندرعباس به این لینک Attend کرده</p>\n\n\n\n<p><a href=\"https://www.meetup.com/bandarabbas-wordpress-meetup/events/293634850/\">https://www.meetup.com/bandarabbas-wordpress-meetup/</a></p>\n\n\n\n<p>به دلیل محدودیت ظرفیت در این رویداد در صورت ثبت نام و کنسل شدن حضورتون حتما به برگزار کنندگان رویداد اطلاع‌رسانی کنید.</p>\n\n\n\n<p>جهت اطلاع‌رسانی در مورد رویداد در شبکه‌های اجتماعی میتاپ وردپرس عضو شوید.</p>\n\n\n\n<p><a href=\"https://t.me/irwpmeetup\" target=\"_blank\" rel=\"noreferrer noopener\">https://t.me/irwpmeetup</a><br><a href=\"https://instagram.com/irwpmeetup\" target=\"_blank\" rel=\"noreferrer noopener\">https://instagram.com/irwpmeetup</a><br><a href=\"https://wpmeetup.ir/\" target=\"_blank\" rel=\"noreferrer noopener\">https://wpmeetup.ir/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<h2 class=\"wp-block-heading\">برنامه رویداد</h2>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table><tbody><tr><td><strong>برنامه</strong></td><td><strong>ساعت</strong></td></tr><tr><td>معرفی و خوش‌آمد گویی</td><td>18:00 الی 18:15</td></tr><tr><td>فرصت شبکه سازی با متخصصان و علاقه مندان وردپرس</td><td>18:15 الی 18:45</td></tr><tr><td>بحث و گفتگو در مورد سرعت و بهینه سازی وردپرس</td><td>18:45 الی 19:45</td></tr><tr><td>جشن تولد وردپرس همراه با کیک و عکاسی</td><td>19:45 الی 20:15</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">برگزارکنندگان این رویداد</h2>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/sponser-bnd.jpg\" alt=\"\" class=\"wp-image-818\"></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:244:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"میتاپ تولد ۲۰ سالگی وردپرس در تهران برگزار می‌شود\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 May 2023 06:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=104\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:512:\"در تاریخ ۶ خرداد امسال وردپرس ۲۰ ساله می‌شود. به همین مناسبت در تمامی دنیا رویدادهایی با هدف گرفتن جشن برای این روز برگزار می‌شود. لوکال منیجرها، توسعه‌دهنده‌ها و سایر دوستدارن دنیای متن باز و وردپرس با دورهم جمع شدن این روز رو در کل دنیا با هم جشن می‌گیرند. به همین جهت ما نیز [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4439:\"<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2023/05/2.png\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/2-1024x768.png\" alt=\"\" class=\"wp-image-790\"></a></figure>\n\n\n\n<p>در تاریخ ۶ خرداد امسال وردپرس ۲۰ ساله می‌شود. به همین مناسبت در تمامی دنیا رویدادهایی با هدف گرفتن جشن برای این روز برگزار می‌شود. لوکال منیجرها، توسعه‌دهنده‌ها و سایر دوستدارن دنیای متن باز و وردپرس با دورهم جمع شدن این روز رو در کل دنیا با هم جشن می‌گیرند.</p>\n\n\n\n<p>به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم.</p>\n\n\n\n<p>از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید.</p>\n\n\n\n<p>تاریخ برگزاری رویداد: <strong>جمعه 5 خرداد، ساعت 9:30 الی 14:00</strong></p>\n\n\n\n<p>محل برگزاری: <strong>تهران، کیلومتر 15 بزرگراه فتح (پل ایرانخودرو)، خیابان تولایی،نبش کوچه لاله،کارخانه نوآوری و صنایع خلاق آمپر</strong></p>\n\n\n\n<p>ظرفیت: <strong>45 نفر</strong></p>\n\n\n\n<p>شرکت در این رویداد رایگان است اما حتما برای حضور باید در آن ثبت نام کنید.<br>برای ثبت نام ابتدا در میتاپ وردپرس تهران به این لینک Attend کرده</p>\n\n\n\n<p><a href=\"https://www.meetup.com/tehran-wordpress-meetup/events/293556812/\">https://www.meetup.com/tehran-wordpress-meetup/events/293556812</a></p>\n\n\n\n<p>و سپس اطلاعاتتون رو در این فرم ثبت کنید.</p>\n\n\n\n<p><a href=\"https://wpmeetup.ir/wp20/\">https://wpmeetup.ir/wp20</a><br></p>\n\n\n\n<p><strong>توجه نمایید که ثبت اطلاعات در فرم ذکر شده به منزله نهایی کردن ثبت نام است.</strong></p>\n\n\n\n<p>به دلیل محدودیت ظرفیت در این رویداد در صورت ثبت نام و کنسل شدن حضورتون حتما به برگزار کنندگان رویداد اطلاع‌رسانی کنید.</p>\n\n\n\n<p>جهت اطلاع‌رسانی در مورد رویداد در شبکه‌های اجتماعی میتاپ وردپرس عضو شوید.</p>\n\n\n\n<p><a rel=\"noreferrer noopener\" href=\"https://t.me/irwpmeetup\" target=\"_blank\">https://t.me/irwpmeetup</a><br><a rel=\"noreferrer noopener\" href=\"https://instagram.com/irwpmeetup\" target=\"_blank\">https://instagram.com/irwpmeetup</a><br><a rel=\"noreferrer noopener\" href=\"https://wpmeetup.ir/\" target=\"_blank\">https://wpmeetup.ir/</a></p>\n\n\n\n<span id=\"more-104\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">برنامه رویداد</h2>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table><tbody><tr><td><strong>برنامه</strong></td><td><strong>ساعت</strong></td></tr><tr><td>معرفی و خوش‌آمد گویی (سعید فرد)</td><td>9:45 الی 10</td></tr><tr><td>سخنرانی اول – رسول وحدتی (امنیت وردپرس)</td><td>10 الی 10:45</td></tr><tr><td>وقت استراحت و پذیرایی اول</td><td>10:45 الی 11:15</td></tr><tr><td>سخنرانی دوم – مخاطرات استفاده محصولات وردپرسی نال و غیراصل (صحبت به صورت آزاد)</td><td>11:15 الی 12</td></tr><tr><td>تولد وردپرس، عکاسی و پذیرایی و شبکه‌سازی</td><td>12 الی 13:30</td></tr></tbody></table></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2023/05/2.5.png\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/2.5-1024x768.png\" alt=\"\" class=\"wp-image-802\"></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">اسپانسر برگزاری این رویداد</h2>\n\n\n\n<figure class=\"wp-block-image aligncenter size-medium is-resized\"><a href=\"https://limoo.host/\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://wpmeetup.ir/wp-content/uploads/2023/05/IMG_7339-300x300.png\" alt=\"\" class=\"wp-image-531\" style=\"width:146px;height:146px\"></a></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"104\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"میتاپ روز ترجمه وردپرس به فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:203:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Sep 2020 06:51:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=115\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:564:\"رویداد چند روزه ترجمه وردپرس همزمان با روز جهانی ترجمه شروع شد. در این رویداد طبق روال چند سال اخیر، همزمان با سایر مترجمان وردپرس به زبان‌های مختلف، بخش‌های هسته، سایت اصلی، پوسته‌ها، افزونه‌ها و اپ‌های موبایل را در کنار هم به زبان فارسی ترجمه می‌کنیم. رویداد روز ترجمه فارسی، بصورت یک میتاپ آنلاین در [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1895:\"<p>رویداد چند روزه ترجمه وردپرس همزمان با روز جهانی ترجمه شروع شد. در این رویداد طبق روال چند سال اخیر، همزمان با سایر مترجمان وردپرس به زبان‌های مختلف، بخش‌های هسته، سایت اصلی، پوسته‌ها، افزونه‌ها و اپ‌های موبایل را در کنار هم به زبان فارسی ترجمه می‌کنیم.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/09/highres_492664489-1024x576.png\" alt=\"\" class=\"wp-image-648\"></figure>\n\n\n\n<p>رویداد روز ترجمه فارسی، بصورت یک میتاپ آنلاین در روز <strong>جمعه ۱۱ مهرماه ۱۳۹۹</strong> انجام می شود. اگر علاقمند به حضور در این رویداد هستید می‌توانید از طریق آدرس زیر اطلاعات بیشتری در مورد آن کسب کنید:<br></p>\n\n\n\n<figure class=\"wp-block-embed-meetup-com wp-block-embed is-type-rich is-provider-meetup\"><div class=\"wp-block-embed__wrapper\">\r\nhttps://www.meetup.com/tehran-wordpress-meetup/events/273541393/\r\n</div></figure>\n\n\n\n<p class=\"has-text-align-right\">و یا می‌توانید در ساعت مشخص شده، بصورت مستقیم به پیوند رویداد وارد و به جمع دیگر دوستان بپیوندید:</p>\n\n\n\n<p class=\"has-text-align-left\" style=\"font-size:18px\"><br><strong><a href=\"https://www.meetup.com/tehran-wordpress-meetup/events/273541393\">https://www.meetup.com/tehran-wordpress-meetup/events/273541393</a></strong></p>\n\n\n\n<p>توجه داشته باشید که برای شرکت در پیوند بالا، نیازی به ثبت نام نیست و رویداد راس ساعت اعلام شده آغاز می‌شود.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"115\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"برگزاری روز ترجمه وردپرس به فارسی در تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 May 2019 07:54:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=122\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"امروز (۲۱ اردیبهشت ۱۳۹۸) روز جهانی ترجمه وردپرس بود، یک رویداد که افراد زیادی در سراسر جهان جهت مشارکت برای ترجمه وردپرس، همکاری می‌کنند. ما نیز از این موضوع به دور نبودیم و به صورت گروهی وردپرس را به فارسی ترجمه کردیم و از کنار هم بودن لذت بردیم. روز ترجمه وردپرس باز نیز تکرار [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2346:\"<p>امروز (۲۱ اردیبهشت ۱۳۹۸) روز جهانی ترجمه وردپرس بود، یک رویداد که افراد زیادی در سراسر جهان جهت مشارکت برای ترجمه وردپرس، همکاری می‌کنند. ما نیز از این موضوع به دور نبودیم و به صورت گروهی وردپرس را به فارسی ترجمه کردیم و از کنار هم بودن لذت بردیم. روز ترجمه وردپرس باز نیز تکرار خواهد شد. </p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/1.jpg\"><img decoding=\"async\" data-id=\"495\" src=\"https://fa.wordpress.org/files/2019/05/1-1024x772.jpg\" alt=\"\" class=\"wp-image-495\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/2.jpg\"><img decoding=\"async\" data-id=\"496\" src=\"https://fa.wordpress.org/files/2019/05/2-1024x767.jpg\" alt=\"\" class=\"wp-image-496\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/3.jpg\"><img decoding=\"async\" data-id=\"497\" src=\"https://fa.wordpress.org/files/2019/05/3-1024x767.jpg\" alt=\"\" class=\"wp-image-497\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/4.jpg\"><img decoding=\"async\" data-id=\"498\" src=\"https://fa.wordpress.org/files/2019/05/4-1024x767.jpg\" alt=\"\" class=\"wp-image-498\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/5.jpg\"><img decoding=\"async\" data-id=\"499\" src=\"https://fa.wordpress.org/files/2019/05/5-1024x767.jpg\" alt=\"\" class=\"wp-image-499\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/6.jpg\"><img decoding=\"async\" data-id=\"500\" src=\"https://fa.wordpress.org/files/2019/05/6-1024x767.jpg\" alt=\"\" class=\"wp-image-500\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/7.jpg\"><img decoding=\"async\" data-id=\"501\" src=\"https://fa.wordpress.org/files/2019/05/7-1024x533.jpg\" alt=\"\" class=\"wp-image-501\"></a></figure>\n</figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"122\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"پنجمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Jan 2019 07:59:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=127\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:554:\"پنجمین میتاپ وردپرس تهران در تاریخ 7 دی‌ماه 1397 برگزار شد. میتاپ در این دوره هم با استقبال بی‌نظیر علاقمندان به وردپرس مواجه بود . انتظار می‌رود که شاهدحضور بیشتر شما عزیزان در میتاپ‌های بعد باشیم. آقای سعید فرد با صحبت درباره اهداف میتاپ (برگزاری wordcamp در سال آینده، توسعه وردپرس فارسی) آغاز کننده این [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4863:\"<p>پنجمین میتاپ وردپرس تهران در تاریخ 7 دی‌ماه 1397 برگزار شد. میتاپ در این دوره هم با استقبال بی‌نظیر علاقمندان به وردپرس مواجه بود . انتظار می‌رود که شاهدحضور بیشتر شما عزیزان در میتاپ‌های بعد باشیم.</p>\n\n\n\n<p>آقای سعید فرد با صحبت درباره اهداف میتاپ (برگزاری wordcamp در سال آینده، توسعه وردپرس فارسی) آغاز کننده این رویداد بود.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/%D8%B3%D8%B9%DB%8C%D8%AF-%D9%81%D8%B1%D8%AF-%D9%85%DB%8C%D8%AA%D8%A7%D9%BE-768x768-1.jpg\" alt=\"\" class=\"wp-image-587\"></figure>\n\n\n\n<p>بعد از اینکه دوستان شرکت کننده خودشان را معرفی کردند نوبت به ارائه آقای مهدی رضایی (طراح وتوسعه دهنده وب) با موضوع: توسعه دهنده بهتری برای وردپرس باشیم رسید .</p>\n\n\n\n<p>آقای رضایی در ابتدا وردپرسفیای را برای دوستان معرفی کرد و مراحل نصب آن را توضیح و انجام داد. به سوالات حضار درباره ودرپرسفیای پاسخ داد .</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/mehdi-rezaeii-768x768-1.jpg\" alt=\"\" class=\"wp-image-588\"></figure>\n\n\n\n<p>در قسمت دوم ارائه خود آقای رضایی، سایپرس (ابزاری برای آزمایش سایت وردپرسی) را معرفی کرده و مراحل کار با سایپرس را به صورت عملی توضیح داد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/member-meetup-768x768-1.jpg\" alt=\"\" class=\"wp-image-589\"></figure>\n\n\n\n<p>بعد از تمام شدن ارائه آقای رضایی نوبت به پذیرایی و تبادل نظر شرکت کنندگان رسید .</p>\n\n\n\n<p>بعد از پذیرایی آقای سعید فرد برد ترلو میتاپ را معرفی کرد و از کاربران خواست که برای مشارکت در زمینه بهبود وردپرس فارسی به آن بپیوندند. تمامی دوستان و شرکت‌کننده‌های میتاپ وردپرس می‌توانند در این بورد نظرات و پیشنهادات خود را برای این رویداد ارسال کنند و در برگزاری میتاپ همکاری داشته باشند.</p>\n\n\n\n<p>قسمت دوم میتاپ به صورت بحث و گفتگو بین شرکت‌کننده‌ها در میتاپ با موضوع فارسی سازی وردپرس و مشکلات آن شکل گرفت.</p>\n\n\n\n<p>آقای سخایی از کاربران وردپرس خواست تا در زمینه ترجمه وردپرس، گروه وردپرس را همراهی کنند و به بحث و تبادل نظر بپردازند.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/all-member-768x768-1.jpg\" alt=\"\" class=\"wp-image-590\"></figure>\n\n\n\n<p>گفت و گو درباره ترجمه وردپرس فارسی ادامه پیدا کرد و کاربران پیشنهادات و نظرات خود را درباره این موضوع به اشتراک گذاشتند. بعد از جمع‌بندی صحبت‌های کاربران توسط سعید فرد میتاپ پنجم به پایان رسید.</p>\n\n\n\n<p>عکس دسته جمعی در پایان میتاپ</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/5th-meetup-tehran-768x773-1.jpg\" alt=\"\" class=\"wp-image-591\"></figure>\n\n\n\n<p>اگر تمایل به حضور در دوره‌های بعدی میتاپ وردپرس تهران را دارید می‌توانید جهت اطلاع‌رسانی از برگزاری در اکانت‌های شبکه اجتماعی میتاپ در تلگرام و اینستاگرام عضو شوید.</p>\n\n\n\n<p class=\"has-text-align-center\" dir=\"ltr\"><a href=\"https://t.me/irwpmeetup\">https://t.me/irwpmeetup</a></p>\n\n\n\n<p class=\"has-text-align-center\" dir=\"ltr\"><a href=\"https://instagram.com/irwpmeetup\">https://instagram.com/irwpmeetup</a></p>\n\n\n\n<p>این مژده به کسانی که فرصت حضور در میتاپ ها را ندارند داده می‎‌شود که می‌توانند از طریق اکانت ما در اینستاگرام به صورت زنده و یا از طریق بخش <a href=\"https://wpmeetup.ir/category/videos/\">ویدیوهای میتاپ</a>، میتاپ‌های وردپرس قبلی را مشاهده کنند.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:182:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"127\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"چهارمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Dec 2018 08:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=131\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:567:\"چهارمین میتاپ وردپرس ۹ آذر ۹۷ ساعت ۱۰ صبح برگزار شد. این میتاپ هم مانند سه میتاپ قبل شاهد حضور علاقه‌مندان وردپرس در هر زمینه‌ای (توسعه دهنده‌، طراح، کاربران وردپرس وحتی دانشجویان) بود. میتاپ با صحبت‌های آغازین آقای سعید‌‌ فرد با تأکید بر اهداف میتاپ که تشکیل جامعه‌ی وردپرسی، مطرح کردن مباحث فنی و عمومی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5455:\"<p>چهارمین میتاپ وردپرس ۹ آذر ۹۷ ساعت ۱۰ صبح برگزار شد. این میتاپ هم مانند سه میتاپ قبل شاهد حضور علاقه‌مندان وردپرس در هر زمینه‌ای (توسعه دهنده‌، طراح، کاربران وردپرس وحتی دانشجویان) بود.</p>\n\n\n\n<p>میتاپ با صحبت‌های آغازین آقای سعید‌‌ فرد با تأکید بر اهداف میتاپ که تشکیل جامعه‌ی وردپرسی، مطرح کردن مباحث فنی و عمومی در رابطه با وردپرس، کمک به توسعه و پیشرفت  وردپرس در ایران و اشاره به این که هدف اصلی برگزاری میتاپ‌ها برگزاری وردکمپ در سال آینده برای اولین بار در آسیا است آغاز شد.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/%D8%B3%D8%B9%DB%8C%D8%AF-%D9%81%D8%B1%D8%AF-768x623-1.jpg\" alt=\"\" class=\"wp-image-579\"></figure>\n\n\n\n<p>بعد از معرفی شرکت کنندگان مثل میتاپ های گذشته نوبت به ارائه دوستان رسید.</p>\n\n\n\n<p>در این میتاپ آقای مهدی سلطانی که به صورت داوطلب و از طریق قراردادن ارائه خود در قسمت ارسال مقاله در  سایت میتاپ وردپرس علاقه خود را برای به اشتراک گذاشتن تجربیات خود با دیگر دوستان اعلام کرده بود  ارائه‌ی خود را در زمینه برنامه نویسی شی‌گرا در وردپرس آغاز کرد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/soltani-768x493-1.jpg\" alt=\"\" class=\"wp-image-580\"></figure>\n\n\n\n<p>در این ارائه نکات کلیدی در استفاده از برنامه نویسی شی‌گرا توسط آقای سلطانی گفته شد، نمونه کدهای نوشته شده OOP نشان دادن و توضیحاتی بر روی کدها دادن.</p>\n\n\n\n<p>بعد از تبادل نظر و استراحت دوستان شرکت کننده و پذیرایی توسط مجموعه آتی ارتباط کیش نوبت به ارائه دوم با عنوان وردپرس ارزان برای شروع کسب و کار توسط آقای شاهین کلانتر آغاز شد.</p>\n\n\n\n<p>آقای کلانتر راهکارهایی ارائه کرد که بتوان کسب و کار نوپایی را با کمترین هزینه شروع کرد . در ادامه اضافه کرد که میتوانید بسته به نیاز وب سایت و کسب و کارتان پوسته ای نزدیک به اهدافتان بیابید و مخازن رایگان پوسته های وردپرس را معرفی کرد.</p>\n\n\n\n<p>آقای کلانتر :باجستجو در شبکه های اجتماعی میتوان از خلاقیت های طراحان صفحات وب استفاده کرد. با استفاده از هشتگ‌ها در شبکه‌های اجتماعی مانند اینستاگرام و پینترست.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/kalantar-768x512-1.jpg\" alt=\"\" class=\"wp-image-581\"></figure>\n\n\n\n<p>در ادامه به بررسی و معرفی پلاگین‌های رایگان و مهم و پرکاربرد وردپرس پرداخت و در آخر اضافه کرد که ما با رشد و توسعه وب سایت خود رشد می‌کنیم و بزرگ وبزرگتر می‌شویم  و وقتی وب سایت ما به سود دهی رسید برای برنده شدن در فضای رقابتی باید هزینه کنیم، هیچ رقابتی بدون هزینه نیست و از هزینه کردن نترسیم چون در مقابل بازدهی آن هزینه‌ی کمی است.</p>\n\n\n\n<p>بعد از اتمام ارائه آقای کلانتر دوستان به بحث و گفتگو در زمینه بازار کسب و کار وردپرس پرداختن و نظرات جالب و نکات مثبت زیادی در این زمینه گفته شد.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"582\" src=\"https://fa.wordpress.org/files/2020/01/all1-meetup-768x650-1.jpg\" alt=\"\" class=\"wp-image-582\"></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"583\" src=\"https://fa.wordpress.org/files/2020/01/all2-meetup-768x638-1.jpg\" alt=\"\" class=\"wp-image-583\"></figure>\n</figure>\n\n\n\n<p>گروه وردپرس برای دوستان و علاقه مندانی که موفق به حضور در میتاپ‌ها را نشده‌اند با پخش زنده از طریق اینستاگرام و همچنین قراردادن ویدئوی میتاپ در آپارات امکان استفاده از مطالب گفته شده در میتاپ را فراهم می‌کند.</p>\n\n\n\n<p>عکس دست جمعی در پایان رویداد وردپرس</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/irwpmeetup4-768x830-1.jpg\" alt=\"\" class=\"wp-image-584\"></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/team/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"117865853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 16 Dec 2025 10:22:38 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 15 Feb 2025 19:56:46 GMT\";s:4:\"link\";s:66:\"<https://fa.wordpress.org/team/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1765923758;s:23:\"__cache_expiration_time\";i:1765923758;}", "off");
INSERT INTO `aor_options` VALUES("151", "_transient_feed_mod_813f86eb29c12d6094f1acd1445797e5", "1765880558", "off");
INSERT INTO `aor_options` VALUES("4690", "_site_transient_timeout_feed_29753cd480eacd2ee3470b45d45adde5", "1767037684", "off");
INSERT INTO `aor_options` VALUES("4691", "_site_transient_feed_29753cd480eacd2ee3470b45d45adde5", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Gravity Forms – گرویتی فرم فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://gravityforms.ir\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"برترین فرم ساز جهان\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Nov 2022 10:25:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=6.7.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:91:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"آموزش تصویری کار با افزونه گرویتی ویو Gravity View\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:225:\"https://gravityforms.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%aa%d8%b5%d9%88%db%8c%d8%b1%db%8c-%da%a9%d8%a7%d8%b1-%d8%a8%d8%a7-%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%88%db%8c%d9%88-gravity/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:234:\"https://gravityforms.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%aa%d8%b5%d9%88%db%8c%d8%b1%db%8c-%da%a9%d8%a7%d8%b1-%d8%a8%d8%a7-%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%88%db%8c%d9%88-gravity/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Nov 2022 08:20:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:10:\"آموزش\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:12:\"Gravity View\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"آموزش Gravity View\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:42:\"آموزش کار با گرویتی ویو\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:30:\"آموزش گرویتی ویو\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:35:\"ایجاد نما در Gravity View\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:19:\"گرویتی ویو\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=51168\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:494:\"در این آموزش از سایت گرویتی فرم فارسی نحوه کار با افزونه گرویتی ویو را آموزش خواهیم داد که کاربرد مختلفی داشته و امکان نمایش ورودی های فرم های گرویتی فرم را در اختیارتان قرار خواهد داد. ابتدا فرم را در جهت نمایش ورود های آن انتخاب کنید. فرم مورد نظر باید دارای ورود بوده [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8081:\"\r\n<p>در این آموزش از سایت گرویتی فرم فارسی نحوه کار با افزونه گرویتی ویو را آموزش خواهیم داد که کاربرد مختلفی داشته و امکان نمایش ورودی های فرم های گرویتی فرم را در اختیارتان قرار خواهد داد.</p>\r\n\r\n\r\n\r\n<p>ابتدا فرم را در جهت نمایش ورود های آن انتخاب کنید. فرم مورد نظر باید دارای ورود بوده و کاربران اطلاعات خود را از طریق فرم ارسال کرده باشند.</p>\r\n\r\n\r\n\r\n<div class=\"wp-block-image\">\r\n<figure class=\"aligncenter\"><img decoding=\"async\" class=\"wp-image-51176\" src=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview1.jpg\" alt=\"آموزش گرویتی ویو\" /></figure>\r\n</div>\r\n\r\n\r\n\r\n<p>به طور مثال ما نحوه نمایش به صورت لیست را انتخاب می کنیم:</p>\r\n\r\n\r\n\r\n<div class=\"wp-block-image\">\r\n<figure class=\"aligncenter\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1039\" height=\"555\" class=\"wp-image-51177\" src=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2.jpg\" alt=\"آموزش گرویتی ویو\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2.jpg 1039w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2-400x214.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2-690x369.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2-200x107.jpg 200w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2-768x410.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview2-500x267.jpg 500w\" sizes=\"(max-width: 1039px) 100vw, 1039px\" /></figure>\r\n</div>\r\n\r\n\r\n\r\n<p>به طور مثال ما قصد داریم بخش را ایجاد کنیم که به وسیله آن کاربر بتواند در اطلاعات ورود فرم مورد نظر جستجو کند. مثلا شما در ورود های فرم خود فیلدهای مانند نام ، نام خانوادگی، کد ملی ، شماره نظام پزشکی و موارد دیگر دارید که به قصد دارید به کاربران این امکان را بدهید تا با جستجو هرکدام از فیلدها (مثلا کد ملی) بتواند به اطلاعات شخص مورد نظر دست پیدا کند.</p>\r\n\r\n\r\n\r\n<p>برای این منظور از قسمت بخش بالا افزودن ویجت را انتخاب کرده و گزینه Search  Bar را انتخاب کنید.</p>\r\n\r\n\r\n\r\n<div class=\"wp-block-image\">\r\n<figure class=\"aligncenter\"><img decoding=\"async\" width=\"844\" height=\"513\" class=\"wp-image-51178\" src=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3.jpg\" alt=\"آموزش گرویتی ویو\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3.jpg 844w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3-400x243.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3-690x419.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3-200x122.jpg 200w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3-768x467.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview3-500x304.jpg 500w\" sizes=\"(max-width: 844px) 100vw, 844px\" /></figure>\r\n</div>\r\n\r\n\r\n\r\n<p>پس از این مرحله باید نحوه نمایش اطلاعات را انتخاب کنید. در این بخش شما میتوانید پس از جستجو کاربر اطلاعاتی که مایل هستید در ورودی فرم ها موجود می باشد را انتخاب کرده و نمایش دهید.</p>\r\n\r\n\r\n\r\n<div class=\"wp-block-image\">\r\n<figure class=\"aligncenter\"><img decoding=\"async\" width=\"968\" height=\"531\" class=\"wp-image-51180\" src=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4.jpg\" alt=\"آموزش گرویتی ویو\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4.jpg 968w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4-400x219.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4-690x379.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4-200x110.jpg 200w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4-768x421.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/10/gravityview4-500x274.jpg 500w\" sizes=\"(max-width: 968px) 100vw, 968px\" /></figure>\r\n</div>\r\n\r\n\r\n\r\n<p>پس از این مرحله نمای شما ایجاد شده و آن را منتشر کنید. برای نمایش فرم جستجو از همین صفحه در نوار کناری سمت چپ، کد کوتاه نمایش نمای خود را انتخاب کرده و در برگه های دلخواه خود جهت نمایش قرار دهید.</p>\r\n\r\n\r\n\r\n<p>پس از این مرحله فرم های جستجو در برگه نمایش داده می شود. کاربر با وارد کرده اطلاعات در هر فیلد میتواند به اطلاعات مورد نظر خود دست پیدا کند. برای <strong>خرید افزونه گرویتی ویو</strong> میتوانید از اینجا اقدام کنید.</p>\r\n\r\n\r\n\r\n<p>امیدواریم از این آموزش از سایت گرویتی فرم فارسی لذت برده باشید.</p>\r\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;51168&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;485&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;1.1&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;1.1\\/5 - (485 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;21.7&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 21.7px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            1.1/5 - (485 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"https://gravityforms.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%aa%d8%b5%d9%88%db%8c%d8%b1%db%8c-%da%a9%d8%a7%d8%b1-%d8%a8%d8%a7-%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%88%db%8c%d9%88-gravity/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"بروزرسانی افزونه درگاه پرداخت سامان کیش گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://gravityforms.ir/saman-gravityforms-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://gravityforms.ir/saman-gravityforms-update/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 03 Jul 2022 06:43:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://gravityforms.ir/?p=87042\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:511:\"به اطلاع کاربران و همراهان گرویتی فرم فارسی می رسانیم افزونه درگاه پرداخت بانک سامان برای گرویتی فرم به نسخه 3.0 ارتقا پیدا کرد. در این نسخه سازگاری کامل با تغییرات جدید بانک سامان و همچنین پشتیبانی از سرویس توکن بانک سامان ایجاد شده است.   همچنین در صورتی که از زمان خرید شما بیش [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3946:\"\n<p>به اطلاع کاربران و همراهان گرویتی فرم فارسی می رسانیم افزونه درگاه پرداخت بانک سامان برای گرویتی فرم به نسخه 3.0 ارتقا پیدا کرد.</p>\n<p>در این نسخه سازگاری کامل با تغییرات جدید بانک سامان و همچنین پشتیبانی از سرویس توکن بانک سامان ایجاد شده است.</p>\n<p> </p>\n<p>همچنین در صورتی که از زمان خرید شما بیش از 24 ماه میگذرد باید مجدد اقدام به خرید و تمدید پشتیبانی نمایید.</p>\n<p>با احترام.</p>\n<p> </p>\n<p> </p>\n<p> </p>\n<p> </p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link has-white-color has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/bank-saman-https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms/\" target=\"_blank\" rel=\"noreferrer noopener\">صفحه خرید افزونه بانک سامان گرویتی فرم</a></div>\n</div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;87042&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;8&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;5&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;5\\/5 - (8 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;107.5&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 107.5px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            5/5 - (8 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://gravityforms.ir/saman-gravityforms-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:88:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"افزونه گرویتی ویو GravityView\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%88%db%8c%d9%88-gravityview/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%88%db%8c%d9%88-gravityview/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Sep 2019 07:17:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:12:\"Gravity View\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:19:\"گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:19:\"گرویتی ویو\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:48:\"نمایش ورودی های گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:39:\"ورودی اکسل گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=48917\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:488:\"گرویتی فرم یک فرم ساز حرفه ای برای وردپرس می باشد که توسط آن میتوانید فرم های خود را ایجاد کرده و در اختیار کاربران قرار دهید. این فرم ساز امکانات بسیار زیادی داشته و قابلیت های مختلفی را در اختیارتان قرار خواهد داد. با این وجود برخی امکانات در این افزونه احساس شده و [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9586:\"\n<p>گرویتی فرم یک فرم ساز حرفه ای برای وردپرس می باشد که توسط آن میتوانید فرم های خود را ایجاد کرده و در اختیار کاربران قرار دهید. این فرم ساز امکانات بسیار زیادی داشته و قابلیت های مختلفی را در اختیارتان قرار خواهد داد. با این وجود برخی امکانات در این افزونه احساس شده و برای همین منظور نیاز به نصب افزونه های جانبی این صفحه ساز می‌باشد.</p>\n\n\n\n<p>از جمله امکانات مورد نیاز در این فرم ساز ، نیاز به نمایش وضعیت فرم های تکمیل شده کاربر و نمایش نتیجه کنترل آن به کاربر می باشد. در چنین شرایطی شما نیازمند این هستید که پس از پر کردن فرم های مختلف توسط کاربر ، شما پس از بررسی اطلاعات ورودی کاربر یاداشتی برای اطلاع کاربر در فرم درج کنید. همچنین جهت اطلاع کاربر از نتیجه درخواست خود شما نیاز به افزونه ای می باشد که بتواند یک ویو های متنوعی از فرم ها برای کاربر ایجاد نماید.</p>\n\n\n\n<p><strong>نکته</strong>: برای کار با افزونه گرویتی ویو میتوانید به <strong><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/51168/\">آموزش گرویتی ویو</a></strong> و برای <strong><a href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-view/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه گرویتی ویو</a></strong> به این لینک مراجعه کنید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"1316\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/09/asdasd.jpg\" alt=\"\" class=\"wp-image-49547\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/09/asdasd.jpg 900w, https://gravityforms.ir/wp-content/uploads/2019/09/asdasd-400x585.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/09/asdasd-690x1009.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/09/asdasd-103x150.jpg 103w, https://gravityforms.ir/wp-content/uploads/2019/09/asdasd-768x1123.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/09/asdasd-342x500.jpg 342w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure></div>\n\n\n\n<p>افزونه GravityView دارای جداول متنوعی است که شما میتوانید با روش های مختلف اطلاعاتی که بواسطه فرم های گراویتی ارسال شده را برای کاربر نمایش دهید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"1161\" height=\"365\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1.png\" alt=\"\" class=\"wp-image-49549\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1.png 1161w, https://gravityforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1-400x126.png 400w, https://gravityforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1-690x217.png 690w, https://gravityforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1-200x63.png 200w, https://gravityforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1-768x241.png 768w, https://gravityforms.ir/wp-content/uploads/2019/09/Screenshot_2019-09-11-نمایش-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-1-500x157.png 500w\" sizes=\"auto, (max-width: 1161px) 100vw, 1161px\" /></figure></div>\n\n\n\n<p>در این افزونه جهت استفاده آسان از این اطلاعات می‌توانند به کاربران این امکان را بدهید تا از جستجو آن استفاده کرده و محتوا مورد نظر را یافت کنند. همچنین می‌توانید مطالب را بر اساس معیار خود مرتب کرده و فیلترهای مختلف را در اختیار کاربران قرار دهید. شما نیز می‌توانید نحوه نمایش اطلاعات فرم ها را با کشیدن و رها کردن المنت های مورد نیاز طراحی کنید.</p>\n\n\n\n<p>افزونه گروایتی ویو برای نمایش اطلاعات گروایتی فرم می باشد که دارای ویو های مختلفی که با توجه به نیاز کاربر می توان از قالب پیشفرض آن استفاده کرد.</p>\n\n\n\n<p>افزونه جانبی DataTables :</p>\n\n\n\n<p>نمایش ستون های متعدد از هر رکورد به همراه نمایش به صورت رسپانسیو</p>\n\n\n\n<p>افزونه جانبی Math by GravityView</p>\n\n\n\n<p>محاسبات ریاضی ( ضرب – تقسیم – میانگین و &#8230;)</p>\n\n\n\n<p><strong>افزونه جانبی Gravity Forms Import Entries</strong></p>\n\n\n\n<p>ایمپورت گروهی ورودی ها را از طریق فایل اکسل</p>\n\n\n\n<p><strong>افزونه جانبی A-Z Filters</strong></p>\n\n\n\n<p>جستجو بر حسب حروف انگلیسی در بالای هر پیچ برای کاربران</p>\n\n\n\n<p><strong>افزونه جانبی Featured Entries</strong></p>\n\n\n\n<p>ورودی ویژه دلخواه در لیست به صورت هایلایت و یا ابتدای صفحه نخست</p>\n\n\n\n<p><strong>افزونه جانبی GravityView Advanced Filtering</strong></p>\n\n\n\n<p>فیلتر پیشرفته برای تنظیم نحوه نمایش اطلاعات</p>\n\n\n\n<p><strong>افزونه جانبی Gravityview sharing seo</strong></p>\n\n\n\n<p>امکان اشتراک گذاری ورودی ها به وسیله این افزودنی</p>\n\n\n\n<p><strong>افزونه جانبی Gravityview ratings reviews</strong></p>\n\n\n\n<p>درج نظر و امتیاز برای ورودی های کاربران</p>\n\n\n\n<p><a href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-view/\"><strong>خرید افزونه گرویتی ویو</strong></a></p>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;48917&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;1&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;5&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;5\\/5 - (1 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;107.5&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 107.5px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            5/5 - (1 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%88%db%8c%d9%88-gravityview/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"بروز رسانی وبسرویس های پیامکی IPPanel و زیر مجموعه های آن\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"https://gravityforms.ir/%d8%a8%d8%b1%d9%88%d8%b2-%d8%b1%d8%b3%d8%a7%d9%86%db%8c-%d9%88%d8%a8%d8%b3%d8%b1%d9%88%db%8c%d8%b3-%d9%87%d8%a7%db%8c-%d9%be%db%8c%d8%a7%d9%85%da%a9%db%8c-ippanel-%d9%88-%d8%b2%db%8c%d8%b1-%d9%85/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:228:\"https://gravityforms.ir/%d8%a8%d8%b1%d9%88%d8%b2-%d8%b1%d8%b3%d8%a7%d9%86%db%8c-%d9%88%d8%a8%d8%b3%d8%b1%d9%88%db%8c%d8%b3-%d9%87%d8%a7%db%8c-%d9%be%db%8c%d8%a7%d9%85%da%a9%db%8c-ippanel-%d9%88-%d8%b2%db%8c%d8%b1-%d9%85/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Aug 2019 10:12:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=48714\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:512:\"با سلام،کلیه کاربرانی که از وبسرویس IPPanel و زیرمجموعه های آن در افزونه پیامک گرویتی فرم استفاده میکنند و پیام زیر را از طرف سامانه پیامکی خود دریافت کرده اند: تمامی کاربرانی که از ارسال وبسرویس و یا ارسال با افزونه استفاده و یا نرم افزارهای خودشان را روی IP ست کرده باشند، می بایست [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4198:\"\n<p>با سلام،<br>کلیه کاربرانی که از وبسرویس IPPanel و زیرمجموعه های آن در افزونه پیامک گرویتی فرم استفاده میکنند و پیام زیر را از طرف سامانه پیامکی خود دریافت کرده اند:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p>تمامی کاربرانی که از ارسال وبسرویس و یا ارسال با افزونه استفاده و یا نرم افزارهای خودشان را روی IP ست کرده باشند، می بایست در شب انتقال IP جدید خود را روی 188.0.240.110 ست نمایند.</p></blockquote>\n\n\n\n<p>میتوانند با مراجعه به پنل کاربری و بخش سوابق خرید خود مجددا اقدام به دانلود افزونه پیامک و وبسرویس مورد نظر خود نمایند.</p>\n\n\n\n<p>در تصویر زیر میتوانید لیست وبسرویس های مذکور رو مشاهده نمایید:</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"248\" height=\"495\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/ippanel.png\" alt=\"\" class=\"wp-image-48717\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/ippanel.png 248w, https://gravityforms.ir/wp-content/uploads/2019/08/ippanel-75x150.png 75w\" sizes=\"auto, (max-width: 248px) 100vw, 248px\" /></figure></div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;48714&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;1&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;5&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;5\\/5 - (1 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;107.5&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 107.5px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            5/5 - (1 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:225:\"https://gravityforms.ir/%d8%a8%d8%b1%d9%88%d8%b2-%d8%b1%d8%b3%d8%a7%d9%86%db%8c-%d9%88%d8%a8%d8%b3%d8%b1%d9%88%db%8c%d8%b3-%d9%87%d8%a7%db%8c-%d9%be%db%8c%d8%a7%d9%85%da%a9%db%8c-ippanel-%d9%88-%d8%b2%db%8c%d8%b1-%d9%85/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"افزونه شخصی سازی ظاهر فرم‌های گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%b4%d8%ae%d8%b5%db%8c-%d8%b3%d8%a7%d8%b2%db%8c-%d8%b8%d8%a7%d9%87%d8%b1-%d9%81%d8%b1%d9%85%e2%80%8c%d9%87%d8%a7%db%8c-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:228:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%b4%d8%ae%d8%b5%db%8c-%d8%b3%d8%a7%d8%b2%db%8c-%d8%b8%d8%a7%d9%87%d8%b1-%d9%81%d8%b1%d9%85%e2%80%8c%d9%87%d8%a7%db%8c-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Aug 2019 11:41:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=48588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:470:\"گرویتی فرم با ایجاد فرم های مختلف به شما این امکان را می‌دهد تا اطلاعات مختلفی را از کاربران دریافت کرده و از آن بهره مند شوید. پس از استفاده از این فرم ساز قدرتمند و بهره مندی از امکانات فراوان آن شاید نیاز به افزودن امکانی در جهت شخصی سازی ظاهر فرم های آن [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9207:\"\n<p>گرویتی فرم با ایجاد فرم های مختلف به شما این امکان را می‌دهد تا اطلاعات مختلفی را از کاربران دریافت کرده و از آن بهره مند شوید. پس از استفاده از این فرم ساز قدرتمند و بهره مندی از امکانات فراوان آن شاید نیاز به افزودن امکانی در جهت شخصی سازی ظاهر فرم های آن داشته باشید. برای این منظور شما به افزونه جانبی نیاز دارید که قابلیت شخصی سازی و افزودن قالب به فرم های این فرم ساز را در اختیارتان قرار دهد.</p>\n\n\n\n<p>اف<a href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-styles-pro/\">زونه شخصی سازی ظاهر فرم‌های گرویتی فرم</a> با افزودن قابلیت شخصی سازی ظاهر فرم های این افزونه در تنظیمات هر فرم به شما این امکان را می دهد تا با مراجعه به این بخش بتوانید هرکدام از فرم های دلخواه خود را شخصی سازی کرده و قالب های مختلف آن را برای فرم های خود انتخاب کنید. این افزونه دارای قالب های پیش فرضی بوده که می‌توانید از هرکدام که مایل هستید برای فرم های خود استفاده کنید.</p>\n\n\n\n<p><strong>نکته</strong>: قبل از مطالعه اگر قصد خرید <strong><a href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-styles-pro/\" target=\"_blank\" rel=\"noreferrer noopener\">افزونه گرویتی فرم Styles pro</a></strong> را دارید میتوانید از این لینک اقدام کنید.</p>\n\n\n\n<p>در تصویر زیر میتوانید برخی از قالب های این افزونه را مشاهده کنید:</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"774\" height=\"527\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/stylespro-5.jpg\" alt=\"\" class=\"wp-image-48589\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-5.jpg 774w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-5-400x272.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-5-690x470.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-5-200x136.jpg 200w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-5-768x523.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-5-500x340.jpg 500w\" sizes=\"auto, (max-width: 774px) 100vw, 774px\" /></figure></div>\n\n\n\n<p>همان طور که مشاهده کردید این افزونه دارای قالب های پیش فرض بوده و در کنار آن این امکان را می دهد تا قالب های شخصی خود را متناسب با نیاز طراحی کنید. شما میتوانید تمامی موارد ظاهری فرم های خود را از هر جهت تغییر داده و ظاهر بسیار زیبا برای فرم های خود ایجاد کنید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"898\" height=\"471\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/stylespro.jpg\" alt=\"\" class=\"wp-image-48590\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/stylespro.jpg 898w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-400x210.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-690x362.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-200x105.jpg 200w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-768x403.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-500x262.jpg 500w\" sizes=\"auto, (max-width: 898px) 100vw, 898px\" /></figure></div>\n\n\n\n<p>در تنظیمات این افزونه میتوانید بخش ها و ویژگی های مختلفی از فرم های خود را به صورت کامل شخصی سازی کنید. به طور مثال شما می‌تواند فونت های متن ها و فیلدهای فرم خود را به صورت کامل تغییر داده و فونت مورد نظر خود را اعمال کنید. همچین می‌توانید رنگ و سایز فونت های خود را به صورت کامل تغییر دهید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"800\" height=\"1206\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/stylespro-2.jpg\" alt=\"\" class=\"wp-image-48591\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-2.jpg 800w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-2-400x603.jpg 400w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-2-690x1040.jpg 690w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-2-100x150.jpg 100w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-2-768x1158.jpg 768w, https://gravityforms.ir/wp-content/uploads/2019/08/stylespro-2-332x500.jpg 332w\" sizes=\"auto, (max-width: 800px) 100vw, 800px\" /></figure></div>\n\n\n\n<p>در بخش تنظیمات قالب های این افزونه میتوانید آیکون های مختلف را انتخاب کرده و در فرم های خود از آنها استفاده کنید. همچنین می‌توانید پس زمینه های فرم های خود را بر اساس موارد مختلف انتخاب کنید.</p>\n\n\n\n<p>در تنظیمات این افزونه می‌توانید از کدهای CSS در جهت ویرایش و شخصی سازی فونت ها استفاده کرده و موارد دلخواه خود را ویرایش کنید.</p>\n\n\n\n<p>در پایان اگر قصد خرید <strong><a href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-styles-pro/\">افزونه شخصی سازی ظاهر فرم‌های گرویتی فرم</a></strong> را دارید به این لینک مراجعه کنید.</p>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;48588&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;1&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;5&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;5\\/5 - (1 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;107.5&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 107.5px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            5/5 - (1 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:224:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%b4%d8%ae%d8%b5%db%8c-%d8%b3%d8%a7%d8%b2%db%8c-%d8%b8%d8%a7%d9%87%d8%b1-%d9%81%d8%b1%d9%85%e2%80%8c%d9%87%d8%a7%db%8c-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"20\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"افزونه گرویتی فلو Gravity Flow\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d9%84%d9%88-gravity-flow/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d9%84%d9%88-gravity-flow/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Aug 2019 08:14:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=48416\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:470:\"افزونه Gravity Flow یک افزونه کاربردی و تجاری فرم ساز گرویتی فرم می‌باشد که توسط آن می‌توانید روندهای کاری خود را ایجاد کرده و فرم های گرویتی فرم را خودکار سازی کنید. این افزونه به شما این امکان را می دهد تا فرم های ایجاد شده توسط گرویتی فرم را به آن متصل کرده و [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8022:\"\n<p>افزونه Gravity Flow یک افزونه کاربردی و تجاری فرم ساز گرویتی فرم می‌باشد که توسط آن می‌توانید روندهای کاری خود را ایجاد کرده و فرم های گرویتی فرم را خودکار سازی کنید.</p>\n\n\n\n<p>این افزونه به شما این امکان را می دهد تا فرم های ایجاد شده توسط گرویتی فرم را به آن متصل کرده و از روند کاری فرم ها آگاه شوید. این افزونه یک داشبورد را در اختیارتان قرار خواهد داد که میتوانید از روند هرکدام از فرم ها مطلع شوید.</p>\n\n\n\n<p>نکته: اگر قصد <strong><a href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpgflows/\">خرید افزونه گرویتی فلو</a></strong> را دارید می‌توانید از این لینک اقدام کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpgflows/\">خرید افزونه گرویتی فلو Gravity Flow</a></div>\n</div>\n\n\n\n<p>پس از فعالسازی و اتصال هرکدام از فرم ها به افزونه گرویتی فلو، میتوانید فرم های ارسالی از سوی کاربران را بازبینی کرده و آنها را تایید و یا رد کنید. با این را بدانید که که تمامی اعمالی که بر روی فرم ها انجام می شود ، توسط مدیر و کاربران قابل مشاهده است و میتوانند از آن آگاه شوند.</p>\n\n\n\n<p>این افزونه چندین امکان را به منو مدیریت وردپرس شما اضافه خواهد کرد که در ادامه به صورت تصویری قابل مشاهده می‌باشند.</p>\n\n\n\n<h4 class=\"wp-block-heading\" id=\"h-7\">نکته: در کنار این افزونه 7 افزونه جانبی دیگر افزونه گرویتی فلو به صورت کاملا فارسی سازی شده ارائه می شود:</h4>\n\n\n\n<ul class=\"wp-block-list\"><li>افزونه فارسی جانبی Gravity Flow Checklists</li><li>افزونه فارسی جانبی Gravity Flow Flowchart Extension</li><li>افزونه فارسی جانبی Gravity Flow Form Connector</li><li>افزونه فارسی جانبی Gravity Flow Incoming Webhook</li><li>افزونه فارسی جانبی Gravity Flow PayPal Extension</li><li>افزونه فارسی جانبی Gravity Flow PDF Generator Extension</li><li>افزونه فارسی جانبی Gravity Flow Stripe Extension</li><li>افزونه فارسی جانبی Gravity Flow Vacation Requests Extension</li></ul>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgflowhttps://gravityforms.ir/wp-content/uploads/saman-1.jpgformspersian-2.jpg\" alt=\"\" class=\"wp-image-48490\"/></figure></div>\n\n\n\n<p>بخش اتصال فرم ها به گرویتی فلو که از تنظیمات هر فرم قابل دسترس می باشد.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgflowhttps://gravityforms.ir/wp-content/uploads/saman-1.jpgformspersian2-1.jpg\" alt=\"\" class=\"wp-image-48493\"/></figure></div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgflowhttps://gravityforms.ir/wp-content/uploads/saman-1.jpgformspersian3.jpg\" alt=\"گرویتی فلو Gravity flow\" class=\"wp-image-48498\"/></figure></div>\n\n\n\n<ul class=\"wp-block-list\"><li>واکنش گرا و بهینه شده برای دستگاه های همراه</li><li>سازگار با گرویتی فرم فارسی</li><li>دارای افزونه های جانبی</li><li>مراحل تایید، هشدار، ورودی کاربر، وب‌هوک</li><li>گزارش دهی از جریان های کاری</li><li>امکان ایجاد برنامه ریزی</li><li>استفاده از منطق های شرطی در روند کاری</li><li>شخصی سازی ارسال ایمیل ها</li><li>ارسال ایمیل بر اساس روندهای کاری</li><li>و امکانات دیگر&#8230;</li></ul>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpgflows/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه گرویتی فلو</a></div>\n</div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;48416&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;1&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;1&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;1\\/5 - (1 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;19.5&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 19.5px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            1/5 - (1 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d9%84%d9%88-gravity-flow/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:97:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"افزونه اتصال گرویتی فرم به میل چیمپ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:205:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-%d8%a8%d9%87-%d9%85%db%8c%d9%84-%da%86%db%8c%d9%85%d9%be/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-%d8%a8%d9%87-%d9%85%db%8c%d9%84-%da%86%db%8c%d9%85%d9%be/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2019 07:59:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"Mailchimp گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:47:\"اتصال Mailchimp به گراویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:51:\"اتصال گرویتی فرم به میل چیمپ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:22:\"افزونه Mailchimp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:53:\"افزونه فارسی گرویتی فرم Mailchimp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:19:\"گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:15:\"میل چیمپ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:44:\"میل چیمپ برای گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=48276\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:457:\"یکی از راه های کاربردی در بازاریابی آنلاین , کمپین های ایمیل مارکتینگ می باشد . یکی از روش های مدیریت این کمپین ها , میل چیمپ می باشد . mailchimp یک سیستم کارآمد و برنامه تحت وب می باشد که یک نسخه رایگان برای ارسال ایمیل به صورت انبوه در اختیار شما می گذارد [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6801:\"\n<p>یکی از راه های کاربردی در بازاریابی آنلاین , کمپین های ایمیل مارکتینگ می باشد . یکی از روش های مدیریت این کمپین ها , میل چیمپ می باشد . mailchimp یک سیستم کارآمد و برنامه تحت وب می باشد که یک نسخه رایگان برای ارسال ایمیل به صورت انبوه در اختیار شما می گذارد . شما با این برنامه می توانید لیست ایمیلی خود را مدیریت نمایید. کمپین های متنوع بدون فیلترهای اسپم بسازید و از آن ها گزارش دریافت نمایید.</p>\n\n\n\n<p>افزونه اتصال گرویتی فرم به میل چیمپ به شما این امکان را خواهد داد تا بتوانید فرم های خود را با سرویس mailchimp ادغام کرده و از این طریق افراد بیشتری را به مخاطبین خبرنامه خود جذب کنید. این افزونه با امکاناتی که در اختیارتان قرار خواهد داد <span class=\"tlid-translation translation\" lang=\"fa\">هر فرم سایت شما را به یک مشترک بالقوه تبدیل می کند.</span></p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/mailchimp-https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه میل چیمپ گرویتی فرم</a></div>\n</div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgformsMailchimp.jpg\" alt=\"\" class=\"wp-image-48278\"/></figure></div>\n\n\n\n<p>در مرحله اول کار با این افزونه ابتدا باید به حساب کاربری خود در میل چیمپ رفته و یک API ایجاد کنید. پس از دریافت کلید API آن را در تنظیمات این افزونه وارد می‌کنید تا به این سرویس متصل شود. پس از این مراحل است که میتوانید در هرکدام از فرم های که نیاز دارید این امکان را فعال کرده و به هرکدام لیست های مخاطبین خود در میل چیمپ متصل کنید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgformsMailchimp-33.jpg\" alt=\"افزونه اتصال گرویتی فرم به میل چیمپ\" class=\"wp-image-48279\"/></figure></div>\n\n\n\n<p>با وارد کردن کلید API عملا به میل چیمپ متصل هستید!</p>\n\n\n\n<p>پس از مرحله اتصال به تنظیمات هرکدام از فرم های که مراجعه کنید این امکان را خواهید داشت تا فرم مورد نظر را به مخاطبین خود در میل چیمپ متصل کنید.</p>\n\n\n\n<p>این افزونه امکانی را نیز در اختیارتان قرار خواهد داد تا وسیله آن مخاطبین خود را بهینه کرده و افرادی که مایل به دریافت ایمیل هستند را انتخاب کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/mailchimp-https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه میل چیمپ گرویتی فرم</a></div>\n</div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;48276&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;0&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;0&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;0\\/5 - (0 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;0&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 0px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            <span class=\"kksr-muted\">به این post امتیاز دهید</span>\n    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:210:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-%d8%a8%d9%87-%d9%85%db%8c%d9%84-%da%86%db%8c%d9%85%d9%be/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:97:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"افزونه آزمون گراویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:154:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a2%d8%b2%d9%85%d9%88%d9%86-%da%af%d8%b1%d8%a7%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a2%d8%b2%d9%85%d9%88%d9%86-%da%af%d8%b1%d8%a7%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2019 11:48:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"Gravity Forms Quiz Add-On\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:30:\"آزمون ساز وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:32:\"آزمون گراویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:30:\"آزمون گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:38:\"افزونه Gravity Forms Quiz Add-On\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:38:\"افزونه امتحان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:32:\"امتحان گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:19:\"گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=47531\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:517:\"یکی از امکانات مورد نیاز اغلب وبسایت های آموزشی و موارد مرتبط، ایجاد بخشی به عنوان آزمون می باشد که مدیر وبسایت بتواند آزمون های مختلف خود را برای کاربران و دانش آموزان برگزار کند. اکثر سیستم های آزمون آنلاین دارای بخشی می باشند که استاد به وسیله آن میتوانید سوالات خود را طرح کرده [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7409:\"\n<p>یکی از امکانات مورد نیاز اغلب وبسایت های آموزشی و موارد مرتبط، ایجاد بخشی به عنوان آزمون می باشد که مدیر وبسایت بتواند آزمون های مختلف خود را برای کاربران و دانش آموزان برگزار کند. اکثر سیستم های آزمون آنلاین دارای بخشی می باشند که استاد به وسیله آن میتوانید سوالات خود را طرح کرده و آن را به صورت تستی در اختیار دانش آموزان قرار دهد. پس از ایجاد فرم آزمون ، دانش آموز میتواند پس از پر کردن مشخصات خود، به سوالات پاسخ داده و فرم آزمون برای برای استاد ارسال کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-quiz-add-on/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه آزمون گرویتی فرم</a></div>\n</div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgformsquiz-1.jpg\" alt=\"\" class=\"wp-image-48250\"/></figure></div>\n\n\n\n<p>افزونه آزمون گراویتی فرم با افزودن فیلدهای آزمون به این فرم ساز به شما این امکان را خواهد داد تا آزمون های خود را ایجاد کرده و در اختیار دانش آموزان خود قرار دهید. این افزونه دارای فیلد آزمون بوده که به وسیله آن میتوانید سوال خود را طرح کرده و پاسخ های تستی آن را درج کنید. در این بخش میتوانید پس از ایجاد سوال پاسخ صحیح را مشخص کرده و برای آن امتیاز دلخواه خود را قرار دهید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img loading=\"lazy\" decoding=\"async\" width=\"509\" height=\"920\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-21-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2.png\" alt=\"\" class=\"wp-image-48251\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-21-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2.png 509w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-21-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2-400x723.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-21-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2-83x150.png 83w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-21-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2-277x500.png 277w\" sizes=\"auto, (max-width: 509px) 100vw, 509px\" /></figure></div>\n\n\n\n<p>افزونه آزمون گراویتی فرم دارای بخش نمایش نتایج آزمون می‌باشد که یک سیستم آمار آزمون با امکانات بسیار کاربردی است. این بخش نتایج آزمون هرکدام از دانش آموزان را نمایش داده و امکانات کاربردی بسیاری دارد. در این نمودار آزمون دانش آموزان قرار دارد که نمرات آنها در این جدول قابل مشاهده می باشد. همچنین در این بخش تعداد شرکت کنندگان در آزمون به همراه میانگین نمره آنها در دسترس می باشد.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img decoding=\"async\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/https://gravityforms.ir/wp-content/uploads/saman-1.jpgformsquiz-23.jpg\" alt=\"\" class=\"wp-image-48258\"/></figure></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-quiz-add-on/\">خرید افزونه آزمون گرویتی فرم</a></div>\n</div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;47531&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;432&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;1&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;1\\/5 - (432 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;19.5&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 19.5px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            1/5 - (432 امتیاز)    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a2%d8%b2%d9%85%d9%88%d9%86-%da%af%d8%b1%d8%a7%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"12\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:94:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"افزونه اتصال گرویتی فرم به ووکامرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:204:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-%d8%a8%d9%87-%d9%88%d9%88%da%a9%d8%a7%d9%85%d8%b1%d8%b3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-%d8%a8%d9%87-%d9%88%d9%88%da%a9%d8%a7%d9%85%d8%b1%d8%b3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Aug 2019 09:49:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"Gravity Forms Product Add-ons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:52:\"اتصال گراویتی فرم به ووکامرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:50:\"اتصال گرویتی فرم به ووکامرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:50:\"اتصال ووکامرس به گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:19:\"گرویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:57:\"نمایش فرم گرویتی فرم در ووکامرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:14:\"ووکامرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=48106\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"ووکامرس یک افزونه قدرتمند در زمینه ساخت فروشگاه های اینترنتی می باشد که به کمک آن میتوانید یک فروشگاه اینترنتی ایجاد کرده و محصولات خود را برای فروش آنلاین در آن قرار دهید. این فروشگاه ساز از امکانات بسیار متنوعی برخودار است و با افزونه های زیادی همچون فرم ساز گراویتی فرم سازگار است. افزونه [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8561:\"\n<p>ووکامرس یک افزونه قدرتمند در زمینه ساخت فروشگاه های اینترنتی می باشد که به کمک آن میتوانید یک فروشگاه اینترنتی ایجاد کرده و محصولات خود را برای فروش آنلاین در آن قرار دهید. این فروشگاه ساز از امکانات بسیار متنوعی برخودار است و با افزونه های زیادی همچون فرم ساز گراویتی فرم سازگار است.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-add-ons-woocommerce/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه اتصال گرویتی فرم به ووکامرس </a></div>\n</div>\n\n\n\n<p>افزونه اتصال گرویتی فرم به ووکامرس&nbsp; یک افزونه کاربردی در زمینه اتصال فروشگاه ساز ووکامرس به فرم ساز گرویتی فرم می‌باشد که به کمک آن می‌توانید فرم های ایجاد شده در این فرم ساز را در محصولات خود نمایش دهید. این افزونه یک بخش به ویرایش محصولات ووکامرس اضافه خواهد کرد که به وسیله آن میتوانید هرکدام از فرم های ایجاد شده را انتخاب کنید. همچنین میتوانید گزینه نمایش نام فرم و توضیحات آن را درصورت تمایل فعال و یا غیرفعال کنید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس.png\"><img loading=\"lazy\" decoding=\"async\" width=\"861\" height=\"481\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس.png\" alt=\"\" class=\"wp-image-48108\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس.png 861w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس-400x223.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس-690x385.png 690w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس-200x112.png 200w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس-768x429.png 768w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-ویرایش-محصول-u2039-دمو-گراویتی-فرم-فارسی-—-وردپرس-500x279.png 500w\" sizes=\"auto, (max-width: 861px) 100vw, 861px\" /></a></figure></div>\n\n\n\n<p>در اینجا میتوانید یک نمای کلی از نحوه نمایش فرم های گرویتی فرم در ووکامرس را مشاهده کنید. هرکدام از فرم های انتخابی در بخش نمایش محصول ووکامرس نمایش داده خواهد شد.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-محصول-اتصال-گراویتی-فرم-به-ووکامرس-–-دمو-گراویتی-فرم-فارسی1-1-1.png\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"553\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-محصول-اتصال-گراویتی-فرم-به-ووکامرس-–-دمو-گراویتی-فرم-فارسی1-1-1.png\" alt=\"اتصال گرویتی فرم به ووکامرس\" class=\"wp-image-48112\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-محصول-اتصال-گراویتی-فرم-به-ووکامرس-–-دمو-گراویتی-فرم-فارسی1-1-1.png 500w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-محصول-اتصال-گراویتی-فرم-به-ووکامرس-–-دمو-گراویتی-فرم-فارسی1-1-1-400x442.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-محصول-اتصال-گراویتی-فرم-به-ووکامرس-–-دمو-گراویتی-فرم-فارسی1-1-1-136x150.png 136w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-محصول-اتصال-گراویتی-فرم-به-ووکامرس-–-دمو-گراویتی-فرم-فارسی1-1-1-452x500.png 452w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></a></figure></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpg-forms-add-ons-woocommerce/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه اتصال گرویتی فرم به ووکامرس</a></div>\n</div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;48106&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;0&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;0&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;0\\/5 - (0 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;0&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 0px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            <span class=\"kksr-muted\">به این post امتیاز دهید</span>\n    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:209:\"https://gravityforms.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-%da%af%d8%b1%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-%d8%a8%d9%87-%d9%88%d9%88%da%a9%d8%a7%d9%85%d8%b1%d8%b3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"22\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:103:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"بسته افزودنی های گرویتی فرم Gravity Perks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:187:\"https://gravityforms.ir/%d8%a8%d8%b3%d8%aa%d9%87-%d8%a7%d9%81%d8%b2%d9%88%d8%af%d9%86%db%8c-%d9%87%d8%a7%db%8c-%da%af%d8%b1%d8%a7%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-gravity-perks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:196:\"https://gravityforms.ir/%d8%a8%d8%b3%d8%aa%d9%87-%d8%a7%d9%81%d8%b2%d9%88%d8%af%d9%86%db%8c-%d9%87%d8%a7%db%8c-%da%af%d8%b1%d8%a7%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-gravity-perks/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 11 Aug 2019 08:11:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:11:{i:0;a:5:{s:4:\"data\";s:30:\"افزونه های تجاری\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Gravity Perks فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:26:\"افزونه Gravity Perks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:23:\"افزونه جانبی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:45:\"افزونه جانبی گراویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:36:\"افزونه جانبی گرویتی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:45:\"افزونه فارسی گراویتی فرم\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"افزونه گرویتی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:21:\"گراویتی پرک\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:32:\"گراویتی پرک فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:12:\"گرویتی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://gravityforms.ir/?p=47648\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:507:\"افزونه گرویتی فرم دارای امکانات بسیار متنوعی بوده و فرم های بسیار جذابی را در اختیارتان قرار خواهد داد. با این حال این افزونه نیز دارای کمبود برخی امکانات می‌باشد که به کمک یک افزونه جانبی میتوان این امکانات را تا حد ممکن به فرم ساز اضافه کرد. افزونه Gravity Perks یکی از افزونه های [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"مدیریت گرویتی فرم پارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13567:\"\n<p>افزونه گرویتی فرم دارای امکانات بسیار متنوعی بوده و فرم های بسیار جذابی را در اختیارتان قرار خواهد داد. با این حال این افزونه نیز دارای کمبود برخی امکانات می‌باشد که به کمک یک افزونه جانبی میتوان این امکانات را تا حد ممکن به فرم ساز اضافه کرد.</p>\n\n\n\n<p>افزونه Gravity Perks یکی از افزونه های جانبی و پرکاربرد فرم ساز گراویتی فرم می‌باشد که آخرین نسخه&nbsp; آن به همراه فارسی سازی کامل برای شما کاربران عزیز فارسی زبان قرار داده شده است.</p>\n\n\n\n<p>این بسته شامل یک افزونه مادر می‌باشد که در مرحله باید آن را نصب کرده و پس از آن با توجه به امکانات مورد نیاز مابقی افزونه جانبی آن را نصب کنید. این پکیج شامل بیش از 30 افزونه می‌باشد که هرکدام امکانات متنوعی را به فرم ساز گراویتی فرم اضافه خواهد کرد. در ادامه توضیحاتی در مورد افزونه های این پکیج به همراه امکانات آن ارائه خواهیم کرد.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpgperks/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید بسته افزودنی های گرویتی فرم Gravity Perks</a></div>\n</div>\n\n\n\n<p><strong>افزونه GP Limit Checkboxes ایجاد محدودیت در چک باکس های گراویتی فرم</strong></p>\n\n\n\n<p>به وسیله این افزونه میتوانید در انتخاب چک باکس های گراویتی فرم محدودیت حداقل و حداکثر قرار دهید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس.png\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"418\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس.png\" alt=\"افزونه Gravityperks فارسی\" class=\"wp-image-47716\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس.png 500w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-400x334.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس-179x150.png 179w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></a></figure></div>\n\n\n\n<p><span style=\"font-size: 16px;\"><strong>در ادامه چند افزونه دیگر برای محدودیت بر روی فیلدها نیز موجود می باشند:</strong></span></p>\n\n\n\n<ul class=\"wp-block-list\"><li>افزونه GP Limit Choices محدودیت انتخاب در فیلد دکمه های رادیویی</li><li>افزونه GP Limit Dates محدودیت بر روی فیلد تاریخ گراویتی فرم<br>\n<span style=\"color: #ff0000;\"><strong>نکته</strong> </span>: این افزونه این امکان را می دهد تا محدودیتی بر روی انتخاب تاریخ در فیلد تاریخ گراویتی فرم ایجاد کنید.</li><li>افزونه <span class=\"tlid-translation translation\" tabindex=\"-1\" lang=\"fa\"><span class=\"\" title=\"\">GP Word Count</span></span> ایجاد محدودیت در تعداد ورود کلمات در فیلدها<br>\n<span style=\"color: #ff0000;\"><strong>نکته</strong></span>: تعداد کلماتی را که می توانید در فیلدهای تک خط ، متن پاراگراف و قسمت ارسال متن ارسال کنید ، محدود کنید.</li><li>افزونه GP Limit Submissions محدودیت در تعداد ورودی ها<br>\n<span style=\"color: #ff0000;\"><strong>نکته</strong></span>: تعداد ورودی هایی را که تقریباً توسط هر چیزی ارسال می شود (به عنوان مثال کاربر ، نقش ، IP ، مقدار زمینه) محدود کنید.</li></ul>\n\n\n\n<p><strong><span style=\"font-size: 16px;\">افزونه GP Terms Of Service افزودن فیلد پذیرش قوانین و شرایط برای کاربران</span></strong></p>\n\n\n\n<p>این افزونه به شما این امکان را می دهد تا بتوانید یک فیلد شرایط و قوانین به فرم های خود اضافه کرده و از کاربران بخواهید تا قبل از ارسال فیلد با قوانین و شرایط موافقت کنند. این افزونه گزینه های مختلفی را اضافه کرده و میتوانید پذیرش آن را برای کاربران اجباری کنید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2.png\"><img loading=\"lazy\" decoding=\"async\" width=\"504\" height=\"858\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2.png\" alt=\"\" class=\"wp-image-47721\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2.png 504w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2-400x681.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2-88x150.png 88w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس2-294x500.png 294w\" sizes=\"auto, (max-width: 504px) 100vw, 504px\" /></a></figure></div>\n\n\n\n<p><strong><span style=\"font-size: 16px;\">افزونه</span> GP Blacklist ایجاد لیست سیاه از کلمات غیر مجاز</strong></p>\n\n\n\n<p>این افزونه به شما این امکان را می دهد تا بتوانید یک لیست سیاه از کلمات غیرمجاز و دلخواه خود را ایجاد کرده و به فرم های خود اعمال کنید. پس از ایجاد لیست سیاه از کلماتی که مایل هستید ، دیگر امکان ارسال این کلمات از سوی کاربران وجود نداشته و فرم های کاربر ارسال نخواهد شد.</p>\n\n\n\n<p><span style=\"font-size: 16px;\"><strong>افزونه Gravity Forms Unique ID ایجاد شناسه منحصر به فرد</strong></span></p>\n\n\n\n<p>مقادیر حروف الفبا ، عددی&nbsp; &#8220;منحصر به فرد&#8221; را برای ورود هنگام ارسال تولید کنید.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس3.png\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"453\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس3.png\" alt=\"\" class=\"wp-image-47723\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس3.png 500w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس3-400x362.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/Screenshot_2019-08-11-فرم-ها-‹-دمو-گراویتی-فرم-فارسی-—-وردپرس3-166x150.png 166w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></a></figure></div>\n\n\n\n<p><strong><span style=\"font-size: 16px;\">افزونه Gravity Forms eCommerce Fields فیلدهای فروشگاهی گراویتی فرم</span></strong></p>\n\n\n\n<p>با پشتیبانی از زمینه های مالیاتی ، تخفیف ها و زیرمجموعه ها به علاوه دسته ای از دیگر ویژگی های مفید تجارت الکترونیک و فروشگاه های اینترنتی می باشد.</p>\n\n\n\n<p><strong><span style=\"font-size: 16px;\">افزونه Gravity Forms Read Only فیلدهای فقط خواندنی</span></strong></p>\n\n\n\n<p>گزینه فقط خواندنی را بر روی فیلدها تنظیم کنید تا فقط در حالت خوانده شده تنظیم شوند تا قابل مشاهده باشند اما قابل ویرایش نیستند.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><a href=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/gp-read-only-settings.png\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"208\" src=\"http://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/wp-content/uploads/2019/08/gp-read-only-settings.png\" alt=\"\" class=\"wp-image-47725\" srcset=\"https://gravityforms.ir/wp-content/uploads/2019/08/gp-read-only-settings.png 500w, https://gravityforms.ir/wp-content/uploads/2019/08/gp-read-only-settings-400x166.png 400w, https://gravityforms.ir/wp-content/uploads/2019/08/gp-read-only-settings-200x83.png 200w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></a></figure></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://https://gravityforms.ir/wp-content/uploads/saman-1.jpgforms.ir/product/https://gravityforms.ir/wp-content/uploads/saman-1.jpgperks/\" target=\"_blank\" rel=\"noreferrer noopener\">خرید افزونه گرویتی پرک Gravity Perks</a></div>\n</div>\n\n<div class=\"kk-star-ratings\n     kksr-valign-bottom     kksr-align-center    \"\n    data-payload=\"{&quot;align&quot;:&quot;center&quot;,&quot;id&quot;:&quot;47648&quot;,&quot;slug&quot;:&quot;default&quot;,&quot;valign&quot;:&quot;bottom&quot;,&quot;reference&quot;:&quot;auto&quot;,&quot;count&quot;:&quot;0&quot;,&quot;readonly&quot;:&quot;&quot;,&quot;score&quot;:&quot;0&quot;,&quot;best&quot;:&quot;5&quot;,&quot;gap&quot;:&quot;5&quot;,&quot;greet&quot;:&quot;\\u0628\\u0647 \\u0627\\u06cc\\u0646 post \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0647\\u06cc\\u062f&quot;,&quot;legend&quot;:&quot;0\\/5 - (0 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632)&quot;,&quot;size&quot;:&quot;17&quot;,&quot;width&quot;:&quot;0&quot;,&quot;_legend&quot;:&quot;{score}\\/{best} - ({count} {votes})&quot;}\">\n    \n<div class=\"kksr-stars\">\n    \n<div class=\"kksr-stars-inactive\">\n            <div class=\"kksr-star\" data-star=\"1\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"2\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"3\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"4\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" data-star=\"5\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n    \n<div class=\"kksr-stars-active\" style=\"width: 0px;\">\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n            <div class=\"kksr-star\" style=\"padding-left: 5px\">\n            \n\n<div class=\"kksr-icon\" style=\"width: 17px; height: 17px;\"></div>\n        </div>\n    </div>\n</div>\n    \n<div class=\"kksr-legend\">\n            <span class=\"kksr-muted\">به این post امتیاز دهید</span>\n    </div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:192:\"https://gravityforms.ir/%d8%a8%d8%b3%d8%aa%d9%87-%d8%a7%d9%81%d8%b2%d9%88%d8%af%d9%86%db%8c-%d9%87%d8%a7%db%8c-%da%af%d8%b1%d8%a7%d9%88%db%8c%d8%aa%db%8c-%d9%81%d8%b1%d9%85-gravity-perks/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:29:\"https://gravityforms.ir/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:12:\"x-powered-by\";s:10:\"PHP/7.4.33\";s:13:\"last-modified\";s:29:\"Tue, 23 Dec 2025 18:16:56 GMT\";s:4:\"etag\";s:34:\"\"5dc9dc9b0ad486349b56b9995092b2a6\"\";s:4:\"link\";s:60:\"<https://gravityforms.ir/wp-json/>; rel=\"https://api.w.org/\"\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Mon, 29 Dec 2025 07:48:03 GMT\";s:7:\"alt-svc\";s:168:\"h3=\":443\"; ma=2592000, h3-29=\":443\"; ma=2592000, h3-Q050=\":443\"; ma=2592000, h3-Q046=\":443\"; ma=2592000, h3-Q043=\":443\"; ma=2592000, quic=\":443\"; ma=2592000; v=\"43, 46\"\";}s:5:\"build\";i:1765880593;s:21:\"cache_expiration_time\";i:1767037684;s:23:\"__cache_expiration_time\";i:1767037684;}", "off");
INSERT INTO `aor_options` VALUES("2677", "gf_previous_db_version", "2.9.24", "auto");
INSERT INTO `aor_options` VALUES("217", "persian_elementor", "a:6:{s:14:\"efa-panel-font\";s:1:\"1\";s:16:\"efa-iranian-icon\";s:1:\"1\";s:17:\"efa-elementor-pro\";s:1:\"1\";s:13:\"efa-elementor\";s:1:\"1\";s:12:\"efa-all-font\";s:1:\"1\";s:19:\"efa-zarinpal-button\";s:1:\"1\";}", "auto");
INSERT INTO `aor_options` VALUES("2105", "theme_mods_hello-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1766834339;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "on");
INSERT INTO `aor_options` VALUES("337", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1767022121;}", "auto");
INSERT INTO `aor_options` VALUES("4774", "t15s-registry-gravitykit", "a:2:{s:10:\"expiration\";i:1767090307;s:5:\"value\";O:8:\"stdClass\":1:{s:8:\"projects\";a:27:{s:14:\"gk-gravityview\";a:1:{s:12:\"translations\";a:28:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:29:37+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:30:18+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:30:59+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:2:\"zh\";a:7:{s:8:\"language\";N;s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-07-03T19:46:41+00:00\";s:12:\"english_name\";s:7:\"Chinese\";s:11:\"native_name\";s:6:\"中文\";s:7:\"package\";s:84:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:26:29+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:33:34+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:20:07+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:51:47+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:52:34+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:53:16+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:34:13+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:53:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T13:40:06+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T13:41:08+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T13:41:54+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"ko\";a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:18:39+00:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-ko_KR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ko\";i:1;s:3:\"kor\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:19:22+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:51:03+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:20:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:21:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:22:14+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:23:03+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:23:58+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-ar\";a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:34:52+00:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-es_AR.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:49:29+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T03:50:13+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:24:49+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:4:\"2.49\";s:7:\"updated\";s:25:\"2025-12-03T14:25:42+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityview/gk-gravityview-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:16:\"gk-gravityimport\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T20:26:13+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:90:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T20:34:58+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T20:39:10+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:28:55+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T20:43:33+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:57:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:14:55+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:90:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:19:42+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:24:46+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T20:52:34+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:29:40+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:35:55+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:40:28+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:44:18+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:90:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"ko\";a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:48:39+00:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-ko_KR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ko\";i:1;s:3:\"kor\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:53:11+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:10:35+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:58:25+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:02:55+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:07:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:10:56+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:17:21+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-ar\";a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T20:57:06+00:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-es_AR.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:01:28+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T21:06:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:21:24+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.7.0\";s:7:\"updated\";s:25:\"2025-12-03T22:24:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravityimport/gk-gravityimport-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:16:\"gk-gravitycharts\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:19:52+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:90:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:20:41+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-09-12T12:20:58+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:50:54+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-09-12T12:24:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:44:08+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:33:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:90:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:37:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:38:36+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:25:12+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-09-12T12:58:42+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:40:20+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:41:05+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:41:46+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:90:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"ko\";a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:42:32+00:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-ko_KR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ko\";i:1;s:3:\"kor\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:43:25+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:32:29+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:44:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:45:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:46:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:47:25+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:48:12+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-ar\";a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:27:52+00:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-es_AR.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:30:56+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:31:41+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:48:54+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:4:\"1.17\";s:7:\"updated\";s:25:\"2025-12-04T03:49:56+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:93:\"https://packages.translationspress.com/gravitykit/gk-gravitycharts/gk-gravitycharts-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:18:\"gk-gravitycalendar\";a:1:{s:12:\"translations\";a:28:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:34:49+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:35:54+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:40:56+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:2:\"zh\";a:7:{s:8:\"language\";N;s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2024-12-16T18:57:06+00:00\";s:12:\"english_name\";s:7:\"Chinese\";s:11:\"native_name\";s:6:\"中文\";s:7:\"package\";s:92:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:18:59+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:41:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:09:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:56:10+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:00:57+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:02:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:42:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:03:30+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:04:47+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:05:46+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:06:45+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"ko\";a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:07:48+00:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-ko_KR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ko\";i:1;s:3:\"kor\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:08:44+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:54:54+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:10:54+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:11:58+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:13:15+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:14:19+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:16:55+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-ar\";a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:47:50+00:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-es_AR.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:52:51+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T02:53:48+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:16:55+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:6:\"2.13.0\";s:7:\"updated\";s:25:\"2025-12-04T03:18:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/gravitykit/gk-gravitycalendar/gk-gravitycalendar-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:14:\"gk-gravityedit\";a:1:{s:12:\"translations\";a:28:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:51:25+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:51:41+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:52:14+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:2:\"zh\";a:7:{s:8:\"language\";N;s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2024-11-09T15:02:28+00:00\";s:12:\"english_name\";s:7:\"Chinese\";s:11:\"native_name\";s:6:\"中文\";s:7:\"package\";s:84:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T04:00:59+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:52:33+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:57:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:54:36+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:54:56+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:55:15+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:53:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:55:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:56:05+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:56:24+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:56:48+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"ko\";a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:57:06+00:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-ko_KR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ko\";i:1;s:3:\"kor\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:57:25+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:54:22+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:58:10+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:58:27+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:58:44+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:59:05+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:59:41+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-ar\";a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:53:31+00:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-es_AR.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:53:51+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T03:54:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T04:00:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.5.1\";s:7:\"updated\";s:25:\"2025-12-04T04:00:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravityedit/gk-gravityedit-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:14:\"gk-gravitymath\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T05:48:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T05:50:19+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T05:52:51+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:51:51+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T05:55:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:31:05+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:08:45+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:11:10+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:13:36+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T05:57:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:15:46+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:18:32+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:21:01+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:23:40+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:86:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"ko\";a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:26:11+00:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-ko_KR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ko\";i:1;s:3:\"kor\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:28:41+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:06:26+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:33:14+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:35:32+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:38:44+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:41:26+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:43:56+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-ar\";a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T05:59:20+00:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-es_AR.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:01:52+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:04:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:46:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.6\";s:7:\"updated\";s:25:\"2025-12-04T06:49:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:89:\"https://packages.translationspress.com/gravitykit/gk-gravitymath/gk-gravitymath-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:17:\"gk-gravityactions\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2025-12-04T02:21:02+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/gravitykit/gk-gravityactions/gk-gravityactions-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bn\";a:7:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2025-12-04T02:21:19+00:00\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:95:\"https://packages.translationspress.com/gravitykit/gk-gravityactions/gk-gravityactions-bn_BD.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"bn\";}}s:2:\"bs\";a:7:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2025-12-04T02:22:34+00:00\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/gravitykit/gk-gravityactions/gk-gravityactions-bs_BA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bs\";i:1;s:3:\"bos\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2025-12-04T02:33:09+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:95:\"https://packages.translationspress.com/gravitykit/gk-gravityactions/gk-gravityactions-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2025-12-04T02:22:51+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/gravitykit/gk-gravityactions/gk-gravityactions-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2025-12-04T02:29:54+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/gravitykit/gk-gravityactions/gk-gravityactions-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated