function wpjsloader_finpar(dom, key) {

    let par, last_par;

    par = dom.parentNode;

    if (par === null || par === undefined) {
        return false;
    }

    last_par = par;

    key = String(key);
    let find_mode = "tag";

    if (key.includes("#")) {

        find_mode = "id";
        key = key.split("#");
        key = key[1];

    } else if (/^\[.*]$/.test(key)) {

        find_mode = "attr";
        var regex = /\[(.*?)\]/g;
        var matches = key.match(regex);
        var results = matches.map(match => match.slice(1, -1));
        key = results[0];

    } else if (key.includes(".")) {

        find_mode = "class";
        key = key.split(".");
        key = key[1];
    }


    let this_attr;
    switch (find_mode) {
        case 'tag':
            key = key.toLowerCase();
            var tag_name = par.tagName.toLowerCase();
            while (par !== null && par !== undefined && tag_name != key) {
                last_par = par;
                par = par.parentNode;
            }
            break;
        case 'id':
            while (par !== null && par !== undefined && par.id != key) {
                last_par = par;
                par = par.parentNode;
            }
            break;
        case 'attr':
            if (key.includes("=")) {

                find_mode = "hard_attr";
                key = key.split("=")
                let has_attr = par.hasAttribute(key[0]);
                this_attr = '';
                key[1] = key[1].replaceAll("'", "");
                key[1] = key[1].replaceAll('"', '');

                while (par !== null && par !== undefined && !has_attr) {

                    this_attr = par.getAttribute(key[0]);
                    if (this_attr == key[1]) {
                        return par;
                    }
                    last_par = par;
                    par = par.parentNode;

                    try {
                        has_attr = par.hasAttribute(key[0]);
                    } catch {
                        has_attr = false
                    }

                }

            } else {
                let has_attr = par.hasAttribute(key);
                while (par !== null && par !== undefined && !has_attr) {
                    last_par = par;
                    par = par.parentNode;

                    try {
                        has_attr = par.hasAttribute(key);
                    } catch {
                        has_attr = false
                    }
                }
            }
            break;
        case 'class':
            let has_class = par.classList.contains(key)
            while (par !== null && par !== undefined && !has_class) {

                last_par = par;
                par = par.parentNode;

                try {
                    has_class = par.classList.contains(key);
                } catch {
                    has_class = false;
                }
            }
            break;
        default:
            return false;
            break;
    }

    if (par !== null && par !== undefined) {

        if (find_mode == 'hard_attr') {

            this_attr = par.getAttribute(key[0])
            if (this_attr == key[1]) {
                return par;
            } else return false;

        } else return par;

    } else {
        if (find_mode == 'hard_attr') {

            this_attr = last_par.getAttribute(key[0])
            if (this_attr == key[1]) {
                return par;
            } else return false;

        } else return last_par;
    }

}
function wpjsloader_open_sec(sec_id, this_btn) {

    //helpers 
    var is_dom = obj => {
        return obj instanceof Element;
    }
    var reset_all_btns = () => {

        var all_other_btns = document.querySelectorAll('.settings-side-con .side-selector-btn-con');
        for (var cgi = 0; cgi < all_other_btns.length; cgi++) {
            all_other_btns[cgi].classList.remove('is-act-btn');
        }

        var all_opener_divs = document.querySelectorAll('div[idhd]');
        for (var tgi = 0; tgi < all_opener_divs.length; tgi++) {

            all_opener_divs[tgi].classList.add("mdz-hidden2")
            all_opener_divs[tgi].setAttribute("stts", "hddn");
        }
    }
    /***/

    if (!is_dom(this_btn) && this_btn.includes('.')) {
        this_btn = document.querySelector(this_btn);
    }

    var opener_div = document.querySelector('div[idhd="sec-' + sec_id + '"]');

    if (sec_id == 0) {
        reset_all_btns();

        if (this_btn !== null && this_btn !== undefined) {
            this_btn.classList.add('is-act-btn');
        }


        window.scrollTo(0, 0);
    }

    if (opener_div !== null && opener_div !== undefined) {


        //reseting
        reset_all_btns();
        /***/

        if (this_btn !== null && this_btn !== undefined) {
            this_btn.classList.add('is-act-btn');
        }

        opener_div.classList.remove("mdz-hidden2")
        opener_div.setAttribute("stts", "no");

        let opener_h4 = document.querySelector('.sec-opener-btn[opener="sec-' + sec_id + '"]');
        if (opener_h4 !== null && opener_h4 !== undefined) {
            setTimeout(function () {
                opener_h4.scrollIntoView();
            }, 115)
        }
    }
}
jQuery(document).ready(function () {

    //Defines
    var mother = document.getElementById('wpjsloader-mother');
    /***/

    /*Set current Select tags option*/
    var all_select_tags = document.querySelectorAll("#wpjsloader-mother select");
    for (var i = 0; i < all_select_tags.length; i++) {
        var tmp = all_select_tags[i];
        var current = tmp.getAttribute("current");
        var all_options = tmp.querySelectorAll("option");
        for (var z = 0; z < all_options.length; z++) {
            if (all_options[z].value == current) {
                all_options[z].setAttribute("selected", "");
            }
        }
    }
    /***/

    //Active checkbox
    var all_chckboxes = document.querySelectorAll('input[type="checkbox"]');
    for (var ti = 0; ti < all_chckboxes.length; ti++) {
        let this_checkbox = all_chckboxes[ti];

        this_checkbox.addEventListener('input', function () {

            var label = this.parentNode;
            if (this.checked) {
                label.classList.add('active-label-chck')
            } else label.classList.remove('active-label-chck')
        })

        var label = this_checkbox.parentNode;
        if (this_checkbox.checked) {
            label.classList.add('active-label-chck')
        } else label.classList.remove('active-label-chck')
    }
    /***/

    /*All Openers*/
    var all_openers = document.querySelectorAll("[opener]")
    for (var c = 0; c < all_openers.length; c++) {
        if (all_openers[c] !== null && all_openers[c] !== undefined) {
            all_openers[c].addEventListener("click", function () {
                var ider = this.getAttribute("opener");
                var tmp = document.querySelector("[idhd='" + ider + "']");

                if (tmp !== null && tmp !== undefined) {

                    //reset
                    var all_other_btns = document.querySelectorAll('.settings-side-con .side-selector-btn-con');
                    for (var cgi = 0; cgi < all_other_btns.length; cgi++) {
                        all_other_btns[cgi].classList.remove('is-act-btn');
                    }

                    var tmp_id = ider.split('-');
                    tmp_id = tmp_id[1];
                    var tmp_btn = document.querySelector('.settings-side-con .side-selector-btn-con[opener-id="' + tmp_id + '"]');
                    /***/

                    var stts = tmp.getAttribute("stts");

                    switch (stts) {
                        case 'hddn':
                            tmp.classList.remove("mdz-hidden2")
                            tmp.setAttribute("stts", "no");

                            if (tmp_btn !== null && tmp_btn !== undefined) {
                                tmp_btn.classList.add('is-act-btn')
                            }
                            break;
                        case 'no':
                            tmp.classList.add("mdz-hidden2")
                            tmp.setAttribute("stts", "hddn");
                            break;
                    }
                }
            })
        }
    }
    /***/

    /*Perf opener*/
    var perf_link = document.getElementById("perf-link");
    if (perf_link !== null && perf_link !== undefined) {
        perf_link.addEventListener("click", function () {
            setTimeout(function () {

                var tmp2 = document.querySelector("[idhd='sec-6']")
                if (tmp2 !== null && tmp2 !== undefined) {

                    var stts = tmp2.getAttribute("stts");

                    switch (stts) {
                        case 'hddn':
                            tmp2.classList.remove("mdz-hidden2")
                            tmp2.setAttribute("stts", "no");
                            break;
                        case 'no':
                            tmp2.classList.add("mdz-hidden2")
                            tmp2.setAttribute("stts", "hddn");
                            break;
                    }
                }

            }, 375)

        })

    }
    /***/

    //Hidden-options con
    var all_hidden_opts = document.querySelectorAll('.hidden-opt-con');
    for (var hg = 0; hg < all_hidden_opts.length; hg++) {

        let this_hidden = all_hidden_opts[hg];

        var is_vip_opt = this_hidden.getAttribute('is-vip-hid-opt');
        if (is_vip_opt == 1) {
            var is_dis = mother.getAttribute('is-dis');
            if (is_dis != 15) {
                continue;
            }
        }

        var opt_type = this_hidden.getAttribute('opt-type');

        var opt_main = this_hidden.getAttribute('opt-connect');
        var opt_main_tag = document.getElementById(opt_main)

        if (opt_main_tag !== null && opt_main_tag !== undefined) {

            switch (opt_type) {
                case 'checkbox':
                    opt_main_tag.addEventListener('input', function () {
                        this_hidden.classList.toggle('mdz-hidden2')
                    })

                    if (opt_main_tag.checked) {
                        this_hidden.classList.remove('mdz-hidden2')
                    }
                    break;
            }
        }

    }
    /***/

    //Dash-loader sample-effect!
    var dash_loader = document.querySelector('#sample-dashloader-effect div')
    let width = 0;
    let smaple_interval = '';
    if (dash_loader !== null && dash_loader !== undefined) {

        smaple_interval = setInterval(function () {



            width += Math.random() * 10; // Simulate loading progress (random increments)

            if (width >= 75) { // Cap at 95% until the very end
                //width = 75;
                width += Math.random() * 1.2;//Slower!
            }

            if (width >= 100) {
                width = 0;
            }

            dash_loader.style.width = width + '%';

        }, 200)
    }
    /***/

    /*Sticky Elements*/
    var all_stickers = mother.querySelectorAll("[wpjsloader-sticky]");
    if (all_stickers.length > 0) {

        for (var o = 0; o < all_stickers.length; o++) {
            all_stickers[o].setAttribute("where-sticked", "");
        }



        window.addEventListener("scroll", function () {

            var top = window.scrollY;
            for (var i = 0; i < all_stickers.length; i++) {

                if (all_stickers[i] !== null && all_stickers[i] !== undefined) {

                    var has_stop_parent = false;
                    let stop_parent = wpjsloader_finpar(all_stickers[i], "[wpjsloader-stick]");
                    var stop_width = all_stickers[i].getAttribute("wpjsloader-sticky-stop-wid");
                    stop_width = parseInt(stop_width);

                    if (this.window.innerWidth <= stop_width) { return; }


                    if (stop_parent !== document) {
                        has_stop_parent = true;
                    }

                    var this_top = all_stickers[i].offsetTop;

                    if (has_stop_parent && (stop_parent.offsetHeight) <= (all_stickers[i].offsetHeight + 255)) {
                        all_stickers[i].classList.remove("wpjsloader-sticked");
                        return;
                    }

                    let this_offset = '';
                    if (all_stickers[i].hasAttribute("wpjsloader-sticky")) {
                        this_offset = all_stickers[i].getAttribute("wpjsloader-sticky");
                    }
                    if (all_stickers[i].hasAttribute("wpjsloader-sticker")) {
                        this_offset = all_stickers[i].getAttribute("wpjsloader-sticker");
                    }

                    if (this_offset.trim() == "") {
                        this_offset = 0;
                    }

                    var stop_pos = all_stickers[i].getAttribute("where-sticked");

                    var stop_pos_num = parseInt(stop_pos);

                    if (top >= this_top && stop_pos.trim() == '') {

                        all_stickers[i].setAttribute("where-sticked", this_top);
                        var elem_left_pos = all_stickers[i].getBoundingClientRect().left;
                        var elem_width = all_stickers[i].offsetWidth;

                        all_stickers[i].classList.add("wpjsloader-sticked");
                        all_stickers[i].style.top = this_offset + "px";
                        all_stickers[i].style.left = elem_left_pos + "px";
                        all_stickers[i].style.maxWidth = elem_width + "px";
                    }

                    if (stop_pos.trim() != '' && top < stop_pos_num) {
                        all_stickers[i].classList.remove("wpjsloader-sticked");
                        all_stickers[i].setAttribute("where-sticked", "");
                    }

                    if (has_stop_parent) {

                        var par_height = stop_parent.offsetHeight;
                        var par_top = stop_parent.offsetTop;
                        var threshold = all_stickers[i].offsetHeight;;
                        var parent_bottom = (par_top + par_height) - threshold;

                        if (stop_pos.trim() != '' && top >= parent_bottom) {
                            stop_parent.classList.add("ended")
                            all_stickers[i].classList.add("ended");
                            all_stickers[i].style.left = "unset";
                        }
                        if (stop_pos.trim() != '' && top < parent_bottom) {
                            stop_parent.classList.remove("ended")
                            all_stickers[i].classList.remove("ended");
                        }
                    }

                }
            }

        })

    }
    /***/

    //Settings-Side
    var all_side_selectors = document.querySelectorAll('.settings-side-con .side-selector-btn-con');
    for (var op = 0; op < all_side_selectors.length; op++) {

        let this_selector = all_side_selectors[op];

        this_selector.addEventListener('click', function () {

            //alert('done|!')
            let this_btn = this;
            var opener_id = this_btn.getAttribute('opener-id');

            wpjsloader_open_sec(opener_id, this_btn)

        });
    }

    let default_openede = document.querySelector('.settings-side-con .side-selector-btn-con[opener-id="0"]');
    if (default_openede !== null && default_openede !== undefined) {
        setTimeout(() => {
            default_openede.click();
        }, (245));
    }
    /***/

    //Side SAver btn
    var side_saver = document.getElementById('side-saver-btn');
    if (side_saver !== null && side_saver !== undefined) {
        side_saver.addEventListener('click', function () {
            var tmp_saver = document.querySelector('div#save-now');

            if (tmp_saver !== null && tmp_saver !== undefined) {
                var tmp = tmp_saver.querySelector('input[type="submit"]');
                tmp.click();
            }

        })
    }
    /***/

    //Go up & down btns
    var all_up_btns = document.querySelectorAll('.spn-go-up')
    var all_down_btns = document.querySelectorAll('.spn-go-down')

    for (var nm = 0; nm < all_up_btns.length; nm++) {
        all_up_btns[nm].addEventListener('click', function () {
            window.scroll(0, 0);
        })
    }

    for (var mn = 0; mn < all_down_btns.length; mn++) {
        all_down_btns[mn].addEventListener('click', function () {

            var scrollHeight = Math.max(
                document.body.scrollHeight,
                document.documentElement.scrollHeight,
                document.body.offsetHeight,
                document.documentElement.offsetHeight,
                document.body.clientHeight,
                document.documentElement.clientHeight
            );

            // Scroll to the bottom
            window.scrollTo(0, scrollHeight);
        })
    }
    /***/
})