<?php
if (!function_exists('add_action'))
{
    echo '<h3>an error occured! You may not be able to access this plugin via direct URL...</h3>';
    exit();
}
else if (!defined('ABSPATH'))
{
    echo '<h3>an error occured! You may not be able to access this plugin via direct URL...</h3>';
    exit();
}
/**/
if (!class_exists('wpjsloadbymdz_admin'))
{

    class wpjsloadbymdz_admin 
    {
        //Props
        private static $instance;

        //constructor
        public function __Construct() 
        {
            
            //activate & deactivate hooks
            register_activation_hook(WPJSLOADBYMDZ_PLG, array($this, 'onactivate'));
            register_deactivation_hook(WPJSLOADBYMDZ_PLG, array($this, 'ondeactivate'));

            $this->checkfirstredirect(); //redirect on first time activation
            $this->deactivationConfirmation(); //Confirm to empty or not the data

            //add menue
            add_action('admin_menu', array($this, 'addmenue'));

        }

        //METHODS
        public static function get_instance() 
        {
            if ( ! isset( self::$instance ) ) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        public function onactivate()
        {

            add_option('wpjsloadbymdz_empty_onDeactivate', 0);
            add_option('wpjsloadbymdz_redirect_onActivate', 1);
            
        }

        public function ondeactivate() 
        {

            update_option('wpjsloadbymdz_redirect_onActivate', 1);

        }
        
        //checks to do redirect on activation or not
        public function checkfirstredirect()
        {
            
            global $pagenow;
            $do_redirect = get_option('wpjsloadbymdz_redirect_onActivate');
            if ($pagenow == 'plugins.php' && $do_redirect == '1'){
                add_action('admin_footer', array($this, 'doredirect'));
            }
        }

        //do redirect
        public function doredirect() 
        {
            ?>
            <script type="text/javascript">
                window.location.href = "<?php echo esc_url(admin_url()); ?>tools.php?page=wp-js-loader-bymdz";
            </script>
            <?php
            update_option('wpjsloadbymdz_redirect_onActivate', 0);
        }

        //empty on deactivate checker
        public function deactivationConfirmation()
        {

            global $pagenow;
            if ($pagenow == 'plugins.php'){
                add_action('admin_footer', array($this, 'emptyonDeactivate'));
            }
        }

        //empty on deactivate
        public function emptyonDeactivate()
        {
        ?>
            <script type="text/javascript">
            var btn = document.getElementById("deactivate-ajax-loader-cache");
            if (btn != null){
            btn.addEventListener('click', function(){
            let conf = confirm('<?php echo esc_html__('Do you want to KEEP all of the data of this plugin\ninside your database?\nPlease remind that, all of the plugins options get stored inside\nWP_OPTIONS table inside your database and having too much extra data on this table\nwill cause your web-site to load slowly\nif this is a TEMPORARY de-activation\nclick on the OK button otherwise click Cancel', 'wpjs-loader-bymdez') ?>');
            if (conf == false){
                var data = {
                  action: "wpjsloadbymdz_emptyOptions_AjaxConf",
                  tmp: 1,
                };
                jQuery.post(ajaxurl, data, function (resp){
                    console.log(resp);
                });
            }else {
                console.log('User Decided to keep Options!');
            } 
            });
            }  
           </script>

        <?php
        }

        //menue adder
        public function addmenue()
        {

            add_submenu_page(
                'tools.php',
                'wpjsloader',
                esc_html__('Ajax Loader', 'wpjs-loader-bymdez'),
                'install_plugins',
                'wp-js-loader-bymdz',
                array($this, 'menufunc'),
                999,
            );

        }

        //Menu function
        public function menufunc()
        {
            include_once WPJSLOADBYMDZ_PATH . 'admin'.DIRECTORY_SEPARATOR.'settings-pagehtml.php';
        }

        //custom sanitize
        public function sanitize_checkbox( $input )
        {         
            //returns true if checkbox is checked
            return ( isset( $input ) ? true : false );
        }

        //Checker
        public function has_plg($php_filename)
        {
            $all_plugins = apply_filters('active_plugins', get_option('active_plugins'));

            if (stripos(implode($all_plugins), $php_filename)) {
                return true;
            } else return false;
        }

        //Get settings
        private function get_plugin_settings($mode)
        {

            switch($mode){
                case '1':
                case 1:
                    if($this->has_plg('ajax-loader-bymdez.php') && defined('WPJSLOADBYMDZ_VER')){
                        return true;
                    }else return false;
                    break;
                case '2':
                case 2:
                    return get_option('wpjsloadbymdz_activate');
                    break;
                case '3':
                case 3:
                    if(get_option('wpjsloadbymdz_activate') == 1){
                        return false;
                    }else return true;
                    break;
                case '4':
                case 4:
                    if($this->has_plg('ajax-loader-pro-bymdez.php') && defined('WPJSLOADBPROYMDZ_VER')){
                        return 3;
                    }else return 4;
                    break;
                case '5':
                case 5:
                    if(is_user_logged_in()){
                        return false;
                    }else return true;
                    break;
                case '6':
                case 6:
                    if($this->has_plg('ajax-loader-pro-bymdez.php') && defined('WPJSLOADBPROYMDZ_VER')){
                        return 15;
                    }else return true;
                    break;
                default: 
                    break;
            }

        }

        //Set Options Autoload off (no)
        private function set_autoload_off($option) 
        {

            $tmp_option_val = get_option($option);
            delete_option($option);
  
            add_option($option, $tmp_option_val, '', 'no');
  
        }
    }

}
//init
wpjsloadbymdz_admin::get_instance();
//close the PHP tag to reduce the blank spaces ?>