<?php
/**
 * @link              https://profiles.wordpress.org/mdesignfa/
 * @since             1.0.0
 * @package           ajaxloaderbymdez
 * 
 * @wordpress-plugin
 * Plugin Name:      Ajax loader + Cache
 * Plugin URI:       https://ajaxloader.mdezign.ir/en/
 * Description:      Full Ajax loader system + Cache! (✨ Pro version Added + Lazy-Load system)
 * Version:          1.6.41
 * Author:           M_Design
 * License:          GPL-3.0+
 * License URI:      http://www.gnu.org/licenses/gpl-3.0.txt
 * Author URI:       https://landing.mdezign.ir/en/
 * Text Domain:      wpjs-loader-bymdez
 * Domain Path:      /languages
 */

if (!function_exists('add_action'))
{
    echo '<h3>an error occured! You may not be able to access this plugin via direct URL...</h3>';
    exit();
}
else if (!defined('ABSPATH'))
{
    echo '<h3>an error occured! You may not be able to access this plugin via direct URL...</h3>';
    exit();
}

/*Define Consts*/
if (!defined('WPJSLOADBYMDZ_VER')) { define('WPJSLOADBYMDZ_VER', '1.6.41'); }
if (!defined('WPJSLOADBYMDZ_PATH')) { define('WPJSLOADBYMDZ_PATH', trailingslashit(plugin_dir_path(__FILE__))); }
if (!defined('WPJSLOADBYMDZ_URL')) { define('WPJSLOADBYMDZ_URL', trailingslashit(plugin_dir_url(__FILE__))); }
if (!defined('WPJSLOADBYMDZ_PLG')) { define('WPJSLOADBYMDZ_PLG', __FILE__); }
/**/

/*add settings btn*/
if(!function_exists('wpjsloadbymdz_addsettingsbtn'))
{
    function wpjsloadbymdz_addsettingsbtn( array $links )
    {
        $url = get_admin_url() . 'tools.php?page=wp-js-loader-bymdz';
        $settings_link = '<a href="' . $url . '">' . esc_html__('Settings', 'wpjs-loader-bymdez'). '</a>';
        $links[] = $settings_link;
        return $links;
    }
}add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'wpjsloadbymdz_addsettingsbtn' );
/**/

/*Translations*/
if (!function_exists('wpjsloadbymdz_i18n'))
{
    function wpjsloadbymdz_i18n()
    {
        $test = load_plugin_textdomain( 'wpjs-loader-bymdez', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}add_action('init', 'wpjsloadbymdz_i18n');
/**/

/*Admin*/
if(is_admin())
{
    include_once WPJSLOADBYMDZ_PATH.DIRECTORY_SEPARATOR.'admin'.DIRECTORY_SEPARATOR.'admin-ajax.php';
    include_once WPJSLOADBYMDZ_PATH.DIRECTORY_SEPARATOR.'admin'.DIRECTORY_SEPARATOR.'class-admin.php';
}
/**/

/*Core*/
if(!is_admin())
{
    $is_active = get_option('wpjsloadbymdz_activate');

    if($is_active == '1')
    {//dont run anything on the front if plugin is deactive
    
    if(!function_exists('wpjsloadbymdz_def_settings'))
    {
        function wpjsloadbymdz_def_settings()
        {

            //helpers
            function wpjsloadbymdz_normalize_url($url)
            {

                $url_arr = str_split($url);
                $arrlen = count($url_arr);
                

                //add `/` at the end of url!
                if(isset($url_arr[$arrlen-1])){
                    $last_inx = $url_arr[$arrlen-1];
                    if($last_inx != '/'){
                        $url_arr[] = '/';

                        $url = implode('', $url_arr);
                    }
                }
                /***/

                //remove `https` OR `http` at the begining of url
                if(strpos($url, 'https://') !== false){
                    $url = explode('https://', $url);
                    if(isset($url[1])){
                       $url = $url[1]; 
                    }

                }else if(strpos($url, 'http://') !== false){
                    $url = explode('http://', $url);
                    if(isset($url[1])){
                       $url = $url[1]; 
                    }
                }
                /***/

                return $url;
            }
            /***/

            //Fetch Settings
            $is_active = get_option('wpjsloadbymdz_activate');
            $doon_scroll = get_option('wpjsloadbymdz_doon_scroll');
            $loader_css = get_option('wpjsloadbymdz_loadercss');
            $loader_effect = get_option('wpjsloadbymdz_loadereffect');
            $apply_on_exts = get_option('wpjsloadbymdz_applyonexts');
            $a_tags_exc_classes = get_option('wpjsloadbymdz_clasesexc');
            $a_tags_exc_attrs = get_option('wpjsloadbymdz_attrsexc');
            $a_tags_exc_par_css = get_option('wpjsloadbymdz_par_classexc');
            $a_tags_exc_par_attr = get_option('wpjsloadbymdz_par_attrexc');

            $is_cache = get_option('wpjsloadbymdz_cache');
            $cache_time = get_option('wpjsloadbymdz_cache_time');
            $cache_exc_pages = get_option('wpjsloadbymdz_cache_excpages');

            $cache_on_loggedins = get_option('wpjsloadbymdz_cacheon_users');
            $don_cache_queries = get_option('wpjsloadbymdz_dont_cachequeries');
            $cache_force_remove = get_option('wpjsloadbymdz_cache_remover');

            $ajax_cache = get_option('wpjsloadbymdz_ajax_cache');

            $dis_pwa = get_option('wpjsloader_dispwa');
            $pwa_param = get_option('wpjsloadbymdz_pwaparam'); 

            $is_drag_detect = get_option('wpjsloader_is_dragdetect');
            $drag_threshold = get_option('wpjsloadbymdz_dragthreshold');
            $no_top_scroll = get_option('wpjsloadbymdz_notopscroll');

            $trans_time = get_option('wpjsloadbymdz_trans_time');

            $is_ss_plc = 19;
            if(defined('WPJSLOADBPROYMDZ_VER')){
                $is_ss_plc = 8;
            }

            $fetch_mtd = 'default';
            $write_mtd = 'default';

            $use_dash_loader = 0;
            $dash_height = '3.5';
            $dash_pos = 'top';
            $dash_bg = '#ffffff';
            $dash_color = '#ff0000';
            $dash_dir = 'ltr';
            $dash_roundness = 10;//in-pixel

            $use_prod_load = 0;
            $prod_load_img_src = '';
            $prod_mbg = '#4f6eed3d';
            $prod_m_glass = 1;
            $prod_ibg = '#ffffffd1';
            $prod_bcolor = '#54515180';
            $prod_load_img_wid = 77;
            $prod_load_img_hei = 77;
            $prod_items_pos = 'row';
            $prod_load_slogan = esc_html__('Powered by Ajax Loader !', 'wpjs-loader-bymdez');
            $prod_load_slogan_color = '#000000';

            $clr = 0;
            $exc_by_a_urls = '';

            if($is_ss_plc != 19){

                $fetch_mtd = get_option('wpjsloader_load_mtd');
                $write_mtd = get_option('wpjsloader_write_mtd');

                $use_dash_loader = get_option('wpjsloader_adddash_loader');
                if($use_dash_loader == 1){
                    $dash_height = get_option('wpjsloader_dash_h');
                    $dash_pos = get_option('wpjsloader_dash_pos');
                    $dash_bg = get_option('wpjsloader_dash_bg');
                    $dash_color = get_option('wpjsloader_dash_color');
                    $dash_dir = get_option('wpjsloader_dash_dir');
                    $dash_roundness = get_option('wpjsloader_dash_round');
                }

                $use_prod_load = get_option('wpjsloader_addprod_load');
                
                if(defined('WPJSLOADPROBYMDZ_URL')){
                    $prod_load_img_src = WPJSLOADPROBYMDZ_URL.'assets/img/test-loader.svg';
                }
                
                if($use_prod_load == 1){

                    $prod_mbg = get_option('wpjsloader_prod_mbg');
                    $prod_m_glass = get_option('wpjsloader_prod_glass');
                    $prod_ibg = get_option('wpjsloader_prod_ibg');
                    $prod_bcolor = get_option('wpjsloader_prod_bcolor');
                    $prod_load_img_src = get_option('wpjsloader_prod_imgsrc');
                    $prod_load_img_wid = get_option('wpjsloader_prod_imgw');
                    $prod_load_img_hei = get_option('wpjsloader_prod_imgh');
                    $prod_load_slogan = get_option('wpjsloader_prod_slogan');
                    $prod_items_pos = get_option('wpjsloader_prod_itemspos');
                    $prod_load_slogan_color = get_option('wpjsloader_prod_slogan_color');
                }

                $clr = get_option('wpjsloader_cln_urls');
                $exc_by_a_urls = get_option('wpjsloader_exc_byurl');
                $exc_by_a_urls = explode("\n", $exc_by_a_urls);
                $exc_by_a_urls = implode('|', $exc_by_a_urls);
            }
            

            

            $use_vis_vika = 'yes';
            if(defined('WPJSLOADBPROYMDZ_VER')){

                $exc_pages = get_option('wpjsloader_exc_pages');

                if(!empty($exc_pages)){

                    $exc_pages_arr = explode("\n", $exc_pages);

                    if(is_front_page()){
                        $curr_url = home_url();
                    }else {
                        $curr_url = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
                        if(strpos($curr_url, '?') !== false){
                            $curr_url = explode('?',$curr_url);

                            if(isset($curr_url[0])){
                                $curr_url = $curr_url[0];
                            }
                        }
                        
                    }
                    
                    $curr_url = wpjsloadbymdz_normalize_url($curr_url);

                    foreach($exc_pages_arr as $tmp_page){
                        
                        $test_url = wpjsloadbymdz_normalize_url($tmp_page);
                        
                        if($test_url == $curr_url){
                            $use_vis_vika = 'no';
                        }
                    }

                }
            }
            
            

            if($trans_time === NULL || $trans_time == '' || $trans_time == ' ' || !is_numeric($trans_time))
            {
                $trans_time = '.5';
            }else $trans_time = $trans_time/1000;

            switch($loader_effect)
            {
                case 'simple':
                    $class_to_print = '
                    .waiting-for-ajx1 {
                        opacity: .5 !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
                case 'glassy':
                    $class_to_print = '
                    .waiting-for-ajx2 {
                        opacity: .5 !important;
                        pointer-events: none !important;
                        filter: blur(3px) !important;
                    }
                    ';
                    break;
                case 'fantasy':
                    $class_to_print = '
                    .waiting-for-ajx3 {
                        filter: hue-rotate(45deg) !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
                case 'xray':
                    $class_to_print = '
                    .waiting-for-ajx4 {
                        opacity: .77 !important;
                        filter: invert(1) !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
                case 'dark':
                    $class_to_print = '
                    .waiting-for-ajx5 {
                        filter: brightness(0.5) !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
                case 'sepia':
                    $class_to_print = '
                    .waiting-for-ajx6 {
                        opacity: .9 !important;
                        filter: sepia(1) !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
                case 'black':
                    $class_to_print = '
                    .waiting-for-ajx7 {
                        opacity: .5 !important;
                        filter: grayscale(1) !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
                case 'blackglass':
                    $class_to_print = '
                    .waiting-for-ajx8 {
                        filter: brightness(0.3)blur(3px) !important;
                        pointer-events: none !important;
                    }
                    ';
                    break;
            }

            //Print options (for the JS file)
            ob_start();
            ?>

<style id="ajxloaderbymdz-css">
html {transition: all <?php echo esc_html($trans_time); ?>s ease;}
<?php echo esc_html($class_to_print); ?>
</style>

<script type="text/javascript" id="wpjsloadbymdz-js-settings">
var wpjsloadbymdz_url = '<?php echo esc_url(home_url()); ?>';
var wpjsloadbymdz_active = '<?php echo esc_html($is_active); ?>';
var wpjsloadbymdz_doonscroll = '<?php echo esc_html($doon_scroll); ?>';
var wpjsloadbymdz_loaderclass = '<?php echo esc_html($loader_css); ?>';
var wpjsloadbymdz_loadereff = '<?php echo esc_html($loader_effect); ?>';
var wpjsloadbymdz_onexts = '<?php echo esc_html($apply_on_exts); ?>';
var wpjsloadbymdz_exc_class = '<?php echo wp_kses($a_tags_exc_classes, ['"', "'"]); ?>';
var wpjsloadbymdz_exc_attrs = '<?php echo wp_kses($a_tags_exc_attrs, ['"', "'"]); ?>';
var wpjsloadbymdz_exc_parclass = '<?php echo wp_kses($a_tags_exc_par_css, ['"', "'"]); ?>';
var wpjsloadbymdz_exc_parattr = '<?php echo wp_kses($a_tags_exc_par_attr, ['"', "'"]); ?>';
var wpjsloadbymdz_exc_a_byurls = '<?php echo sanitize_text_field($exc_by_a_urls); ?>';
var wpjsloadbymdz_cache = '<?php echo esc_html($is_cache); ?>';
var wpjsloadbymdz_cachetime = '<?php echo esc_html($cache_time); ?>';
var wpjsloadbymdz_exc_cachepages = '<?php echo esc_url($cache_exc_pages); ?>';
var wpjsloadbymdz_cache_uesrs = '<?php echo esc_html($cache_on_loggedins); ?>';
var wpjsloadbymdz_doncache_q = '<?php echo esc_html($don_cache_queries); ?>';
var wpjsloadbymdz_cache_remover = '<?php echo esc_html($cache_force_remove); ?>';
var wpjsloadbymdz_user_isin = '<?php echo is_user_logged_in(); ?>';
var wpjsloadbymdz_ajaxcache = '<?php echo esc_html($ajax_cache); ?>';
var wpjsloadbymdz_disinpwa = '<?php echo esc_html($dis_pwa); ?>';
var wpjsloadbymdz_pwaparam = '<?php echo esc_html($pwa_param); ?>';
var wpjsloadbymdz_isdragdetect = '<?php echo esc_html($is_drag_detect); ?>';
var wpjsloadbymdz_dragthreshold = '<?php echo esc_html($drag_threshold); ?>';
var wpjsloadbymdz_notopscroll = '<?php echo esc_html($no_top_scroll); ?>';
var wpjsloadbymdz_xmkrpg = '<?php echo esc_html($use_vis_vika); ?>';
var wpjsloadbymdz_fetch_mtd = '<?php echo esc_html($fetch_mtd); ?>';
var wpjsloadbymdz_write_mtd = '<?php echo esc_html($write_mtd); ?>';
var wpjsloadbymdz_dashloader = '<?php echo esc_html($use_dash_loader); ?>';
var wpjsloadbymdz_prodloader = '<?php echo esc_html($use_prod_load); ?>';
var wpjsloadbymdz_prodloader_img_w = '<?php echo esc_attr($prod_load_img_wid); ?>';
var wpjsloadbymdz_prodloader_img_h = '<?php echo esc_attr($prod_load_img_hei); ?>';
var wpjsloadbymdz_prodloader_img = '<?php echo esc_url($prod_load_img_src); ?>';
var wpjsloadbymdz_prodloader_txt = '<?php echo esc_attr($prod_load_slogan); ?>';
var wpjsloadbymdz_cll_r = '<?php echo esc_html($clr); ?>'
</script>

<?php 
if($use_dash_loader == 1){
$dash_top = 0;
$dash_bottom = 'unset';
$dash_tl_radius = 0;
$dash_bl_radius = 0;
$dash_tr_radius = $dash_roundness;
$dash_br_radius = $dash_roundness;

switch($dash_pos){
    case 'bot':
        $dash_top = 'unset';
        $dash_bottom = 0;

        break;
}
switch($dash_dir){
    case 'rtl':
        $dash_tl_radius = $dash_roundness;
        $dash_bl_radius = $dash_roundness;
        $dash_tr_radius = 0;
        $dash_br_radius = 0;
        break;
}

if(empty($dash_height) || $dash_height == 0){
    $dash_height = 3.5;
}
if(empty($dash_color) || $dash_color == 0){
    $dash_color = '#ff0000';
}
?>
<style id="wpjsloadbymdz-dash-css-settings">
#wpjsloader-dashloader {
    width: 100%;
    height: <?php echo esc_attr($dash_height); ?>px;
    background-color: <?php echo esc_attr($dash_bg); ?>;
    position: fixed;
    top: <?php echo esc_attr($dash_top); ?>;
    bottom: <?php echo esc_attr($dash_bottom); ?>;
    left: 0;
    z-index: 99999999;
    overflow: hidden;
    direction: <?php echo esc_attr($dash_dir); ?>;
}
#wpjsloader-dashloader > div {
    width: 0%;
    height: 100%;
    background-color: <?php echo esc_attr($dash_color); ?>;
    transition: width 0.3s ease;
    border-top-left-radius: <?php echo esc_attr($dash_tl_radius); ?>px;
    border-bottom-left-radius: <?php echo esc_attr($dash_bl_radius); ?>px;
    border-top-right-radius: <?php echo esc_attr($dash_tr_radius); ?>px;
    border-bottom-right-radius: <?php echo esc_attr($dash_br_radius); ?>px;
}
</style>
<?php 
}//End if (use dash-loader)

if($use_prod_load == 1){
   
$prod_items_align_pos = 'row';
switch($prod_items_pos){
    case 'row-rev':
        $prod_items_align_pos = 'row-reverse';
        break;
    case 'col':
        $prod_items_align_pos = 'column';
        break;
    case 'row-col':
        $prod_items_align_pos = 'column-reverse';
        break;

}

$prod_m_backdrop_eff = 'blur(4.5px) saturate(177%)';
if($prod_m_glass != 1){
    $prod_m_backdrop_eff = 'none';
}
?>
<style id="wpjsloadbymdz-prod-css-settings">
.wpjsloader-prodloader-hidden {
    pointer-events: none !important;
    opacity: 0;
}
.wpjsloader-prodloader-hidden * {
    pointer-events: none !important;
}
#wpjsloader-prodloader {
    width: 100%;
    height: 100%;
    position: fixed;
    top: 0;
    left: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999999;
    background: <?php echo esc_attr($prod_mbg); ?>;
    transition: .377s ease;
    backdrop-filter: <?php echo esc_attr($prod_m_backdrop_eff); ?>;
    -webkit-backdrop-filter: <?php echo esc_attr($prod_m_backdrop_eff); ?>;
}
#wpjsloader-prodloader div {
    background-color: <?php echo esc_attr($prod_ibg); ?>;
    padding: 7px 12px;
    border-radius: 12px;
    border: 2px solid <?php echo esc_attr($prod_bcolor); ?>;
    display: flex;
    flex-direction: <?php echo esc_attr($prod_items_align_pos); ?>;
    align-items: center;
    justify-content: center;
}
#wpjsloader-prodloader div span {
    margin-right: 9px;
    margin-left: 9px;
    margin-top: 7px;
    margin-bottom: 7px;
    color: <?php echo esc_attr($prod_load_slogan_color); ?>;
}
</style>
<?php 
}//End if (use prod-load)

            $settings_print = ob_get_contents();
            ob_get_clean();

            echo $settings_print;

        }
    }add_action('wp_head',  'wpjsloadbymdz_def_settings');

    if(!function_exists('wpjsloadbymdz_add_assets'))
    {
        function wpjsloadbymdz_add_assets()
        {

            $is_no_compress = get_option('wpjsloader_add_nocompress');
            $is_tmp_plg = 6;//means if is this plugin is avtive

            if(defined('WPJSLOADBPROYMDZ_VER')){
                $is_tmp_plg = 4;
            }

            if($is_no_compress == '1')
            {

                if($is_tmp_plg == 6){

                    wp_enqueue_script('wpjsloadermdz', WPJSLOADBYMDZ_URL.'loader-notmin.js', array('jquery'), WPJSLOADBYMDZ_VER, true);

                }else if($is_tmp_plg == 4){

                    wp_enqueue_script('wpjsloadermdz', WPJSLOADPROBYMDZ_URL.'assets/libs/axios/orio-rio-notmin.js', array('jquery'), WPJSLOADBYMDZ_VER, true);
                }
                

            }else {

                if($is_tmp_plg == 6){

                    wp_enqueue_script('wpjsloadermdz', WPJSLOADBYMDZ_URL.'loader.js', array('jquery'), WPJSLOADBYMDZ_VER, true);

                }else if($is_tmp_plg == 4){

                    wp_enqueue_script('wpjsloadermdz', WPJSLOADPROBYMDZ_URL.'assets/libs/axios/orio-yo-js.js', array('jquery'), WPJSLOADBYMDZ_VER, true);
                }
                
            }
            
        }
    }
    add_action('wp_enqueue_scripts', 'wpjsloadbymdz_add_assets', 9990 , 0);


    $use_cust_codes = get_option('wpjsloader_cust_scr');
    if($use_cust_codes == 1){
        add_action('wp_footer', function(){
            if(defined('WPJSLOADBPROYMDZ_VER')){

                $unfiltered_js_codes = get_option('wpjsloader_unf_js');

                $user_codes2 = get_option('wpjsloader_cust_jscode2');

                if(!empty($user_codes2)):

                if($unfiltered_js_codes != 1){

                    $user_codes2 = esc_js($user_codes2);
                    $user_codes2 = str_replace('&quot;', '"', $user_codes2);
                    $user_codes2 = str_replace('\n', "\n", $user_codes2);
                    $user_codes2 = str_replace("\'", "'", $user_codes2);
                    $user_codes2 = str_replace('&amp;', '&', $user_codes2);
                    $user_codes2 = str_replace('&lt;', '<', $user_codes2);
                    $user_codes2 = str_replace('&gt;', '>', $user_codes2);
                    
                    
                }
                

                ?>
                <script type="text/javascript" id="wpjsloadbymdz-user-js2">

                function wpjsloadermdz_custom_user_codes2(data, url, mtd, history){
                    <?php echo $user_codes2; ?>
                }
                </script>
                <?php
                endif;


                $user_codes = get_option('wpjsloader_cust_jscode');
                if(!empty($user_codes)):

                if($unfiltered_js_codes != 1){
                    
                    $user_codes = esc_js($user_codes);
                    $user_codes = str_replace('&quot;', '"', $user_codes);
                    $user_codes = str_replace('\n', "\n", $user_codes);
                    $user_codes = str_replace("\'", "'", $user_codes);
                    $user_codes = str_replace('&amp;', '&', $user_codes);
                    $user_codes = str_replace('&lt;', '<', $user_codes);
                    $user_codes = str_replace('&gt;', '>', $user_codes);
                    
                }
                

                ?>
                <script type="text/javascript" id="wpjsloadbymdz-user-js">

                function wpjsloadermdz_custom_user_codes(data, url, mtd, history){
                    <?php echo $user_codes; ?>
                }
                </script>
                <?php
                endif;
            }
        }, 9999);
    }



    $use_lazy_load = get_option('wpjsloader_laze');
    if($use_lazy_load == 1){

        if(!function_exists('wpjsloadbymdz_laze_loader')){
            function wpjsloadbymdz_laze_loader($matches, $mode=1, $dont_use_placeholder=1, $plc_txt='', $use_exc=0, $exc_tags='')
            {

                $do_this_tag = 1;
                //Check Exceptions
                if($use_exc == 1){
                    $exc_tags = explode("\n", $exc_tags);

                    foreach($matches as $match){
                        //var_dump($match);
                        foreach($exc_tags as $exc){
                            //var_dump($exc);
                            if(!empty($exc) && strpos($match, $exc) !== false){
                                $do_this_tag = 0;
                            }
                        }
                    }
                }
                /***/

                //$use_exc = 'done';

                if($do_this_tag == 1){

                    $placeholder = 'data:image/gif;base64,R0lGODdhAQABAPAAAP///wAAACwAAAAAAQABAEACAkQBADs=';
                    $key_word = '';

                    $wid_mathces = ['emp'];
                    switch($mode){
                        case '1':
                        case 1:
                            if($dont_use_placeholder != 1){
                                
                                //fetch the current image width and height attrs!
                                $plc_wid = '100%25';
                                $plc_hei = '100%25';
                                //$plc_txt_x = '50%25';
                                //$plc_txt_y = '50%25';

                                if(empty($plc_txt_ff)){$plc_txt_ff = 'sans-serif';}

                                if(isset($matches[1])){

                                    preg_match('/width="(.*?)".*height="(.*?)"/i', $matches[1], $wid_mathces);

                                    if(isset($wid_mathces[1]) && isset($wid_mathces[2])){
                                        $plc_wid = intval($wid_mathces[1]);
                                        $plc_hei = intval($wid_mathces[2]);

                                        if($plc_wid != $plc_hei){
                                            
                                            if($plc_wid > $plc_hei){
                                                $plc_hei = (100*$plc_hei)/$plc_wid;
                                                //$plc_txt_y = ($plc_hei/2).'%25';
                                                $plc_hei = $plc_hei.'%25';
                                                $plc_wid = '100%25';
                                            }else {
                                                $plc_wid = (100*$plc_wid)/$plc_hei;
                                                //$plc_txt_x = ($plc_wid/2).'%25';
                                                $plc_wid = $plc_wid.'%25';
                                                $plc_hei = '100%25';
                                            }

                                            $plc_wid = esc_attr($plc_wid);
                                            $plc_hei = esc_attr($plc_hei);
                                            //$plc_txt_x = esc_attr($plc_txt_x);
                                            //$plc_txt_y = esc_attr($plc_txt_y);
                                        }
                                        
                                    }
                                }
                                /***/

                                //$placeholder = "data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 ".$plc_wid." ".$plc_hei."'><rect width='100%' height='100%' fill='%23e0e0e0'/><text x='".$plc_txt_x."' y='".$plc_txt_y."' font-family='".$plc_txt_ff."' font-size='225%' fill='%23777' text-anchor='middle' dominant-baseline='middle'>".$plc_txt."</text></svg>";//Deprecated Since: 1.6.15 

                                //$placeholder = "data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 ".$plc_wid." ".$plc_hei."'><rect width='100%' height='100%' fill='%23e0e0e0'/></svg>";//Deprecated Since: 1.6.15 

                                $placeholder = "data:image/svg+xml;utf8,&lt;svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 ".$plc_wid." ".$plc_hei."'&gt;&lt;rect width='100%' height='100%' fill='%23e0e0e0'/&gt;&lt;/svg&gt;";
                            }
                            
                            $key_word = 'img';
                            break;
                        case '2':
                        case 2:
                            if(defined('WPJSLOADPROBYMDZ_URL')){
                                $placeholder = WPJSLOADPROBYMDZ_URL.'assets/video/tiny-audio.m4a';
                            }
                            $key_word = 'audio';
                            break;
                        case '3':
                        case 3:
                            if(defined('WPJSLOADPROBYMDZ_URL')){
                                $placeholder = WPJSLOADPROBYMDZ_URL.'assets/video/tiny-vid.mp4';
                            }
                            $key_word = 'video';
                            break;
                        case '4':
                        case 4:
                            $placeholder = '#';
                            if(defined('WPJSLOADPROBYMDZ_URL')){
                                $placeholder = WPJSLOADPROBYMDZ_URL.'assets/html/index.html';
                            }
                            $key_word = 'iframe';
                            break;
                        case '5':
                        case 5:
                            $key_word = 'embed';
                            break;
                        case '6':
                        case 6:
                            $key_word = 'input type="image"';
                            break;
                    }

                    //$matches[1] = 'tested!';
                    $html = sprintf( '<'.$key_word.' %1$s src="%4$s" wpjs-laze-src=%2$s%3$s dont-placeholder="%5$s" '.$wid_mathces[0].'>', $matches[1], $matches[2], $matches[3], $placeholder, $dont_use_placeholder);

                    $html_noscript = '';
                    if($mode != 4){
                        $html_noscript = sprintf( '<noscript><'.$key_word.'%1$s src=%2$s%3$s></noscript>', $matches[1], $matches[2], $matches[3] );
                    }
                    


                    return $html . $html_noscript;

                }else {

                    $key_word = '';

                    switch($mode){
                        case '1':
                        case 1:
                            $key_word = 'img';
                            break;
                        case '2':
                        case 2:
                            $key_word = 'audio';
                            break;
                        case '3':
                        case 3:
                            $key_word = 'video';
                            break;
                        case '4':
                        case 4:
                            $key_word = 'iframe';
                            break;
                        case '5':
                        case 5:
                            $key_word = 'embed';
                            break;
                        case '6':
                        case 6:
                            $key_word = 'input type="image"';
                            break;
                    }

                    $html = sprintf( '<'.$key_word.'%1$s wpjsload-is-excluded="1" wpjs-laze-src="none" src=%2$s%3$s>', $matches[1], $matches[2], $matches[3]);

                    return $html;//No Changes!
                }

                
                

            }
        }

        if(!function_exists('wpjsloadbymdz_laze')){
            function wpjsloadbymdz_laze($html)
            {

                if(defined('WPJSLOADBPROYMDZ_VER')){

                    //settings
                    $dont_use_placeholder = get_option('wpjsloader_laze_noplc');
                    $plc_txt = '';
                    if($dont_use_placeholder != 1){
                        $plc_txt = get_option('wpjsloader_laze_txt');
                    }

                    $use_exceptions = get_option('wpjsloader_laze_use_excs');
                    //var_dump($use_exceptions);
                    $exc_tags_keywords = '';
                    if($use_exceptions == 1){
                        $exc_tags_keywords = get_option('wpjsloader_exc_laze_tags');
                    }
                    /***/

                    $html = preg_replace_callback( '#<img([^>]*) src=("(?:[^"]+)"|\'(?:[^\']+)\'|(?:[^ >]+))([^>]*)>#', function($matches)use($dont_use_placeholder, $plc_txt, $use_exceptions, $exc_tags_keywords){
                        return wpjsloadbymdz_laze_loader($matches, 1, $dont_use_placeholder, $plc_txt, $use_exceptions, $exc_tags_keywords);
                    }, $html );

                    $html = preg_replace_callback( '#<audio([^>]*) src=("(?:[^"]+)"|\'(?:[^\']+)\'|(?:[^ >]+))([^>]*)>#', function($matches)use($use_exceptions, $exc_tags_keywords){
                        return wpjsloadbymdz_laze_loader($matches, 2, 1, '', $use_exceptions, $exc_tags_keywords);
                    }, $html );

                    $html = preg_replace_callback( '#<video([^>]*) src=("(?:[^"]+)"|\'(?:[^\']+)\'|(?:[^ >]+))([^>]*)>#', function($matches)use($use_exceptions, $exc_tags_keywords){
                        return wpjsloadbymdz_laze_loader($matches, 3, 1, '', $use_exceptions, $exc_tags_keywords);
                    }, $html );

                    $html = preg_replace_callback( '#<iframe([^>]*) src=("(?:[^"]+)"|\'(?:[^\']+)\'|(?:[^ >]+))([^>]*)>#', function($matches)use($use_exceptions, $exc_tags_keywords){
                        return wpjsloadbymdz_laze_loader($matches, 4, 1, '', $use_exceptions, $exc_tags_keywords);
                    }, $html );

                    $html = preg_replace_callback( '#<embed([^>]*) src=("(?:[^"]+)"|\'(?:[^\']+)\'|(?:[^ >]+))([^>]*)>#', function($matches)use($use_exceptions, $exc_tags_keywords){
                        return wpjsloadbymdz_laze_loader($matches, 5, 1, '', $use_exceptions, $exc_tags_keywords);
                    }, $html );

                    $html = preg_replace_callback( '#<input([^>]*) type="image"* src=("(?:[^"]+)"|\'(?:[^\']+)\'|(?:[^ >]+))([^>]*)>#', function($matches)use($use_exceptions, $exc_tags_keywords){
                        return wpjsloadbymdz_laze_loader($matches, 6, 1, '', $use_exceptions, $exc_tags_keywords);
                    }, $html );

                }

                


                return $html;

            }
        }

        /**
         * Start output buffering early to capture all HTML.
         */
        add_action( 'template_redirect', function(){
            if(defined('WPJSLOADBPROYMDZ_VER')){ob_start('wpjsloadbymdz_laze');}
        }, 1); // Fires before any HTML is sent.

        add_action('wp_head', function(){

            $dont_use_placeholder = get_option('wpjsloader_laze_noplc');
            if($dont_use_placeholder != 1):

                $plc_txt_font_family = get_option('wpjsloader_laze_txt_ff');
                if(empty($plc_txt_font_family)){
                    $plc_txt_font_family = 'sans-serif';
                }
            ?>
            <style id="wpjsloadbymdz-laze-css-settings">
                img.wpjs-lazy-load-waiting {
                    object-fit: cover;
                    object-position: center;
                    background-color: #e0e0e0;
                    background-image: url("data:image/svg+xml;utf8,&lt;svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'&gt;&lt;rect width='100%25' height='100%25' fill='%23e0e0e0'/&gt;&lt;text x='50%25' y='50%25' font-family='sans-serif' font-size='14' fill='%23777' text-anchor='middle' dominant-baseline='middle'&gt;Loading...&lt;/text&gt;&lt;/svg&gt;");
                    background-repeat: no-repeat;
                    background-position: center center;
                    background-size: 50% auto;
                    color: transparent;
                    text-indent: 100%;
                    white-space: nowrap;
                    overflow: hidden;
                }
                .wpjs-imgpar-rel {
                    position: relative !important;
                }
                .wpjs-imgpar-not-loaded:after {
                    content: 'در حال بارگذاری';
                    position: absolute;
                    top: 45%;
                    left: 50%;
                    pointer-events: none !important;
                    transform: translateX(-50%);
                    font-family: '<?php echo esc_attr($plc_txt_font_family); ?>'
                }
            </style>
            <?php
            endif;
        });

        add_action('wp_enqueue_scripts', function(){
            if(defined('WPJSLOADPROBYMDZ_URL')){

                $is_no_compress = get_option('wpjsloader_add_nocompress');
                if($is_no_compress == 1){
                    wp_enqueue_script('wpjsloadermdz-lazyloader', WPJSLOADPROBYMDZ_URL.'assets/libs/hex/mtpms-runner-notmin.js', [], WPJSLOADBYMDZ_VER, true);
                }else {
                    wp_enqueue_script('wpjsloadermdz-lazyloader', WPJSLOADPROBYMDZ_URL.'assets/libs/hex/mtpms-runner.js', [], WPJSLOADBYMDZ_VER, true);
                }
                
            }
        }, 99 , 0);
    
    }
    

    }//Endof if (is_active)

    
}


/* Omit closing PHP tag to avoid "Headers already sent" issues. */